#include <windows.h>
#include <pehdr.h>
#include <romldr.h>

#include <halether.h>
#include <bsp.h>
#include <register_map.h>

#include "Library.h"
#include "USB.h"

typedef VOID (*TSR_RUN)(VOID);

// Globals variables.
//
ROMHDR * volatile const pTOC = (ROMHDR *)-1;

volatile BOOL bDoneLoading;
volatile DWORD dwImgAddr;
volatile DWORD dwImgSize;
DWORD dwXferCnt;

void main(void)
{
    PDWORD pdwGINTSTS = 0xEC000014;
    TSR_RUN CallTSR;

    OEMInitLib();
    OEMInitPMIC();
    InitializeInterrupt();

    bDoneLoading = FALSE;
    dwImgAddr = 0x0;
    dwImgSize = 0x0;
    dwXferCnt = 0x0;
    
    OTGDEV_InitOtg(USB_HIGH);
    INTC_Enable(PHYIRQ_OTG);

    while(!dwImgAddr || !dwImgSize);

    EdbgOutputDebugString("TSR START ADDRESS : 0x%X\r\n", dwImgAddr);
    EdbgOutputDebugString("TSR IMAGE SIZE : 0x%X\r\n", dwImgSize);

    while(!bDoneLoading);

    EdbgOutputDebugString("DOWNLOADING IS COMPLETED\r\n");
    
    CallTSR = (TSR_RUN)dwImgAddr;
    CallTSR();
/*    while(1)
    {
        WriteDebugByte('C');
        OEMWriteDebugString(L"TEST\n");
    }*/    
}
