#ifndef __LIBRARY_H__
#define __LIBRARY_H__

#include <windows.h>

//------------------------------------------------------------------------------
//
//  Defines: 
//

// Flags to denote the serial port status
#if (S5PV210_EVT == 0)
#define ILDR_DEBUG_PORT				DEBUG_UART3
#else
#define ILDR_DEBUG_PORT             DEBUG_UART2
#endif

#define DEFAULT_DEBUG_BAUDRATE		115200
#define DEBUG_UART_ULCON            ((0<<6)|(0<<3)|(0<<2)|(3<<0))              // 8 bits, 1 stop, no parity
#define DEBUG_UART_UCON             ((0<<10)|(1<<9)|(1<<8)|(0<<7)|(0<<6)|(0<<5)|(0<<4)|(1<<2)|(1<<0))              // PCLKPSYS divide, Polling
#define DEBUG_UART_UFCON         	((0<<6)|(0<<4)|(0<<2)|(0<<1)|(0<<0))		// disable FIFO
#define DEBUG_UART_UMCON         	((0<<5)|(0<<4)|(0<<0))                       // Disable Auto Flow Control


//------------------------------------------------------------------------------
//
//  Function Prototypes
//

VOID OEMInitLib(VOID);
VOID OEMInitDebugSerial(VOID);
VOID OEMWriteDebugByte(CHAR ch);
VOID OEMWriteDebugString(CHAR *string);

VOID OEMInitPMIC(VOID);


#endif /*__LIBRARY_H__*/

