@REM
@REM Copyright (c) Microsoft Corporation.  All rights reserved.
@REM
@REM
@REM Use of this source code is subject to the terms of the Microsoft end-user
@REM license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
@REM If you did not accept the terms of the EULA, you are not authorized to use
@REM this source code. For a copy of the EULA, please see the LICENSE.RTF on your
@REM install media.
@REM

set WINCEREL=1

@REM =============================================================
@REM
@REM 	Main Platform Features
@REM
@REM =============================================================


set BSP_NONANDFS=
set BSP_NOPOCKETSTORE=1
if /i not "%BSP_NOPOCKETSTORE%"=="1" set BSP_POCKETFS=1

set BSP_NOSDMMC_BOOT=1
if /i "%BSP_NOSDMMC_BOOT%"=="" set BSP_NONANDFS=1


@REM ----- Chip Revision Number Selection ------------------------
@REM S5PV210_EVT = 0  : S5PV210 EVT0
@REM S5PV210_EVT = 1  : S5PV210 EVT1
@REM ============================================
set S5PV210_EVT=1

@REM ----- BSP Configuration ---------------------------------------------------
set IMGNODEBUGGER=1
set IMGNOKITL=1

set BSP_NOPCIBUS=1
set BSP_NOCS8900=1

set IMGPROFILER=
if /i "%IMGPROFILER%"=="1" set IMGPERF=1

@REM =============================================================
@REM
@REM 	System Features
@REM
@REM =============================================================

@REM ----- System Clock Configuration ------------------------------


@REM ----- Filesystem Configuration ------------------------------
@REM For PocketFS
set BSP_POCKETFS=

@REM ----- Power Manangement Configuration ----------------------
@REM Support DVFS and Voltage Control by PMIC
set BSP_USEDVFS=
set BSP_PMIC_VOLTAGE_CONTROL=

@REM Deep Idle Test with Reset Button
@REM In this feature, Reset button works as button of triggering deep idle mode 
set BSP_DEEPIDLE_TEST=

@REM Support Variable Idle 
@REM Variable Idle function works in default level. It is able to be changed in case of something, for example, in using T32. 
set BSP_NOIDLE=

@REM ----- System Timer Configuration ---------------------------
@REM Select Tick Timer type
@REM SYSTIMER_FIXED/SYSTIMER_VARIDLE
@REM set BSP_TICKTIMER=SYSTIMER_FIXED
set BSP_TICKTIMER=SYSTIMER_VARIDLE

@REM _SYSTIMERDIR has to be matched to a name of system timer folder
if /I "%BSP_TICKTIMER%"=="SYSTIMER_VARIDLE" set _SYSTIMERDIR=VARIDLETIMER
if /I "%BSP_TICKTIMER%"=="SYSTIMER_FIXED"   set _SYSTIMERDIR=FIXEDSYSTIMER


@REM System timer tick error compensation by RTC TICK
set BSP_TICK_COMPENSATION=

@REM ----- Power Button Configuration  ---------------------------
set BSP_NOPWRBTN=1

@REM ----- BATTERY Driver Configuration  -------------------------
set BSP_NOBATTERY=1

@REM ----- NLED Driver Configuration  ----------------------------
set BSP_NONLED=1


@REM ----- Configure the Debug serial channel ---------------------

@REM if /I "%S5PV210_EVT%"=="0" set BSP_DEBUGPORT=SERIAL_UART3
@REM if /I not "%S5PV210_EVT%"=="0" set BSP_DEBUGPORT=SERIAL_UART2

set BSP_DEBUGPORT=SERIAL_UART0
@REM =============================================================
@REM
@REM 	Connectivity Features
@REM
@REM =============================================================

@REM ----- TOUCH Driver Configuration  ---------------------------
@REM BSP_TOUCH_TYPE=0	: TSADC_CH0
@REM BSP_TOUCH_TYPE=1	: TSADC_CH1
@REM -------------------------------------------------------------
set BSP_NOTOUCH=
set BSP_TOUCH_TYPE=0

set BSP_ETH_EINT9=1  ;LAN ENABLE EINT9


@REM ----- KEYBD Driver Configuration  ---------------------------
@REM BSP_KEYBD_TYPE=0	: 8x8 keypad
@REM BSP_KEYBD_TYPE=1	: On-board key
@REM BSP_KEYBD_TYPE=2	: QWERTY keyboard
@REM -------------------------------------------------------------
set BSP_NOKEYBD=1
set BSP_KEYBD_TYPE=1


@REM ----- SD/MMC Driver Configuration  -------------------------
set BSP_NOSDMMC_CH0=1
set BSP_USE_SDMMC_CH0_8BIT=
set BSP_NOSDMMC_CH1=1
set BSP_NOSDMMC_CH2=
set BSP_USE_SDMMC_CH2_8BIT=
set BSP_NOSDMMC_CH3=
if /i "%BSP_NOSDMMC_BOOT%"=="" set BSP_NOSDMMC_CH0=1

@REM ----- SERIAL/SIR Device Driver Configuration  -----------------
@REM SERIAL/SIR Device Driver
set BSP_NOSERIAL=
set BSP_NOUART0=
set BSP_NOUART1=
set BSP_NOUART2=
set BSP_NOUART3=
set BSP_NOIRDA2=1
set BSP_NOIRDA3=1
set BSP_UART_RX_DMA=
set BSP_NOSIR=1

@REM ----- USB HOST/FUNCTION Device Driver Configuration  --------
set BSP_NOUSB=
set BSP_NOUSBHCD=
set BSP_NOUSBFN=
set BSP_USBFN_SERIAL=1
set BSP_USBFN_MSF=
set BSP_USBFN_RNDIS=

@REM ----- AUDIO Device Driver Configuration  --------------------
@REM AUDIO Device Driver
set BSP_NOAUDIO=
set BSP_AUDIO_AC97=

@REM ----- I2C Device Driver Configuration  -----------------------
set BSP_NOI2C=

@REM ----- SPI Device Driver Configuration  -----------------------
set BSP_NOSPI=
set BSP_NOSPI0=
set BSP_NOSPI1=
set BSP_NOSPI2=1

@REM ----- BT Device Driver Configuration  ------------------------
set BSP_NOBLUETOOTH=1

@REM ----- WLAN Device Driver Configuration  ---------------------
set BSP_NOWLAN=1


@REM =============================================================
@REM
@REM 	Display & Multimedia Features
@REM
@REM =============================================================

@REM ----- BACKLIGHT Device Driver Configuration  ----------------
set BSP_NOBACKLIGHT=1

@REM ----- MFC Device Driver Configuration  ----------------------
set BSP_NOMFC=

@REM ----- JPEG Device Driver Configuration  ----------------------
set BSP_NOJPEG=

@REM ----- OpenGL ES Device Driver Configuration  -----------------
@REM BSP_OES_FLIP=1    : FLIP mode
@REM BSP_OES_FLIP=     : BLT mode

set BSP_NOOES=
set BSP_OES_FLIP=

if /i not "%BSP_OES_FLIP%"=="1"  set _OESRELEASEDIR=%_FLATRELEASEDIR%\OpenGLES\DLL_BLT
if /i "%BSP_OES_FLIP%"=="1" set _OESRELEASEDIR=%_FLATRELEASEDIR%\OpenGLES\DLL_FLIP


@REM ----- D3DM Device Driver Configuration  ---------------------
set BSP_NOD3DM=1

@REM ----- TVOUT Device Driver Configuration  --------------------
set BSP_NOTVOUT=
set BSP_NOHDCP=
set BSP_NOCEC=

@REM ----- CAMERAFILTER Device Driver Configuration  -------------
@REM CAMERA FILTER/I2C Device Driver

@REM ----- TOUCH Driver Configuration  ---------------------------
@REM BSP_CAMERA_TVP5150=1	: TVP5150
@REM BSP_CAMERA_OV2655=1	: OV2655
@REM -------------------------------------------------------------
set BSP_NOCAMERA=
set BSP_CAMERA_OV2655=1
set BSP_CAMERA_TVP5150=1
set IMGCAMERAOEM=1
set BSP_KITL=NONE
@REM set BSP_KITL=SERIAL_UART0
@REM set BSP_KITL=SERIAL_UART1
@REM set BSP_KITL=SERIAL_UART2
@REM set BSP_KITL=SERIAL_UART3
@REM set BSP_KITL=USBSERIAL

@REM For Hive Based Registry
set IMGHIVEREG=1
if /i "%IMGHIVEREG%"=="1" set PRJ_ENABLE_FSREGHIVE=1
if /i "%IMGHIVEREG%"=="1" set PRJ_ENABLE_REGFLUSH_THREAD=1

@REM For Multiple XIP (using demand paging on BINFS)
set IMGMULTIXIP=

set BUILD_OPTIONS=
if /i "%BSP_NOSDMMC_BOOT%"=="" set BUILD_OPTIONS=%BUILD_OPTIONS% IROMBOOT
if /i "%BSP_NOPOCKETSTORE%"=="" call %_TARGETPLATROOT%\SRC\POCKETSTOREII15\env.bat

@REM Not support Multiple XIP on SDMMC Boot
if /i "%BSP_NOSDMMC_BOOT%"=="" set IMGMULTIXIP=

@REM -------support usb wifi----------
set BSP_USBWIIF_RT2870=1
set BSP_USBWIIF_8188=1
