/*
 * Project Name Camera DRIVER IN WINCE
 * Copyright  2007 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This software is the confidential and proprietary information
 * of Samsung Electronics  ("Confidential Information").
 * you shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Samsung Electronics
 *

 */

#ifndef __CAM_DRIVER_H__
#define __CAM_DRIVER_H__


//#include <windows.h>
//#include "camera_typedef.h"

#define IOCTL_FUNCODE(X)    (2048 + X )
#ifndef FILE_DEVICE_CONTROLLER
#define FILE_DEVICE_CONTROLLER     4
#endif
#define CAMERA_DRIVER       FILE_DEVICE_CONTROLLER
#define CAMERA_DRIVER_CTL_CODE(_Function, _Method, _Access)  \
            CTL_CODE(CAMERA_DRIVER, _Function, _Method, _Access)

typedef enum
{
    // Post Processor Function IOCTL
    CAM_POST_FUNCTION_API_BASE = 300,
    CAM_POST_SET_PROCESSING_PARAM,
    CAM_POST_SET_SOURCE_BUFFER,
    CAM_POST_SET_NEXT_SOURCE_BUFFER,
    CAM_POST_SET_DESTINATION_BUFFER,
    CAM_POST_SET_DESTINATION_1ST_BUFFER,
    CAM_POST_SET_DESTINATION_2ND_BUFFER,
    CAM_POST_SET_DESTINATION_3RD_BUFFER,
    CAM_POST_SET_DESTINATION_4TH_BUFFER,
    CAM_POST_SET_PROCESSING_START,
    CAM_POST_SET_PROCESSING_STOP,
    CAM_POST_WAIT_PROCESSING_DONE,
    CAM_POST_GET_PROCESSING_STATUS,
    // These two IOCTLs should be used by VIDEO driver only when suspend/resume
    CAM_POST_SUSPEND,
    CAM_POST_RESUME,
    CAM_POST_FUNCTION_API_END,
} CAM_API_FUNCTION_CODE;    // 0x0 ~ 0xFFF


#define IOCTL_CAM_INIT                 \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(1), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_RESET                 \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(2), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_PREVIEW_START                 \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(3), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_PREVIEW_GETFRAME                 \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(4), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_PREVIEW_STOP          \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(5), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_STILLCUT              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(6), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_VIDEO_START              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(7), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_VIDEO_GETFRAME                 \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(8), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_VIDEO_STOP              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(9), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_PREVIEWSOURCE            \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(10), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_STILLSOURCE              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(11), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_VIDEOSOURCE              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(12), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_PREVIEWSIZE              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(13), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_STILLSIZE              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(14), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_VIDEOSIZE              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(15), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_PROPERTY              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(16), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_GET_ERROR              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(17), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_DEINIT                 \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(18), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SETCALLBACK           \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(19), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_INIT_SENSOR           \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(20), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_GETCURRENTFRAMENUM           \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(21), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_PREPAREBUFFER           \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(22), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_OPERATIONMODE              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(23), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_REGISTER              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(24), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_CAPTURECONTROL              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(25), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_ZOOM              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(26), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_CLOCK_ONOFF              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(27), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_RSC_REQUEST              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(28), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_RSC_RELEASE              \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(29), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_PCLK                  \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(30), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_SET_DMA_PARAMETER         \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(31), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_DEINIT_SENSOR         \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(32), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_IMAGE_EFFECT_ON      \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(33), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_IMAGE_EFFECT_OFF      \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(34), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_JPEGSTILLCUT         \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(35), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_STILL_STOP           \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(36), METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_CAM_RELEASEBUFFER           \
            CAMERA_DRIVER_CTL_CODE(IOCTL_FUNCODE(37), METHOD_BUFFERED, FILE_ANY_ACCESS)


// Post Processor IOCTL
#define    IOCTL_CAM_POST_SET_PROCESSING_PARAM    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_PROCESSING_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_SOURCE_BUFFER    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_SOURCE_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_NEXT_SOURCE_BUFFER    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_NEXT_SOURCE_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_DESTINATION_BUFFER    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_DESTINATION_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_DESTINATION_1ST_BUFFER    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_DESTINATION_1ST_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_DESTINATION_2ND_BUFFER    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_DESTINATION_2ND_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_DESTINATION_3RD_BUFFER    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_DESTINATION_3RD_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_DESTINATION_4TH_BUFFER    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_DESTINATION_4TH_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_PROCESSING_START    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_PROCESSING_START, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_SET_PROCESSING_STOP    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SET_PROCESSING_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_WAIT_PROCESSING_DONE    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_WAIT_PROCESSING_DONE, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_GET_PROCESSING_STATUS    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_GET_PROCESSING_STATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)

// These two IOCTLs should be used by VIDEO driver only when suspend/resume
#define    IOCTL_CAM_POST_SUSPEND    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_SUSPEND, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define    IOCTL_CAM_POST_RESUME    \
            CAMERA_DRIVER_CTL_CODE(CAM_POST_RESUME, METHOD_BUFFERED, FILE_ANY_ACCESS)

// HIWORD of Rotation is Input Rotation
// LOWORD of Roataion is Output Rotation
// ROT[2], YFLIP[1], XFLIP[0]
#define ROT_BIT     0x4
#define YFLIP_BIT   0x2
#define XFLIP_BIT   0x1

// Post Interface IOCONTROL Argument
typedef struct
{
    DWORD dwOpMode;        // Operation Mode (Frame or Free Run)
    DWORD dwScanMode;    // Scan Mode (Progressive or Interace)
    DWORD dwRotFlipMode;    // Rotation and Flip Mode ( HIWORD : Input Rotator, LOWORD : Output Rotator)
                            // Rotation can effect HW performance, use it carefully.
                            // Both Rotator can rotate 90,180,270, X-axis flip, Y-axis Flip, XY-axis flip.
                            // Input Rotator use NOT scaled and NOT Color converted data
                            // Output Rotator use Scaled and Color converted data
                            // These two rotator can not be used simultaneously
                            // If HIWORD has some value, LOWORD will be ignored.
                            // HIWORD : can have POST_ROTFLIP_MODE
                            // LOWORD : can have POST_ROTFLIP_MODE
    DWORD dwSrcType;        // Src Image Type
    DWORD dwSrcBaseWidth;
    DWORD dwSrcBaseHeight;
    DWORD dwSrcWidth;
    DWORD dwSrcHeight;
    DWORD dwSrcOffsetX;
    DWORD dwSrcOffsetY;
    DWORD dwDstType;        // Dst Image Type
    DWORD dwDstBaseWidth;
    DWORD dwDstBaseHeight;
    DWORD dwDstWidth;
    DWORD dwDstHeight;
    DWORD dwDstOffsetX;
    DWORD dwDstOffsetY;
    DWORD dwDMATileMode;    // HIWORD : Input DMA, LOWORD : Output DMA, use CAM_DMA_MODE enum
} CAMARG_POST_PARAMETER;

typedef struct
{
    DWORD dwBufferRGBY;
    DWORD dwBufferCb;
    DWORD dwBufferCr;
    BOOL bWaitForVSync;        // Blocked Operation
} CAMARG_POST_BUFFER;

#endif /*__CAM_DRIVER_H__*/
