/**********************************************************************
 *                                                                    *
 * Sample implementation of vgu.h, version 1.0                        *
 *                                                                    *
 * Copyright  2005 The Khronos Group                                 *
 *                                                                    *
 **********************************************************************/

#ifndef _VGU_H
#define _VGU_H

#ifdef __cplusplus 
extern "C" { 
#endif

#include <VG/openvg.h>

#define VGU_VERSION_1_0 1

#ifdef UNDER_CE
#	ifdef _VGU_EXPORTS
#		define VGU_API_CALL
#	else
#		define VGU_API_CALL
#	endif
#	define VGU_APIENTRY 
#else
#if _WIN32
#	ifdef _VGU_EXPORTS
#		define VGU_API_CALL __declspec(dllexport)
#	else
#		define VGU_API_CALL __declspec(dllimport)
#	endif
#	define VGU_APIENTRY __stdcall
#else
#	ifdef _VGU_EXPORTS
#		define VGU_API_CALL
#	else
#		define VGU_API_CALL extern
#	endif
#	define VGU_APIENTRY 
#endif
#endif

typedef enum {
  VGU_NO_ERROR                                 = 0,
  VGU_BAD_HANDLE_ERROR                         = 0xF000,
  VGU_ILLEGAL_ARGUMENT_ERROR                   = 0xF001,
  VGU_OUT_OF_MEMORY_ERROR                      = 0xF002,
  VGU_PATH_CAPABILITY_ERROR                    = 0xF003,
  VGU_BAD_WARP_ERROR                           = 0xF004
} VGUErrorCode;

typedef enum {
  VGU_ARC_OPEN                                 = 0xF100,
  VGU_ARC_CHORD                                = 0xF101,
  VGU_ARC_PIE                                  = 0xF102
} VGUArcType;

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguLine(VGPath path,
											   VGfloat x0, VGfloat y0,
											   VGfloat x1, VGfloat y1);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguPolygon(VGPath path,
												  const VGfloat * points, VGint count,
												  VGboolean closed);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguRect(VGPath path,
											   VGfloat x, VGfloat y,
											   VGfloat width, VGfloat height);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguRoundRect(VGPath path,
													VGfloat x, VGfloat y,
													VGfloat width, VGfloat height,
													VGfloat arcWidth, VGfloat arcHeight);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguEllipse(VGPath path,
												  VGfloat cx, VGfloat cy,
												  VGfloat width, VGfloat height);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguArc(VGPath path,
											  VGfloat x, VGfloat y,
											  VGfloat width, VGfloat height,
											  VGfloat startAngle, VGfloat angleExtent,
											  VGUArcType arcType);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguComputeWarpQuadToSquare(VGfloat sx0, VGfloat sy0,
																  VGfloat sx1, VGfloat sy1,
																  VGfloat sx2, VGfloat sy2,
																  VGfloat sx3, VGfloat sy3,
																  VGfloat * matrix);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguComputeWarpSquareToQuad(VGfloat dx0, VGfloat dy0,
															      VGfloat dx1, VGfloat dy1,
																  VGfloat dx2, VGfloat dy2,
																  VGfloat dx3, VGfloat dy3,
																  VGfloat * matrix);

VGU_API_CALL VGUErrorCode VGU_APIENTRY vguComputeWarpQuadToQuad(VGfloat dx0, VGfloat dy0,
																VGfloat dx1, VGfloat dy1,
																VGfloat dx2, VGfloat dy2,
																VGfloat dx3, VGfloat dy3,
																VGfloat sx0, VGfloat sy0,
																VGfloat sx1, VGfloat sy1,
																VGfloat sx2, VGfloat sy2,
																VGfloat sx3, VGfloat sy3,
																VGfloat * matrix);

#ifdef __cplusplus 
} /* extern "C" */
#endif

#endif /* #ifndef _VGU_H */
