/*********************************************************************************
*                                                                               *
* Copyright (c) 2008 Samsung System LSI											*
* All rights reserved.                                                          *
*                                                                               *
* This software is test sample code for MFC v5.0								*
*																				*
* Author : Jiyoung Shin 								    					*	
* Last Changed : 2008.08.05 													*
*********************************************************************************/

#include <windows.h>
#include <ceddk.h>
#include "MfcRender.h"
#include "SVEDriverAPI.h"
#include "camif.h"
#include "Camif_reg.h"
#include "CAMDriver.h"
#include "CMMAPI.h"
#include "tvd_api.h"

#define NO_TV 0

#define TV_1080P 1
#define TV_720P  2
#define TV_480P  3
#define TV_1080I 4

#define TV_NTSC		100
#define TV_PAL_NC	101
#define TV_PAL_M	102
#define TV_PAL_N	103

#define TV_RESOLUTION TV_720P


#if(TV_RESOLUTION == TV_720P)

#define TV_WIDTH	1280
#define TV_HEIGHT	720

#elif(TV_RESOLUTION == TV_1080P)

#define TV_WIDTH	1920
#define TV_HEIGHT	1080

#elif(TV_RESOLUTION == TV_1080I)

#define TV_WIDTH	1920
#define TV_HEIGHT	1080

#elif((TV_RESOLUTION == TV_NTSC)||(TV_RESOLUTION == TV_PAL_M))

#define TV_WIDTH	720
#define TV_HEIGHT	480

#elif((TV_RESOLUTION == TV_PAL_NC)||(TV_RESOLUTION == TV_PAL_N))

#define TV_WIDTH	720
#define TV_HEIGHT	576


#elif(TV_RESOLUTION == TV_480P)

#define TV_WIDTH	720
#define TV_HEIGHT	480

#else

#define TV_WIDTH	0
#define TV_HEIGHT	0

#endif

//#define MEM_TO_MEM		  1

int GetFrameBuffer();

HANDLE 			hVideoOverlay_1 = INVALID_HANDLE_VALUE;
HANDLE 			hVideoOverlay_2 = INVALID_HANDLE_VALUE;
HANDLE			hCamDrv = INVALID_HANDLE_VALUE;
HANDLE			hCMMOpen = INVALID_HANDLE_VALUE;

//For TV
HANDLE 			hVideoDrv = INVALID_HANDLE_VALUE;
HANDLE 			hTVout = INVALID_HANDLE_VALUE;
TVOUT_OUTPUT_IF tTVoutIF;
STDA_ARG_GRP_BASIC_PARAM tGrp;
BOOL bHDCPEn = TRUE;
HDMI_AUDIO_TYPE hdmiAudioType = HDMI_AUDIO_PCM;
BOOL bHpdStatus;


static DWORD *g_pdwWin1Ctrl = NULL;
static unsigned int	DisplayOffsetX, DisplayOffsetY;
static BOOL	bFirstRenderOverlay_1;
static BOOL	bFirstRenderOverlay_2;

//////////////////////////////////////////////////////
//                        //                        //
//                        //                        //
//    vt_call_dec         //         vt_call        //
//    (overaly_1/WIN0)    //       (overlay_2/WIN2) //
//                        //                        //
//////////////////////////////////////////////////////

static int SsbSipDisplayOpen(MFCExeMode exeMode)
{
	DWORD 			dwBytes;

	if((exeMode == SINGLE_DECODE) || (exeMode == DEC_ENC) || (exeMode == DEC_UNIT) || (exeMode == DEC_DEC_DISPLAY_1)){ // use local_path
		printf("SsbSipDisplayOpen : SINGLE_DECODE or VT_CALL_DEC \n");

		hVideoOverlay_1 = CreateFile( L"VDE0:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
		if (hVideoOverlay_1 == INVALID_HANDLE_VALUE)
		{
			RETAILMSG(1,(L"[VDE:ERR] VDE0 Open Device Failed\n"));
			return 0;
		}

		// Request FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_REQUEST_FIMD_WIN0, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_REQUEST_FIMD_WIN0 Failed\n"));
			return 0;
		}
		
		// Request Post Processor H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_REQUEST_POST, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_REQUEST_POST Failed\n"));
			return 0;
		}

		// Open TVout Driver
		hTVout = CreateFile( L"TVD0:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);

		// Request TVout Driver Resource
		DeviceIoControl(hTVout, IOCTL_STDA_RSC_REQUEST_TVOUT_INTERFACE, NULL, 0, NULL, 0, &dwBytes, NULL);

		// Init TVout Driver
#if(TV_RESOLUTION == TV_720P)
		tTVoutIF.dispMode = TVOUT_720P_60;
//		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI;
		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI_YCBCR;

#elif(TV_RESOLUTION == TV_1080P)
		tTVoutIF.dispMode = TVOUT_1080P_60;
//		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI;
		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI_YCBCR;

#elif(TV_RESOLUTION == TV_1080I)
		tTVoutIF.dispMode = TVOUT_1080I_60;
//		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI;
		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI_YCBCR;

#elif(TV_RESOLUTION == TV_480P)
		tTVoutIF.dispMode = TVOUT_480P_60_16_9;
//		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI;
		tTVoutIF.outMode = TVOUT_OUTPUT_HDMI_YCBCR;

#elif(TV_RESOLUTION == TV_NTSC)
		tTVoutIF.dispMode = TVOUT_NTSC_M;
		tTVoutIF.outMode = TVOUT_OUTPUT_COMPOSITE;

#elif(TV_RESOLUTION == TV_PAL_NC)
		tTVoutIF.dispMode = TVOUT_PAL_NC;
		tTVoutIF.outMode = TVOUT_OUTPUT_COMPOSITE;

#elif(TV_RESOLUTION == TV_PAL_M)
		tTVoutIF.dispMode = TVOUT_PAL_M;
		tTVoutIF.outMode = TVOUT_OUTPUT_COMPOSITE;

#elif(TV_RESOLUTION == TV_PAL_N)
		tTVoutIF.dispMode = TVOUT_PAL_N;
		tTVoutIF.outMode = TVOUT_OUTPUT_COMPOSITE;

#else

		//For No TV. This is dummy datas
		tTVoutIF.dispMode = TVOUT_NTSC_M;
		tTVoutIF.outMode = TVOUT_OUTPUT_COMPOSITE;


#endif


		DeviceIoControl(hTVout, IOCTL_STDA_TVOUT_INIT_INTERFACE_PARAM, &tTVoutIF, sizeof(TVOUT_OUTPUT_IF), NULL, 0, &dwBytes, NULL);


		//Disable HDCP
//		    DeviceIoControl(hTVout, IOCTL_STDA_HDMI_INIT_HDCP_EN, &bHDCPEn, sizeof(BOOL), NULL, 0, &dwBytes, NULL);

#if ((TV_RESOLUTION == TV_1080P)||(TV_RESOLUTION == TV_720P)||(TV_RESOLUTION == TV_480P)||(TV_RESOLUTION == TV_1080I))
	    DeviceIoControl(hTVout, IOCTL_STDA_HDMI_INIT_AUDIO, &hdmiAudioType, sizeof(HDMI_AUDIO_TYPE), NULL, 0, &dwBytes, NULL);

	    // Wait inserting HDMI cable
		DeviceIoControl(hTVout, IOCTL_STDA_HDMI_GET_HPD_STATUS, NULL, 0, &bHpdStatus, sizeof(BOOL), &dwBytes, NULL);

/*
		while(!bHpdStatus)
		{
			DeviceIoControl(hTVout, IOCTL_STDA_HDMI_WAIT_HPD_STATUS_CHANGE, NULL, 0, &dwWaitResult, sizeof(DWORD), &dwBytes, NULL);
			if(dwWaitResult == WAIT_OBJECT_0)
			{
				DeviceIoControl(hTVoutDrv, IOCTL_STDA_HDMI_GET_HPD_STATUS, NULL, 0, &bHpdStatus, sizeof(BOOL), &dwBytes, NULL);
			}
		}
*/

//			waveOutMessage((HWAVEOUT)WAVE_MAPPER, DRVM_MAPPER_PREFERRED_SET, 0, 1);

		Sleep(1000);
#endif

		// Start TVout Driver
		DeviceIoControl(hTVout, IOCTL_STDA_TVOUT_START, NULL, 0, NULL, 0, &dwBytes, NULL);

		// Request VP Resource
		DeviceIoControl(hTVout, IOCTL_STDA_RSC_REQUEST_VIDEO_PROCESSOR, NULL, 0, NULL, 0, &dwBytes, NULL);



		bFirstRenderOverlay_1 = TRUE;
	}
	else if(exeMode == DEC_DEC_DISPLAY_2){
		printf("SsbSipDisplayOpen : VT_CALL\n");
		hVideoOverlay_2 = CreateFile( L"VDE0:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
		if (hVideoOverlay_2 == INVALID_HANDLE_VALUE)
		{
			RETAILMSG(1,(L"[VDE:ERR] VDE0 Open Device Failed\n"));
			return 0;
		}

		// Request FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_RSC_REQUEST_FIMD_WIN2, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_REQUEST_FIMD_WIN2 Failed\n"));
			return 0;
		}

		hCamDrv = CreateFile( L"CAM3:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
		if (hCamDrv == INVALID_HANDLE_VALUE)
		{
			RETAILMSG(1,(L"[CAM:ERR] CAM3 Open Device Failed\n"));
			return 0;
		}

		// Request resource for the camera driver
		if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_RSC_REQUEST, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_RSC_REQUEST Failed\n"));
			return 0;
		}

		bFirstRenderOverlay_2 = TRUE;

#ifdef WIN_CONTROL
	// Map Window1 Control register
    {
		PHYSICAL_ADDRESS pa;

		pa.HighPart = 0;
		//pa.LowPart = 0xEE000024;
		pa.LowPart = 0xF8000024;
	
		g_pdwWin1Ctrl = (DWORD *)MmMapIoSpace(pa, 4, FALSE);
		if(NULL == g_pdwWin1Ctrl)
		{
			RETAILMSG(1,(L"MmMapIoSpace Failed\n"));
			return 0;
		}
	}
#endif
	}
	else{
		printf("[SsbSipDisplayOpen]Invalid Mode... can't create surface\n");
		return 0;
	}



	return	1;

}

int SsbSipDisplayClose(MFCExeMode exeMode)
{
	DWORD 			dwBytes;
	DWORD			dwWinNum;

	if((exeMode == SINGLE_DECODE) || (exeMode == DEC_ENC) || (exeMode == DEC_UNIT) || (exeMode == DEC_DEC_DISPLAY_1)){
#ifdef MEM_TO_MEM
		dwWinNum = DISP_WIN0;
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_DISABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_DISABLE Failed\n"));
			return 0;
		}
#else
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_LOCALPATH_SET_WIN0_STOP, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_LOCALPATH_SET_WIN0_STOP Failed\n"));
			return 0;
		}
#endif
		// Release FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_RELEASE_FIMD_WIN0, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_RELEASE_FIMD_WIN0 Failed\n"));
			return 0;
		}

		// Release Post Processor H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_RELEASE_POST, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_RELEASE_POST Failed\n"));
			return 0;
		}

		CloseHandle(hVideoOverlay_1);



#if(TV_RESOLUTION == NO_TV)

#else

		// Stop VP
		DeviceIoControl(hTVout, IOCTL_STDA_VL_STOP, NULL, 0, NULL, 0, &dwBytes, NULL);
#endif

		// Release VP Resource
		DeviceIoControl(hTVout, IOCTL_STDA_RSC_RELEASE_VIDEO_PROCESSOR, NULL, 0, NULL, 0, &dwBytes, NULL);

		// Stop TVout Driver
		DeviceIoControl(hTVout, IOCTL_STDA_TVOUT_STOP, NULL, 0, NULL, 0, &dwBytes, NULL);

		// Release TVout Driver Resource
		DeviceIoControl(hTVout, IOCTL_STDA_RSC_RELEASE_TVOUT_INTERFACE, NULL, 0, NULL, 0, &dwBytes, NULL);

		// Close TVout Driver
		if (hTVout!= INVALID_HANDLE_VALUE)
		{
			CloseHandle(hTVout);
			hTVout = INVALID_HANDLE_VALUE;
		}


	}
	else if(exeMode == DEC_DEC_DISPLAY_2){
		if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_WAIT_PROCESSING_DONE, NULL, 0, NULL, 0, &dwBytes, NULL) )
        {
            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_WAIT_PROCESSING_DONE Failed\n"));
            return 0;
        }

		if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_RSC_RELEASE, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_RSC_RELEASE Failed\n"));
			return 0;
		}
		CloseHandle(hCamDrv);

		dwWinNum = DISP_WIN2;
		if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_DISABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_DISABLE Failed\n"));
			return 0;
		}

		// Release FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_RSC_RELEASE_FIMD_WIN2, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_RELEASE_FIMD_WIN0 Failed\n"));
			return 0;
		}
		CloseHandle(hVideoOverlay_2);


#ifdef WIN_CONTROL
    // Window1 Enable
	*g_pdwWin1Ctrl |= 0x1;

	MmUnmapIoSpace((PVOID)g_pdwWin1Ctrl, 4);
#endif
	}	
	else{
		printf("[SsbSipDisplayClose]Invalid Mode... can't close surface\n");
		return 0;
	}

	return 1;
}




 
int SsbSipDisplayStart(MFCExeMode exeMode, int DisplayYAddr, int DisplayCAddr, int DisplayWidth, int DisplayHeight)
{
	int							ret;
	SVEARG_FIMD_WIN_MODE		tParamMode;
	SVEARG_FIMD_WIN_FRAMEBUFFER tParamFB;
	SVEARG_FIMD_WIN_COLORKEY	tParamCKey;
	SVEARG_FIMD_WIN_ALPHA		tParamAlpha;
	SVEARG_POST_PARAMETER		tParamPost;
	SVEARG_POST_BUFFER			tParamBuffer;
	CAMARG_POST_PARAMETER		tCamParamPost;
	CAMARG_POST_BUFFER			tCamParamBuffer;
	DWORD 						dwBytes;
	DWORD						dwWinNum;
	int							FRAME_BUFFER_ADDR;

	STDA_ARG_VIDEO_BASIC_PARAM tVideoParam;
	STDA_ARG_VIDEO_IMG_ADDRESS tAddress;

	if((exeMode == SINGLE_DECODE) || (exeMode == DEC_ENC) || (exeMode == DEC_UNIT) || (exeMode == DEC_DEC_DISPLAY_1))// use local path, full window
	{ 
#ifdef MEM_TO_MEM
		if (bFirstRenderOverlay_1)
		{
				bFirstRenderOverlay_1 = FALSE;
				FRAME_BUFFER_ADDR = GetFrameBuffer();
				printf("GetFrameBuffer : 0x%08x\n", FRAME_BUFFER_ADDR);

				tParamMode.dwWinMode = DISP_WIN0_DMA;
				tParamMode.dwBPP = DISP_24BPP_888;
				tParamMode.dwWidth = DISPLAY_X;
				tParamMode.dwHeight = DISPLAY_Y;
				tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
				tParamMode.dwOffsetY = (LCD_Y - tParamMode.dwHeight)/2;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_MODE, &tParamMode, sizeof(SVEARG_FIMD_WIN_MODE), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_MODE Failed\n"));
					return 0;
				}


				// Color Key Disable
				tParamCKey.dwWinNum = DISP_WIN1;
				tParamCKey.bOnOff = FALSE;
				tParamCKey.dwDirection = DISP_FG_MATCH_BG_DISPLAY;
				tParamCKey.dwColorKey = 0;
				tParamCKey.dwCompareKey = 0;

				// Alpha Set to 0x0 (Show Window0)
				tParamAlpha.dwWinNum = DISP_WIN1;
				tParamAlpha.dwMethod = DISP_ALPHA_PER_PLANE;
				tParamAlpha.dwAlpha0 = 0x0;
				tParamAlpha.dwAlpha1 = 0x0;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY, &tParamCKey, sizeof(SVEARG_FIMD_WIN_COLORKEY), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY Failed\n"));
					return 0;
				}

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA, &tParamAlpha, sizeof(SVEARG_FIMD_WIN_ALPHA), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA Failed\n"));
					return 0;
				}

				// Set Window0 Framebuffer
				tParamFB.dwWinNum = DISP_WIN0;
				tParamFB.dwFrameBuffer = FRAME_BUFFER_ADDR;
				tParamFB.bWaitForVSync = FALSE;
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER, &tParamFB, sizeof(SVEARG_FIMD_WIN_FRAMEBUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER Failed\n"));
					return 0;
				}

				// Window0 Enable
				dwWinNum = DISP_WIN0;
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_ENABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_ENABLE Failed\n"));
					return 0;
				}

				tParamPost.dwOpMode = POST_PER_FRAME_MODE;
				tParamPost.dwScanMode = POST_PROGRESSIVE;
				tParamPost.dwSrcType = POST_SRC_NV12;
				tParamPost.dwRotFlipMode = MAKELONG(POST_90_NOFLIP, POST_0_NOFLIP);
				tParamPost.dwDMATileMode = MAKELONG(POST_DMA_LINEAR, POST_DMA_64BY32);
			 	tParamPost.dwSrcBaseWidth = DisplayWidth;
				tParamPost.dwSrcBaseHeight = DisplayHeight;
				tParamPost.dwSrcOffsetX = DisplayOffsetX;
				tParamPost.dwSrcOffsetY = DisplayOffsetY;
				tParamPost.dwSrcWidth = DisplayWidth;
				tParamPost.dwSrcHeight = DisplayHeight ;
				tParamPost.dwDstType = POST_DST_RGB24;
			 	tParamPost.dwDstBaseWidth = DISPLAY_X;
				tParamPost.dwDstBaseHeight = DISPLAY_Y;
				tParamPost.dwDstWidth = DISPLAY_X;
				tParamPost.dwDstHeight = DISPLAY_Y;
				tParamPost.dwDstOffsetX = (tParamPost.dwDstBaseWidth - tParamPost.dwDstWidth)/2;
				tParamPost.dwDstOffsetY = (tParamPost.dwDstBaseHeight - tParamPost.dwDstHeight)/2;



				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_PARAM, &tParamPost, sizeof(SVEARG_POST_PARAMETER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_PARAM Failed\n"));
					return 0;
				}

				tParamBuffer.dwBufferRGBY =DisplayYAddr;
				tParamBuffer.dwBufferCb = DisplayCAddr;
				tParamBuffer.dwBufferCr = DisplayCAddr;
				tParamBuffer.bWaitForVSync = FALSE;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_SOURCE_BUFFER Failed\n"));
					return 0;
				}

				// Destination Address
				tParamBuffer.dwBufferRGBY = FRAME_BUFFER_ADDR;
				tParamBuffer.dwBufferCb = 0;
				tParamBuffer.dwBufferCr = 0;
				tParamBuffer.bWaitForVSync = FALSE;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_DESTINATION_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_DESTINATION_BUFFER Failed\n"));
					return 0;
				}

				// Post Processing Start
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_START Failed\n"));
					return 0;
				}
			}
			else
			{
				// Wait for Post Processing Finished
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_WAIT_PROCESSING_DONE, NULL, 0, NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_WAIT_PROCESSING_DONE Failed\n"));
					return 0;
				}

				// Source Address
				tParamBuffer.dwBufferRGBY =DisplayYAddr;
				tParamBuffer.dwBufferCb = DisplayCAddr;
				tParamBuffer.dwBufferCr = DisplayCAddr;
				tParamBuffer.bWaitForVSync = FALSE;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_SOURCE_BUFFER Failed\n"));
					return 0;
				}

				// Post Processing Start
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_START Failed\n"));
					return 0;
				}
			}
#else
		if (bFirstRenderOverlay_1)
		{
			printf("SsbSipDisplayStart : SINGLE_DECODE \n");
			bFirstRenderOverlay_1 = FALSE;
#ifdef WIN_CONTROL
            // Window1 Disable
//			*g_pdwWin1Ctrl &= ~0x1;
#endif

			tParamMode.dwWinMode = DISP_WIN0_CAMIF0_RGB;
			tParamMode.dwBPP = DISP_24BPP_888;

			if((exeMode == SINGLE_DECODE) || (exeMode == DEC_UNIT)){
				tParamMode.dwWidth = DISPLAY_X;
				tParamMode.dwHeight = DISPLAY_Y;
				tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
				tParamMode.dwOffsetY = (LCD_Y - tParamMode.dwHeight)/2;
			}
			else{
				tParamMode.dwWidth = DISPLAY_X;
				tParamMode.dwHeight = DISPLAY_Y/2;
				tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
				tParamMode.dwOffsetY = (LCD_Y - (tParamMode.dwHeight*2))/2;
			}

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_MODE, &tParamMode, sizeof(SVEARG_FIMD_WIN_MODE), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_MODE Failed\n"));
				return 0;
			}

#ifndef WIN_CONTROL
			// Color Key Disable
			tParamCKey.dwWinNum = DISP_WIN1;
			tParamCKey.bOnOff = FALSE;
			tParamCKey.dwDirection = DISP_FG_MATCH_BG_DISPLAY;
			tParamCKey.dwColorKey = 0;
			tParamCKey.dwCompareKey = 0;
			tParamCKey.bBlend = FALSE;

			// Alpha Set to 0x0 (Show Window0)
			tParamAlpha.dwWinNum = DISP_WIN1;
			tParamAlpha.dwMethod = DISP_ALPHA_PER_PLANE;
			tParamAlpha.dwAlpha0 = 0x0;
			tParamAlpha.dwAlpha1 = 0x0;

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY, &tParamCKey, sizeof(SVEARG_FIMD_WIN_COLORKEY), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY Failed\n"));
				return 0;
			}

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA, &tParamAlpha, sizeof(SVEARG_FIMD_WIN_ALPHA), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA Failed\n"));
				return 0;
			}
#endif
			tParamPost.dwOpMode = POST_FREE_RUN_MODE;
			tParamPost.dwScanMode = POST_PROGRESSIVE;
			tParamPost.dwSrcType = POST_SRC_NV12;
			tParamPost.dwRotFlipMode = MAKELONG(POST_0_NOFLIP, POST_90_NOFLIP);
			tParamPost.dwDMATileMode = MAKELONG(POST_DMA_LINEAR, POST_DMA_64BY32);
			printf("ROT_VAL : %d\n", tParamPost.dwRotFlipMode);
		 	tParamPost.dwSrcBaseWidth = DisplayWidth;
			tParamPost.dwSrcBaseHeight = DisplayHeight;
			tParamPost.dwSrcOffsetX = DisplayOffsetX;
			tParamPost.dwSrcOffsetY = DisplayOffsetY;
			tParamPost.dwSrcWidth = DisplayWidth;
			tParamPost.dwSrcHeight = DisplayHeight ;
			tParamPost.dwDstType = POST_DST_FIFO_RGB888;

			if((exeMode == SINGLE_DECODE) || (exeMode == DEC_UNIT)){
		 		tParamPost.dwDstBaseWidth = DISPLAY_X;
				tParamPost.dwDstBaseHeight = DISPLAY_Y;
				tParamPost.dwDstWidth = DISPLAY_X;
				tParamPost.dwDstHeight = DISPLAY_Y;
			}
			else{
		 		tParamPost.dwDstBaseWidth = DISPLAY_X;
				tParamPost.dwDstBaseHeight = DISPLAY_Y/2;
				tParamPost.dwDstWidth = DISPLAY_X;
				tParamPost.dwDstHeight = DISPLAY_Y/2;
			}

			tParamPost.dwDstOffsetX = (tParamPost.dwDstBaseWidth - tParamPost.dwDstWidth)/2;
			tParamPost.dwDstOffsetY = (tParamPost.dwDstBaseHeight - tParamPost.dwDstHeight)/2;



			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_PARAM, &tParamPost, sizeof(SVEARG_POST_PARAMETER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_PARAM Failed\n"));
				return 0;
			}

			tParamBuffer.dwBufferRGBY = DisplayYAddr;
			tParamBuffer.dwBufferCb = DisplayCAddr;
			tParamBuffer.dwBufferCr = DisplayCAddr;
			tParamBuffer.bWaitForVSync = FALSE;

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_SOURCE_BUFFER Failed\n"));
				return 0;
			}

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER Failed\n"));
				return 0;
			}

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_LOCALPATH_SET_WIN0_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_LOCALPATH_SET_WIN0_START Failed\n"));
				return 0;
			}

			tVideoParam.bWinBlending = FALSE;
//			tVideoParam.srcColor = VPROC_SRC_COLOR_TILE_NV12;
//			tVideoParam.srcCodec = VPROC_SRC_CODEC_PROGRESSIVE;

			tVideoParam.srcColor = VPROC_SRC_COLOR_TILE_NV12IW;
			tVideoParam.srcCodec = VPROC_SRC_CODEC_INTERLACE;

			tVideoParam.uiAlpha = 0;
			tVideoParam.uiPriority = 1;

			tVideoParam.uiTopYAddress = DisplayYAddr;
			tVideoParam.uiTopCAddress = DisplayCAddr;

			tVideoParam.srcImgEndian = TVOUT_LITTLE_ENDIAN_MODE;
			tVideoParam.uiImgWidth = DisplayWidth;
			tVideoParam.uiImgHeight = DisplayHeight;

			tVideoParam.uiSrcOffsetX = DisplayOffsetX;
			tVideoParam.uiSrcOffsetY = DisplayOffsetY;
			tVideoParam.uiSrcWidth = DisplayWidth;
			tVideoParam.uiSrcHeight = DisplayHeight;

			tVideoParam.uiDestWidth = TV_WIDTH;
//			tVideoParam.uiDestHeight = (1280*DisplayHeight)/1920;
			tVideoParam.uiDestHeight = (TV_WIDTH*DisplayHeight)/DisplayWidth;
//			tVideoParam.uiDestOffsetX = (1280- ((1280*DisplayHeight)/1920))/2;
			tVideoParam.uiDestOffsetX = 0;
			tVideoParam.uiDestOffsetY = (TV_HEIGHT - tVideoParam.uiDestHeight)/2;

			DeviceIoControl(hTVout, IOCTL_STDA_VL_INIT_PROCESSING_PARAM, &tVideoParam, sizeof(STDA_ARG_VIDEO_BASIC_PARAM), NULL, 0, &dwBytes, NULL);
#if(TV_RESOLUTION == NO_TV)

#else
			DeviceIoControl(hTVout, IOCTL_STDA_VL_START, NULL, 0, NULL, 0, &dwBytes, NULL);
#endif


		}
		else
		{
			tParamBuffer.dwBufferRGBY = DisplayYAddr;
			tParamBuffer.dwBufferCb = DisplayCAddr;
			tParamBuffer.dwBufferCr = DisplayCAddr;
			tParamBuffer.bWaitForVSync = FALSE;

			tAddress.uiYAddress = DisplayYAddr;
			tAddress.uiCAddress = DisplayCAddr;

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER Failed\n"));
				return 0;
			}

#if(TV_RESOLUTION == NO_TV)

#else
			DeviceIoControl(hTVout, IOCTL_STDA_VL_SET_TOP_ADDRESS, &tAddress, sizeof(STDA_ARG_VIDEO_IMG_ADDRESS), NULL, 0, &dwBytes, NULL);
#endif

		}
#endif
	}
	else if(exeMode == DEC_DEC_DISPLAY_2) // use mem_to_mem, right hand side of window
	{ 
		if (bFirstRenderOverlay_2)
		{
			printf("SsbSipDisplayStart : VT_CALL\n");
			bFirstRenderOverlay_2 = FALSE;

#ifdef WIN_CONTROL
            // Window1 Disable
			*g_pdwWin1Ctrl &= ~0x1;
#endif
			tParamMode.dwWinMode = DISP_WIN2_DMA;
			tParamMode.dwBPP = DISP_24BPP_888;
			tParamMode.dwWidth = DISPLAY_X;
			tParamMode.dwHeight = DISPLAY_Y/2;
			tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
			tParamMode.dwOffsetY = LCD_Y/2 - (LCD_Y/2 - tParamMode.dwHeight)/2;

			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_MODE, &tParamMode, sizeof(SVEARG_FIMD_WIN_MODE), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_MODE Failed\n"));
				return 0;
			}

#ifndef WIN_CONTROL
			// Color Key Disable
			tParamCKey.dwWinNum = DISP_WIN1;
			tParamCKey.bOnOff = FALSE;
			tParamCKey.dwDirection = DISP_FG_MATCH_BG_DISPLAY;
			tParamCKey.dwColorKey = 0;
			tParamCKey.dwCompareKey = 0;
			tParamCKey.bBlend = FALSE;

			// Alpha Set to 0xFF (Show Window2)
			tParamAlpha.dwWinNum = DISP_WIN1;
			tParamAlpha.dwMethod = DISP_ALPHA_PER_PLANE;
			tParamAlpha.dwAlpha0 = 0xFF;
			tParamAlpha.dwAlpha1 = 0xFF;

			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY, &tParamCKey, sizeof(SVEARG_FIMD_WIN_COLORKEY), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY Failed\n"));
				return 0;
			}

			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA, &tParamAlpha, sizeof(SVEARG_FIMD_WIN_ALPHA), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA Failed\n"));
				return 0;
			}
#endif
			// Set Window0 Framebuffer
			FRAME_BUFFER_ADDR = GetFrameBuffer();
			tParamFB.dwWinNum = DISP_WIN2;
			tParamFB.dwFrameBuffer = FRAME_BUFFER_ADDR;
			tParamFB.bWaitForVSync = FALSE;
			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER, &tParamFB, sizeof(SVEARG_FIMD_WIN_FRAMEBUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER Failed\n"));
				return 0;
			}

			// Window0 Enable
			dwWinNum = DISP_WIN2;
			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_ENABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_ENABLE Failed\n"));
				return 0;
			}


			// Set processing parameters
            tCamParamPost.dwOpMode = POST_PER_FRAME_MODE;
            tCamParamPost.dwScanMode = POST_PROGRESSIVE;
			tCamParamPost.dwRotFlipMode = MAKELONG(POST_90_NOFLIP, POST_0_NOFLIP);
			tCamParamPost.dwDMATileMode = MAKELONG(POST_DMA_LINEAR, POST_DMA_64BY32);
            tCamParamPost.dwSrcType = POST_SRC_NV12;
            tCamParamPost.dwSrcBaseWidth = DisplayWidth;
            tCamParamPost.dwSrcBaseHeight = DisplayHeight;
            tCamParamPost.dwSrcOffsetX = DisplayOffsetX;
            tCamParamPost.dwSrcOffsetY = DisplayOffsetY;
            tCamParamPost.dwSrcWidth = DisplayWidth;
            tCamParamPost.dwSrcHeight = DisplayHeight;
            tCamParamPost.dwDstType = POST_DST_RGB24;
            tCamParamPost.dwDstBaseWidth = DISPLAY_X;
            tCamParamPost.dwDstBaseHeight = DISPLAY_Y/2;
            tCamParamPost.dwDstWidth = DISPLAY_X;
            tCamParamPost.dwDstHeight = DISPLAY_Y/2;
            tCamParamPost.dwDstOffsetX = (tCamParamPost.dwDstBaseWidth - tCamParamPost.dwDstWidth)/2;
            tCamParamPost.dwDstOffsetY = (tCamParamPost.dwDstBaseHeight - tCamParamPost.dwDstHeight)/2;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_PROCESSING_PARAM, &tCamParamPost, sizeof(CAMARG_POST_PARAMETER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_PROCESSING_PARAM Failed\n"));
	            return 0;
            }
        	
            tCamParamBuffer.dwBufferRGBY = DisplayYAddr;
            tCamParamBuffer.dwBufferCb = DisplayCAddr;
            tCamParamBuffer.dwBufferCr = DisplayCAddr;
            tCamParamBuffer.bWaitForVSync = FALSE;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_SOURCE_BUFFER, &tCamParamBuffer, sizeof(CAMARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_SOURCE_BUFFER Failed\n"));
	            return 0;
            }

            // Destination Address
	
            tCamParamBuffer.dwBufferRGBY = FRAME_BUFFER_ADDR;
            tCamParamBuffer.dwBufferCb = 0;
            tCamParamBuffer.dwBufferCr = 0;
            tCamParamBuffer.bWaitForVSync = FALSE;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_DESTINATION_BUFFER, &tCamParamBuffer, sizeof(CAMARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_DESTINATION_BUFFER Failed\n"));
	            return 0;
            }
		
#if 0
            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_NEXT_DESTINATION_BUFFER, &tCamParamBuffer, sizeof(CAMARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_NEXT_DESTINATION_BUFFER Failed\n"));
	            return 0;
            }
#endif
            // Post Processing Start for DISPWIN2 and CAMIF3

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_PROCESSING_START Failed\n"));
	            return 0;
            }

			}
		else
		{

			if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_WAIT_PROCESSING_DONE, NULL, 0, NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_WAIT_PROCESSING_DONE Failed\n"));
	            return 0;
            }
            tCamParamBuffer.dwBufferRGBY = DisplayYAddr;
            tCamParamBuffer.dwBufferCb = DisplayCAddr;
            tCamParamBuffer.dwBufferCr = DisplayCAddr;
            tCamParamBuffer.bWaitForVSync = FALSE;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_SOURCE_BUFFER, &tCamParamBuffer, sizeof(CAMARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_SOURCE_BUFFER Failed\n"));
	            return 0;
            }

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_PROCESSING_START Failed\n"));
	            return 0;
            }
			

		}
	}
	else{
		printf("[SsbSipDisplayClose]Invalid Mode... can't close surface\n");
		return 0;
	}

	return 1;

}

int SsbSipDisplayInit(MFCExeMode exeMode)
{
	return(SsbSipDisplayOpen(exeMode));

}
void SsbSipDisplayDeInit(MFCExeMode exeMode)
{
	SsbSipDisplayClose(exeMode);
	CloseHandle(hCMMOpen);

}

int GetFrameBuffer()
{
	CMM_ALLOC_PRAM_T	CMMParam;
	int 				phyFrmBuf;
	int					virFrmBuf;
	int					r;

	//CMM init
	hCMMOpen = CreateFile(L"CMM1:",
					   GENERIC_READ|GENERIC_WRITE,
					   0,
					   NULL,
					   OPEN_EXISTING,
					   FILE_ATTRIBUTE_NORMAL,
					   NULL);
	if (hCMMOpen == INVALID_HANDLE_VALUE)
	{
		printf("CMM Open failure\n");
		return 0;
	}

    // allocation of Y Frame buffer
    CMMParam.size = (unsigned int)800*480*4;
    CMMParam.cacheFlag = 0;
    CMMParam.dramLocation = DRAM_1;

	r = DeviceIoControl(hCMMOpen, IOCTL_CODEC_MEM_ALLOC, (PBYTE)&CMMParam, 
                        sizeof(CMM_ALLOC_PRAM_T *), &virFrmBuf, sizeof(virFrmBuf), 
                        NULL, NULL);
	if(r == FALSE)
	{
        printf("IOCTL_CODEC_MEM_ALLOC failed\n");
        return 0;
	}

	r = DeviceIoControl(hCMMOpen, IOCTL_CODEC_GET_PHY_ADDR, (PBYTE)virFrmBuf, 
                        sizeof(virFrmBuf), &phyFrmBuf, sizeof(phyFrmBuf), 
                        NULL, NULL);
	if(r == FALSE)
	{
        printf("IOCTL_CODEC_GET_PHY_ADDR failed\n");
        return 0;
	}

	return phyFrmBuf;

}
