/*********************************************************************************
*                                                                               *
* Copyright (c) 2008 Samsung System LSI											*
* All rights reserved.                                                          *
*                                                                               *
* This software is test sample code for MFC v5.0								*
*																				*
* Author : Jiyoung Shin 								    					*	
* Last Changed : 2008.08.05 													*
*********************************************************************************/

#include <windows.h>
#include <ceddk.h>
#include "MfcRender.h"
#include "SVEDriverAPI.h"
#include "camif.h"
#include "Camif_reg.h"
#include "CAMDriver.h"
#include "CMMAPI.h"

#define MEM_TO_MEM		  1

int GetFrameBuffer();

HANDLE 			hVideoOverlay_1 = INVALID_HANDLE_VALUE;
HANDLE 			hVideoOverlay_2 = INVALID_HANDLE_VALUE;
HANDLE			hCamDrv = INVALID_HANDLE_VALUE;
HANDLE			hCMMOpen = INVALID_HANDLE_VALUE;

static DWORD *g_pdwWin1Ctrl = NULL;
static unsigned int	DisplayOffsetX, DisplayOffsetY;
static BOOL	bFirstRenderOverlay_1;
static BOOL	bFirstRenderOverlay_2;
static int 	FRAME_BUFFER_VIR_ADDR;
static int 	FRAME_BUFFER_PHY_ADDR;

//////////////////////////////////////////////////////
//													//
//               Primary(WIN2)						//
//													//
//////////////////////////////////////////////////////
//                        //                        //
//                        //                        //
//    vt_call_dec         //         vt_call        //
//    (overaly_1/WIN1)    //       (overlay_2/WIN0) //
//                        //                        //
//////////////////////////////////////////////////////

static int SsbSipDisplayOpen(MFCExeMode exeMode)
{
	DWORD 			dwBytes;

	if((exeMode == SINGLE_DECODE) || (exeMode == DEC_ENC) || (exeMode == DEC_UNIT) || (exeMode == DEC_DEC_DISPLAY_1)){ // use local_path
		printf("SsbSipDisplayOpen : SINGLE_DECODE or VT_CALL_DEC \n");
		hVideoOverlay_1 = CreateFile( L"VDE0:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
		if (hVideoOverlay_1 == INVALID_HANDLE_VALUE)
		{
			RETAILMSG(1,(L"[VDE:ERR] VDE0 Open Device Failed\n"));
			return 0;
		}

		// Request FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_REQUEST_FIMD_WIN1, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_REQUEST_FIMD_WIN1 Failed\n"));
			return 0;
		}
		
		// Request Post Processor H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_REQUEST_POST, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_REQUEST_POST Failed\n"));
			return 0;
		}

		bFirstRenderOverlay_1 = TRUE;
	}
	else if(exeMode == DEC_DEC_DISPLAY_2){
		printf("SsbSipDisplayOpen : VT_CALL\n");
		hVideoOverlay_2 = CreateFile( L"VDE0:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
		if (hVideoOverlay_2 == INVALID_HANDLE_VALUE)
		{
			RETAILMSG(1,(L"[VDE:ERR] VDE0 Open Device Failed\n"));
			return 0;
		}

		// Request FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_RSC_REQUEST_FIMD_WIN0, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_REQUEST_FIMD_WIN0 Failed\n"));
			return 0;
		}

		hCamDrv = CreateFile( L"CAM1:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
		if (hCamDrv == INVALID_HANDLE_VALUE)
		{
			RETAILMSG(1,(L"[CAM:ERR] CAM1 Open Device Failed\n"));
			return 0;
		}

		// Request resource for the camera driver
		if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_RSC_REQUEST, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_RSC_REQUEST Failed\n"));
			return 0;
		}

		bFirstRenderOverlay_2 = TRUE;
	}
	else{
		printf("[SsbSipDisplayOpen]Invalid Mode... can't create surface\n");
		return 0;
	}



	return	1;

}

int SsbSipDisplayClose(MFCExeMode exeMode)
{
	DWORD 			dwBytes;
	DWORD			dwWinNum;

	if((exeMode == SINGLE_DECODE) || (exeMode == DEC_ENC) || (exeMode == DEC_UNIT) || (exeMode == DEC_DEC_DISPLAY_1)){
#if MEM_TO_MEM
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_STOP, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_STOP Failed\n"));
			return 0;
		}

		dwWinNum = DISP_WIN1;
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_DISABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_DISABLE Failed\n"));
			return 0;
		}
#else
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_LOCALPATH_SET_WIN1_STOP, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_LOCALPATH_SET_WIN1_STOP Failed\n"));
			return 0;
		}
#endif
		// Release FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_RELEASE_FIMD_WIN1, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_RELEASE_FIMD_WIN1 Failed\n"));
			return 0;
		}

		// Release Post Processor H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_RSC_RELEASE_POST, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_RELEASE_POST Failed\n"));
			return 0;
		}

		CloseHandle(hVideoOverlay_1);


	}
	else if(exeMode == DEC_DEC_DISPLAY_2){
		if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_WAIT_PROCESSING_DONE, NULL, 0, NULL, 0, &dwBytes, NULL) )
        {
            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_WAIT_PROCESSING_DONE Failed\n"));
            return 0;
        }

		if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_RSC_RELEASE, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_RSC_RELEASE Failed\n"));
			return 0;
		}
		CloseHandle(hCamDrv);

		dwWinNum = DISP_WIN0;
		if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_DISABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_DISABLE Failed\n"));
			return 0;
		}

		// Release FIMD Win0 H/W Resource to Video Engine Driver for Local Path
		if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_RSC_RELEASE_FIMD_WIN0, NULL, 0, NULL, 0, &dwBytes, NULL) )
		{
			RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_RSC_RELEASE_FIMD_WIN0 Failed\n"));
			return 0;
		}
		CloseHandle(hVideoOverlay_2);
	}	
	else{
		printf("[SsbSipDisplayClose]Invalid Mode... can't close surface\n");
		return 0;
	}

	return 1;
}




 
int SsbSipDisplayStart(MFCExeMode exeMode, int DisplayYAddr, int DisplayCAddr, int DisplayWidth, int DisplayHeight)
{
	int							ret;
	SVEARG_FIMD_WIN_MODE		tParamMode;
	SVEARG_FIMD_WIN_FRAMEBUFFER tParamFB;
	SVEARG_FIMD_WIN_ALPHA_EX	tParamAlpha;
	SVEARG_POST_PARAMETER		tParamPost;
	SVEARG_POST_BUFFER			tParamBuffer;
	CAMARG_POST_PARAMETER		tCamParamPost;
	CAMARG_POST_BUFFER			tCamParamBuffer;
	DWORD 						dwBytes;
	DWORD						dwWinNum;
	int							FRAME_BUFFER_ADDR;




	if((exeMode == SINGLE_DECODE) || (exeMode == DEC_ENC) || (exeMode == DEC_UNIT) || (exeMode == DEC_DEC_DISPLAY_1))// use local path, full window
	{ 
#if MEM_TO_MEM
		if (bFirstRenderOverlay_1)
		{
				printf("MEM_TO_MEM\n");
				bFirstRenderOverlay_1 = FALSE;
				FRAME_BUFFER_PHY_ADDR = GetFrameBuffer();
				//memcpy(virFrmBuf, DisplayYAddr, 
				printf("GetFrameBuffer : 0x%08x\n", FRAME_BUFFER_PHY_ADDR);

				tParamMode.dwWinMode = DISP_WIN1_DMA;
				tParamMode.dwBPP = DISP_24BPP_888;
				tParamMode.dwWidth = DISPLAY_X;
				tParamMode.dwHeight = DISPLAY_Y;
				tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
				tParamMode.dwOffsetY = (LCD_Y - tParamMode.dwHeight)/2;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_MODE, &tParamMode, sizeof(SVEARG_FIMD_WIN_MODE), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_MODE Failed\n"));
					return 0;
				}

				tParamAlpha.dwWinNum = DISP_WIN2;
				tParamAlpha.dwMethod = DISP_ALPHA_PER_PLANE;
				tParamAlpha.dwAlpha0 = 0x0;
				tParamAlpha.dwAlpha1 = 0x0;
				tParamAlpha.dwABlendEq = DISP_BLDEQ_ALPHA_A;
				tParamAlpha.dwBBlendEq = DISP_BLDEQ_INV_ALPHA_A;
				tParamAlpha.dwPBlendEq = DISP_BLDEQ_ZERO;
				tParamAlpha.dwQBlendEq = DISP_BLDEQ_ZERO;
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX, &tParamAlpha, sizeof(SVEARG_FIMD_WIN_ALPHA_EX), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX Failed\n"));
				}

				// Set Window0 Framebuffer
				tParamFB.dwWinNum = DISP_WIN1;
				tParamFB.dwFrameBuffer = FRAME_BUFFER_PHY_ADDR;
				tParamFB.bWaitForVSync = FALSE;
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER, &tParamFB, sizeof(SVEARG_FIMD_WIN_FRAMEBUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER Failed\n"));
					return 0;
				}

				// Window0 Enable
				dwWinNum = DISP_WIN1;
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_ENABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_ENABLE Failed\n"));
					return 0;
				}

				tParamPost.dwOpMode = POST_PER_FRAME_MODE;
				tParamPost.dwScanMode = POST_PROGRESSIVE;
				tParamPost.dwSrcType = POST_SRC_NV12;
				tParamPost.dwRotFlipMode = MAKELONG(POST_0_NOFLIP, POST_0_NOFLIP);
				tParamPost.dwDMATileMode = MAKELONG(POST_DMA_LINEAR, POST_DMA_64BY32);
			 	tParamPost.dwSrcBaseWidth = DisplayWidth;
				tParamPost.dwSrcBaseHeight = DisplayHeight;
				tParamPost.dwSrcOffsetX = DisplayOffsetX;
				tParamPost.dwSrcOffsetY = DisplayOffsetY;
				tParamPost.dwSrcWidth = DisplayWidth;
				tParamPost.dwSrcHeight = DisplayHeight ;
				tParamPost.dwDstType = POST_DST_RGB24;
			 	tParamPost.dwDstBaseWidth = DISPLAY_X;
				tParamPost.dwDstBaseHeight = DISPLAY_Y;
				tParamPost.dwDstWidth = DISPLAY_X;
				tParamPost.dwDstHeight = DISPLAY_Y;
				tParamPost.dwDstOffsetX = (tParamPost.dwDstBaseWidth - tParamPost.dwDstWidth)/2;
				tParamPost.dwDstOffsetY = (tParamPost.dwDstBaseHeight - tParamPost.dwDstHeight)/2;



				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_PARAM, &tParamPost, sizeof(SVEARG_POST_PARAMETER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_PARAM Failed\n"));
					return 0;
				}

				tParamBuffer.dwBufferRGBY =DisplayYAddr;
				tParamBuffer.dwBufferCb = DisplayCAddr;
				tParamBuffer.dwBufferCr = DisplayCAddr;
				tParamBuffer.bWaitForVSync = FALSE;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_SOURCE_BUFFER Failed\n"));
					return 0;
				}

				// Destination Address
				tParamBuffer.dwBufferRGBY = FRAME_BUFFER_PHY_ADDR;
				tParamBuffer.dwBufferCb = 0;
				tParamBuffer.dwBufferCr = 0;
				tParamBuffer.bWaitForVSync = FALSE;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_DESTINATION_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_DESTINATION_BUFFER Failed\n"));
					return 0;
				}

				// Post Processing Start
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_START Failed\n"));
					return 0;
				}
			}
			else
			{
				// Wait for Post Processing Finished
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_WAIT_PROCESSING_DONE, NULL, 0, NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_WAIT_PROCESSING_DONE Failed\n"));
					return 0;
				}

				// Source Address
				tParamBuffer.dwBufferRGBY =DisplayYAddr;
				tParamBuffer.dwBufferCb = DisplayCAddr;
				tParamBuffer.dwBufferCr = DisplayCAddr;
				tParamBuffer.bWaitForVSync = FALSE;

				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_SOURCE_BUFFER Failed\n"));
					return 0;
				}

				// Post Processing Start
				if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
				{
					RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_START Failed\n"));
					return 0;
				}
			}
#else
		if (bFirstRenderOverlay_1)
		{
			printf("SsbSipDisplayStart : SINGLE_DECODE \n");
			printf("LOCAL_PATH\n");
			bFirstRenderOverlay_1 = FALSE;

			tParamMode.dwWinMode = DISP_WIN1_CAMIF1_RGB;
			tParamMode.dwBPP = DISP_24BPP_888;

			if((exeMode == SINGLE_DECODE) || (exeMode == DEC_UNIT)){
				tParamMode.dwWidth = DISPLAY_X;
				tParamMode.dwHeight = DISPLAY_Y;
				tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
				tParamMode.dwOffsetY = (LCD_Y - tParamMode.dwHeight)/2;
			}
			else{
				tParamMode.dwWidth = DISPLAY_X;
				tParamMode.dwHeight = DISPLAY_Y/2;
				tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
				tParamMode.dwOffsetY = (LCD_Y - (tParamMode.dwHeight*2))/2;
			}

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_MODE, &tParamMode, sizeof(SVEARG_FIMD_WIN_MODE), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_MODE Failed\n"));
				return 0;
			}

			tParamAlpha.dwWinNum = DISP_WIN2;
			tParamAlpha.dwMethod = DISP_ALPHA_PER_PLANE;
			tParamAlpha.dwAlpha0 = 0x0;
			tParamAlpha.dwAlpha1 = 0x0;
			tParamAlpha.dwABlendEq = DISP_BLDEQ_ALPHA_A;
			tParamAlpha.dwBBlendEq = DISP_BLDEQ_INV_ALPHA_A;
			tParamAlpha.dwPBlendEq = DISP_BLDEQ_ZERO;
			tParamAlpha.dwQBlendEq = DISP_BLDEQ_ZERO;
			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX, &tParamAlpha, sizeof(SVEARG_FIMD_WIN_ALPHA_EX), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX Failed\n"));
			}

			tParamPost.dwOpMode = POST_FREE_RUN_MODE;
			tParamPost.dwScanMode = POST_PROGRESSIVE;
			tParamPost.dwSrcType = POST_SRC_NV12;
			tParamPost.dwRotFlipMode = MAKELONG(POST_0_NOFLIP, POST_0_NOFLIP);
			tParamPost.dwDMATileMode = MAKELONG(POST_DMA_LINEAR, POST_DMA_64BY32);
			printf("ROT_VAL : %d\n", tParamPost.dwRotFlipMode);
		 	tParamPost.dwSrcBaseWidth = DisplayWidth;
			tParamPost.dwSrcBaseHeight = DisplayHeight;
			tParamPost.dwSrcOffsetX = DisplayOffsetX;
			tParamPost.dwSrcOffsetY = DisplayOffsetY;
			tParamPost.dwSrcWidth = DisplayWidth;
			tParamPost.dwSrcHeight = DisplayHeight ;
			tParamPost.dwDstType = POST_DST_FIFO_RGB888;

			if((exeMode == SINGLE_DECODE) || (exeMode == DEC_UNIT)){
		 		tParamPost.dwDstBaseWidth = DISPLAY_X;
				tParamPost.dwDstBaseHeight = DISPLAY_Y;
				tParamPost.dwDstWidth = DISPLAY_X;
				tParamPost.dwDstHeight = DISPLAY_Y;
			}
			else{
		 		tParamPost.dwDstBaseWidth = DISPLAY_X;
				tParamPost.dwDstBaseHeight = DISPLAY_Y/2;
				tParamPost.dwDstWidth = DISPLAY_X;
				tParamPost.dwDstHeight = DISPLAY_Y/2;
			}

			tParamPost.dwDstOffsetX = (tParamPost.dwDstBaseWidth - tParamPost.dwDstWidth)/2;
			tParamPost.dwDstOffsetY = (tParamPost.dwDstBaseHeight - tParamPost.dwDstHeight)/2;



			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_PROCESSING_PARAM, &tParamPost, sizeof(SVEARG_POST_PARAMETER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_PROCESSING_PARAM Failed\n"));
				return 0;
			}

			tParamBuffer.dwBufferRGBY = DisplayYAddr;
			tParamBuffer.dwBufferCb = DisplayCAddr;
			tParamBuffer.dwBufferCr = DisplayCAddr;
			tParamBuffer.bWaitForVSync = FALSE;

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_SOURCE_BUFFER Failed\n"));
				return 0;
			}

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER Failed\n"));
				return 0;
			}

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_LOCALPATH_SET_WIN1_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_LOCALPATH_SET_WIN1_START Failed\n"));
				return 0;
			}
		}
		else
		{
			tParamBuffer.dwBufferRGBY = DisplayYAddr;
			tParamBuffer.dwBufferCb = DisplayCAddr;
			tParamBuffer.dwBufferCr = DisplayCAddr;
			tParamBuffer.bWaitForVSync = FALSE;

			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER, &tParamBuffer, sizeof(SVEARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER Failed\n"));
				return 0;
			}
		}
#endif
	}
	else if(exeMode == DEC_DEC_DISPLAY_2) // use mem_to_mem, right hand side of window
	{ 
		if (bFirstRenderOverlay_2)
		{
			printf("SsbSipDisplayStart : VT_CALL\n");
			bFirstRenderOverlay_2 = FALSE;

			tParamMode.dwWinMode = DISP_WIN0_DMA;
			tParamMode.dwBPP = DISP_24BPP_888;
			tParamMode.dwWidth = DISPLAY_X;
			tParamMode.dwHeight = DISPLAY_Y/2;
			tParamMode.dwOffsetX = (LCD_X - tParamMode.dwWidth)/2;
			tParamMode.dwOffsetY = LCD_Y/2 - (LCD_Y/2 - tParamMode.dwHeight)/2;

			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_MODE, &tParamMode, sizeof(SVEARG_FIMD_WIN_MODE), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_MODE Failed\n"));
				return 0;
			}

			tParamAlpha.dwWinNum = DISP_WIN2;
			tParamAlpha.dwMethod = DISP_ALPHA_PER_PLANE;
			tParamAlpha.dwAlpha0 = 0x0;
			tParamAlpha.dwAlpha1 = 0x0;
			tParamAlpha.dwABlendEq = DISP_BLDEQ_ALPHA_A;
			tParamAlpha.dwBBlendEq = DISP_BLDEQ_INV_ALPHA_A;
			tParamAlpha.dwPBlendEq = DISP_BLDEQ_ZERO;
			tParamAlpha.dwQBlendEq = DISP_BLDEQ_ZERO;
			if ( !DeviceIoControl(hVideoOverlay_1, IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX, &tParamAlpha, sizeof(SVEARG_FIMD_WIN_ALPHA_EX), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX Failed\n"));
			}

			// Set Window0 Framebuffer
			FRAME_BUFFER_PHY_ADDR = GetFrameBuffer();
			tParamFB.dwWinNum = DISP_WIN0;
			tParamFB.dwFrameBuffer = FRAME_BUFFER_PHY_ADDR;
			tParamFB.bWaitForVSync = FALSE;
			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER, &tParamFB, sizeof(SVEARG_FIMD_WIN_FRAMEBUFFER), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER Failed\n"));
				return 0;
			}

			// Window0 Enable
			dwWinNum = DISP_WIN0;
			if ( !DeviceIoControl(hVideoOverlay_2, IOCTL_SVE_FIMD_SET_WINDOW_ENABLE, &dwWinNum, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
			{
				RETAILMSG(1,(L"[VDE:ERR] IOCTL_SVE_FIMD_SET_WINDOW_ENABLE Failed\n"));
				return 0;
			}


			// Set processing parameters
            tCamParamPost.dwOpMode = POST_PER_FRAME_MODE;
            tCamParamPost.dwScanMode = POST_PROGRESSIVE;
			tCamParamPost.dwRotFlipMode = MAKELONG(POST_90_NOFLIP, POST_0_NOFLIP);
			tCamParamPost.dwDMATileMode = MAKELONG(POST_DMA_LINEAR, POST_DMA_64BY32);
            tCamParamPost.dwSrcType = POST_SRC_NV12;
            tCamParamPost.dwSrcBaseWidth = DisplayWidth;
            tCamParamPost.dwSrcBaseHeight = DisplayHeight;
            tCamParamPost.dwSrcOffsetX = DisplayOffsetX;
            tCamParamPost.dwSrcOffsetY = DisplayOffsetY;
            tCamParamPost.dwSrcWidth = DisplayWidth;
            tCamParamPost.dwSrcHeight = DisplayHeight;
            tCamParamPost.dwDstType = POST_DST_RGB24;
            tCamParamPost.dwDstBaseWidth = DISPLAY_X;
            tCamParamPost.dwDstBaseHeight = DISPLAY_Y/2;
            tCamParamPost.dwDstWidth = DISPLAY_X;
            tCamParamPost.dwDstHeight = DISPLAY_Y/2;
            tCamParamPost.dwDstOffsetX = (tCamParamPost.dwDstBaseWidth - tCamParamPost.dwDstWidth)/2;
            tCamParamPost.dwDstOffsetY = (tCamParamPost.dwDstBaseHeight - tCamParamPost.dwDstHeight)/2;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_PROCESSING_PARAM, &tCamParamPost, sizeof(CAMARG_POST_PARAMETER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_PROCESSING_PARAM Failed\n"));
	            return 0;
            }
        	
            tCamParamBuffer.dwBufferRGBY = DisplayYAddr;
            tCamParamBuffer.dwBufferCb = DisplayCAddr;
            tCamParamBuffer.dwBufferCr = DisplayCAddr;
            tCamParamBuffer.bWaitForVSync = FALSE;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_SOURCE_BUFFER, &tCamParamBuffer, sizeof(CAMARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_SOURCE_BUFFER Failed\n"));
	            return 0;
            }

            // Destination Address
	
            tCamParamBuffer.dwBufferRGBY = FRAME_BUFFER_PHY_ADDR;
            tCamParamBuffer.dwBufferCb = 0;
            tCamParamBuffer.dwBufferCr = 0;
            tCamParamBuffer.bWaitForVSync = FALSE;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_DESTINATION_BUFFER, &tCamParamBuffer, sizeof(CAMARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_DESTINATION_BUFFER Failed\n"));
	            return 0;
            }
		
            // Post Processing Start for DISPWIN2 and CAMIF3

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_PROCESSING_START Failed\n"));
	            return 0;
            }

			}
		else
		{

			if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_WAIT_PROCESSING_DONE, NULL, 0, NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_WAIT_PROCESSING_DONE Failed\n"));
	            return 0;
            }
            tCamParamBuffer.dwBufferRGBY = DisplayYAddr;
            tCamParamBuffer.dwBufferCb = DisplayCAddr;
            tCamParamBuffer.dwBufferCr = DisplayCAddr;
            tCamParamBuffer.bWaitForVSync = FALSE;

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_SOURCE_BUFFER, &tCamParamBuffer, sizeof(CAMARG_POST_BUFFER), NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_SOURCE_BUFFER Failed\n"));
	            return 0;
            }

            if ( !DeviceIoControl(hCamDrv, IOCTL_CAM_POST_SET_PROCESSING_START, NULL, 0, NULL, 0, &dwBytes, NULL) )
            {
	            RETAILMSG(1,(L"[CAM:ERR] IOCTL_CAM_POST_SET_PROCESSING_START Failed\n"));
	            return 0;
            }
			

		}
	}
	else{
		printf("[SsbSipDisplayClose]Invalid Mode... can't close surface\n");
		return 0;
	}

	return 1;

}

int SsbSipDisplayInit(MFCExeMode exeMode)
{
	return(SsbSipDisplayOpen(exeMode));

}
void SsbSipDisplayDeInit(MFCExeMode exeMode)
{
	int					r;

	SsbSipDisplayClose(exeMode);
	r = DeviceIoControl(hCMMOpen, IOCTL_CODEC_MEM_FREE, (PBYTE)FRAME_BUFFER_VIR_ADDR, 
                        sizeof(FRAME_BUFFER_VIR_ADDR), NULL, 0, 
                        NULL, NULL);
	if(r == FALSE)
        printf("IOCTL_DISP_MEM_FREE failed\n");

	CloseHandle(hCMMOpen);

}

int GetFrameBuffer()
{
	CMM_ALLOC_PRAM_T	CMMParam;
	int 				phyFrmBuf;
	int					virFrmBuf;
	int					r;

	//CMM init
	hCMMOpen = CreateFile(L"CMM1:",
					   GENERIC_READ|GENERIC_WRITE,
					   0,
					   NULL,
					   OPEN_EXISTING,
					   FILE_ATTRIBUTE_NORMAL,
					   NULL);
	if (hCMMOpen == INVALID_HANDLE_VALUE)
	{
		printf("CMM Open failure\n");
		return 0;
	}

    // allocation of Y Frame buffer
    CMMParam.size = (unsigned int)800*480*4;
    CMMParam.cacheFlag = 0;
    CMMParam.dramLocation = DRAM_0;

	r = DeviceIoControl(hCMMOpen, IOCTL_DISPLAY_MEM_ALLOC, (PBYTE)&CMMParam, 
                        sizeof(CMM_ALLOC_PRAM_T *), &virFrmBuf, sizeof(virFrmBuf), 
                        NULL, NULL);
	if(r == FALSE)
	{
        printf("IOCTL_DISP_MEM_ALLOC failed\n");
        return 0;
	}

	FRAME_BUFFER_VIR_ADDR = virFrmBuf;

	r = DeviceIoControl(hCMMOpen, IOCTL_CODEC_GET_PHY_ADDR, (PBYTE)virFrmBuf, 
                        sizeof(virFrmBuf), &phyFrmBuf, sizeof(phyFrmBuf), 
                        NULL, NULL);
	if(r == FALSE)
	{
        printf("IOCTL_CODEC_GET_PHY_ADDR failed\n");
        return 0;
	}

	return phyFrmBuf;

}
