/*********************************************************************************
*                                                                               *
* Copyright (c) 2008 Samsung System LSI											*
* All rights reserved.                                                          *
*                                                                               *
* This software is test sample code for Hybrid Divx Decoder						*
*																				*
* Author : Jiyoung Shin 								    						
* Last Changed : 2008.08.05 													
*********************************************************************************/
#include "MfcInterface.h"
#include "MfcParser.h"

#include <windows.h>

extern void *InitRawFrameExtract(char* pFilename);
extern int GetRawFrameExtract(void *handle, unsigned int index, void *buf, int *isLastFrame);
extern void DeInitRawFrameExtract(void *handle);


FRAMEX_CTX  		*FrameExCtx;
unsigned int 		strm_index;

static ParserInParam	*InParam = NULL;
static ParserOutParam	*OutParam = NULL;


int SsbSipParserFrameGet(void *handle, unsigned int index, void *buf, int *isLastFrame)
{
	int		i;
	
	if(InParam->isRawStream == 1)
	{
		return GetRawFrameExtract(handle, index, buf, isLastFrame);
	}

}


bool CheckExtension(char* fileExt)
{
	char pCh[10];
	int i=-1;
	int mode;
	do
	{
		i++;
		if (fileExt[i]>='A' && fileExt[i]<='Z')
			pCh[i] = fileExt[i]+32;
		else
			pCh[i] = fileExt[i];
	}
	while (pCh[i]);
	
	if ( (strcmp(pCh, "m4v")==0)||(strcmp(pCh, "mp4")==0))
		mode = 1;
	else if ( (strcmp(pCh, "msv")==0))
		mode = 1;
	else if ( (strcmp(pCh, "264")==0)||(strcmp(pCh, "26l")==0) )
		mode = 1;
	else if ( (strcmp(pCh, "dvx")==0))
		mode = 1;
	else if ( (strcmp(pCh, "xvd")==0))
		mode = 1;
	else if ( (strcmp(pCh, "263")==0))
		mode = 1;
	else if ( (strcmp(pCh, "m2v")==0) || (strcmp(pCh, "mpg")==0)|| (strcmp(pCh, "mpeg")==0))
		mode = 1;
	else if ( (strcmp(pCh, "rcv")==0)||(strcmp(pCh, "vc1")==0) )
		mode = 1;
	else
		return false;

	return mode;
}

void *SsbSipParserInit(SSBSIP_MFC_CODEC_TYPE codec_type, char *inputFileName, int size)
{
	unsigned int 			i;
	char* pFileExt;
	static unsigned char 	delimiter_mpeg4[3] = {0x00, 0x00, 0x01};
	void				*hParser;

	InParam = (ParserInParam*)malloc(sizeof(ParserInParam));


	pFileExt = strrchr(inputFileName, '.');
	pFileExt++;
	

	if(true == CheckExtension(pFileExt))
	{
		if((hParser = InitRawFrameExtract(inputFileName)) == NULL)
		{
			printf("InitRawFrameExtract fail\n");
			return NULL;
		}
		printf("SsbSipParserInit\n");
		InParam->isRawStream = 1;
		return hParser;
	}

}

BOOL SsbSipParserDeInit(void *handle)
{
	if(InParam->isRawStream == 1)
	{
		DeInitRawFrameExtract(handle);
		if(InParam)
			free(InParam);
		return TRUE;
	}
}


