#ifndef __VSPARSER_H__
#define __VSPARSER_H__

//#include "system.h"
//#include "mfc.h"

#define RCV_VC1_TYPE (0x85)
/* Bit 6 of the type indicates V1 if 0, V2 if 1 */
#define RCV_V2_MASK (1 << 6)
/* Top nibble bits of frame size word are flags in V2 */
#define RCV_V2_FRAMESIZE_FLAGS (0xf0000000)
#define RCV_V2_KEYFRAME_FLAG   (0x80000000)
/* V2 extra information has a VBR flag */
#define RCV_V2_VBR_FLAG (0x10000000)

typedef unsigned int        u32;
typedef unsigned short      u16;
typedef unsigned char       u8;
typedef signed   int        s32;
typedef signed   short      s16;
typedef signed   char       s8;

typedef enum
{
    H264_DEC,
    VC1_DEC,
    MPEG4_DEC,
    XVID_DEC,
    MPEG1_DEC,
    MPEG2_DEC,
    H263_DEC,
    VC1RCV_DEC, // rcv format
    DIVX311_DEC,
    DIVX412_DEC,
    DIVX502_DEC,
    DIVX503_DEC,
    H264_ENC,
    MPEG4_ENC,
    H263_ENC,
    UNKNOWN_TYPE
} SSBSIP_MFC_CODEC_TYPE;

#if 0
bool ParseVc1Stream(u32  uBufferStartAddr, u32 uBufferByteSize,  bool bIsHeader,
	u32* uFrameStartAddr, u32* uCurFrameSize, u32* uNumOfTotalFrames); //outputs

bool ParseMp4Stream(u32 uRdPtr, u32 uRemainBytes, bool bIsHeader,  //inputs
	u32* uFrameStAddr, u32* uFrameSize, bool* bIsShortHeader);//outputs

bool ParseH264Stream(u32 uStreamStAddr, u32 uStreamFileSize, u32 uFrameArrayStAddr, u32* uNumOfFrames, u32* uEndOfFrameArray);

u32 vc1_parse_MFC50RCV_Frame(u32  buffer_start_addr, u32  buffer_size, u8 *src_mem, u32 *frame_start_addr,  u32 *frame_size);
//u32 vc1_parseRCV_Frame(u32 *frame_start_addr, u8 *src_mem, u32  buffer_size, u32* frameSize, u32 firstFrameFlag);
u32 vc1_parseRCV_Frame(u8 *src_mem, u32  buffer_size, u32* frameSize, u32 firstFrameFlag);

#endif

typedef struct __AVI_INFOs
{
	SSBSIP_MFC_CODEC_TYPE standard;
	unsigned char fccHandler[5];
	u32 total_frames;
	u32 width;
	u32 height;
}AVI_INFOs;

typedef struct _RAMFILE {
	unsigned long filestart;
	unsigned long offset;
	unsigned long filesize;
}RFILE;

u32 VsParser(SSBSIP_MFC_CODEC_TYPE standard, u32 buffer_start_addr, u32 buffer_size, u32 *frame_start_addr, 
	u32 *frame_size, u8 bIsRcvFlag, u8 is_first_seq_header);
u32 mpeg4_parse(SSBSIP_MFC_CODEC_TYPE standard, u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr,
	u32* frame_size, u8 is_first_seq_header);

u32 mpeg2_parse(u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr, 
	u32* frame_size, u8 is_first_seq_header) ;

u32 h264_parse(u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr, 
	u32* frame_size, u8 is_first_seq_header) ;

u8 SkippedPictureCheck(u8 *src_mem, u32 index);

u32 vc1_parse(u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr,
	u32* frame_size,	u8 rcvFlag, u8 is_first_seq_header);

u32 vc1_parse_advancedProfile_Frame(   u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32 *frame_start_addr,
	u32 *frame_size, u8 is_first_seq_header);

u32 rcv_parse(u32  buffer_start_addr, u32  buffer_size,	u8 *src_mem, u32 *frame_start_addr, u32 *frame_size);

u8 _parse_avi_header(RFILE* fp, u32 start_position, u32 total_size, AVI_INFOs* info);

u8 parse_avi_header(RFILE* fp, int position, u32 total_size, SSBSIP_MFC_CODEC_TYPE* standard, u32* width, u32* height);

u32 _read_word_little(unsigned char* buffer);
u8 get_fourcc1(unsigned char* buffer, unsigned char* FourCC);
u32 avi_parse(u32  buffer_start_addr, u32   buffer_size,   u8* src_mem,
							   u32* frame_start_addr,   u32* frame_size, u32* consumed_frame_size);



#endif// __VSPARSER_H__
