/*********************************************************************************
*                                                                               *
* Copyright (c) 2008 Samsung System LSI											*
* All rights reserved.                                                          *
*                                                                               *
* This software is test sample code for Hybrid Divx Decoder						*
*																				*
* Author : Jiyoung Shin															*
* Last Changed : 2008.06.10                                                     *
*********************************************************************************/

#ifndef __SAMSUNG_SYSLSI_SSBSIPAVI_PARSING_H__
#define __SAMSUNG_SYSLSI_SSBSIPAVI_PARSING_H__

#include "FrameExtractor.h"
#include "MPEG4Frames.h"
#include "H264Frames.h"
#include "H263Frames.h"
#include "VC1Frames.h"
#include <windows.h>

typedef enum 
{
	FORMAT_NOT_SUPPORT = 0,
	FORMAT_AVI,
	FORMAT_M4V,
	FORMAT_264,
	FORMAT_263
}FILE_EXTENTION;

typedef struct ParserInParam_t{
	char 		*filename;
	unsigned int	stream_size;
	SSBSIP_MFC_CODEC_TYPE codec_type;
	unsigned int	isRawStream;
}ParserInParam;

typedef struct ParserOutParam_t{
	unsigned int 	width;
	unsigned int 	height;
	unsigned int 	codec_version;
	unsigned int	dwScale;	
    unsigned int	dwRate;
	FILE_EXTENTION		file_format;
}ParserOutParam;

#ifdef __cplusplus
extern "C" {    
#endif

int SsbSipParserFrameGet(void *handle, unsigned int index, void *buf, int *isLastFrame);
void *SsbSipParserInit(SSBSIP_MFC_CODEC_TYPE codec_type, char *inputFileName, int size);
BOOL SsbSipParserDeInit(void *handle);

#ifdef __cplusplus
}        
#endif

#endif //__SAMSUNG_SYSLSI_SSBSIPAVI_PARSING_H__
