#ifndef _SVEDRIVERAPI_H_
#define _SVEDRIVERAPI_H_

//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    SVEDriverAPI.h

Abstract:       Type definition and function prototypes to use Samsung VIDEO Engine Stream Driver

Functions:


Notes:


--*/

#include <CAMDriver.h>

#if __cplusplus
extern "C"
{
#endif

//-----------------------------------------------------------------------------------------
//    Code Macro
//-----------------------------------------------------------------------------------------
#define SVE_DEVICE_TYPE        (0xA000)            // SVE-unique device type
#define SVE_ERROR_BASE        (0x20000000)        // Non system error code

#ifndef    METHOD_BUFFERED
#define METHOD_BUFFERED    (0)
#endif
#ifndef    FILE_ANY_ACCESS
#define FILE_ANY_ACCESS    (0)
#endif
#ifndef    CTL_CODE
#define CTL_CODE(DeviceType, Function, Method, Access) (((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method))
#endif
//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
//    API Function Code
//-----------------------------------------------------------------------------------------
typedef enum _SVE_API_FUNCTION_CODE
{
    SVE_RESOURCE_API_BASE = 100,

    // Resource Request/Release IOCTL(FIMD)
    SVE_RSC_REQUEST_FIMD_INTERFACE,
    SVE_RSC_RELEASE_FIMD_INTERFACE,
    SVE_RSC_REQUEST_FIMD_WIN0,
    SVE_RSC_RELEASE_FIMD_WIN0,
    SVE_RSC_REQUEST_FIMD_WIN1,
    SVE_RSC_RELEASE_FIMD_WIN1,
    SVE_RSC_REQUEST_FIMD_WIN2,
    SVE_RSC_RELEASE_FIMD_WIN2,
    SVE_RSC_REQUEST_FIMD_WIN3,
    SVE_RSC_RELEASE_FIMD_WIN3,
    SVE_RSC_REQUEST_FIMD_WIN4,
    SVE_RSC_RELEASE_FIMD_WIN4,

    // Resource Request/Release IOCTL(Post Processor)
    SVE_RSC_REQUEST_POST,
    SVE_RSC_RELEASE_POST,

    // Resource Request/Release IOCTL(Image Rotator)
    SVE_RSC_REQUEST_ROTATOR,
    SVE_RSC_RELEASE_ROTATOR,

    SVE_RESOURCE_API_END,

    // FIMD Function IOCTL
    SVE_FIMD_FUNCTION_API_BASE = 200,
    SVE_FIMD_SET_INTERFACE_PARAM,
    SVE_FIMD_SET_OUTPUT_RGBIF,
    SVE_FIMD_SET_WB_ENABLE,
    SVE_FIMD_SET_WB_DISABLE,
    SVE_FIMD_SET_OUTPUT_ENABLE,
    SVE_FIMD_SET_OUTPUT_DISABLE,
    SVE_FIMD_SET_WINDOW_MODE,
    SVE_FIMD_SET_WINDOW_POSITION,
    SVE_FIMD_SET_WINDOW_FRAMEBUFFER,
    SVE_FIMD_SET_WINDOW_COLORMAP,
    SVE_FIMD_SET_WINDOW_ENABLE,
    SVE_FIMD_SET_WINDOW_DISABLE,
    SVE_FIMD_SET_WINDOW_BLEND_DISABLE,
    SVE_FIMD_SET_WINDOW_BLEND_COLORKEY,
    SVE_FIMD_SET_WINDOW_BLEND_ALPHA,
    SVE_FIMD_WAIT_FRAME_INTERRUPT,
    SVE_FIMD_GET_OUTPUT_STATUS,
    SVE_FIMD_GET_WINDOW_STATUS,
    SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX,
    SVE_FIMD_SET_GAMMA,
    SVE_FIMD_SET_COLORGAIN,
    SVE_FIMD_SET_HUE,
    SVE_FIMD_SET_DITHERING,
    SVE_FIMD_SET_ALPS,
    SVE_FIMD_SET_WONDOW_QOS,
    SVE_FIMD_FUNCTION_API_END,

    // Post Processor Function IOCTL
    SVE_POST_FUNCTION_API_BASE = 300,
    SVE_POST_SET_PROCESSING_PARAM,
    SVE_POST_SET_SOURCE_BUFFER,
    SVE_POST_SET_NEXT_SOURCE_BUFFER,
    SVE_POST_SET_DESTINATION_BUFFER,
    SVE_POST_SET_PROCESSING_START,
    SVE_POST_SET_PROCESSING_STOP,
    SVE_POST_WAIT_PROCESSING_DONE,
    SVE_POST_GET_PROCESSING_STATUS,
    SVE_POST_FUNCTION_API_END,

    // Local Path (FIMD+Post) Function IOCTL
    SVE_LOCALPATH_FUNCTION_API_BASE = 400,
    SVE_LOCALPATH_SET_WIN0_START,
    SVE_LOCALPATH_SET_WIN0_STOP,
    SVE_LOCALPATH_SET_WIN1_START,
    SVE_LOCALPATH_SET_WIN1_STOP,
    SVE_LOCALPATH_SET_WIN2_START,
    SVE_LOCALPATH_SET_WIN2_STOP,
    SVE_LOCALPATH_FUNCTION_API_END,

    // Image Rotator Function IOCTL
    SVE_ROTATOR_FUNCTION_API_BASE = 500,
    SVE_ROTATOR_SET_OPERATION_PARAM,
    SVE_ROTATOR_SET_SOURCE_BUFFER,
    SVE_ROTATOR_SET_DESTINATION_BUFFER,
    SVE_ROTATOR_SET_OPERATION_START,
    SVE_ROTATOR_SET_OPERATION_STOP,
    SVE_ROTATOR_WAIT_OPERATION_DONE,
    SVE_ROTATOR_GET_STATUS,
    SVE_ROTATOR_FUNCTION_API_END,

    // Power Management IOCTL
    SVE_PM_POWER_API_BASE = 1000,
    SVE_PM_SET_POWER_ON,
    SVE_PM_SET_POWER_OFF,
    SVE_PM_GET_POWER_STATUS,
    SVE_PM_POWER_API_END,

    SVE_API_ENUM_END
} SVE_API_FUNCTION_CODE;    // 0x0 ~ 0xFFF
//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
//    API IOCTL Code
//-----------------------------------------------------------------------------------------
// Resource Request/Release IOCTL
#define    IOCTL_SVE_RSC_REQUEST_FIMD_INTERFACE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_FIMD_INTERFACE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_FIMD_INTERFACE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_FIMD_INTERFACE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_REQUEST_FIMD_WIN0    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_FIMD_WIN0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_FIMD_WIN0        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_FIMD_WIN0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_REQUEST_FIMD_WIN1    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_FIMD_WIN1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_FIMD_WIN1        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_FIMD_WIN1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_REQUEST_FIMD_WIN2    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_FIMD_WIN2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_FIMD_WIN2        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_FIMD_WIN2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_REQUEST_FIMD_WIN3    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_FIMD_WIN3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_FIMD_WIN3        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_FIMD_WIN3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_REQUEST_FIMD_WIN4    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_FIMD_WIN4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_FIMD_WIN4        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_FIMD_WIN4, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Resource Request/Release IOCTL(Post Processor)
#define    IOCTL_SVE_RSC_REQUEST_POST    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_POST, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_POST    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_POST, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Resource Request/Release IOCTL(Image Rotator)
#define    IOCTL_SVE_RSC_REQUEST_ROTATOR    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_REQUEST_ROTATOR, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_RSC_RELEASE_ROTATOR    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_RSC_RELEASE_ROTATOR, METHOD_BUFFERED, FILE_ANY_ACCESS)

// FIMD IOCTL
#define    IOCTL_SVE_FIMD_SET_INTERFACE_PARAM    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_INTERFACE_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_OUTPUT_RGBIF    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_OUTPUT_RGBIF, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WB_ENABLE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WB_ENABLE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WB_DISABLE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WB_DISABLE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_OUTPUT_ENABLE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_OUTPUT_ENABLE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_OUTPUT_DISABLE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_OUTPUT_DISABLE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_MODE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_MODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_POSITION        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_POSITION, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_FRAMEBUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_COLORMAP    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_COLORMAP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_ENABLE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_ENABLE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_DISABLE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_DISABLE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_BLEND_COLORKEY, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_BLEND_ALPHA, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_WAIT_FRAME_INTERRUPT    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_WAIT_FRAME_INTERRUPT, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_GET_OUTPUT_STATUS    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_GET_OUTPUT_STATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_GAMMA        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_GAMMA, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_COLORGAIN        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_COLORGAIN, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_HUE        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_HUE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_DITHERING        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_DITHERING, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_ALPS        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_ALPS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_FIMD_SET_WONDOW_QOS        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_FIMD_SET_WONDOW_QOS, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Post Processor IOCTL
#define    IOCTL_SVE_POST_SET_PROCESSING_PARAM    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_SET_PROCESSING_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_POST_SET_SOURCE_BUFFER    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_SET_SOURCE_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_POST_SET_NEXT_SOURCE_BUFFER    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_SET_NEXT_SOURCE_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_POST_SET_DESTINATION_BUFFER    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_SET_DESTINATION_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_POST_SET_PROCESSING_START    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_SET_PROCESSING_START, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_POST_SET_PROCESSING_STOP    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_SET_PROCESSING_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_POST_WAIT_PROCESSING_DONE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_WAIT_PROCESSING_DONE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_POST_GET_PROCESSING_STATUS    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_POST_GET_PROCESSING_STATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Local Path IOCTL
#define    IOCTL_SVE_LOCALPATH_SET_WIN1_START    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_LOCALPATH_SET_WIN1_START, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_LOCALPATH_SET_WIN1_STOP    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_LOCALPATH_SET_WIN1_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Image Rotator IOCTL
#define    IOCTL_SVE_ROTATOR_SET_OPERATION_PARAM    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_ROTATOR_SET_OPERATION_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_ROTATOR_SET_SOURCE_BUFFER    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_ROTATOR_SET_SOURCE_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_ROTATOR_SET_DESTINATION_BUFFER    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_ROTATOR_SET_DESTINATION_BUFFER, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_ROTATOR_SET_OPERATION_START    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_ROTATOR_SET_OPERATION_START, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_ROTATOR_SET_OPERATION_STOP    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_ROTATOR_SET_OPERATION_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_ROTATOR_WAIT_OPERATION_DONE    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_ROTATOR_WAIT_OPERATION_DONE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_ROTATOR_GET_STATUS    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_ROTATOR_GET_STATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Power Management IOCTL
#define    IOCTL_SVE_PM_SET_POWER_ON        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_PM_SET_POWER_ON, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_PM_SET_POWER_OFF        \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_PM_SET_POWER_OFF, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_SVE_PM_GET_POWER_STATUS    \
        CTL_CODE(SVE_DEVICE_TYPE, SVE_PM_GET_POWER_STATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)
//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
//    API Argument Data Structure
//-----------------------------------------------------------------------------------------
typedef struct    // IOCTL_SVE_FIMD_SET_WINDOW_MODE
{
    DWORD dwWinMode;    // FIMD Window Mode
    DWORD dwBPP;        // BitPerPixel
    DWORD dwWidth;        // Window Horizontal Pixel
    DWORD dwHeight;    // Window Vertical Pixel
    DWORD dwOffsetX;    // Window Horizontal Offset
    DWORD dwOffsetY;    // Window Vertical Offset
} SVEARG_FIMD_WIN_MODE;

typedef struct    // IOCTL_SVE_FIMD_SET_WINDOW_POSITION
{
    DWORD dwWinNum;    // FIMD Window Number
    DWORD dwOffsetX;    // Window Horizontal Offset
    DWORD dwOffsetY;    // Window Vertical Offset
    BOOL bWaitForVSync;        // Blocked Operation
} SVEARG_FIMD_WIN_POS;

typedef struct    // IOCTL_SVE_FIMD_SET_WINDOW_FRAMEBUFFER
{
    DWORD dwWinNum;        // FIMD Window Number
    DWORD dwFrameBuffer;    // Frame Buffer Address
    BOOL bWaitForVSync;        // Blocked Operation
} SVEARG_FIMD_WIN_FRAMEBUFFER;

typedef struct    // IOCTL_SVE_FIMD_SET_WINDOW_BLEND_COLORKEY
{
    DWORD dwWinNum;        // FIMD Window Number
    DWORD dwDirection;        // Keying Direction
    DWORD dwColorKey;        // Color Key Value
    DWORD dwCompareKey;    // Compare Key Value
    DWORD dwKeyAlpha;       // Key Alpha Value
    BOOL  bOnOff;            // Color Key Enable/Disable
    BOOL  bBlend;           // Blend enable/disable
} SVEARG_FIMD_WIN_COLORKEY;

typedef struct    // IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA
{
    DWORD dwWinNum;    // FIMD Window Number
    DWORD dwMethod;    // Blending Method (per Pixel or per Plane)
    DWORD dwAlpha0;    // Alpha Value 0
    DWORD dwAlpha1;    // Alpha Value 1
} SVEARG_FIMD_WIN_ALPHA;

typedef struct    // IOCTL_SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX
{
    DWORD dwWinNum;    // FIMD Window Number
    DWORD dwMethod;    // Blending Method (per Pixel or per Plane or Multiplied)
    DWORD dwAlpha0;    // Alpha Value 0
    DWORD dwAlpha1;    // Alpha Value 1
    DWORD dwABlendEq;  // A Blending Equation
    DWORD dwBBlendEq;  // B Blending Equation
    DWORD dwPBlendEq;  // P Blending Equation
    DWORD dwQBlendEq;  // Q Blending Equation
} SVEARG_FIMD_WIN_ALPHA_EX;

typedef struct    // IOCTL_SVE_FIMD_GET_OUTPUT_STATUS
{
    DWORD dwLineCnt;            // Line Counter
    DWORD dwVerticalStatus;        // Vertical Status
    DWORD dwHorizontalStatus;    // Horizontal Status
    BOOL bENVID;                // ENVID Field of VIDCON0
} SVEARG_FIMD_OUTPUT_STAT;

typedef struct  // IOCTL_SVE_FIMD_SET_GAMMA
{
    BOOL bEnable;       // Gamma control enable/disable
    UINT8 uiLUTSize;    // size of Gamma LUT, must be 65
    PBYTE pbGammaLUT;  // Points to Gamma LUT table
} SVEARG_FIMD_GAMMA_CONTROL;

typedef struct  // IOCTL_SVE_FIMD_SET_COLORGAIN
{
    BOOL bEnable;   // Color gain enable/disable
    WORD wRGain;    // Gain value of R data
    WORD wGGain;    // Gain value of G data
    WORD wBGain;    // Gain value of B data
} SVEARG_FIMD_COLORGAIN_CONTROL;

typedef CAMARG_POST_PARAMETER SVEARG_POST_PARAMETER;
/*
typedef struct    // IOCTL_SVE_POST_SET_PROCESSING_PARAM
{
    DWORD dwOpMode;        // Operation Mode (Frame or Free Run)
    DWORD dwScanMode;    // Scan Mode (Progressive or Interace)
    DWORD dwRotFlipMode;    // Rotation and Flip Mode ( HIWORD : Input Rotator, LOWORD : Output Rotator)
                            // Rotation can effect HW performance, use it carefully.
                            // Both Rotator can rotate 90,180,270, X-axis flip, Y-axis Flip, XY-axis flip.
                            // Input Rotator use NOT scaled and NOT Color converted data
                            // Output Rotator use Scaled and Color converted data
                            // These two rotator can not be used simultaneously
                            // If HIWORD has some value, LOWORD will be ignored.
                            // HIWORD : can have POST_ROTFLIP_MODE
                            // LOWORD : can have POST_ROTFLIP_MODE
    DWORD dwSrcType;        // Src Image Type
    DWORD dwSrcBaseWidth;
    DWORD dwSrcBaseHeight;
    DWORD dwSrcWidth;
    DWORD dwSrcHeight;
    DWORD dwSrcOffsetX;
    DWORD dwSrcOffsetY;
    DWORD dwDstType;        // Dst Image Type
    DWORD dwDstBaseWidth;
    DWORD dwDstBaseHeight;
    DWORD dwDstWidth;
    DWORD dwDstHeight;
    DWORD dwDstOffsetX;
    DWORD dwDstOffsetY;
} SVEARG_POST_PARAMETER;
*/

typedef struct    // IOCTL_SVE_POST_SET_XXX_BUFFER
{
    DWORD dwBufferRGBY;
    DWORD dwBufferCb;
    DWORD dwBufferCr;
    BOOL bWaitForVSync;        // Blocked Operation
} SVEARG_POST_BUFFER;

typedef struct
{
    DWORD dwImgFormat;    // Source Image Format
    DWORD dwOpType;        // Rotator Operation Type
    DWORD dwSrcWidth;
    DWORD dwSrcHeight;
} SVEARG_ROTATOR_PARAMETER;

typedef struct
{
    DWORD dwBufferRGBY;
    DWORD dwBufferCb;
    DWORD dwBufferCr;
} SVEARG_ROTATOR_BUFFER;
//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
//    API Pre-defined Parameter Enumeration
//-----------------------------------------------------------------------------------------
typedef enum _DISP_WINDOW_MODE
{
    DISP_WIN0_DMA = 0,
    DISP_WIN0_CAMIF0_RGB,
    DISP_WIN0_CAMIF0_YUV,
    DISP_WIN1_DMA,
    DISP_WIN1_CAMIF1_RGB,
    DISP_WIN1_CAMIF1_YUV,
    DISP_WIN1_VP_YUV,
    DISP_WIN2_DMA,
    DISP_WIN2_CAMIF2_RGB,
    DISP_WIN2_CAMIF2_YUV,
    DISP_WIN3_DMA,
    DISP_WIN4_DMA
} DISP_WINDOW_MODE;

typedef enum
{
    DISP_WIN0 = 0,
    DISP_WIN1,
    DISP_WIN2,
    DISP_WIN3,
    DISP_WIN4,
    DISP_WIN_MAX
} DISP_WINDOW;

typedef enum
{
    DISP_1BPP = 0,
    DISP_2BPP,
    DISP_4BPP,
    DISP_8BPP_PAL,
    DISP_8BPP_NOPAL,
    DISP_16BPP_565,
    DISP_16BPP_A555,
    DISP_16BPP_I555,
    DISP_18BPP_666,
    DISP_18BPP_A665,
    DISP_19BPP_A666,
    DISP_24BPP_888,
    DISP_24BPP_A887,
    DISP_32BPP_A888,
    DISP_25BPP_A888
} DISP_BPP_MODE;

typedef enum
{
    DISP_FG_MATCH_BG_DISPLAY,
    DISP_BG_MATCH_FG_DISPLAY
} DISP_COLOR_KEY_DIRECTION;

typedef enum
{
    DISP_ALPHA_PER_PLANE = (0<<6),
    DISP_ALPHA_PER_PIXEL = (1<<6),
    DISP_ALPHA_MULTIPLIED = (3<<6)
} DISP_ALPHA_BLEND_METHOD;

typedef enum
{
    DISP_BLDEQ_ZERO =             (0x0),   // 0
    DISP_BLDEQ_MAX =              (0x1),   // 1
    DISP_BLDEQ_ALPHA_A =          (0x2),   // foregorund Alpha
    DISP_BLDEQ_INV_ALPHA_A =      (0x3),   // 1- foreground alpha
    DISP_BLDEQ_ALPHA_B =          (0x4),   // background alpha
    DISP_BLDEQ_INV_ALPHA_B =      (0x5),   // 1 - background alpha
    DISP_BLDEQ_A =                (0xA),   // Foreground color data
    DISP_BLDEQ_INV_A =            (0xB),   // 1 - foreground color data
    DISP_BLDEQ_B =                (0xC),   // Background color data
    DISP_BLDEQ_INV_B =            (0xD)   // 1- background color data
} DISP_BLEND_EQ;

typedef enum
{
    DISP_V_VSYNC = 0,
    DISP_V_BACKPORCH,
    DISP_V_ACTIVE,
    DISP_V_FRONTPORCH
} DISP_VERTICAL_STATUS;

typedef enum
{
    DISP_H_HSYNC = 0,
    DISP_H_BACKPORCH,
    DISP_H_ACTIVE,
    DISP_H_FRONTPORCH
} DISP_HORIZONTAL_STATUS;

typedef enum
{
    POST_PER_FRAME_MODE,
    POST_FREE_RUN_MODE
} POST_OP_MODE;

typedef enum
{
    POST_PROGRESSIVE,
    POST_INTERLACE
} POST_SCAN_MODE;

// 90ROT[2], YFLIP[1], XFLIP[0]
typedef enum
{
    POST_0_NOFLIP = 0x0,
    POST_0_X_FLIP = 0x1,
    POST_0_Y_FLIP = 0x2,
    POST_0_XY_FLIP = 0x3,   // Same to 180 Degree rotation
    POST_90_NOFLIP = 0x4,
    POST_90_X_FLIP = 0x5,
    POST_90_Y_FLIP = 0x6,
    POST_90_XY_FLIP = 0x7,  // Same to 270 Degree rotation
    POST_180_NOFLIP = POST_0_XY_FLIP,
    POST_180_X_FLIP = POST_0_Y_FLIP,
    POST_180_Y_FLIP = POST_0_X_FLIP,
    POST_270_NOFLIP = POST_90_XY_FLIP,
    POST_270_X_FLIP = POST_90_Y_FLIP,
    POST_270_Y_FLIP = POST_90_X_FLIP
} POST_ROTFLIP_MODE;

typedef enum
{
    POST_SRC_RGB16 = 0,
    POST_SRC_RGB565 = 0,
    POST_SRC_RGB24,
    POST_SRC_YUV420,
    POST_SRC_YUV422_YCBYCR,
    POST_SRC_YUV422_CBYCRY,
    POST_SRC_YUV422_YCRYCB,
    POST_SRC_YUV422_CRYCBY,
    POST_SRC_NV12,
    POST_SRC_FIFO_YUV444,    // WriteBack
    POST_SRC_YUV422_YCBYCR_2PLANE,
    POST_SRC_YUV422_CBYCRY_2PLANE,
    POST_SRC_YUV422_YCRYCB_2PLANE,
    POST_SRC_YUV422_CRYCBY_2PLANE,
    POST_SRC_YUV422_YCBYCR_3PLANE,
    POST_SRC_YUV422_CBYCRY_3PLANE,
    POST_SRC_YUV422_YCRYCB_3PLANE,
    POST_SRC_YUV422_CRYCBY_3PLANE,
    POST_SRC_NV12_WEAVE,
    POST_SRC_RGB18

} POST_SRC_TYPE;

typedef enum
{
    POST_DST_RGB16 = 0,
    POST_DST_RGB24,
    POST_DST_YUV420,
    POST_DST_YUV422_YCBYCR,
    POST_DST_YUV422_CBYCRY,
    POST_DST_YUV422_YCRYCB,
    POST_DST_YUV422_CRYCBY,
    POST_DST_NV12,
    POST_DST_FIFO_YUV444,
    POST_DST_FIFO_RGB888,
    POST_DST_RGB18
} POST_DST_TYPE;

typedef enum
{
    POST_IDLE = 0,
    POST_BUSY
} POST_STATE;

// This is replica of CAM_DMA_MODE
typedef enum _POST_DMA_MODE {
    POST_DMA_LINEAR = 0,
    POST_DMA_CONFIGURABLE = 1,
    POST_DMA_16BY16 = 2,
    POST_DMA_64BY32 = 3,
} POST_DMA_MODE;

typedef enum
{
    ROT_FORMAT_YUV420 = 0,
    ROT_FORMAT_YUV422,
    ROT_FORMAT_RGB565,
    ROT_FORMAT_RGB888
} ROTATOR_IMAGE_FORMAT;

typedef enum
{
    ROT_OP_ROTATE_90 = 0,
    ROT_OP_ROTATE_180,
    ROT_OP_ROTATE_270,
    ROT_OP_FLIP_VERTICAL,
    ROT_OP_FLIP_HORIZONTAL
} ROTATOR_OPERATION_TYPE;

typedef enum
{
    DISP_RGB_COLOR_RANGE_WIDE = 0,
    DISP_RGB_COLOR_RANGE_NARROW
} DISP_RGB_COLOR_RANGE;

typedef enum
{
    DISP_CSC_EQ_601 = 0,
    DISP_CSC_EQ_709
} DISP_CSC_EQ;

typedef enum
{
    DISP_DITHER_565,
    DISP_DITHER_666,
    DISP_DITHER_888
} DISP_DITHER_MODE;

typedef enum
{
    DISP_LOW_LUX,
    DISP_HIGH_LUX
} DISP_LUX_CONTROL;

typedef struct
{
    DISP_RGB_COLOR_RANGE eRange;    // RGB color range -> Wide(16~235)/Narrow(0~255)
    DISP_CSC_EQ eCSCEq;             // Color Space(RGB->YUV and vice versa) conversion equation
    WORD wCBG0_P;                   // Hue Matrix coefficient
    WORD wCBG0_N;                   // Hue Matrix coefficient
    WORD wCBG1_P;                   // Hue Matrix coefficient
    WORD wCBG1_N;                   // Hue Matrix coefficient
    WORD wCRG0_P;                   // Hue Matrix coefficient
    WORD wCRG0_N;                   // Hue Matrix coefficient
    WORD wCRG1_P;                   // Hue Matrix coefficient
    WORD wCRG1_N;                   // Hue Matrix coefficient
    WORD wInOffset;                 // In Offset
    WORD wOutOffset;                // In Offset
} DISP_HUE_CONTROL;

typedef struct  // IOCTL_SVE_FIMD_SET_HUE
{
    BOOL bEnable;                   // Hue control enable/disable
    DISP_HUE_CONTROL hueControl;
} SVEARG_FIMD_HUE_CONTROL;

typedef struct  // IOCTL_SVE_FIMD_SET_DITHERING
{
    BOOL bEnable;                   // Dithering enable/disable
    DISP_DITHER_MODE eMode;
} SVEARG_FIMD_DITHERING_CONTROL;

typedef struct  // IOCTL_SVE_FIMD_SET_ALPS
{
    BOOL bEnable;                   // ALPS enable/disable
    DISP_LUX_CONTROL luxControl;
    unsigned int uiSizeH;
    unsigned int uiSizeV;
    unsigned int uiValueSize;
    unsigned char* pLow_R_LUT;
    unsigned char* pLow_G_LUT;
    unsigned char* pLow_B_LUT;
    unsigned char* pHigh_R_LUT;
    unsigned char* pHigh_G_LUT;
    unsigned char* pHigh_B_LUT;
} SVEARG_FIMD_ALPS_CONTROL;

typedef struct  // IOCTL_SVE_FIMD_SET_WINDOW_COLORMAP
{
    DISP_WINDOW eWinNum;
    BOOL bOnOff;                   // COLOR MAP enable/disable
    unsigned int uiColorValue;
} SVEARG_FIMD_COLORMAP_CONTROL;

typedef struct  // IOCTL_SVE_FIMD_SET_WONDOW_QOS
{
    DISP_WINDOW eWinNum;
    BOOL bGateEn;
    unsigned char ucFifoLevel;
} SVEARG_FIMD_WINDOW_QOS_CONTROL;


#if __cplusplus
}
#endif

#endif    // _SVEDRIVERAPI_H_

