/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER MODULE Module (MfcInterface.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2009/06/05
 */

#ifndef __SAMSUNG_SYSLSI_APDEV_MFC_API_H__
#define __SAMSUNG_SYSLSI_APDEV_MFC_API_H__

#include "SsbSipMfcApi.h"

#ifdef __cplusplus
extern "C" {
#endif

#define IOCTL_MFC_DEC_INIT          (0x00800001)
#define IOCTL_MFC_ENC_INIT          (0x00800002)
#define IOCTL_MFC_DEC_EXE           (0x00800003)
#define IOCTL_MFC_ENC_EXE           (0x00800004)
#define IOCTL_MFC_DEC_BUFFER_INIT   (0x00800005)

#define IOCTL_MFC_SET_CONFIG        (0x00800101)
#define IOCTL_MFC_GET_CONFIG        (0x00800102)


#define MFC_CODEC_TYPE_ISENC(x)     ((x) & (0x100))
#define MFC_CODEC_TYPE_ISDEC(x)     ((x) & (0x200))
#define MFC_MAX_EXTRA_DPB           (5)                 // MFC H/W support maximum 16 extra DPB. 
                                                        // but, due to lack of memory, MFC driver use 5 as maximum

#define Align(x, alignbyte) (((x)+(alignbyte)-1)/(alignbyte)*(alignbyte))
typedef enum
{
    DECODING_ONLY = 0,
    DECODING_DISPLAY = 1,
    DISPLAY_ONLY = 2,
    DISPLAY_END = 3
}MFC_DISPLAY_STATUS;


typedef enum
{
    MFC_UNPACKED_PB = 0,
    MFC_PACKED_PB = 1
} MFC_PACKED_MODE;


typedef struct {
    unsigned int                in_dpb_portA_addr;      // [IN]  DPB A buffer address
    unsigned int                in_dpb_portB_addr;      // [IN]  DPB B buffer address
    unsigned int                in_Strm_St;             // [IN]  Output buffer start address of encoded stream
    unsigned int                in_Strm_End;            // [IN]  Output buffer end address of encoded stream
    int                         out_header_size;        // [OUT] Length of video stream header
    SSBSIP_MFC_ENC_MPEG4_PARAM  in_cfg;                 // [IN]  encoding parameters
} MFC_ENC_INIT_MPEG4_ARG;

typedef struct {
    unsigned int                in_dpb_portA_addr;      // [IN]  DPB A buffer address
    unsigned int                in_dpb_portB_addr;      // [IN]  DPB B buffer address
    unsigned int                in_Strm_St;             // [IN]  Output buffer start address of encoded stream
    unsigned int                in_Strm_End;            // [IN]  Output buffer end address of encoded stream
    int                         out_header_size;        // [OUT] Length of video stream header
    SSBSIP_MFC_ENC_H263_PARAM   in_cfg;                 // [IN]  encoding parameters

} MFC_ENC_INIT_H263_ARG;

typedef struct {
    unsigned int                in_dpb_portA_addr;      // [IN]  DPB A buffer address
    unsigned int                in_dpb_portB_addr;      // [IN]  DPB B buffer address
    unsigned int                in_Strm_St;             // [IN]  Output buffer start address of encoded stream
    unsigned int                in_Strm_End;            // [IN]  Output buffer end address of encoded stream
    int                         out_header_size;        // [OUT] Length of video stream header
    SSBSIP_MFC_ENC_H264_PARAM   in_cfg;                 // [IN]  encoding parameters
} MFC_ENC_INIT_H264_ARG;

typedef struct {
    SSBSIP_MFC_CODEC_TYPE       in_codecType;           // [IN]  codec type
    unsigned int                in_Y_addr;              // [IN]  Input buffer address of Y component
    unsigned int                in_CbCr_addr;           // [IN]  Input buffer address of CbCr component
    unsigned int                in_Strm_St;             // [IN]  Output buffer start address of encoded stream
    unsigned int                in_Strm_End;            // [IN]  Output buffer end address of encoded stream
    unsigned int                out_frameType;          // [OUT] frame type 
    int                         out_encoded_size;       // [OUT] Length of Encoded video stream
    int                         out_header_size;        // [OUT] Length of video stream header
} MFC_ENC_EXE_ARG;

typedef struct {
    SSBSIP_MFC_CODEC_TYPE       in_codecType;           // [IN]  codec type
    int                         in_strmBuf;             // [IN]  the physical address of STRM_BUF
    int                         in_strmSize;            // [IN]  Size of video stream filled in STRM_BUF
    int                         in_packedPB;            // [IN]  Is packed PB frame or not, 1: packedPB  0: unpacked
    int                         out_img_width;          // [OUT] width  of YUV420 frame
    int                         out_img_height;         // [OUT] height of YUV420 frame
    int                         out_buf_width;          // [OUT] width  of YUV420 frame
    int                         out_buf_height;         // [OUT] height of YUV420 frame
    int                         out_dpb_y_size;         // [OUT] the size of buffers which is nessary during decoding.
    int                         out_dpb_cb_size;        // [OUT] the size of buffers which is nessary during decoding.
} MFC_DEC_INIT_ARG;

typedef struct {
    SSBSIP_MFC_CODEC_TYPE       in_codecType;           // [IN]  codec type
    int                         in_strmBuf;             // [IN]  the physical address of STRM_BUF
    int                         in_strmSize;            // [IN]  Size of video stream filled in STRM_BUF
    int                         in_frmYBuf;             // [IN]  the address of Y frame buffer
    int                         in_frmYSize;            // [IN]  Size of video stream filled in Y frame buffer
    int                         in_frmCbBuf;            // [IN]  the address of CbCr & MV buffer
    int                         in_frmCbSize;           // [IN]  Size of video stream filled in CbCr & MV buffer
 } MFC_DEC_BUFFER_INIT_ARG;

typedef struct {
    SSBSIP_MFC_CODEC_TYPE       in_codecType;           // [IN]  codec type
    int                         in_strmBuf;             // [IN]  the physical address of STRM_BUF
    int                         in_strmSize;            // [IN]  Size of video stream filled in STRM_BUF
    int                         in_frmYBuf;             // [IN]  the address of Y frame buffer
    int                         in_frmYSize;            // [IN]  Size of video stream filled in Y frame buffer
    int                         in_frmCbBuf;            // [IN]  the address of CbCr & MV buffer
    int                         in_frmCbSize;           // [IN]  Size of video stream filled in CbCr & MV buffer
    int                         out_displayYAddr;       // [OUT]  the physical address of display buf
    int                         out_displayCAddr;       // [OUT]  the physical address of display buf
    int                         out_displayStatus;      // [OUT]  whether display frame exist or not. 0: no more frame 1: frame exist
    int                         out_timestampTop;       // [OUT]  timestamp of top field. It is valid only for interlace frame
    int                         out_timestampBottom;    // [OUT]  timestamp of bottom field. It is valid only for interlace frame
    int                         out_consumedByte;       // [OUT] the number of byte consumed during decoding
    int                         out_res_change;         // [OUT] whether resolution is changed or not. 0: not change, 1: increased, 2: decreased
    int                         out_crop_top_offset;    // [OUT] crop information, top_offset
    int                         out_crop_bottom_offset; // [OUT] crop information, bottom_offset
    int                         out_crop_left_offset;   // [OUT] crop information, left_offset
    int                         out_crop_right_offset;  // [OUT] crop information, right_offset
} MFC_DEC_EXE_ARG;

typedef struct {
    int                         in_config_param;        // [IN]  Configurable parameter type
    int                         out_config_value[6];    // [IN]  Values to get for the configurable parameter.
                                                        //      Maximum two integer values can be obtained;
} MFC_GET_CONFIG_ARG;

typedef struct {
    int                         in_config_param;        // [IN]  Configurable parameter type
    int                         in_config_value[2];     // [IN]  Values to be set for the configurable parameter.
                                                        //      Maximum two integer values can be set.
    int                         out_config_value_old[2];// [OUT] Old values of the configurable parameters
} MFC_SET_CONFIG_ARG;

typedef union {
    MFC_ENC_INIT_MPEG4_ARG      enc_init_mpeg4;
    MFC_ENC_INIT_H263_ARG       enc_init_h263;
    MFC_ENC_INIT_H264_ARG       enc_init_h264;

    MFC_ENC_EXE_ARG             enc_exe;
    MFC_DEC_INIT_ARG            dec_init;
    MFC_DEC_BUFFER_INIT_ARG     dec_buff_init;
    MFC_DEC_EXE_ARG             dec_exe;
    MFC_GET_CONFIG_ARG          get_config;
    MFC_SET_CONFIG_ARG          set_config;
} ARGS;

typedef struct tagMFC_ARGS{
    SSBSIP_MFC_ERROR_CODE              ret_code;               // [OUT] error code
    ARGS                        args;
}MFC_ARGS;


typedef struct
{
    HANDLE hMFC;
    HANDLE hCMM;

    SSBSIP_MFC_CODEC_TYPE codec_type;
    int width, height;

    int phyStrmBuf;
    int virStrmBuf;
    int sizeStrmBuf;

    int phyYFrmBuf;
    int virYFrmBuf;
    int sizeYFrmBuf;

    int phyCbFrmBuf;
    int virCbFrmBuf;
    int sizeCbFrmBuf;

    int phyEncDpbABuf;
    int virEncDpbABuf;

    int phyEncDpbBBuf;
    int virEncDpbBBuf;

    DWORD proc_id;
    SSBSIP_MFC_DEC_OUTPUT_INFO decOutInfo;
    SSBSIP_MFC_ENC_OUTPUT_INFO encOutInfo;
    int displayStatus;
	
} _MFCLIB;
#ifdef __cplusplus
}
#endif


#define ENC_PROFILE_MPEG4_SP                   0
#define ENC_PROFILE_MPEG4_ASP                  1
#define ENC_PROFILE_H264_BP                    0
#define ENC_PROFILE_H264_MAIN                  1
#define ENC_PROFILE_H264_HIGH                  2


#define ENC_RC_DISABLE                         0
#define ENC_RC_ENABLE_MACROBLOCK               1
#define ENC_RC_ENABLE_FRAME                    2

#define ENC_RC_MB_CTRL_DARK_DISABLE            (1 << 3)
#define ENC_RC_MB_CTRL_SMOOTH_DISABLE          (1 << 2)
#define ENC_RC_MB_CTRL_STATIC_DISABLE          (1 << 1)
#define ENC_RC_MB_CTRL_ACTIVITY_DISABLE        (1 << 0)


#endif
