;******************************************************************************
;*
;* System On Chip(SOC)
;*
;* Copyright (c) 2002 Software Center, Samsung Electronics, Inc.
;* All rights reserved.
;*
;* This software is the confidential and proprietary information of Samsung 
;* Electronics, Inc("Confidential Information"). You Shall not disclose such 
;* Confidential Information and shall use it only in accordance with the terms 
;* of the license agreement you entered into Samsung.
;*
;******************************************************************************

    INCLUDE kxarm.h
    INCLUDE register_map.inc
    INCLUDE armmacros.s

    
IDLEMASK            EQU         0x60
ENTER_IDLE          EQU         0x20


    TEXTAREA

;--------------------------------------------------------------------------
; OALCPUIdle_WFI
; - As WM6.x does not support ARMv7, we can't use the ARM instruction 'WFI'
;   So we should use the disassemble value of WFI
;--------------------------------------------------------------------------        
    LEAF_ENTRY OALCPUIdle_WFI


    stmfd   sp!, {r0-r4}

    [ {FALSE}
    ldr     r0, =vPWR_CFG
    ldr     r1, [r0]
    bic     r1, r1, #IDLEMASK
    orr     r1, r1, #ENTER_IDLE         
    str     r1, [r0]                    ; Enter IDLE mode

    mov     r2, #0
    mcr     p15,0,r2,c7,c10,5           ; Data Memory Barrier
    mcr     p15,0,r2,c7,c10,4           ; Data Synchronization Barrier
    
    DCD     0xe320f003                  ; WFI 

    bic     r1, r1, #ENTER_IDLE         
    str     r1, [r0]                    ; Clear IDLE mode

    |

    ;mov     r2, #0
    ;mcr     p15,0,r2,c7,c10,5          ; Data Memory Barrier
    ;mcr     p15,0,r2,c7,c10,4          ; Data Synchronization Barrier
    DCD     0xf57ff05f                  ; DMB (Data Memory Barrier)
    DCD     0xf57ff04f                  ; DSB (Data Synchronization Barrier)
    
    DCD     0xe320f003                  ; WFI
    
    ]

    
    ldmfd   sp!, {r0-r4}
    mov     pc, lr
   

    ENTRY_END
    
    END

    
