;------------------------------------------------------------------------------
;
;  Copyright (c) Microsoft Corporation.  All rights reserved.
;
;
;  Use of this source code is subject to the terms of the Microsoft end-user
;  license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
;  If you did not accept the terms of the EULA, you are not authorized to use
;  this source code. For a copy of the EULA, please see the LICENSE.RTF on your
;  install media.
;
;------------------------------------------------------------------------------
;
;   File:  startup.s
;
;   Kernel startup routine for Samsung SMDKV210 board. Hardware is
;   initialized in boot loader - so there isn't much code at all.
;
;------------------------------------------------------------------------------

        INCLUDE kxarm.h
        INCLUDE armmacros.s
        INCLUDE register_map.inc

        TEXTAREA

        EXPORT    System_EnableIRQ
        EXPORT    System_DisableIRQ
        EXPORT    System_EnableFIQ
        EXPORT    System_DisableFIQ
        EXPORT    System_EnableBP
        EXPORT    System_DisableBP
        EXPORT    System_EnableICache
        EXPORT    System_WaitForInterrupt
        EXPORT    InvalidateDCacheIndex

    ;--------------------
    ;    Enable IRQ
    ;--------------------
    LEAF_ENTRY System_EnableIRQ
        mrs        r0,cpsr
        bic        r0,r0,#I_Bit
        msr        cpsr_cxsf,r0
        mov        pc, lr
    ENTRY_END


    ;--------------------
    ;    Disable IRQ
    ;--------------------
    LEAF_ENTRY System_DisableIRQ
        mrs        r0,cpsr
        orr        r0,r0,#I_Bit
        msr        cpsr_cxsf,r0
        mov        pc, lr
    ENTRY_END


    ;--------------------
    ;    Enable FIQ
    ;--------------------
    LEAF_ENTRY System_EnableFIQ
        mrs        r0,cpsr
        bic        r0,r0,#F_Bit
        msr        cpsr_cxsf,r0
        mov        pc, lr
    ENTRY_END


    ;--------------------
    ;    Disable FIQ
    ;--------------------
    LEAF_ENTRY System_DisableFIQ
        mrs        r0,cpsr
        orr        r0,r0,#F_Bit
        msr        cpsr_cxsf,r0
        mov        pc, lr
    ENTRY_END


    ;-------------------------
    ;    Enable Branch Prediction
    ;-------------------------
    LEAF_ENTRY System_EnableBP
        mrc        p15,0,r0,c1,c0,0
        orr        r0,r0,#R1_BP
        mcr        p15,0,r0,c1,c0,0
        mov        pc, lr
    ENTRY_END


    ;-------------------------
    ;    Disable Branch Prediction
    ;-------------------------
    LEAF_ENTRY System_DisableBP
        mrc        p15,0,r0,c1,c0,0
        bic        r0,r0,#R1_BP
        mcr        p15,0,r0,c1,c0,0
        mov        pc, lr
    ENTRY_END


    ;-------------------------
    ;    Enable ICache
    ;-------------------------
    LEAF_ENTRY System_EnableICache
        mrc        p15, 0, r0, c1, c0, 0
        orr        r0, r0, #R1_I
        mcr        p15, 0, r0, c1, c0, 0
        mov        pc, lr
    ENTRY_END



    ;---------------------------
    ;    Set WaitForInterrupt
    ;---------------------------
    LEAF_ENTRY System_WaitForInterrupt

        mov     r0, #0
        ;mcr     p15, 0, r0, c7, c10, 5     ; Data Memory Barrier
        ;mcr     p15, 0, r0, c7, c10, 4     ; Data Synchronization Barrier
        DCD     0xf57ff05f                  ; DMB (Data Memory Barrier)
        DCD     0xf57ff04f                  ; DSB (Data Synchronization Barrier)

        DCD     0xe320f003                 ; WFI

        mov     pc, lr

    ENTRY_END

    LEAF_ENTRY  InvalidateDCacheIndex
        mcr     p15,0,r0,c7,c6,2
        mov     pc,lr
    ENTRY_END
        END

;------------------------------------------------------------------------------

