//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// NOTE: stubs are being used - this isn't done

#include <windows.h>
#include <oal.h>
#include "soc_cfg.h"
#include "base_regs.h"
#include "register_map.h"
#include "bsp_gpio.h"
#include <pmplatform.h>

#if(S5PV210_EVT==0)   
#define USE_WDT     // Use Watchdog Reset
#endif

#ifdef BSP_USEDVFS
// DVFS control function in "\common\dvfs\dvfs.c
extern void ResetDVFS();
#endif

void OEMSWReset(void)
{
//
// If the board design supports software-controllable hardware reset logic, it should be
// used.  Because this routine is specific to the S5PV210 CPU, it only uses the watchdog
// timer to assert reset.  One downside to this approach is that nRSTOUT isn't asserted
// so any board-level logic isn't reset via this method.  This routine can be overidden in
// the specific platform code to control board-level reset logic, should it exist.
//
#ifdef USE_WDT
	volatile WATCHDOG_REG *pWDTRegs = (WATCHDOG_REG *) OALPAtoVA(BASE_REG_PA_WATCHDOG, FALSE);
#else
    volatile CMU_SRST_REG *pCMUSwReset = (CMU_SRST_REG *)OALPAtoVA(BASE_REG_PA_CMU_SRST, FALSE);
#endif

    OALMSG(TRUE, (L"[OEM] ++OEMSWReset()\r\n"));

    //-----------------------------
    // Disable DVFS and Set to Full Speed
    //-----------------------------
#ifdef BSP_USEDVFS
    ResetDVFS();
#endif

#ifdef USE_WDT
	// Set WDT
	pWDTRegs->WTDAT = 0;
    pWDTRegs->WTCNT = 5;         // Load count with low value.
    pWDTRegs->WTCON = 0x8021;    // Enable watchdog timer...
#else    
    // Generate Software Reset
    pCMUSwReset->SWRESET = (SWRESET_VALUE<<BP_SWRESET);
#endif

    // Wait for Reset
    //
    while(1);

    // Should Never Get Here
    //
    OALMSG(TRUE, (L"[OEM] --OEMSWReset() : Do Not See Me !!!!!! \r\n"));
}

//------------------------------------------------------------------------------

