//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: vp_reg.h
//
//  Defines the Video Processor CPU register layout and definitions.
//
#ifndef __S5PV210_VP_REG_H
#define __S5PV210_VP_REG_H

#if __cplusplus
	extern "C"
	{
#endif

typedef struct
{
	UINT32 VP_ENABLE;					//0x000,
	UINT32 VP_SRESET;					//0x004,
	UINT32 VP_SHADOW_UPDATE;			//0x008,
	UINT32 VP_FIELD_ID;					//0x00C,
	
	UINT32 VP_MODE;						//0x010,
	UINT32 VP_IMG_SIZE_Y;				//0x014,
	UINT32 VP_IMG_SIZE_C;				//0x018,
	UINT32 PAD0[3];						//0x01C,
										//0x020
										//0x024

	UINT32 VP_TOP_Y_PTR;				//0x028,
	UINT32 VP_BOT_Y_PTR;				//0x02C,

	UINT32 VP_TOP_C_PTR;				//0x030,
	UINT32 VP_BOT_C_PTR;				//0x034,

	UINT32 PAD1[3];						//0x038
										//0x03C,
										//0x040,

	UINT32 VP_SRC_H_POSITION;			//0x044,
	UINT32 VP_SRC_V_POSITION;			//0x048,
	UINT32 VP_SRC_WIDTH;				//0x04C,

	UINT32 VP_SRC_HEIGHT;				//0x050,
	UINT32 VP_DST_H_POSITION;			//0x054,
	UINT32 VP_DST_V_POSITION;			//0x058,
	UINT32 VP_DST_WIDTH;				//0x05C,

	UINT32 VP_DST_HEIGHT;				//0x060,
	UINT32 VP_H_RATIO;					//0x064,
	UINT32 VP_V_RATIO;					//0x068,
	UINT32 VP_POLY8_Y0_LL;				//0x6C,

	UINT32 VP_POLY8_Y0_LH;				//0x70,
	UINT32 VP_POLY8_Y0_HL;				//0x74,
	UINT32 VP_POLY8_Y0_HH;				//0x78,
	UINT32 VP_POLY8_Y1_LL;				//0x7C,

	UINT32 VP_POLY8_Y1_LH;				//0x80,
	UINT32 VP_POLY8_Y1_HL;				//0x84,
	UINT32 VP_POLY8_Y1_HH;				//0x88,
	UINT32 VP_POLY8_Y2_LL;				//0x8C,
	
	UINT32 VP_POLY8_Y2_LH;				//0x90,
	UINT32 VP_POLY8_Y2_HL;				//0x94,
	UINT32 VP_POLY8_Y2_HH;				//0x98,
	UINT32 VP_POLY8_Y3_LL;				//0x9C,

	UINT32 VP_POLY8_Y3_LH;				//0xA0,
	UINT32 VP_POLY8_Y3_HL;				//0xA4,
	UINT32 VP_POLY8_Y3_HH;				//0xA8,
	UINT32 PAD2[16];						//0xAC
										//0xb0
										//0xc0
										//0xd0
										//0xe0
										//0xe4
										//0xE8
	UINT32 VP_POLY4_Y0_LL;				//0xEC,

	UINT32 VP_POLY4_Y0_LH;				//0xF0,
	UINT32 VP_POLY4_Y0_HL;				//0xF4,
	UINT32 VP_POLY4_Y0_HH;				//0xF8,
	UINT32 VP_POLY4_Y1_LL;				//0xFC,
	
	UINT32 VP_POLY4_Y1_LH;				//0x100,
	UINT32 VP_POLY4_Y1_HL;				//0x104,
	UINT32 VP_POLY4_Y1_HH;				//0x108,
	UINT32 VP_POLY4_Y2_LL;				//0x10C,

	UINT32 VP_POLY4_Y2_LH;				//0x110,
	UINT32 VP_POLY4_Y2_HL;				//0x114,
	UINT32 VP_POLY4_Y2_HH;				//0x118,
	UINT32 VP_POLY4_Y3_LL;				//0x11C,
	
	UINT32 VP_POLY4_Y3_LH;				//0x120,
	UINT32 VP_POLY4_Y3_HL;				//0x124,
	UINT32 VP_POLY4_Y3_HH;				//0x128,
	UINT32 VP_POLY4_C0_LL;				//0x12C,

	UINT32 VP_POLY4_C0_LH;				//0x130,
	UINT32 VP_POLY4_C0_HL;				//0x134,
	UINT32 VP_POLY4_C0_HH;				//0x138,
	UINT32 VP_POLY4_C1_LL;				//0x13C,

	UINT32 VP_POLY4_C1_LH;				//0x140,
	UINT32 VP_POLY4_C1_HL;				//0x144,
	UINT32 VP_POLY4_C1_HH;				//0x148,

	UINT32 PAD3[34];						//0x14c
										//0x150
										//0x160
										//0x170
										//0x180
										//0x190
										//0x1a0
										//0x1b0
										//0x1c0
										//0x1d0

	UINT32 PP_CSC_Y2Y_COEF;			//0x1D4,
	UINT32 PP_CSC_CB2Y_COEF;			//0x1D8,
	UINT32 PP_CSC_CR2Y_COEF;			//0x1DC,

	UINT32 PP_CSC_Y2CB_COEF;			//0x1E0,
	UINT32 PP_CSC_CB2CB_COEF;			//0x1E4,
	UINT32 PP_CSC_CR2CB_COEF;			//0x1E8,
	UINT32 PP_CSC_Y2CR_COEF;			//0x1EC,
	UINT32 PP_CSC_CB2CR_COEF;			//0x1F0,
	UINT32 PP_CSC_CR2CR_COEF;			//0x1F4,

	UINT32 PAD4[2];						//0x1f8
										//0x1fc

	UINT32 PP_BYPASS;					//0x200,
	UINT32 PAD5[2];						//0x204
										//0x208
	UINT32 PP_SATURATION;				//0x20C,

	UINT32 PP_SHARPNESS;				//0x210,
	UINT32 PAD6;						//0x214
	UINT32 PP_LINE_EQ0;					//0x218,
	UINT32 PP_LINE_EQ1;					//0x21C,

	UINT32 PP_LINE_EQ2;					//0x220,
	UINT32 PP_LINE_EQ3;					//0x224,
	UINT32 PP_LINE_EQ4;					//0x228,
	UINT32 PP_LINE_EQ5;					//0x22C,

	UINT32 PP_LINE_EQ6;					//0x230,
	UINT32 PP_LINE_EQ7;					//0x234,
	UINT32 PP_BRIGHT_OFFSET;			//0x238,
	UINT32 PP_CSC_EN;					//0x23C,

	UINT32 PAD7[99];						//0x240 ~ 0x3C8
	UINT32 VP_ENDIAN_MODE;			//0x3CC,

	UINT32 PAD8[6];						//0x3d0 ~ 0x3f8
	UINT32 PP_VERSION_INFO;			//0x3FC
	} VP_REG, *PVP_REG;

#if __cplusplus
}
#endif

#endif    // __S5PV210_VP_REG_H
