//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: usbotg_reg.h
//
//  Defines the USBOTG controller CPU register layout and definitions.
//
#ifndef __S5PV210_USBOTG_H
#define __S5PV210_USBOTG_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//
//  Type: USBOTG_REG
//
//  Defines the USB device control register block. This register bank is
//  located by the constant BASE_REG_PA_USBOTG in configuration file
//  base_reg_cfg.h.
//



typedef struct
{
    UINT32    OPHYPWR;
    UINT32    OPHYCLK;
    UINT32     ORSTCON;
}OTG_PHY_REG, *PS_OTG_PHY_REG;

typedef struct
{
    UINT32 GOTGCTL;                     // 0x000            OTG Control & Status
    UINT32 GOTGINT;                     // 0x004            OTG Interrupt
    UINT32 GAHBCFG;                     // 0x008            Core AHB Configuration
    UINT32 GUSBCFG;                     // 0x00C            Core USB Configuration
    UINT32 GRSTCTL;                     // 0x010            Core Reset
    UINT32 GINTSTS;                     // 0x014            Core Interrupt
    UINT32 GINTMSK;                     // 0x018            Core Interrupt Mask
    UINT32 GRXSTSR;                     // 0x01C            Receive Status Debug Read/Status Read
    UINT32 GRXSTSP;                     // 0x020            Receive Status Debug Pop/Status Pop
    UINT32 GRXFSIZ;                     // 0x024            Receive FIFO Size
    UINT32 GNPTXFSIZ;                   // 0x028            Non-Periodic Transmit FIFO Size
    UINT32 GNPTXSTS;                    // 0x02C            Non-Periodic Transmit FIFO/Queue Status
    UINT32 PAD0[52];
                                           
    UINT32 HPTXFSIZ;                    // 0x100            Host Periodic Transmit FIFO Size
    UINT32 DPTXFSIZ1;                   // 0x104            Device Periodic Transmit FIFO-1 Size
    UINT32 DPTXFSIZ2;                   // 0x108            Device Periodic Transmit FIFO-2 Size
    UINT32 DPTXFSIZ3;                   // 0x10C            Device Periodic Transmit FIFO-3 Size
    UINT32 DPTXFSIZ4;                   // 0x110            Device Periodic Transmit FIFO-4 Size
    UINT32 DPTXFSIZ5;                   // 0x114            Device Periodic Transmit FIFO-5 Size
    UINT32 DPTXFSIZ6;                   // 0x118            Device Periodic Transmit FIFO-6 Size
    UINT32 DPTXFSIZ7;                   // 0x11C            Device Periodic Transmit FIFO-7 Size
    UINT32 DPTXFSIZ8;                   // 0x120            Device Periodic Transmit FIFO-8 Size
    UINT32 DPTXFSIZ9;                   // 0x124            Device Periodic Transmit FIFO-9 Size
    UINT32 DPTXFSIZ10;                  // 0x128            Device Periodic Transmit FIFO-10 Size
    UINT32 DPTXFSIZ11;                  // 0x12C            Device Periodic Transmit FIFO-11 Size
    UINT32 DPTXFSIZ12;                  // 0x130            Device Periodic Transmit FIFO-12 Size
    UINT32 DPTXFSIZ13;                  // 0x134            Device Periodic Transmit FIFO-13 Size
    UINT32 DPTXFSIZ14;                  // 0x138            Device Periodic Transmit FIFO-14 Size
    UINT32 DPTXFSIZ15;                  // 0x13C            Device Periodic Transmit FIFO-15 Size
    UINT32 PAD1[176];

//*********************************************************************
//    Host Mode Registers
//*********************************************************************
// Host Global Registers

    UINT32 HCFG;                        // 0x400            Host Configuration
    UINT32 HFIR;                        // 0x404            Host Frame Interval
    UINT32 HFNUM;                       // 0x408            Host Frame Number/Frame Time Remaining
    UINT32 HPTXSTS;                     // 0x410            Host Periodic Transmit FIFO/Queue Status
    UINT32 HAINT;                       // 0x414            Host All Channels Interrupt
    UINT32 HAINTMSK;                    // 0x418            Host All Channels Interrupt Mask
    UINT32 PAD2[9];

// Host Port Control & Status Registers

    UINT32 HPRT;                        // 0x440            Host Port Control & Status
    UINT32 PAD3[47];

// Host Channel-Specific Registers #0

    UINT32 HCCHAR0;                     // 0x500            Host Channel-0 Characteristics
    UINT32 HCSPLT0;                     // 0x504            Host Channel-0 Split Control
    UINT32 HCINT0;                      // 0x508            Host Channel-0 Interrupt
    UINT32 HCINTMSK0;                   // 0x50C            Host Channel-0 Interrupt Mask
    UINT32 HCTSIZ0;                     // 0x510            Host Channel-0 Transfer Size
    UINT32 HCDMA0;                      // 0x514            Host Channel-0 DMA Address
    UINT32 PAD4[2];

// Host Channel-Specific Registers #1

    UINT32 HCCHAR1;                     // 0x520           Host Channel-1 Characteristics
    UINT32 HCSPLT1;                     // 0x524           Host Channel-1 Split Control
    UINT32 HCINT1;                      // 0x528           Host Channel-1 Interrupt
    UINT32 HCINTMSK1;                   // 0x52C           Host Channel-1 Interrupt Mask
    UINT32 HCTSIZ1;                     // 0x530           Host Channel-1 Transfer Size
    UINT32 HCDMA1;                      // 0x534           Host Channel-1 DMA Address
    UINT32 PAD5[2];

// Host Channel-Specific Registers #2

    UINT32 HCCHAR2;                     // 0x540           Host Channel-2 Characteristics
    UINT32 HCSPLT2;                     // 0x544           Host Channel-2 Split Control
    UINT32 HCINT2;                      // 0x548           Host Channel-2 Interrupt
    UINT32 HCINTMSK2;                   // 0x54C           Host Channel-2 Interrupt Mask
    UINT32 HCTSIZ2;                     // 0x550           Host Channel-2 Transfer Size
    UINT32 HCDMA2;                      // 0x554           Host Channel-2 DMA Address
    UINT32 PAD6[2];

// Host Channel-Specific Registers #3

    UINT32 HCCHAR3;                     // 0x560           Host Channel-3 Characteristics
    UINT32 HCSPLT3;                     // 0x564           Host Channel-3 Split Control
    UINT32 HCINT3;                      // 0x568           Host Channel-3 Interrupt
    UINT32 HCINTMSK3;                   // 0x56C           Host Channel-3 Interrupt Mask
    UINT32 HCTSIZ3;                     // 0x570           Host Channel-3 Transfer Size
    UINT32 HCDMA3;                      // 0x574           Host Channel-3 DMA Address
    UINT32 PAD7[2];

// Host Channel-Specific Registers #4

    UINT32 HCCHAR4;                     // 0x580           Host Channel-4 Characteristics
    UINT32 HCSPLT4;                     // 0x584           Host Channel-4 Split Control
    UINT32 HCINT4;                      // 0x588           Host Channel-4 Interrupt
    UINT32 HCINTMSK4;                   // 0x58C           Host Channel-4 Interrupt Mask
    UINT32 HCTSIZ4;                     // 0x590           Host Channel-4 Transfer Size
    UINT32 HCDMA4;                      // 0x594           Host Channel-4 DMA Address
    UINT32 PAD8[2];

// Host Channel-Specific Registers #5

    UINT32 HCCHAR5;                     // 0x5A0           Host Channel-5 Characteristics
    UINT32 HCSPLT5;                     // 0x5A4           Host Channel-5 Split Control
    UINT32 HCINT5;                      // 0x5A8           Host Channel-5 Interrupt
    UINT32 HCINTMSK5;                   // 0x5AC           Host Channel-5 Interrupt Mask
    UINT32 HCTSIZ5;                     // 0x5B0           Host Channel-5 Transfer Size
    UINT32 HCDMA5;                      // 0x5B4           Host Channel-5 DMA Address
    UINT32 PAD9[2];

// Host Channel-Specific Registers #6

    UINT32 HCCHAR6;                     // 0x5C0           Host Channel-6 Characteristics
    UINT32 HCSPLT6;                     // 0x5C4           Host Channel-6 Split Control
    UINT32 HCINT6;                      // 0x5C8           Host Channel-6 Interrupt
    UINT32 HCINTMSK6;                   // 0x5CC           Host Channel-6 Interrupt Mask
    UINT32 HCTSIZ6;                     // 0x5D0           Host Channel-6 Transfer Size
    UINT32 HCDMA6;                      // 0x5D4           Host Channel-6 DMA Address
    UINT32 PAD10[2];

// Host Channel-Specific Registers #7

    UINT32 HCCHAR7;                     // 0x5E0           Host Channel-7 Characteristics
    UINT32 HCSPLT7;                     // 0x5E4           Host Channel-7 Split Control
    UINT32 HCINT7;                      // 0x5E8           Host Channel-7 Interrupt
    UINT32 HCINTMSK7;                   // 0x5EC           Host Channel-7 Interrupt Mask
    UINT32 HCTSIZ7;                     // 0x5F0           Host Channel-7 Transfer Size
    UINT32 HCDMA7;                      // 0x5F4           Host Channel-7 DMA Address
    UINT32 PAD11[2];

// Host Channel-Specific Registers #8

    UINT32 HCCHAR8;                     // 0x600           Host Channel-8 Characteristics
    UINT32 HCSPLT8;                     // 0x604           Host Channel-8 Split Control
    UINT32 HCINT8;                      // 0x608           Host Channel-8 Interrupt
    UINT32 HCINTMSK8;                   // 0x60C           Host Channel-8 Interrupt Mask
    UINT32 HCTSIZ8;                     // 0x610           Host Channel-8 Transfer Size
    UINT32 HCDMA8;                      // 0x614           Host Channel-8 DMA Address
    UINT32 PAD12[2];

// Host Channel-Specific Registers #9

    UINT32 HCCHAR9;                     // 0x620           Host Channel-9 Characteristics
    UINT32 HCSPLT9;                     // 0x624           Host Channel-9 Split Control
    UINT32 HCINT9;                      // 0x628           Host Channel-9 Interrupt
    UINT32 HCINTMSK9;                   // 0x62C           Host Channel-9 Interrupt Mask
    UINT32 HCTSIZ9;                     // 0x630           Host Channel-9 Transfer Size
    UINT32 HCDMA9;                      // 0x634           Host Channel-9 DMA Address
    UINT32 PAD13[2];

// Host Channel-Specific Registers #10

    UINT32 HCCHAR10;                    // 0x640           Host Channel-10 Characteristics
    UINT32 HCSPLT10;                    // 0x644           Host Channel-10 Split Control
    UINT32 HCINT10;                     // 0x648           Host Channel-10 Interrupt
    UINT32 HCINTMSK10;                  // 0x64C           Host Channel-10 Interrupt Mask
    UINT32 HCTSIZ10;                    // 0x650           Host Channel-10 Transfer Size
    UINT32 HCDMA10;                     // 0x654           Host Channel-10 DMA Address
    UINT32 PAD14[2];

// Host Channel-Specific Registers #11

    UINT32 HCCHAR11;                    // 0x660           Host Channel-11 Characteristics
    UINT32 HCSPLT11;                    // 0x664           Host Channel-11 Split Control
    UINT32 HCINT11;                     // 0x668           Host Channel-11 Interrupt
    UINT32 HCINTMSK11;                  // 0x66C           Host Channel-11 Interrupt Mask
    UINT32 HCTSIZ11;                    // 0x670           Host Channel-11 Transfer Size
    UINT32 HCDMA11;                     // 0x674           Host Channel-11 DMA Address
    UINT32 PAD15[2];

// Host Channel-Specific Registers #12

    UINT32 HCCHAR12;                    // 0x680           Host Channel-12 Characteristics
    UINT32 HCSPLT12;                    // 0x684           Host Channel-12 Split Control
    UINT32 HCINT12;                     // 0x688           Host Channel-12 Interrupt
    UINT32 HCINTMSK12;                  // 0x68C           Host Channel-12 Interrupt Mask
    UINT32 HCTSIZ12;                    // 0x690           Host Channel-12 Transfer Size
    UINT32 HCDMA12;                     // 0x694           Host Channel-12 DMA Address
    UINT32 PAD16[2];

// Host Channel-Specific Registers #13

    UINT32 HCCHAR13;                    // 0x6A0           Host Channel-13 Characteristics
    UINT32 HCSPLT13;                    // 0x6A4           Host Channel-13 Split Control
    UINT32 HCINT13;                     // 0x6A8           Host Channel-13 Interrupt
    UINT32 HCINTMSK13;                  // 0x6AC           Host Channel-13 Interrupt Mask
    UINT32 HCTSIZ13;                    // 0x6B0           Host Channel-13 Transfer Size
    UINT32 HCDMA13;                     // 0x6B4           Host Channel-13 DMA Address
    UINT32 PAD17[2];

// Host Channel-Specific Registers #14

    UINT32 HCCHAR14;                    // 0x6C0           Host Channel-14 Characteristics
    UINT32 HCSPLT14;                    // 0x6C4           Host Channel-14 Split Control
    UINT32 HCINT14;                     // 0x6C8           Host Channel-14 Interrupt
    UINT32 HCINTMSK14;                  // 0x6CC           Host Channel-14 Interrupt Mask
    UINT32 HCTSIZ14;                    // 0x6D0           Host Channel-14 Transfer Size
    UINT32 HCDMA14;                     // 0x6D4           Host Channel-14 DMA Address
    UINT32 PAD18[2];

// Host Channel-Specific Registers #15

    UINT32 HCCHAR15;                    // 0x6E0           Host Channel-15 Characteristics
    UINT32 HCSPLT15;                    // 0x6E4           Host Channel-15 Split Control
    UINT32 HCINT15;                     // 0x6E8           Host Channel-15 Interrupt
    UINT32 HCINTMSK15;                  // 0x6EC           Host Channel-15 Interrupt Mask
    UINT32 HCTSIZ15;                    // 0x6F0           Host Channel-15 Transfer Size
    UINT32 HCDMA15;                     // 0x6F4           Host Channel-15 DMA Address
    UINT32 PAD19[66];

//*********************************************************************
//    Device Mode Registers
//*********************************************************************
// Device Global Registers

    UINT32 DCFG;                        // 0x800            Device Configuration
    UINT32 DCTL;                        // 0x804            Device Control
    UINT32 DSTS;                        // 0x808            Device Status
    UINT32 PAD20[1];
    UINT32 DIEPMSK;                     // 0x810            Device IN Endpoint Common Interrupt Mask
    UINT32 DOEPMSK;                     // 0x814            Device OUT Endpoint Common Interrupt Mask
    UINT32 DAINT;                       // 0x818            Device All Endpoints Interrupt
    UINT32 DAINTMSK;                    // 0x81C            Device All Endpoints Interrupt Mask
    UINT32 DTKNQR1;                     // 0x820            Device IN Token Sequence Learning Queue Read 1
    UINT32 DTKNQR2;                     // 0x824            Device IN Token Sequence Learning Queue Read 2
    UINT32 DVBUSDIS;                    // 0x828            Device VBUS Discharge Time
    UINT32 DVBUSPULSE;                  // 0x82C            Device VBUS Pulsing Time
    UINT32 DTKNQR3;                     // 0x830            Device IN Token Sequence Learning Queue Read 3
    UINT32 DTKNQR4;                     // 0x834            Device IN Token Sequence Learning Queue Read 4
    UINT32 PAD21[50];

// Device Logical Endpoints-Specific Registers

    UINT32 DIEPCTL0;                    // 0x900            Device IN Endpoint 0 Control
    UINT32 PAD22[1];
    UINT32 DIEPINT0;                    // 0x908            Device IN Endpoint 0 Interrupt
    UINT32 PAD23[1];
    UINT32 DIEPTSIZ0;                   // 0x910            Device IN Endpoint 0 Transfer Size
    UINT32 DIEPDMA0;                    // 0x914            Device IN Endpoint 0 DMA Address
    UINT32 PAD24[2];

    UINT32 DIEPCTL1;                    // 0x920            Device IN Endpoint 1 Control
    UINT32 PAD25[1];
    UINT32 DIEPINT1;                    // 0x928            Device IN Endpoint 1 Interrupt
    UINT32 PAD26[1];
    UINT32 DIEPTSIZ1;                   // 0x930            Device IN Endpoint 1 Transfer Size
    UINT32 DIEPDMA1;                    // 0x934            Device IN Endpoint 1 DMA Address
    UINT32 PAD27[2];

    UINT32 DIEPCTL2;                    // 0x940            Device IN Endpoint 2 Control
    UINT32 PAD28[1];
    UINT32 DIEPINT2;                    // 0x948            Device IN Endpoint 2 Interrupt
    UINT32 PAD29[1];
    UINT32 DIEPTSIZ2;                   // 0x950            Device IN Endpoint 2 Transfer Size
    UINT32 DIEPDMA2;                    // 0x954            Device IN Endpoint 2 DMA Address
    UINT32 PAD30[2];

    UINT32 DIEPCTL3;                    // 0x960            Device IN Endpoint 3 Control
    UINT32 PAD31[1];
    UINT32 DIEPINT3;                    // 0x968            Device IN Endpoint 3 Interrupt
    UINT32 PAD32[1];
    UINT32 DIEPTSIZ3;                   // 0x970            Device IN Endpoint 3 Transfer Size
    UINT32 DIEPDMA3;                    // 0x974            Device IN Endpoint 3 DMA Address
    UINT32 PAD33[2];

    UINT32 DIEPCTL4;                    // 0x980            Device IN Endpoint 4 Control
    UINT32 PAD34[1];
    UINT32 DIEPINT4;                    // 0x988            Device IN Endpoint 4 Interrupt
    UINT32 PAD35[1];
    UINT32 DIEPTSIZ4;                   // 0x990            Device IN Endpoint 4 Transfer Size
    UINT32 DIEPDMA4;                    // 0x994            Device IN Endpoint 4 DMA Address
    UINT32 PAD36[2];    

    UINT32 DIEPCTL5;                    // 0x9A0            Device IN Endpoint 5 Control
    UINT32 PAD37[1];
    UINT32 DIEPINT5;                    // 0x9A8            Device IN Endpoint 5 Interrupt
    UINT32 PAD38[1];
    UINT32 DIEPTSIZ5;                   // 0x9B0            Device IN Endpoint 5 Transfer Size
    UINT32 DIEPDMA5;                    // 0x9B4            Device IN Endpoint 5 DMA Address
    UINT32 PAD39[2];

    UINT32 DIEPCTL6;                    // 0x9C0            Device IN Endpoint 6 Control
    UINT32 PAD40[1];
    UINT32 DIEPINT6;                    // 0x9C8            Device IN Endpoint 6 Interrupt
    UINT32 PAD41[1];
    UINT32 DIEPTSIZ6;                   // 0x9D0            Device IN Endpoint 6 Transfer Size
    UINT32 DIEPDMA6;                    // 0x9D4            Device IN Endpoint 6 DMA Address
    UINT32 PAD42[2];

    UINT32 DIEPCTL7;                    // 0x9E0            Device IN Endpoint 7 Control
    UINT32 PAD43[1];
    UINT32 DIEPINT7;                    // 0x9E8            Device IN Endpoint 7 Interrupt
    UINT32 PAD44[1];
    UINT32 DIEPTSIZ7;                   // 0x9F0            Device IN Endpoint 7 Transfer Size
    UINT32 DIEPDMA7;                    // 0x9F4            Device IN Endpoint 7 DMA Address
    UINT32 PAD45[2];

    UINT32 DIEPCTL8;                    // 0xA00            Device IN Endpoint 8 Control
    UINT32 PAD46[1];
    UINT32 DIEPINT8;                    // 0xA08            Device IN Endpoint 8 Interrupt
    UINT32 PAD47[1];
    UINT32 DIEPTSIZ8;                   // 0xA10            Device IN Endpoint 8 Transfer Size
    UINT32 DIEPDMA8;                    // 0xA14            Device IN Endpoint 8 DMA Address
    UINT32 PAD48[2];

    UINT32 DIEPCTL9;                    // 0xA20            Device IN Endpoint 9 Control
    UINT32 PAD49[1];
    UINT32 DIEPINT9;                    // 0xA28            Device IN Endpoint 9 Interrupt
    UINT32 PAD50[1];
    UINT32 DIEPTSIZ9;                   // 0xA30            Device IN Endpoint 9 Transfer Size
    UINT32 DIEPDMA9;                    // 0xA34            Device IN Endpoint 9 DMA Address
    UINT32 PAD51[2];

    UINT32 DIEPCTL10;                   // 0xA40            Device IN Endpoint 10 Control
    UINT32 PAD52[1];
    UINT32 DIEPINT10;                   // 0xA48            Device IN Endpoint 10 Interrupt
    UINT32 PAD53[1];
    UINT32 DIEPTSIZ10;                  // 0xA50            Device IN Endpoint 10 Transfer Size
    UINT32 DIEPDMA10;                   // 0xA54            Device IN Endpoint 10 DMA Address
    UINT32 PAD54[2];

    UINT32 DIEPCTL11;                   // 0xA60            Device IN Endpoint 11 Control
    UINT32 PAD55[1];
    UINT32 DIEPINT11;                   // 0xA68            Device IN Endpoint 11 Interrupt
    UINT32 PAD56[1];
    UINT32 DIEPTSIZ11;                  // 0xA70            Device IN Endpoint 11 Transfer Size
    UINT32 DIEPDMA11;                   // 0xA74            Device IN Endpoint 11 DMA Address
    UINT32 PAD57[2];

    UINT32 DIEPCTL12;                   // 0xA80            Device IN Endpoint 12 Control
    UINT32 PAD58[1];
    UINT32 DIEPINT12;                   // 0xA88            Device IN Endpoint 12 Interrupt
    UINT32 PAD59[1];
    UINT32 DIEPTSIZ12;                  // 0xA90            Device IN Endpoint 12 Transfer Size
    UINT32 DIEPDMA12;                   // 0xA94            Device IN Endpoint 12 DMA Address
    UINT32 PAD60[2];

    UINT32 DIEPCTL13;                   // 0xAA0            Device IN Endpoint 13 Control
    UINT32 PAD61[1];
    UINT32 DIEPINT13;                   // 0xAA8            Device IN Endpoint 13 Interrupt
    UINT32 PAD62[1];
    UINT32 DIEPTSIZ13;                  // 0xAB0            Device IN Endpoint 13 Transfer Size
    UINT32 DIEPDMA13;                   // 0xAB4            Device IN Endpoint 13 DMA Address                   
    UINT32 PAD63[2];

    UINT32 DIEPCTL14;                   // 0xAC0            Device IN Endpoint 14 Control
    UINT32 PAD64[1];
    UINT32 DIEPINT14;                   // 0xAC8            Device IN Endpoint 14 Interrupt
    UINT32 PAD65[1];
    UINT32 DIEPTSIZ14;                  // 0xAD0            Device IN Endpoint 14 Transfer Size
    UINT32 DIEPDMA14;                   // 0xAD4            Device IN Endpoint 14 DMA Address                   
    UINT32 PAD66[2];

    UINT32 DIEPCTL15;                   // 0xAE0            Device IN Endpoint 15 Control
    UINT32 PAD67[1];
    UINT32 DIEPINT15;                   // 0xAE8            Device IN Endpoint 15 Interrupt
    UINT32 PAD68[1];
    UINT32 DIEPTSIZ15;                  // 0xAF0            Device IN Endpoint 15 Transfer Size
    UINT32 DIEPDMA15;                   // 0xAF4            Device IN Endpoint 15 DMA Address
    UINT32 PAD69[2];

    UINT32 DOEPCTL0;                    // 0xB00            Device OUT Endpoint 0 Control
    UINT32 PAD70[1];
    UINT32 DOEPINT0;                    // 0xB08            Device OUT Endpoint 0 Interrupt
    UINT32 PAD71[1];
    UINT32 DOEPTSIZ0;                   // 0xB10            Device OUT Endpoint 0 Transfer Size
    UINT32 DOEPDMA0;                    // 0xB14            Device OUT Endpoint 0 DMA Address
    UINT32 PAD72[2];

    UINT32 DOEPCTL1;                    // 0xB20            Device OUT Endpoint 1 Control
    UINT32 PAD73[1];
    UINT32 DOEPINT1;                    // 0xB28            Device OUT Endpoint 1 Interrupt
    UINT32 PAD74[1];
    UINT32 DOEPTSIZ1;                   // 0xB30            Device OUT Endpoint 1 Transfer Size
    UINT32 DOEPDMA1;                    // 0xB34            Device OUT Endpoint 1 DMA Address
    UINT32 PAD75[2];

    UINT32 DOEPCTL2;                    // 0xB40            Device OUT Endpoint 2 Control
    UINT32 PAD76[1];
    UINT32 DOEPINT2;                    // 0xB48            Device OUT Endpoint 2 Interrupt
    UINT32 PAD77[1];
    UINT32 DOEPTSIZ2;                   // 0xB50            Device OUT Endpoint 2 Transfer Size
    UINT32 DOEPDMA2;                    // 0xB54            Device OUT Endpoint 2 DMA Address
    UINT32 PAD78[2];

    UINT32 DOEPCTL3;                    // 0xB60            Device OUT Endpoint 3 Control
    UINT32 PAD79[1];
    UINT32 DOEPINT3;                    // 0xB68            Device OUT Endpoint 3 Interrupt
    UINT32 PAD80[1];
    UINT32 DOEPTSIZ3;                   // 0xB70            Device OUT Endpoint 3 Transfer Size
    UINT32 DOEPDMA3;                    // 0xB74            Device OUT Endpoint 3 DMA Address
    UINT32 PAD81[2];

    UINT32 DOEPCTL4;                    // 0xB80            Device OUT Endpoint 4 Control
    UINT32 PAD82[1];
    UINT32 DOEPINT4;                    // 0xB88            Device OUT Endpoint 4 Interrupt
    UINT32 PAD83[1];
    UINT32 DOEPTSIZ4;                   // 0xB90            Device OUT Endpoint 4 Transfer Size
    UINT32 DOEPDMA4;                    // 0xB94            Device OUT Endpoint 4 DMA Address
    UINT32 PAD84[2];

    UINT32 DOEPCTL5;                    // 0xBA0            Device OUT Endpoint 5 Control
    UINT32 PAD85[1];
    UINT32 DOEPINT5;                    // 0xBA8            Device OUT Endpoint 5 Interrupt
    UINT32 PAD86[1];
    UINT32 DOEPTSIZ5;                   // 0xBB0            Device OUT Endpoint 5 Transfer Size
    UINT32 DOEPDMA5;                    // 0xBB4            Device OUT Endpoint 5 DMA Address
    UINT32 PAD87[2];

    UINT32 DOEPCTL6;                    // 0xBC0            Device OUT Endpoint 6 Control
    UINT32 PAD88[1];
    UINT32 DOEPINT6;                    // 0xBC8            Device OUT Endpoint 6 Interrupt
    UINT32 PAD89[1];
    UINT32 DOEPTSIZ6;                   // 0xBD0            Device OUT Endpoint 6 Transfer Size
    UINT32 DOEPDMA6;                    // 0xBD4            Device OUT Endpoint 6 DMA Address
    UINT32 PAD90[2];

    UINT32 DOEPCTL7;                    // 0xBE0            Device OUT Endpoint 7 Control
    UINT32 PAD91[1];
    UINT32 DOEPINT7;                    // 0xBE8            Device OUT Endpoint 7 Interrupt
    UINT32 PAD92[1];
    UINT32 DOEPTSIZ7;                   // 0xBF0            Device OUT Endpoint 7 Transfer Size
    UINT32 DOEPDMA7;                    // 0xBF4            Device OUT Endpoint 7 DMA Address
    UINT32 PAD93[2];

    UINT32 DOEPCTL8;                    // 0xC00            Device OUT Endpoint 8 Control
    UINT32 PAD94[1];
    UINT32 DOEPINT8;                    // 0xC08            Device OUT Endpoint 8 Interrupt
    UINT32 PAD95[1];
    UINT32 DOEPTSIZ8;                   // 0xC10            Device OUT Endpoint 8 Transfer Size
    UINT32 DOEPDMA8;                    // 0xC14            Device OUT Endpoint 8 DMA Address
    UINT32 PAD96[2];

    UINT32 DOEPCTL9;                    // 0xC20            Device OUT Endpoint 9 Control
    UINT32 PAD97[1];
    UINT32 DOEPINT9;                    // 0xC28            Device OUT Endpoint 9 Interrupt
    UINT32 PAD98[1];
    UINT32 DOEPTSIZ9;                   // 0xC30            Device OUT Endpoint 9 Transfer Size
    UINT32 DOEPDMA9;                    // 0xC34            Device OUT Endpoint 9 DMA Address
    UINT32 PAD99[2];

    UINT32 DOEPCTL10;                   // 0xC40            Device OUT Endpoint 10 Control
    UINT32 PAD100[1];
    UINT32 DOEPINT10;                   // 0xC48            Device OUT Endpoint 10 Interrupt
    UINT32 PAD101[1];
    UINT32 DOEPTSIZ10;                  // 0xC50            Device OUT Endpoint 10 Transfer Size
    UINT32 DOEPDMA10;                   // 0xC54            Device OUT Endpoint 10 DMA Address
    UINT32 PAD102[2];

    UINT32 DOEPCTL11;                   // 0xC60            Device OUT Endpoint 11 Control
    UINT32 PAD103[1];
    UINT32 DOEPINT11;                   // 0xC68            Device OUT Endpoint 11 Interrupt
    UINT32 PAD104[1];
    UINT32 DOEPTSIZ11;                  // 0xC70            Device OUT Endpoint 11 Transfer Size
    UINT32 DOEPDMA11;                   // 0xC74            Device OUT Endpoint 11 DMA Address
    UINT32 PAD105[2];

    UINT32 DOEPCTL12;                   // 0xC80            Device OUT Endpoint 12 Control
    UINT32 PAD106[1];
    UINT32 DOEPINT12;                   // 0xC88            Device OUT Endpoint 12 Interrupt
    UINT32 PAD107[1];
    UINT32 DOEPTSIZ12;                  // 0xC90            Device OUT Endpoint 12 Transfer Size
    UINT32 DOEPDMA12;                   // 0xC94            Device OUT Endpoint 12 DMA Address
    UINT32 PAD108[2];

    UINT32 DOEPCTL13;                   // 0xCA0            Device OUT Endpoint 13 Control
    UINT32 PAD109[1];
    UINT32 DOEPINT13;                   // 0xCA8            Device OUT Endpoint 13 Interrupt
    UINT32 PAD110[1];
    UINT32 DOEPTSIZ13;                  // 0xCB0            Device OUT Endpoint 13 Transfer Size
    UINT32 DOEPDMA13;                   // 0xCB4            Device OUT Endpoint 13 DMA Address              
    UINT32 PAD111[2];

    UINT32 DOEPCTL14;                   // 0xCC0            Device OUT Endpoint 14 Control
    UINT32 PAD112[1];
    UINT32 DOEPINT14;                   // 0xCC8            Device OUT Endpoint 14 Interrupt
    UINT32 PAD113[1];
    UINT32 DOEPTSIZ14;                  // 0xCD0            Device OUT Endpoint 14 Transfer Size
    UINT32 DOEPDMA14;                   // 0xCD4            Device OUT Endpoint 14 DMA Address
    UINT32 PAD114[2];

    UINT32 DOEPCTL15;                   // 0xCE0            Device OUT Endpoint 15 Control
    UINT32 PAD115[1];
    UINT32 DOEPINT15;                   // 0xCE8            Device OUT Endpoint 15 Interrupt
    UINT32 PAD116[1];
    UINT32 DOEPTSIZ15;                  // 0xCF0            Device OUT Endpoint 15 Transfer Size
    UINT32 DOEPDMA15;                   // 0xCF4            Device OUT Endpoint 15 DMA Address
    UINT32 PAD117[2];
} USBOTG_REG, *PUSBOTG_REG;

//------------------------------------------------------------------------------

#if __cplusplus
}
#endif

#endif

