//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: spi_reg.h
//
//  Defines the Serial Peripheral Interface (SPI) controller CPU register layout and
//  definitions.
//
#ifndef __S5PV210_SPI_H
#define __S5PV210_SPI_H

#if __cplusplus
    extern "C"
    {
#endif

#include <winioctl.h>
#include <ceddk.h>

typedef struct  
{
    UINT32 CH_CFG;          // 00
    UINT32 CLK_CFG;         // 04
    UINT32 MODE_CFG;        // 08
    UINT32 CS_SEL;          // 0C
    UINT32 SPI_INT_EN;      // 10
    UINT32 SPI_STATUS;      // 14
    UINT32 SPI_TX_DATA;     // 18
    UINT32 SPI_RX_DATA;     // 1C
    UINT32 PACKET_CNT_REG;  // 20
    UINT32 PENDING_CLR_REG; // 24
    UINT32 SWAP_CFG;        // 28
    UINT32 FB_CLK_SEL;      // 2C
} SPI_REG, *PSPI_REG; 



//------------------------------------------------------------------------------

#if __cplusplus
       }
#endif

#endif    // __S5PV210_SPI_H


