/*
**************************************************************************
*
*                                            SAMSUNG ELECTRONICS
*                                                 Copyright(C) 2009
*                                              ALL RIGHTS RESERVED
*
* This program is proprietary to Samsung Electronics,and is protected under International
* Copyright Act as an unpublished work.Its use and disclosure is limited by the terms and
* conditions of a license agreement.  It may not  be copied  or  otherwise   reproduced or
* disclosed  to persons  outside  the  licensee's   organization  except  in  accordance with
* the  terms and conditions  of such  an agreement. All copies and  reproductions shall be
* the property of  Samsung  Electronics  and  must bear this  notice in its entirety.
*
**************************************************************************
*/
/*
*
*    File name : smdkv210_rev00_bsp_gpio.h
*
*    Descriptions : this file contains the Samsung Microprocessor GPIO Primitives (SGIP), and
*                              Pin aliasing for smdkv210 rev00 board
* 
*
*     History         :
*            July 23 2009 : First generated.
*
*/

#ifndef __SMDKV210_REV00_BSP_GPIO_H__
#define __SMDKV210_REV00_BSP_GPIO_H__

#include "gpio_lib.h"


/********************************************************************************/
//	    Function Name            GPIO Name           Pad Name
//GPA
#define	UART0_RXD           GPA00_UART_0_RXD        // XuRXD[0]
#define	UART0_TXD           GPA01_UART_0_TXD        // XuTXD[0]
#define	UART0_CTSn          GPA02_UART_0_CTSn       // XuCTSn[0]
#define	UART0_RTSn          GPA03_UART_0_RTSn       // XuRTSn[0]
#define	UART1_RXD           GPA04_UART_1_RXD        // XuRXD[1]
#define	UART1_TXD           GPA05_UART_1_TXD        // XuTXD[1]
#define	UART1_CTSn          GPA06_UART_1_CTSn       // XuCTSn[1]
#define	UART1_RTSn	        GPA07_UART_1_RTSn       // XuRTSn[1]
#define	UART2_RXD	        GPA10_UART_2_RXD        // XuRXD[2]
#define	UART2_TXD	        GPA11_UART_2_TXD        // XuTXD[2]
#define	UART3_RXD	        GPA12_UART_3_RXD        // XuRXD[3]
#define	UART3_TXD	        GPA13_UART_3_TXD        // XuTXD[3]
//GPB
#define	SPI0_CLK	        GPB0_SPI_0_CLK          // XspiCLK[0]
#define	SPI0_nSS	        GPB1_SPI_0_nSS          // XspiCSn[0]
#define	SPI0_MISO	        GPB2_SPI_0_MISO         // XspiMISO[0]
#define	SPI0_MOSI	        GPB3_SPI_0_MOSI         // XspiMOSI[0]
#define	SPI1_CLK	        GPB4_SPI_1_CLK          // XspiCLK[1]
#define	SPI1_nSS	        GPB5_SPI_1_nSS          // XspiCSn[1]
#define	SPI1_MISO	        GPB6_SPI_1_MISO         // XspiMISO[1]
#define	SPI1_MOSI	        GPB7_SPI_1_MOSI         // XspiMOSI[1]
#define DISPLAY_CS              GPB5_Output             // XspiCSn[1]
#define DISPLAY_CLK             GPB4_Output             // Xm0ADDR[1]
#define DISPLAY_SO              GPB6_Output             // Xm0ADDR[2]
#define DISPLAY_SI              GPB7_Output             // Xm0ADDR[3]
//GPC
#define	I2S1_SCLK	        GPC00_I2S_1_SCLK        // Xi2s1SCLK
#define	I2S1_CDCLK	        GPC01_I2S_1_CDCLK       // Xi2s1CDCLK
#define	I2S1_LRCK	        GPC02_I2S_1_LRCK        // Xi2s1LRCK
#define	I2S1_SDI	        GPC03_I2S_1_SDI         // Xi2s1SDI
#define	I2S1_SDO	        GPC04_I2S_1_SDO         // Xi2s1SDO
#define	PCM0_SCLK	        GPC10_PCM_0_SCLK        // Xpcm0SCLK
#define	PCM0_EXTCLK	        GPC11_PCM_0_EXTCLK      // Xpcm0EXTCLK
#define	PCM0_FSYNC	        GPC12_PCM_0_FSYNC       // Xpcm0FSYNC
#define	PCM0_SIN	        GPC13_PCM_0_SIN         // Xpcm0SIN
#define	PCM0_SOUT	        GPC14_PCM_0_SOUT        // Xpcm0SOUT
//GPD
#define	TOUT0	            GPD00_TOUT_0            // XpwmTOUT[0]
#define	TOUT1	            GPD01_TOUT_1            // XpwmTOUT[1]
#define	TOUT2	            GPD02_TOUT_2            // XpwmTOUT[2]
#define	PWM_MIE	            GPD03_TOUT_3            // XpwmTOUT[3]
#define	I2C0_SDA	        GPD10_I2C0_SDA          // Xi2c0SDA
#define	I2C0_SCL	        GPD11_I2C0_SCL          // Xi2c0SCL
#define	I2C1_SDA	        GPD12_I2C1_SDA          // Xi2c1SDA
#define	I2C1_SCL	        GPD13_I2C1_SCL          // Xi2c1SCL
#define	I2C2_SDA            GPD14_I2C2_SDA          // Xi2c2SDA
#define	I2C2_SCL            GPD15_I2C2_SCL          // Xi2c2SCL
#define BACKLIGHT           GPD03_Output            //
//GPE
#define	CAM_A_PCLK	        GPE00_CAM_A_PCLK        // XciPCLK
#define	CAM_A_VSYNC	        GPE01_CAM_A_VSYNC       // XciVSYNC
#define	CAM_A_HREF	        GPE02_CAM_A_HREF        // XciHREF
#define	CAM_A_DATA0         GPE03_CAM_A_DATA0       // XciDATA[0]
#define	CAM_A_DATA1         GPE04_CAM_A_DATA1       // XciDATA[1]
#define	CAM_A_DATA2         GPE05_CAM_A_DATA2       // XciDATA[2]
#define	CAM_A_DATA3         GPE06_CAM_A_DATA3       // XciDATA[3]
#define	CAM_A_DATA4         GPE07_CAM_A_DATA4       // XciDATA[4]
#define	CAM_A_DATA5         GPE10_CAM_A_DATA5       // XciDATA[5]
#define	CAM_A_DATA6         GPE11_CAM_A_DATA6       // XciDATA[6]
#define	CAM_A_DATA7         GPE12_CAM_A_DATA7       // XciDATA[7]
#define	CAM_A_CLKOUT        GPE13_CAM_A_CLKOUT      // XciCLKenb
#define	CAM_A_FIELD	        GPE14_CAM_A_FIELD       // XciFIELD
//GPF
#define	LCD_HSYNC	        GPF00_LCD_HSYNC         // XvHSYNC
#define	LCD_VSYNC	        GPF01_LCD_VSYNC         // XvVSYNC
#define	LCD_VDEN	        GPF02_LCD_VDEN          // XvVDEN
#define	LCD_VCLK	        GPF03_LCD_VCLK          // XvVCLK
#define	LCD_D0	            GPF04_LCD_VD_0          // XvVD[0]
#define	LCD_D1	            GPF05_LCD_VD_1          // XvVD[1]
#define	LCD_D2	            GPF06_LCD_VD_2          // XvVD[2]
#define	LCD_D3	            GPF07_LCD_VD_3          // XvVD[3]
#define	LCD_D4	            GPF10_LCD_VD_4          // XvVD[4]
#define	LCD_D5	            GPF11_LCD_VD_5          // XvVD[5]
#define	LCD_D6	            GPF12_LCD_VD_6          // XvVD[6]
#define	LCD_D7	            GPF13_LCD_VD_7          // XvVD[7]
#define	LCD_D8	            GPF14_LCD_VD_8          // XvVD[8]
#define	LCD_D9	            GPF15_LCD_VD_9          // XvVD[9]
#define	LCD_D10	            GPF16_LCD_VD_10         // XvVD[10]
#define	LCD_D11	            GPF17_LCD_VD_11         // XvVD[11]
#define	LCD_D12	            GPF20_LCD_VD_12         // XvVD[12]
#define	LCD_D13	            GPF21_LCD_VD_13         // XvVD[13]
#define	LCD_D14	            GPF22_LCD_VD_14         // XvVD[14]
#define	LCD_D15	            GPF23_LCD_VD_15         // XvVD[15]
#define	LCD_D16	            GPF24_LCD_VD_16         // XvVD[16]
#define	LCD_D17	            GPF25_LCD_VD_17         // XvVD[17]
#define	LCD_D18	            GPF26_LCD_VD_18         // XvVD[18]
#define	LCD_D19	            GPF27_LCD_VD_19         // XvVD[19]
#define	LCD_D20	            GPF30_LCD_VD_20         // XvVD[20]
#define	LCD_D21	            GPF31_LCD_VD_21         // XvVD[21]
#define	LCD_D22	            GPF32_LCD_VD_22         // XvVD[22]
#define	LCD_D23	            GPF33_LCD_VD_23         // XvVD[23]
#define	VSYNC_LDI	        GPF34_VSYNC_LDI         // XvVSYNC_LDI
#define	SYS_OE	            GPF35_SYS_OE            // XvSYS_OE
//GPG
#define	MMC_SLOT0_A_CLK	    GPG00_SD_0_CLK          // Xmmc0CLK
#define	MMC_SLOT0_A_CMD	    GPG01_SD_0_CMD          // Xmmc0CMD
#define	MMC_SLOT0_A_CDn	    GPG02_SD_0_CDn          // Xmmc0CDn
#define	MMC_SLOT0_A_D0	    GPG03_SD_0_DATA_0       // Xmmc0DATA[0]
#define	MMC_SLOT0_A_D1	    GPG04_SD_0_DATA_1       // Xmmc0DATA[1]
#define	MMC_SLOT0_A_D2	    GPG05_SD_0_DATA_2       // Xmmc0DATA[2]
#define	MMC_SLOT0_A_D3	    GPG06_SD_0_DATA_3       // Xmmc0DATA[3]
#define	MMC_SLOT0_A_D4	    GPG13_SD_0_DATA_4       // Xmmc0DATA[4]
#define	MMC_SLOT0_A_D5	    GPG14_SD_0_DATA_5       // Xmmc0DATA[5]
#define	MMC_SLOT0_A_D6	    GPG15_SD_0_DATA_6       // Xmmc0DATA[6]
#define	MMC_SLOT0_A_D7	    GPG16_SD_0_DATA_7       // Xmmc0DATA[7]

#define	MMC_SLOT0_B_CLK	    GPG10_SD_1_CLK          // Xmmc1CLK
#define	MMC_SLOT0_B_CMD	    GPG11_SD_1_CMD          // Xmmc1CMD
#define	MMC_SLOT0_B_CDn	    GPG12_SD_1_CDn          // Xmmc1CDn
#define	MMC_SLOT0_B_D0	    GPG13_SD_1_DATA_0       // Xmmc1DATA[0]
#define	MMC_SLOT0_B_D1	    GPG14_SD_1_DATA_1       // Xmmc1DATA[1]
#define	MMC_SLOT0_B_D2	    GPG15_SD_1_DATA_2       // Xmmc1DATA[2]
#define	MMC_SLOT0_B_D3	    GPG16_SD_1_DATA_3       // Xmmc1DATA[3]

#define	MMC_SLOT1_CLK	    GPG20_SD_2_CLK          // Xmmc2CLK
#define	MMC_SLOT1_CMD	    GPG21_SD_2_CMD          // Xmmc2CMD
#define	MMC_SLOT1_CDn	    GPG22_SD_2_CDn          // Xmmc2CDn
#define	MMC_SLOT1_D0	    GPG23_SD_2_DATA_0       // Xmmc2DATA[0]
#define	MMC_SLOT1_D1	    GPG24_SD_2_DATA_1	    // Xmmc2DATA[1]
#define	MMC_SLOT1_D2	    GPG25_SD_2_DATA_2	    // Xmmc2DATA[2]
#define	MMC_SLOT1_D3	    GPG26_SD_2_DATA_3	    // Xmmc2DATA[3]
#define	MMC_SLOT1_D4	    GPG33_SD_2_DATA_4       // Xmmc2DATA[4]
#define	MMC_SLOT1_D5	    GPG34_SD_2_DATA_5	    // Xmmc2DATA[5]
#define	MMC_SLOT1_D6	    GPG35_SD_2_DATA_6	    // Xmmc2DATA[6]
#define	MMC_SLOT1_D7	    GPG36_SD_2_DATA_7	    // Xmmc2DATA[7]

#define	MMC_SLOT2_CLK	    GPG30_SD_3_CLK          // Xmmc3CLK
#define	MMC_SLOT2_CMD	    GPG31_SD_3_CMD          // Xmmc3CMD
#define	MMC_SLOT2_CDn	    GPG32_SD_3_CDn          // Xmmc3CDn
#define	MMC_SLOT2_D0	    GPG33_SD_3_DATA_0       // Xmmc3DATA[0]
#define	MMC_SLOT2_D1	    GPG34_SD_3_DATA_1	    // Xmmc3DATA[1]
#define	MMC_SLOT2_D2	    GPG35_SD_3_DATA_2	    // Xmmc3DATA[2]
#define	MMC_SLOT2_D3	    GPG36_SD_3_DATA_3	    // Xmmc3DATA[3]
//GPH
#define RESET_BUTTON        GPH04_EXT_INT_4         // Reset Button
#define MLCD_RST             GPH06_Output
#define MMC_SLOT0_WP        GPH07_Input             // Slot0_WriteProtect
#define MMC_SLOT2_WP        GPH10_Input             // MMC Slot2 WP
#define MIPI_CSI_EN         GPH12_Output			// MIPI_CSI_ENABLE
#define MIPI_DSI_RESET      GPH21_Output			// MIPI_DSI_RESET


#if 0
#define LED6                GPH24_Output            // LED6
#define LED7                GPH25_Output            // LED7
#define LED8                GPH26_Output            // LED8
#define LED9                GPH27_Output            // LED9
#else

#define LED6                0            // LED6
#define LED7                0            // LED7
#define LED8                0            // LED8
#define LED9                0            // LED9
#endif








#define HDMI_HPD_FUNC		GPH15_HDMI_HPD
#define HDMI_HPD_EINT		GPH15_EXT_INT_13
#define PMIC_SET1           GPH16_Output            // XEINT14
#define PMIC_SET2           GPH17_Output            // XEINT15
#define PMIC_SET3           GPH04_Output            // XEINT4
#define MMC_SLOT1_WP        GPH31_Input             // MMC Slot1 WP
#define PWR_BUTTON          GPH37_EXT_INT_31        // Sleep/WakeUP Power button
#define CAM_A_RESET         GPH02_Output         // CAM A Module Reset
#define CAM_B_RESET         GPH03_Output         // CAM A Module Reset

#define KEYIF_COL0			GPH20_KP_COL_0			// KEYIF column 0
#define KEYIF_COL1			GPH21_KP_COL_1			// KEYIF column 1
#define KEYIF_COL2			GPH22_KP_COL_2			// KEYIF column 2
#define KEYIF_COL3			GPH23_KP_COL_3			// KEYIF column 3
#define KEYIF_COL4			GPH24_KP_COL_4			// KEYIF column 4
#define KEYIF_COL5			GPH25_KP_COL_5			// KEYIF column 5
#define KEYIF_COL6			GPH26_KP_COL_6			// KEYIF column 6
#define KEYIF_COL7			GPH27_KP_COL_7			// KEYIF column 7

#define KEYIF_ROW0			GPH30_KP_ROW_0			// KEYIF row 0
#define KEYIF_ROW1			GPH31_KP_ROW_1			// KEYIF row 1
#define KEYIF_ROW2			GPH32_KP_ROW_2			// KEYIF row 2
#define KEYIF_ROW3			GPH33_KP_ROW_3			// KEYIF row 3
#define KEYIF_ROW4			GPH34_KP_ROW_4			// KEYIF row 4
#define KEYIF_ROW5			GPH35_KP_ROW_5			// KEYIF row 5
#define KEYIF_ROW6			GPH36_KP_ROW_6			// KEYIF row 6
#define KEYIF_ROW7			GPH37_KP_ROW_7			// KEYIF row 

//GPI
#define	I2S0_SCLK	        GPI00_I2S_0_SCLK        // Xi2s0SCLK
#define	I2S0_CDCLK	        GPI01_I2S_0_CDCLK   	// Xi2s0CDCLK
#define	I2S0_LRCK	        GPI02_I2S_0_LRCK    	// Xi2s0LRCK
#define	I2S0_SDI	        GPI03_I2S_0_SDI     	// Xi2s0SDI
#define	I2S0_SDO0	        GPI04_I2S_0_SDO_0   	// Xi2s0SDO[0]
#define	I2S0_SDO1	        GPI05_I2S_0_SDO_1       // Xi2s0SDO[1]
#define	I2S0_SDO2	        GPI06_I2S_0_SDO_2       // Xi2s0SDO[2]
#define	MSM_ADDR0	        GPJ00_MSM_ADDR_0        // XmsmADDR[0]
#define	MSM_ADDR1           GPJ01_MSM_ADDR_1        // XmsmADDR[1]
#define	MSM_ADDR2	        GPJ02_MSM_ADDR_2        // XmsmADDR[2]
#define	MSM_ADDR3	        GPJ03_MSM_ADDR_3        // XmsmADDR[3]
#define	MSM_ADDR4	        GPJ04_MSM_ADDR_4        // XmsmADDR[4]
#define	MSM_ADDR5           GPJ05_MSM_ADDR_5        // XmsmADDR[5]
#define	MSM_ADDR6       	GPJ06_MSM_ADDR_6        // XmsmADDR[6]
#define	MSM_ADDR7           GPJ07_MSM_ADDR_7        // XmsmADDR[7]
#define	MSM_ADDR8           GPJ10_MSM_ADDR_8        // XmsmADDR[8]
#define	MSM_ADDR9	        GPJ11_MSM_ADDR_9        // XmsmADDR[9]
#define	MSM_ADDR10	        GPJ12_MSM_ADDR_10       // XmsmADDR[10]
#define	MSM_ADDR11	        GPJ13_MSM_ADDR_11       // XmsmADDR[11]
#define	MSM_ADDR12	        GPJ14_MSM_ADDR_12       // XmsmADDR[12]
#define	MSM_ADDR13          GPJ15_MSM_ADDR_13       // XmsmADDR[13]
#define	MSM_DATA0           GPJ20_MSM_DATA_0        // XmsmDATA[0]
#define	MSM_DATA1           GPJ21_MSM_DATA_1        // XmsmDATA[1]
#define	MSM_DATA2	        GPJ22_MSM_DATA_2        // XmsmDATA[2]
#define	MSM_DATA3       	GPJ23_MSM_DATA_3        // XmsmDATA[3]
#define	MSM_DATA4	        GPJ24_MSM_DATA_4        // XmsmDATA[4]
#define	MSM_DATA5           GPJ25_CF_DATA_5         // XmsmDATA[5]
#define	MSM_DATA6           GPJ26_CF_DATA_6         // XmsmDATA[6]
#define	MSM_DATA7       	GPJ27_CF_DATA_7         // XmsmDATA[7]
#define	MSM_DATA8           GPJ30_MSM_DATA_8        // XmsmDATA[8]
#define	MSM_DATA9           GPJ31_MSM_DATA_9        // XmsmDATA[9]
#define	MSM_DATA10          GPJ32_MSM_DATA_10       // XmsmDATA[10]
#define	MSM_DATA11          GPJ33_MSM_DATA_11       // XmsmDATA[11]
#define	MSM_DATA12          GPJ34_MSM_DATA_12       // XmsmDATA[12]
#define	MSM_DATA13          GPJ35_MSM_DATA_13       // XmsmDATA[13]
#define	MSM_DATA14          GPJ36_MSM_DATA_14       // XmsmDATA[14]
#define	MSM_DATA15          GPJ37_MSM_DATA_15       // XmsmDATA[15]
#define	MSM_CSn	            GPJ40_MSM_CSn           // XmsmCSn
#define	MSM_WEn	            GPJ41_MSM_WEn           // XmsmWEn
#define	MSM_Rn	            GPJ42_MSM_Rn            // XmsmRn
#define	MSM_IRQn	        GPJ43_MSM_IRQn          // XmsmIRQn
#define	MSM_ADVN	        GPJ44_MSM_ADVN          // XmsmADVN

//CAM B
#define	CAM_B_DATA_0	    GPJ00_CAM_B_DATA_0
#define	CAM_B_DATA_1	    GPJ01_CAM_B_DATA_1
#define	CAM_B_DATA_2	    GPJ02_CAM_B_DATA_2
#define	CAM_B_DATA_3	    GPJ03_CAM_B_DATA_3
#define	CAM_B_DATA_4	    GPJ04_CAM_B_DATA_4
#define	CAM_B_DATA_5	    GPJ05_CAM_B_DATA_5
#define	CAM_B_DATA_6	    GPJ06_CAM_B_DATA_6
#define	CAM_B_DATA_7	    GPJ07_CAM_B_DATA_7
#define	CAM_B_PCLK	        GPJ10_CAM_B_PCLK
#define	CAM_B_VSYNC	        GPJ11_CAM_B_VSYNC
#define	CAM_B_HREF	        GPJ12_CAM_B_HREF
#define	CAM_B_FIELD	        GPJ13_CAM_B_FIELD
#define	CAM_B_CLKOUT	    GPJ14_CAM_B_CLKOUT

//MP
#define SUB_DISPLAY_CS      MP01_2_Output           // Xm0CSn[2]
#define ONENAND_CS0         MP01_4_ONANDXL_CSn_0    // OneNand CS0
#define ONENAND_CS1         MP01_5_ONANDXL_CSn_1    // OneNand CS1
#define NAND_CS0            MP01_2_NFCSn_0          // Nand CS0
#define NAND_CS1            MP01_3_NFCSn_1          // Nand CS1
#define NAND_CS2            MP01_4_NFCSn_2          // Nand CS2
#define NAND_CS3            MP01_5_NFCSn_3          // Nand CS3
#define ONENAND_OE          MP01_6_EBI_OEn          // OneNand OEn
#define ONENAND_WE          MP01_7_EBI_WEn          // OneNand WE
#define ONENAND_ADDRVALID   MP03_0_ONANDXL_ADDRVALID// OneNand Address Valid
#define ONENAND_CLK         MP03_1_ONANDXL_SMCLK    // OneNand ClK
#define ONENAND_RP          MP03_2_ONANDXL_RPn      // OneNand Reset
#define ONENAND_INT0        MP03_4_ONANDXL_INT_0    // OneNand INT0
#define ONENAND_INT1        MP03_5_ONANDXL_INT_1    // OneNand INT1
#define NAND_CLE            MP03_0_NF_CLE           // Nand CLE
#define NAND_ALE            MP03_1_NF_ALE           // Nand ALE
#define NAND_FWE            MP03_2_NF_FWEn          // Nand FWE
#define NAND_RNB0           MP03_4_NF_RnB_0         // Nand RNB0
#define NAND_RNB1           MP03_5_NF_RnB_1         // Nand RNB1
#define NAND_RNB2           MP03_6_NF_RnB_2         // Nand RNB2
#define NAND_RNB3           MP03_7_NF_RnB_3         // Nand RNB3

#endif // __SMDKV210_REV00_BSP_GPIO_H__
