//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: image_rotator_reg.h
//
//  Defines the Image Rotator CPU register layout and definitions.
//
#ifndef __IMAGE_ROTATOR_REG_H
#define __IMAGE_ROTATOR_REG_H

#if __cplusplus
    extern "C"
    {
#endif


//------------------------------------------------------------------------------
//  Type: IMAGE_ROTATOR_REG
//
//  Post Processor register layout. This register bank is located
//  by the constant CPU_BASE_REG_XX_POST in the configuration file
//  cpu_base_reg_cfg.h.
//

typedef struct
{
    UINT32 CTRLCFG;                // 0x00
    UINT32 SrcAddrReg0;            // 0x04
    UINT32 SrcAddrReg1;            // 0x08
    UINT32 SrcAddrReg2;            // 0x0c    

    UINT32 SrcSizeReg;            // 0x10
    UINT32 PAD0;                // 0x14
    UINT32 DstAddrReg0;            // 0x18
    UINT32 DstAddrReg1;            // 0x1c

    UINT32 DstAddrReg2;            // 0x20
    UINT32 PAD1;                // 0x24
    UINT32 PAD2;                // 0x28
    UINT32 STATCFG;                // 0x2c    
} IMAGE_ROTATOR_REG, *PIMAGE_ROTATOR_REG;

#if __cplusplus
    }
#endif

#endif    // __IMAGE_ROTATOR_REG_H