//=============================================================================
// File Name : regs_for_BL.h
// Function  : S5PV210 SFR Definitions
//=============================================================================

#ifndef __V210ADDR_H__
#define __V210ADDR_H__

#ifdef __cplusplus
extern "C" {
#endif

void Uart_Init(void);
void Uart_SendByte(int data);
void Uart_SendString(char *pt);
void Uart_SendDWORD(DWORD d, BOOL cr);
char *hex2char(unsigned int val);


#define GPIO_BASE           (0xE0300000)
#define rGPA0CON            (*(volatile unsigned *)(GPIO_BASE+0x00))
#define rGPA0DAT            (*(volatile unsigned *)(GPIO_BASE+0x04))
#define rGPA0PUD            (*(volatile unsigned *)(GPIO_BASE+0x08))


// chapter7 Nand Flash
#define NANDF_BASE          (0xE7200000)
#define rNFCONF             (*(volatile unsigned *)(NANDF_BASE+0x00))       //NAND Flash configuration
#define rNFCONT             (*(volatile unsigned *)(NANDF_BASE+0x04))       //NAND Flash control
#define rNFCMD              (*(volatile unsigned *)(NANDF_BASE+0x08))       //NAND Flash command 
#define rNFADDR             (*(volatile unsigned *)(NANDF_BASE+0x0C))       //NAND Flash address
#define rNFDATA             (*(volatile unsigned *)(NANDF_BASE+0x10))       //NAND Flash data 
#define rNFDATA8            (*(volatile unsigned char *)(NANDF_BASE+0x10))  //NAND Flash data (byte)
#define rNFDATA32           (*(volatile unsigned *)(NANDF_BASE+0x10))       //NAND Flash data (word)
#define NFDATA              (NANDF_BASE+0x10)                        
#define rNFMECCD0           (*(volatile unsigned *)(NANDF_BASE+0x14))       //NAND Flash ECC for Main 
#define rNFMECCD1           (*(volatile unsigned *)(NANDF_BASE+0x18))       //NAND Flash ECC for Main 
#define rNFSECCD            (*(volatile unsigned *)(NANDF_BASE+0x1C))       //NAND Flash ECC for Spare Area
#define rNFSBLK             (*(volatile unsigned *)(NANDF_BASE+0x20))       //NAND Flash programmable start block address
#define rNFEBLK             (*(volatile unsigned *)(NANDF_BASE+0x24))       //NAND Flash programmable end block address     
#define rNFSTAT             (*(volatile unsigned *)(NANDF_BASE+0x28))       //NAND Flash operation status 
#define rNFECCERR0          (*(volatile unsigned *)(NANDF_BASE+0x2C))       //NAND Flash ECC Error Status for I/O [7:0]
#define rNFECCERR1          (*(volatile unsigned *)(NANDF_BASE+0x30))       //NAND Flash ECC Error Status for I/O [15:8]
#define rNFMECC0            (*(volatile unsigned *)(NANDF_BASE+0x34))       //SLC or MLC NAND Flash ECC status
#define rNFMECC1            (*(volatile unsigned *)(NANDF_BASE+0x38))       //SLC or MLC NAND Flash ECC status    
#define rNFSECC             (*(volatile unsigned *)(NANDF_BASE+0x3C))       //NAND Flash ECC for I/O[15:0]
#define rNFMLCBITPT         (*(volatile unsigned *)(NANDF_BASE+0x40))       //NAND Flash 4-bit ECC Error Pattern for data[7:0]

// UART
#define UART0_BASE          (0xEC000000)    
#define rULCON0             (*(volatile unsigned *)(UART0_BASE+0x00))
#define rUCON0              (*(volatile unsigned *)(UART0_BASE+0x04))
#define rUFCON0             (*(volatile unsigned *)(UART0_BASE+0x08))
#define rUMCON0             (*(volatile unsigned *)(UART0_BASE+0x0C))
#define rUTRSTAT0           (*(volatile unsigned *)(UART0_BASE+0x10))
#define rUERSTAT0           (*(volatile unsigned *)(UART0_BASE+0x14))
#define rUFSTAT0            (*(volatile unsigned *)(UART0_BASE+0x18))
#define rUMSTAT0            (*(volatile unsigned *)(UART0_BASE+0x1C))
#define rUTXH0              (*(volatile unsigned *)(UART0_BASE+0x20))
#define rURXH0              (*(volatile unsigned *)(UART0_BASE+0x24))
#define rUBRDIV0            (*(volatile unsigned *)(UART0_BASE+0x28))
#define rUDIVSLOT0          (*(volatile unsigned *)(UART0_BASE+0x2C))
#define rUINTP0             (*(volatile unsigned *)(UART0_BASE+0x30))
#define rUINTSP0            (*(volatile unsigned *)(UART0_BASE+0x34))
#define rUINTM0             (*(volatile unsigned *)(UART0_BASE+0x38))

#define UART1_BASE          (0xEC000400)
#define rULCON1             (*(volatile unsigned *)(UART1_BASE+0x00))
#define rUCON1              (*(volatile unsigned *)(UART1_BASE+0x04))
#define rUFCON1             (*(volatile unsigned *)(UART1_BASE+0x08))
#define rUMCON1             (*(volatile unsigned *)(UART1_BASE+0x0C))
#define rUTRSTAT1           (*(volatile unsigned *)(UART1_BASE+0x10))
#define rUERSTAT1           (*(volatile unsigned *)(UART1_BASE+0x14))
#define rUFSTAT1            (*(volatile unsigned *)(UART1_BASE+0x18))
#define rUMSTAT1            (*(volatile unsigned *)(UART1_BASE+0x1C))
#define rUTXH1              (*(volatile unsigned *)(UART1_BASE+0x20))
#define rURXH1              (*(volatile unsigned *)(UART1_BASE+0x24))
#define rUBRDIV1            (*(volatile unsigned *)(UART1_BASE+0x28))
#define rUDIVSLOT1          (*(volatile unsigned *)(UART1_BASE+0x2C))
#define rUINTP1             (*(volatile unsigned *)(UART1_BASE+0x2C))
#define rUINTSP1            (*(volatile unsigned *)(UART1_BASE+0x34))
#define rUINTM1             (*(volatile unsigned *)(UART1_BASE+0x38))

#define UART2_BASE          (0xEC000800)
#define rULCON2             (*(volatile unsigned *)(UART2_BASE+0x00))
#define rUCON2              (*(volatile unsigned *)(UART2_BASE+0x04))
#define rUFCON2             (*(volatile unsigned *)(UART2_BASE+0x08))
#define rUMCON2             (*(volatile unsigned *)(UART2_BASE+0x0C))
#define rUTRSTAT2           (*(volatile unsigned *)(UART2_BASE+0x10))
#define rUERSTAT2           (*(volatile unsigned *)(UART2_BASE+0x14))
#define rUFSTAT2            (*(volatile unsigned *)(UART2_BASE+0x18))
#define rUMSTAT2            (*(volatile unsigned *)(UART2_BASE+0x1C))
#define rUTXH2              (*(volatile unsigned *)(UART2_BASE+0x20))
#define rURXH2              (*(volatile unsigned *)(UART2_BASE+0x24))
#define rUBRDIV2            (*(volatile unsigned *)(UART2_BASE+0x28))
#define rUDIVSLOT2          (*(volatile unsigned *)(UART2_BASE+0x2C))
#define rUINTP2             (*(volatile unsigned *)(UART2_BASE+0x30))
#define rUINTSP2            (*(volatile unsigned *)(UART2_BASE+0x34))
#define rUINTM2             (*(volatile unsigned *)(UART2_BASE+0x38))

#define WrUTXH0(ch)         (*(volatile unsigned char *)(UART0_BASE+0x20))=(unsigned char)(ch)                                                                                                                            
#define RdURXH0()           (*(volatile unsigned char *)(UART0_BASE+0x24))                                                                                                                                                
#define WrUTXH1(ch)         (*(volatile unsigned char *)(UART1_BASE+0x20))=(unsigned char)(ch)                                                                                                                            
#define RdURXH1()           (*(volatile unsigned char *)(UART1_BASE+0x24))                                                                                                                                                
#define WrUTXH2(ch)         (*(volatile unsigned char *)(UART2_BASE+0x20))=(unsigned char)(ch)                                                                                                                            
#define RdURXH2()           (*(volatile unsigned char *)(UART2_BASE+0x24))                                                                                                                                                

//---------------------------------------------
// Define Clock Controller Registers
//---------------------------------------------
#define CMU_BASE    (0xE0100000)     

#define	rAPLL_LOCK 			(*(volatile unsigned *)(CMU_BASE+0x0000))
#define	rMPLL_LOCK 			(*(volatile unsigned *)(CMU_BASE+0x0008))
#define	rEPLL_LOCK 			(*(volatile unsigned *)(CMU_BASE+0x0010))
#define	rVPLL_LOCK 			(*(volatile unsigned *)(CMU_BASE+0x0020))

#if (S5PV210_EVT==0)
#define	rAPLL_CON 			(*(volatile unsigned *)(CMU_BASE+0x0100))
#else
#define	rAPLL_CON0 			(*(volatile unsigned *)(CMU_BASE+0x0100))
#define	rAPLL_CON1 			(*(volatile unsigned *)(CMU_BASE+0x0104))
#endif
#define	rMPLL_CON 			(*(volatile unsigned *)(CMU_BASE+0x0108))
#if (S5PV210_EVT==0)
#define	rEPLL_CON 			(*(volatile unsigned *)(CMU_BASE+0x0110))
#else
#define	rEPLL_CON0 			(*(volatile unsigned *)(CMU_BASE+0x0110))
#define	rEPLL_CON1 			(*(volatile unsigned *)(CMU_BASE+0x0114))
#endif
#define	rVPLL_CON 			(*(volatile unsigned *)(CMU_BASE+0x0120))
	
#define	rCLK_SRC0 			(*(volatile unsigned *)(CMU_BASE+0x0200))
#define	rCLK_SRC1 			(*(volatile unsigned *)(CMU_BASE+0x0204))
#define	rCLK_SRC2 			(*(volatile unsigned *)(CMU_BASE+0x0208))
#define	rCLK_SRC3 			(*(volatile unsigned *)(CMU_BASE+0x020c))
#define	rCLK_SRC4 			(*(volatile unsigned *)(CMU_BASE+0x0210))
#define	rCLK_SRC5 			(*(volatile unsigned *)(CMU_BASE+0x0214))
#define	rCLK_SRC6 			(*(volatile unsigned *)(CMU_BASE+0x0218))
#define	rCLK_SRC_MASK0 	    (*(volatile unsigned *)(CMU_BASE+0x0280))		
#define	rCLK_SRC_MASK1 	    (*(volatile unsigned *)(CMU_BASE+0x0284))		

#define	rCLK_DIV0 			(*(volatile unsigned *)(CMU_BASE+0x0300))
#define	rCLK_DIV1 			(*(volatile unsigned *)(CMU_BASE+0x0304))
#define	rCLK_DIV2 			(*(volatile unsigned *)(CMU_BASE+0x0308))
#define	rCLK_DIV3 			(*(volatile unsigned *)(CMU_BASE+0x030c))
#define	rCLK_DIV4 			(*(volatile unsigned *)(CMU_BASE+0x0310))
#define	rCLK_DIV5 			(*(volatile unsigned *)(CMU_BASE+0x0314))
#define	rCLK_DIV6 			(*(volatile unsigned *)(CMU_BASE+0x0318))
#define	rCLK_DIV7 			(*(volatile unsigned *)(CMU_BASE+0x031C))

#define	rCLK_GATE_IP0 		(*(volatile unsigned *)(CMU_BASE+0x0460))	
#define	rCLK_GATE_IP1 		(*(volatile unsigned *)(CMU_BASE+0x0464))	
#define	rCLK_GATE_IP2 		(*(volatile unsigned *)(CMU_BASE+0x0468))	
#define	rCLK_GATE_IP3 		(*(volatile unsigned *)(CMU_BASE+0x046C))	
#define	rCLK_GATE_IP4 		(*(volatile unsigned *)(CMU_BASE+0x0470))	
#define	rCLK_GATE_BLOCK 	(*(volatile unsigned *)(CMU_BASE+0x0480))		

#define	rCLK_OUT 			(*(volatile unsigned *)(CMU_BASE+0x0500))
	
#define	rCLK_DIV_STAT0		(*(volatile unsigned *)(CMU_BASE+0x1000))	
#define	rCLK_DIV_STAT1		(*(volatile unsigned *)(CMU_BASE+0x1004))	
#define	rCLK_MUX_STAT0	    (*(volatile unsigned *)(CMU_BASE+0x1100))		
#define	rCLK_MUX_STAT1	    (*(volatile unsigned *)(CMU_BASE+0x1104))		
					
	// RESET				
#define	rGLOBAL_SW_RESET 	(*(volatile unsigned *)(CMU_BASE+0x2000))		
					
	// IEM				
#define	rDCGIDX_MAP0 		(*(volatile unsigned *)(CMU_BASE+0x3000))	
#define	rDCGIDX_MAP1 		(*(volatile unsigned *)(CMU_BASE+0x3004))	
#define	rDCGIDX_MAP2 		(*(volatile unsigned *)(CMU_BASE+0x3008))	
#define	rDCGPERF_MAP0		(*(volatile unsigned *)(CMU_BASE+0x3020))	
#define	rDCGPERF_MAP1		(*(volatile unsigned *)(CMU_BASE+0x3024))	
#define	rDVCIDX_MAP		    (*(volatile unsigned *)(CMU_BASE+0x3040))	
#define	rFREQ_CPU			(*(volatile unsigned *)(CMU_BASE+0x3060))
#define	rFREQ_DPM			(*(volatile unsigned *)(CMU_BASE+0x3064))
#define	rDVSEMCLK_EN 		(*(volatile unsigned *)(CMU_BASE+0x3080))	
#define	rMAXPERF	 		(*(volatile unsigned *)(CMU_BASE+0x3084))
#if (S5PV210_EVT==0)
#define	rAPLL_CON_L8 		(*(volatile unsigned *)(CMU_BASE+0x3100))	
#define	rAPLL_CON_L7 		(*(volatile unsigned *)(CMU_BASE+0x3104))	
#define	rAPLL_CON_L6 		(*(volatile unsigned *)(CMU_BASE+0x3108))	
#define	rAPLL_CON_L5 		(*(volatile unsigned *)(CMU_BASE+0x310c))	
#define	rAPLL_CON_L4 		(*(volatile unsigned *)(CMU_BASE+0x3110))	
#define	rAPLL_CON_L3 		(*(volatile unsigned *)(CMU_BASE+0x3114))	
#define	rAPLL_CON_L2 		(*(volatile unsigned *)(CMU_BASE+0x3118))	
#define	rAPLL_CON_L1 		(*(volatile unsigned *)(CMU_BASE+0x311c))	
#else
#define	rAPLL_CON0_L8 		(*(volatile unsigned *)(CMU_BASE+0x3100))	
#define	rAPLL_CON0_L7 		(*(volatile unsigned *)(CMU_BASE+0x3104))	
#define	rAPLL_CON0_L6 		(*(volatile unsigned *)(CMU_BASE+0x3108))	
#define	rAPLL_CON0_L5 		(*(volatile unsigned *)(CMU_BASE+0x310c))	
#define	rAPLL_CON0_L4 		(*(volatile unsigned *)(CMU_BASE+0x3110))	
#define	rAPLL_CON0_L3 		(*(volatile unsigned *)(CMU_BASE+0x3114))	
#define	rAPLL_CON0_L2 		(*(volatile unsigned *)(CMU_BASE+0x3118))	
#define	rAPLL_CON0_L1 		(*(volatile unsigned *)(CMU_BASE+0x311c))	
#endif
#define	rCLKDIV_IEM_L8		(*(volatile unsigned *)(CMU_BASE+0x3200))	
#define	rCLKDIV_IEM_L7		(*(volatile unsigned *)(CMU_BASE+0x3204))	
#define	rCLKDIV_IEM_L6		(*(volatile unsigned *)(CMU_BASE+0x3208))	
#define	rCLKDIV_IEM_L5		(*(volatile unsigned *)(CMU_BASE+0x320c))	
#define	rCLKDIV_IEM_L4		(*(volatile unsigned *)(CMU_BASE+0x3210))	
#define	rCLKDIV_IEM_L3		(*(volatile unsigned *)(CMU_BASE+0x3214))	
#define	rCLKDIV_IEM_L2		(*(volatile unsigned *)(CMU_BASE+0x3218))	
#define	rCLKDIV_IEM_L1		(*(volatile unsigned *)(CMU_BASE+0x321c))
#if (S5PV210_EVT>0)
#define	rAPLL_CON1_L8 		(*(volatile unsigned *)(CMU_BASE+0x3300))	
#define	rAPLL_CON2_L7 		(*(volatile unsigned *)(CMU_BASE+0x3304))	
#define	rAPLL_CON3_L6 		(*(volatile unsigned *)(CMU_BASE+0x3308))	
#define	rAPLL_CON4_L5 		(*(volatile unsigned *)(CMU_BASE+0x330c))	
#define	rAPLL_CON5_L4 		(*(volatile unsigned *)(CMU_BASE+0x3310))	
#define	rAPLL_CON6_L3 		(*(volatile unsigned *)(CMU_BASE+0x3314))	
#define	rAPLL_CON7_L2 		(*(volatile unsigned *)(CMU_BASE+0x3318))	
#define	rAPLL_CON8_L1 		(*(volatile unsigned *)(CMU_BASE+0x331c))	
#endif					
	// MISC				
#define	rDMC0_CFG 		    (*(volatile unsigned *)(CMU_BASE+0x6208))
#define	rCAM_MUX_SEL 		(*(volatile unsigned *)(CMU_BASE+0x7000))	
#define	rMIXER_OUT_SEL 	    (*(volatile unsigned *)(CMU_BASE+0x7004))		
#define	rMDNIE_SEL 			(*(volatile unsigned *)(CMU_BASE+0x7008))
#define	rAUDIO_ENDIAN_SEL   (*(volatile unsigned *)(CMU_BASE+0x700C))			
#define	rEMA_CON0 			(*(volatile unsigned *)(CMU_BASE+0x7100))
#define	rEMA_CON1 			(*(volatile unsigned *)(CMU_BASE+0x7104))
#define	rEMA_CON2 			(*(volatile unsigned *)(CMU_BASE+0x7108))
#define	rEMA_CON3 			(*(volatile unsigned *)(CMU_BASE+0x710c))
#define	rEMA_CON4 			(*(volatile unsigned *)(CMU_BASE+0x7110))
#define	rEMA_CON5 			(*(volatile unsigned *)(CMU_BASE+0x7114))
#define	rEMA_CON6 			(*(volatile unsigned *)(CMU_BASE+0x7118))
#define	rMIPI_PHY_CON0 	    (*(volatile unsigned *)(CMU_BASE+0x7200))		
#define	rMIPI_PHY_CON1 	    (*(volatile unsigned *)(CMU_BASE+0x7204))		
#define	rHDMI_PHY_CON0 	    (*(volatile unsigned *)(CMU_BASE+0x7208	)	


#define SetReg32(addr, data)    ((addr) = (data))
#define GetReg32(addr, data)    ((data) = (addr))


//-----------------------------------
// Define DRAM Controller Registers
//-----------------------------------
#define DMC0_BASE    (0xF0000000)
#define DMC1_BASE    (0xF1400000)

#define rDMC0_CON_CONTROL   (*(volatile unsigned *)(DMC0_BASE + 0x00000000))
#define rDMC0_MEM_CONTROL   (*(volatile unsigned *)(DMC0_BASE + 0x00000004))
#define rDMC0_MEM_CONFIG0   (*(volatile unsigned *)(DMC0_BASE + 0x00000008))
#define rDMC0_MEM_CONFIG1   (*(volatile unsigned *)(DMC0_BASE + 0x0000000c))
#define rDMC0_DIRECT_CMD    (*(volatile unsigned *)(DMC0_BASE + 0x00000010))
#define rDMC0_PRECH_CONFIG  (*(volatile unsigned *)(DMC0_BASE + 0x00000014))
#define rDMC0_PHY_CONTROL0  (*(volatile unsigned *)(DMC0_BASE + 0x00000018))
#define rDMC0_PHY_CONTROL1  (*(volatile unsigned *)(DMC0_BASE + 0x0000001c))
#define rDMC0_PHY_CONTROL2  (*(volatile unsigned *)(DMC0_BASE + 0x00000020))
#define rDMC0_PWRDN_CONFIG  (*(volatile unsigned *)(DMC0_BASE + 0x00000028))
#define rDMC0_TIMING_AREF   (*(volatile unsigned *)(DMC0_BASE + 0x00000030))
#define rDMC0_TIMING_ROW    (*(volatile unsigned *)(DMC0_BASE + 0x00000034))
#define rDMC0_TIMING_DATA   (*(volatile unsigned *)(DMC0_BASE + 0x00000038))
#define rDMC0_TIMING_POWER  (*(volatile unsigned *)(DMC0_BASE + 0x0000003c))
#define rDMC0_PHY_STATUS0   (*(volatile unsigned *)(DMC0_BASE + 0x00000040))
#define rDMC0_PHY_STATUS1   (*(volatile unsigned *)(DMC0_BASE + 0x00000044))
#define rDMC0_CHIP0_STATUS  (*(volatile unsigned *)(DMC0_BASE + 0x00000048))
#define rDMC0_CHIP1_STATUS  (*(volatile unsigned *)(DMC0_BASE + 0x0000004c))
#define rDMC0_AREF_STATUS   (*(volatile unsigned *)(DMC0_BASE + 0x00000050))

#define rDMC0_QOS_CONTROL0  (*(volatile unsigned *)(DMC0_BASE + 0x00000060))
#define rDMC0_QOS_CONFIG0   (*(volatile unsigned *)(DMC0_BASE + 0x00000064))
#define rDMC0_QOS_CONTROL1  (*(volatile unsigned *)(DMC0_BASE + 0x00000068))
#define rDMC0_QOS_CONFIG1   (*(volatile unsigned *)(DMC0_BASE + 0x0000006c))
#define rDMC0_QOS_CONTROL2  (*(volatile unsigned *)(DMC0_BASE + 0x00000070))
#define rDMC0_QOS_CONFIG2   (*(volatile unsigned *)(DMC0_BASE + 0x00000074))
#define rDMC0_QOS_CONTROL3  (*(volatile unsigned *)(DMC0_BASE + 0x00000078))
#define rDMC0_QOS_CONFIG3   (*(volatile unsigned *)(DMC0_BASE + 0x0000007c))
#define rDMC0_QOS_CONTROL4  (*(volatile unsigned *)(DMC0_BASE + 0x00000080))
#define rDMC0_QOS_CONFIG4   (*(volatile unsigned *)(DMC0_BASE + 0x00000084))
#define rDMC0_QOS_CONTROL5  (*(volatile unsigned *)(DMC0_BASE + 0x00000088))
#define rDMC0_QOS_CONFIG5   (*(volatile unsigned *)(DMC0_BASE + 0x0000008c))
#define rDMC0_QOS_CONTROL6  (*(volatile unsigned *)(DMC0_BASE + 0x00000090))
#define rDMC0_QOS_CONFIG6   (*(volatile unsigned *)(DMC0_BASE + 0x00000094))
#define rDMC0_QOS_CONTROL7  (*(volatile unsigned *)(DMC0_BASE + 0x00000098))
#define rDMC0_QOS_CONFIG7   (*(volatile unsigned *)(DMC0_BASE + 0x0000009c))
#define rDMC0_QOS_CONTROL8  (*(volatile unsigned *)(DMC0_BASE + 0x000000a0))
#define rDMC0_QOS_CONFIG8   (*(volatile unsigned *)(DMC0_BASE + 0x000000a4))
#define rDMC0_QOS_CONTROL9  (*(volatile unsigned *)(DMC0_BASE + 0x000000a8))
#define rDMC0_QOS_CONFIG9   (*(volatile unsigned *)(DMC0_BASE + 0x000000ac))
#define rDMC0_QOS_CONTROL10 (*(volatile unsigned *)(DMC0_BASE + 0x000000b0))
#define rDMC0_QOS_CONFIG10  (*(volatile unsigned *)(DMC0_BASE + 0x000000b4))
#define rDMC0_QOS_CONTROL11 (*(volatile unsigned *)(DMC0_BASE + 0x000000b8))
#define rDMC0_QOS_CONFIG11  (*(volatile unsigned *)(DMC0_BASE + 0x000000bc))
#define rDMC0_QOS_CONTROL12 (*(volatile unsigned *)(DMC0_BASE + 0x000000c0))
#define rDMC0_QOS_CONFIG12  (*(volatile unsigned *)(DMC0_BASE + 0x000000c4))
#define rDMC0_QOS_CONTROL13 (*(volatile unsigned *)(DMC0_BASE + 0x000000c8))
#define rDMC0_QOS_CONFIG13  (*(volatile unsigned *)(DMC0_BASE + 0x000000cc))
#define rDMC0_QOS_CONTROL14 (*(volatile unsigned *)(DMC0_BASE + 0x000000d0))
#define rDMC0_QOS_CONFIG14  (*(volatile unsigned *)(DMC0_BASE + 0x000000d4))
#define rDMC0_QOS_CONTROL15 (*(volatile unsigned *)(DMC0_BASE + 0x000000d8))
#define rDMC0_QOS_CONFIG15  (*(volatile unsigned *)(DMC0_BASE + 0x000000dc))

#define rDMC1_CON_CONTROL   (*(volatile unsigned *)(DMC1_BASE + 0x00000000))
#define rDMC1_MEM_CONTROL   (*(volatile unsigned *)(DMC1_BASE + 0x00000004))
#define rDMC1_MEM_CONFIG0   (*(volatile unsigned *)(DMC1_BASE + 0x00000008))
#define rDMC1_MEM_CONFIG1   (*(volatile unsigned *)(DMC1_BASE + 0x0000000c))
#define rDMC1_DIRECT_CMD    (*(volatile unsigned *)(DMC1_BASE + 0x00000010))
#define rDMC1_PRECH_CONFIG  (*(volatile unsigned *)(DMC1_BASE + 0x00000014))
#define rDMC1_PHY_CONTROL0  (*(volatile unsigned *)(DMC1_BASE + 0x00000018))
#define rDMC1_PHY_CONTROL1  (*(volatile unsigned *)(DMC1_BASE + 0x0000001c))
#define rDMC1_PHY_CONTROL2  (*(volatile unsigned *)(DMC1_BASE + 0x00000020))
#define rDMC1_PWRDN_CONFIG  (*(volatile unsigned *)(DMC1_BASE + 0x00000028))
#define rDMC1_TIMING_AREF   (*(volatile unsigned *)(DMC1_BASE + 0x00000030))
#define rDMC1_TIMING_ROW    (*(volatile unsigned *)(DMC1_BASE + 0x00000034))
#define rDMC1_TIMING_DATA   (*(volatile unsigned *)(DMC1_BASE + 0x00000038))
#define rDMC1_TIMING_POWER  (*(volatile unsigned *)(DMC1_BASE + 0x0000003c))
#define rDMC1_PHY_STATUS0   (*(volatile unsigned *)(DMC1_BASE + 0x00000040))
#define rDMC1_PHY_STATUS1   (*(volatile unsigned *)(DMC1_BASE + 0x00000044))
#define rDMC1_CHIP0_STATUS  (*(volatile unsigned *)(DMC1_BASE + 0x00000048))
#define rDMC1_CHIP1_STATUS  (*(volatile unsigned *)(DMC1_BASE + 0x0000004c))
#define rDMC1_AREF_STATUS   (*(volatile unsigned *)(DMC1_BASE + 0x00000050))

#define rDMC1_QOS_CONTROL0  (*(volatile unsigned *)(DMC1_BASE + 0x00000060))
#define rDMC1_QOS_CONFIG0   (*(volatile unsigned *)(DMC1_BASE + 0x00000064))
#define rDMC1_QOS_CONTROL1  (*(volatile unsigned *)(DMC1_BASE + 0x00000068))
#define rDMC1_QOS_CONFIG1   (*(volatile unsigned *)(DMC1_BASE + 0x0000006c))
#define rDMC1_QOS_CONTROL2  (*(volatile unsigned *)(DMC1_BASE + 0x00000070))
#define rDMC1_QOS_CONFIG2   (*(volatile unsigned *)(DMC1_BASE + 0x00000074))
#define rDMC1_QOS_CONTROL3  (*(volatile unsigned *)(DMC1_BASE + 0x00000078))
#define rDMC1_QOS_CONFIG3   (*(volatile unsigned *)(DMC1_BASE + 0x0000007c))
#define rDMC1_QOS_CONTROL4  (*(volatile unsigned *)(DMC1_BASE + 0x00000080))
#define rDMC1_QOS_CONFIG4   (*(volatile unsigned *)(DMC1_BASE + 0x00000084))
#define rDMC1_QOS_CONTROL5  (*(volatile unsigned *)(DMC1_BASE + 0x00000088))
#define rDMC1_QOS_CONFIG5   (*(volatile unsigned *)(DMC1_BASE + 0x0000008c))
#define rDMC1_QOS_CONTROL6  (*(volatile unsigned *)(DMC1_BASE + 0x00000090))
#define rDMC1_QOS_CONFIG6   (*(volatile unsigned *)(DMC1_BASE + 0x00000094))
#define rDMC1_QOS_CONTROL7  (*(volatile unsigned *)(DMC1_BASE + 0x00000098))
#define rDMC1_QOS_CONFIG7   (*(volatile unsigned *)(DMC1_BASE + 0x0000009c))
#define rDMC1_QOS_CONTROL8  (*(volatile unsigned *)(DMC1_BASE + 0x000000a0))
#define rDMC1_QOS_CONFIG8   (*(volatile unsigned *)(DMC1_BASE + 0x000000a4))
#define rDMC1_QOS_CONTROL9  (*(volatile unsigned *)(DMC1_BASE + 0x000000a8))
#define rDMC1_QOS_CONFIG9   (*(volatile unsigned *)(DMC1_BASE + 0x000000ac))
#define rDMC1_QOS_CONTROL10 (*(volatile unsigned *)(DMC1_BASE + 0x000000b0))
#define rDMC1_QOS_CONFIG10  (*(volatile unsigned *)(DMC1_BASE + 0x000000b4))
#define rDMC1_QOS_CONTROL11 (*(volatile unsigned *)(DMC1_BASE + 0x000000b8))
#define rDMC1_QOS_CONFIG11  (*(volatile unsigned *)(DMC1_BASE + 0x000000bc))
#define rDMC1_QOS_CONTROL12 (*(volatile unsigned *)(DMC1_BASE + 0x000000c0))
#define rDMC1_QOS_CONFIG12  (*(volatile unsigned *)(DMC1_BASE + 0x000000c4))
#define rDMC1_QOS_CONTROL13 (*(volatile unsigned *)(DMC1_BASE + 0x000000c8))
#define rDMC1_QOS_CONFIG13  (*(volatile unsigned *)(DMC1_BASE + 0x000000cc))
#define rDMC1_QOS_CONTROL14 (*(volatile unsigned *)(DMC1_BASE + 0x000000d0))
#define rDMC1_QOS_CONFIG14  (*(volatile unsigned *)(DMC1_BASE + 0x000000d4))
#define rDMC1_QOS_CONTROL15 (*(volatile unsigned *)(DMC1_BASE + 0x000000d8))
#define rDMC1_QOS_CONFIG15  (*(volatile unsigned *)(DMC1_BASE + 0x000000dc))


#ifdef __cplusplus
}
#endif
#endif  //__V210ADDR_H___

