//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: register_map.h
//
//  This header file defines the S5PV210 processor.
//
//  The S5PV210 is a System on Chip (SoC) part consisting of an ARM Cortex-A8 core.
//  This header file is comprised of component header files that define the
//  register layout of each component.
//
//------------------------------------------------------------------------------
#ifndef __S5PV210_H
#define __S5PV210_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------

// Base Definitions
#include "base_regs.h"

// SoC Components
#include "ac97_reg.h"
#include "adc_reg.h"
#include "camif_reg.h"
#include "cfcon_reg.h"
#include "displaycon_reg.h"
#include "dma_reg.h"
#include "dramcon_reg.h"
#include "gpio_reg.h"
#include "gpio_lib.h"
#include "sdmmc_reg.h"
#include "iic_reg.h"
#include "iis_reg.h"
#include "intr_reg.h"
#include "keypad_reg.h"
#include "msmif_reg.h"
#include "nand_reg.h"
#include "rotator_reg.h"
#include "systimer_reg.h"
#include "pwm_reg.h"
#include "rtc_reg.h"
#include "spi_reg.h"
#include "sromcon_reg.h"
#include "syscon_reg.h"
#include "system.h"
#include "uart_reg.h"
#include "usbotg_reg.h"
#include "wdog_reg.h"
#include "SPDIF_reg.h"
#include "chipid_reg.h"
#include "onenand_reg.h"
#include "mfc_reg.h"
#include "mie_reg.h"
#include "USBHost_reg.h"


//#include "security_reg.h"
//#include "g2d_reg.h"
//#include "rotator_reg.h"
//#include "mfc_reg.h"
//#include "jpeg_reg.h"
//#include "hostif_reg.h"
//#include "usbhost_reg.h"
//#include "mipiif_reg.h"
//#include "iisbus_reg.h"
//#include "pcm_reg.h"
//#include "irda_reg.h"
//#include "keypad_reg.h"
//#include "mdpif_reg.h"

//------------------------------------------------------------------------------

#if __cplusplus
}
#endif

#endif
