//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//

//
// This module defines the platform power management customizations.
//

#ifndef _PM_PLATFORM_H_
#define _PM_PLATFORM_H_

#include <nkintr.h>

//Block Power Domain
typedef enum
{
    BLKPWR_DOMAIN_IROM,
    BLKPWR_DOMAIN_AUDIOSS,
    BLKPWR_DOMAIN_CAM,
    BLKPWR_DOMAIN_TV,       // NORMAL_CFG
    BLKPWR_DOMAIN_LCD,      // NORMAL_CFG
    BLKPWR_DOMAIN_G3D,      // NORMAL_CFG
    BLKPWR_DOMAIN_MFC       // NORMAL_CFG
} BLKPWR_DOMAIN;

//--------------------------------------------------------------------------------------
//
// Power Controllable IP List (Block Power will be turn off, when all IPs in the power domain is turned off)
//
typedef enum
{
    PWR_IP_IROM=0,      // IROM
    PWR_IP_CAMIF,       // Domain CAM Sub system
    PWR_IP_CAMIF1,      // Domain CAM Sub system
    PWR_IP_CAMIF2,      // Domain CAM Sub system
    PWR_IP_MIPI_CSI,    // Domain CAM Sub system
    PWR_IP_JPEG,        // Domain CAM Sub system
    PWR_IP_ROTATOR,     // Domain CAM Sub system
    PWR_IP_IPC,         // Domain CAM Sub system   
    PWR_IP_VP,          // Domain TV Sub system
    PWR_IP_MIXER,       // Domain TV Sub system
    PWR_IP_TVENC,       // Domain TV Sub system
    PWR_IP_HDMI,        // Domain TV Sub system
    PWR_IP_DISPCON,     // Domain LCD Sub system
    PWR_IP_MIE,         // Domain LCD Sub system
    PWR_IP_MIPI_DSI,    // Domain LCD Sub system
    PWR_IP_G2D,         // Domain LCD Sub system - only EVT1
    PWR_IP_G3D,         // Domain G3D
    PWR_IP_MFC,         // Domain MFC
    PWR_IP_AUDIOSS,     // Domain AudioSS
    PWR_IP_MIE_SLEEP,   // MIE Sleep
    PWR_IP_HDMI_PHY,    // MIPI PHY
    PWR_IP_USB_PHY0,    // USB_PHY0 OTG
    PWR_IP_USB_PHY1,    // USB_PHY1 HOST
    PWR_IP_DAC,         // DAC
    PWR_IP_MIPI_DSI_DPHY, // MIPI_DPHY for DSI
    PWR_IP_MIPI_CSI_DPHY, // MIPI_DPHY for CSI
    PWR_IP_BATT_ADC,      // ADC
    PWR_IP_TS_ADC,
    PWR_IP_MAX
} PWR_IP_LIST;

//--------------------------------------------------------------------------------------
//
// CLock Gating Controllable IP List 
//
typedef enum
{
    CLK_IP0_CSIS=0,
    CLK_IP0_IPC,
    CLK_IP0_ROTATOR,
    CLK_IP0_JPEG,    
    CLK_IP0_FIMC2,
    CLK_IP0_FIMC1,
    CLK_IP0_FIMC0,   
    CLK_IP0_MFC,
    CLK_IP0_G2D,
    CLK_IP0_G3D,
    CLK_IP0_IMEM,   
    CLK_IP0_PDMA1,
    CLK_IP0_PDMA0,
    CLK_IP0_MDMA,   
    CLK_IP0_DMC1,
    CLK_IP0_DMC0,    //14

    CLK_IP1_NFCON,   //15
    CLK_IP1_SROMC,
    CLK_IP1_CFCON,
    CLK_IP1_ONENAND,   
    CLK_IP1_USBHOST,
    CLK_IP1_USBOTG,
    CLK_IP1_HDMI,   
    CLK_IP1_TVENC,
    CLK_IP1_MIXER,
    CLK_IP1_VP,   
    CLK_IP1_DSIM,
    CLK_IP1_MIE,
    CLK_IP1_FIMD,    //27

    CLK_IP2_TZIC3,   //28
    CLK_IP2_TZIC2,
    CLK_IP2_TZIC1,   
    CLK_IP2_TZIC0,
    CLK_IP2_VIC3,
    CLK_IP2_VIC2,   
    CLK_IP2_VIC1,
    CLK_IP2_VIC0,
    CLK_IP2_TSI,   
    CLK_IP2_HSMMC3,
    CLK_IP2_HSMMC2,
    CLK_IP2_HSMMC1,  
    CLK_IP2_HSMMC0,
    CLK_IP2_SECJTAG,
    CLK_IP2_HOSTIF,   
    CLK_IP2_MODEM,
    CLK_IP2_CORESIGHT,
    CLK_IP2_SDM,
    CLK_IP2_SECSS,    //46
    
    CLK_IP3_PCM2,     //47
    CLK_IP3_PCM1,   
    CLK_IP3_PCM0,
    CLK_IP3_SYSCON,
    CLK_IP3_GPIO,
    CLK_IP3_TSADC,
    CLK_IP3_PWM,   
    CLK_IP3_WDT,
    CLK_IP3_KEYIF,   
    CLK_IP3_UART3,
    CLK_IP3_UART2,
    CLK_IP3_UART1,
    CLK_IP3_UART0,
    CLK_IP3_SYSTIMER,
    CLK_IP3_RTC,     
    CLK_IP3_SPI2,   
    CLK_IP3_SPI1,
    CLK_IP3_SPI0,   
    CLK_IP3_I2C_HDMI_PHY,
    CLK_IP3_I2C_HDMI_DDC,
    CLK_IP3_I2C2,
    CLK_IP3_I2C1,
    CLK_IP3_I2C0,
    CLK_IP3_I2S2, 
    CLK_IP3_I2S1,   
    CLK_IP3_I2S0,
    CLK_IP3_AC97,   
    CLK_IP3_SPDIF,  //74
    
    CLK_IP4_TZPC3,  //75
    CLK_IP4_TZPC2,
    CLK_IP4_TZPC1,
    CLK_IP4_TZPC0,
    CLK_IP4_SECKEY,
    CLK_IP4_IEM_APC,
    CLK_IP4_IEM_IEC,
    CLK_IP4_CHIP_ID,
    CLK_IP_MAX       //84
} CLK_IP_LIST;



//
// Power/Clock Gating Control Driver I/O Control
//
#define FILE_DEVICE_PWRCON        (FILE_DEVICE_CONTROLLER)

#define IOCTL_PWRCON_SET_POWER_ON    \
    CTL_CODE(FILE_DEVICE_PWRCON, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_PWRCON_SET_POWER_OFF    \
    CTL_CODE(FILE_DEVICE_PWRCON, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_PWRCON_SET_SYSTEM_LEVEL   \
    CTL_CODE(FILE_DEVICE_PWRCON, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_PWRCON_QUERY_SYSTEM_LEVEL   \
    CTL_CODE(FILE_DEVICE_PWRCON, 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_PWRCON_PROFILE_DVFS   \
    CTL_CODE(FILE_DEVICE_PWRCON, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
    
#define IOCTL_PWRCON_SET_CLOCK_ON   \
    CTL_CODE(FILE_DEVICE_PWRCON, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_PWRCON_SET_CLOCK_OFF   \
    CTL_CODE(FILE_DEVICE_PWRCON, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)    

#ifdef BSP_USEDVFS
#define IOCTL_DVFS_SET_LEVEL_FIX    \
    CTL_CODE(FILE_DEVICE_PWRCON, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DVFS_CLEAR_LEVEL_FIX    \
    CTL_CODE(FILE_DEVICE_PWRCON, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

typedef enum
{
    HYPER_PERF =0,        // L0 (1GHz)
    HIGH_PERF,            // L0 ~ L1
    HIGH_NORM_PERF,       // L0 ~ L2
    NORM_PERF,            // L1 ~ L2
    LOW_NORM_PERF,        // L1 ~ L3
    LOW_PERF,             // L2 ~ L3
    SLOW_PERF,            // L3
    PERF_MAX
} PROFILE_LIST;

#define IOCTL_DVFS_SET_PROFILE    \
    CTL_CODE(FILE_DEVICE_PWRCON, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DVFS_CLEAR_PROFILE    \
    CTL_CODE(FILE_DEVICE_PWRCON, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_DVFS_GET_STATUS    \
    CTL_CODE(FILE_DEVICE_PWRCON, 11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#endif // BSP_USEDVFS

//--------------------------------------------------------------------------------------

//
// S5PV210 Wakeup Source Definition
//
typedef enum
{
    OEMWAKE_EINT0 = SYSWAKE_OEMBASE, // in "nkintr.h"
    OEMWAKE_EINT1,
    OEMWAKE_EINT2,
    OEMWAKE_EINT3,
    OEMWAKE_EINT4,
    OEMWAKE_EINT5,
    OEMWAKE_EINT6,
    OEMWAKE_EINT7,
    OEMWAKE_EINT8,
    OEMWAKE_EINT9,
    OEMWAKE_EINT10,
    OEMWAKE_EINT11,
    OEMWAKE_EINT12,
    OEMWAKE_EINT13,
    OEMWAKE_EINT14,
    OEMWAKE_EINT15,
    OEMWAKE_EINT16,
    OEMWAKE_EINT17,
    OEMWAKE_EINT18,
    OEMWAKE_EINT19,
    OEMWAKE_EINT20,
    OEMWAKE_EINT21,
    OEMWAKE_EINT22,
    OEMWAKE_EINT23,
    OEMWAKE_EINT24,
    OEMWAKE_EINT25,
    OEMWAKE_EINT26,
    OEMWAKE_EINT27,
    OEMWAKE_RTC_ALARM,
    OEMWAKE_RTC_TICK,
    OEMWAKE_TS,         // Stop mode only
    OEMWAKE_KEYPAD,
    OEMWAKE_MSM,
    OEMWAKE_MMC0,    // Stop mode only
    OEMWAKE_MMC1,    // Stop mode only
    OEMWAKE_MMC2,       // Stop mode only
    OEMWAKE_MMC3,       // Stop mode only
    OEMWAKE_I2S,        // Deep Idle Only
    OEMWAKE_ST,         // Stop mode only
    OEMWAKE_HDMICEC,
    OEMWAKE_BYPASS
} OEMWAKE_SOURCE;

//--------------------------------------------------------------------------------------

//
// System Active Level for Dynamic Voltage and Frequency Scaling
//
#ifdef BSP_USEDVFS
typedef enum
{
    SYS_L0 = 0,		// 1000:200:166:133
    SYS_L1,         // 3. 800:200:166:133
    SYS_L2,         // 4. 400:200:166:133
    SYS_L3,         // 5. 100:100:83:66

    // unused, reserved
    SYS_L4,        
    SYS_L5,
    SYS_L6,
    SYS_L7,

    SYS_LEVEL_MAX
} SYSTEM_ACTIVE_LEVEL;

#define ACTIVE_MAXLEVEL SYS_L0
#define ACTIVE_MINLEVEL SYS_L3
#endif

void SetMaxLevel(void);

//--------------------------------------------------------------------------------------

//#define POWER_CAP_PARENT            0x00000001      // defined in pm.h
//
// These Flags define the meaning of POWER_CAPABILITIES.Flags field.
// They define the unit of measure and prefix reported in the Power field.
//
#define POWER_CAP_UNIT_WATTS        0x00000010
#define POWER_CAP_UNIT_AMPS        0x00000020

#define POWER_CAP_PREFIX_MILLI    0x00000040
#define POWER_CAP_PREFIX_MICRO    0x00000080
#define POWER_CAP_PREFIX_NAN0        0x00000100

//--------------------------------------------------------------------------------------

#endif    // _PM_PLATFORM_H_

