//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: onenand_reg.h
//
//  Defines the OneNAND Controller register layout and associated types and constants.
//
#ifndef __S5PV210_ONENAND_H
#define __S5PV210_ONENAND_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//
//  Type:  ONENANDCON_REG
//
//  Defines the OneNAND control register layout. This register bank is 
//  located by the constant BASE_REG_XX_ONENANDCON in the configuration file
//  base_reg_cfg.h.
//
// OneNAND Controller Base Address = 0xE7100000

#define ONDXL_BASE (0xB9000000)  //(0xB8F00000)

typedef struct
{
    UINT32 MEM_CFG; // 0x000
    UINT32 pad1[3];
    UINT32 BURST_LEN; // 0x010
    UINT32 pad2[3];
    UINT32 MEM_RESET_; // 0x020
    UINT32 pad3[3];
    UINT32 INT_ERR_STAT; // 0x030
    UINT32 pad4[3];
    UINT32 INT_ERR_MASK; // 0x040
    UINT32 pad5[3];
    UINT32 INT_ERR_ACK; // 0x050
    UINT32 pad6[3];
    UINT32 ECC_ERR_STAT_1; // 0x060
    UINT32 pad7[3];
    UINT32 MANUFACT_ID; // 0x070
    UINT32 pad8[3];
    UINT32 DEVICE_ID; // 0x080
    UINT32 pad9[3];
    UINT32 DATA_BUF_SIZE; // 0x090
    UINT32 pad10[3];
    UINT32 BOOT_BUF_SIZE	; // 0x0A0
    UINT32 pad11[3];
    UINT32 BUF_AMOUNT; // 0x0B0
    UINT32 pad12[3];
    UINT32 TECH; // 0x0C0
    UINT32 pad13[3];
    UINT32 FBA_WIDTH; // 0x0D0
    UINT32 pad14[3];
    UINT32 FPA_WIDTH; // 0x0E0
    UINT32 pad15[3];
    UINT32 FSA_WIDTH; // 0x0F0
    UINT32 pad16[3];
    UINT32 REVISION; // 0x100
    UINT32 pad17[3];
    UINT32 pad18[4];
    UINT32 pad19[4];
    UINT32 SYNC_MODE; // 0x130
    UINT32 pad20[3];
    UINT32 TRANS_SPARE; // 0x140
    UINT32 pad21[3];
    UINT32 pad22[4];
    UINT32 pad23[4];
    UINT32 PAGE_CNT; // 0x170
    UINT32 pad24[3];
    UINT32 ERR_PAGE_ADDR; // 0x180
    UINT32 pad25[3];
    UINT32 BURST_RD_LAT; // 0x190
    UINT32 pad26[3];
    UINT32 INT_PIN_ENABLE; // 0x1A0
    UINT32 pad27[3];
    UINT32 INT_MON_CYC; // 0x1B0
    UINT32 pad28[3];
    UINT32 ACC_CLOCK; // 0x1C0
    UINT32 pad29[3];
    UINT32 pad30[4];
    UINT32 ERR_BLK_ADDR; // 0x1E0
    UINT32 pad31[3];
    UINT32 FLASH_VER_ID; // 0x1F0
    UINT32 pad32[11];           // 0x1F4~0x300
    UINT32 BANK_EN;     // 0x220
    UINT32 pad33[15];
    UINT32 WTCHDG_RST_L; // 0x260
    UINT32 pad34[3];
    UINT32 WTCHDG_RST_H; // 0x270
    UINT32 pad35[3];
    UINT32 SYNC_WRITE; // 0x280
    UINT32 pad36[3];
    UINT32 CACHE_READ; // 0x290
    UINT32 pad37[3];
    UINT32 COLD_RST_DLY; // 0x2A0
    UINT32 pad38[3];
    UINT32 DDP_DEVICE; // 0x2B0
    UINT32 pad39[3];
    UINT32 MULTI_PLANE; // 0x2C0
    UINT32 pad40[3];
    UINT32 MEM_CNT; // 0x2D0
    UINT32 pad41[3];
    UINT32 TRANS_MODE; // 0x2E0
    UINT32 pad42[3];
    UINT32 DEV_STAT; // 0x2F0
    UINT32 pad43[3];
    UINT32 ECC_ERR_STAT_2; // 0x300
    UINT32 pad44[3];
    UINT32 ECC_ERR_STAT_3; // 0x310
    UINT32 pad45[3];
    UINT32 ECC_ERR_STAT_4; // 0x320
    UINT32 pad46[3];
    UINT32 EFCT_BUF_CNT; // 0x330
    UINT32 pad47[3];
    UINT32 DEV_PAGE_SIZE; // 0x340
    UINT32 pad48[3];
    UINT32 SUPERLOAD_EN;  // 0x350
    UINT32 pad49[3];
    UINT32 CACHE_PRG_EN; // 0x360
    UINT32 pad50[3];
    UINT32 SINGLE_PAGE_BUF; // 0x370
    UINT32 pad51[3];
    UINT32 OFFSET_ADDR; // 0x380
    UINT32 pad52[3];
    UINT32 INT_MON_STATUS; // 0x390
} ONENANDCON_REG, *PONENANDCON_REG;

typedef enum 
{
	ONDC_CTRL_REG		     = (ONDXL_BASE + 0x0100),
	ONDC_CTRL_CMD_REG		 = (ONDXL_BASE + 0x0104),	
	ONDC_ASYNC_TIME_CTRL     = (ONDXL_BASE + 0x0108),
	ONDC_STATUS_REG          = (ONDXL_BASE + 0x010C),
	ONDC_DMA_SRC_ADDR        = (ONDXL_BASE + 0x0400),
	ONDC_DMA_SRC_CFG         = (ONDXL_BASE + 0x0404),
	ONDC_DMA_DST_ADDR        = (ONDXL_BASE + 0x0408),
	ONDC_DMA_DST_CFG         = (ONDXL_BASE + 0x040C),
	ONDC_DMA_TRANS_SIZE      = (ONDXL_BASE + 0x0414),
	ONDC_DMA_TRANS_CMD       = (ONDXL_BASE + 0x0418),
	ONDC_DMA_TRANS_STATUS    = (ONDXL_BASE + 0x041C),
	ONDC_DMA_TRANS_DIR       = (ONDXL_BASE + 0x0420),
	ONDC_SQC_SAO             = (ONDXL_BASE + 0x0600),
	ONDC_SQC_CMD             = (ONDXL_BASE + 0x0608),
	ONDC_SQC_STATUS          = (ONDXL_BASE + 0x060C),
	ONDC_SQC_CAO             = (ONDXL_BASE + 0x0610),
	ONDC_SQC_REG_CTRL        = (ONDXL_BASE + 0x0614),
	ONDC_SQC_REG_VAL         = (ONDXL_BASE + 0x0618),
	ONDC_SQC_BRPAO_0         = (ONDXL_BASE + 0x0620),
	ONDC_SQC_BRPAO_1         = (ONDXL_BASE + 0x0624),
	ONDC_INTC_SQC_CLR        = (ONDXL_BASE + 0x1000),
	ONDC_INTC_DMA_CLR        = (ONDXL_BASE + 0x1004),
	ONDC_INTC_OND_CLR        = (ONDXL_BASE + 0x1008),
	ONDC_INTC_SQC_MASK       = (ONDXL_BASE + 0x1020),
	ONDC_INTC_DMA_MASK       = (ONDXL_BASE + 0x1024),
	ONDC_INTC_OND_MASK       = (ONDXL_BASE + 0x1028),
	ONDC_INTC_SQC_PEND       = (ONDXL_BASE + 0x1040),
	ONDC_INTC_DMA_PEND       = (ONDXL_BASE + 0x1044),
	ONDC_INTC_OND_PEND       = (ONDXL_BASE + 0x1048),
	ONDC_INTC_SQC_STATUS     = (ONDXL_BASE + 0x1060),
	ONDC_INTC_DMA_STATUS     = (ONDXL_BASE + 0x1064),
	ONDC_INTC_OND_STATUS     = (ONDXL_BASE + 0x1068),
	
}ONDC_REGS;

//------------------------------------------------------------------------------

#if __cplusplus
}
#endif

#endif 
