//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
--*/
/**
*    @file     mipicsi_reg.h
*    @brief    Defines the MIPI-CSI Interface Controller's register layout and definitions.
*    
*    @note This version is made for S5PV210
*    @note IP version is v1.0
*/

#define DEF_REG_BITINFO(BITNAME, BITPOSITION, BITCOUNT, BITWIDTH) \
    enum BITDEF_##BITNAME{      \
        BP_##BITNAME = BITPOSITION,    \
        BS_##BITNAME = (1 << BP_##BITNAME),   \
        BC_##BITNAME = BITCOUNT,    \
        BW_##BITNAME = BITWIDTH,    \
        BM_##BITNAME = (BW_##BITNAME << BP_##BITNAME) \
    };

#ifndef __MIPICSI_REG_H__
#define __MIPICSI_REG_H__

#ifdef __cplusplus
extern "C"
{
#endif

// Bit Definition, BitPosition, BitStart, BitCount, BitWidth, BitMask

// CSIS_CONTROL, R/W


#define BP_CSIS_DPDNSWAP_CLK    (31)        // 0 = default ,  1 : swapping
#define BP_CSIS_DPDNSWAP_DAT    (30)        // 0 = default ,  1 : swapping
#define BP_CSIS_PARALLEL        (20)        // 0 = 24bit data , 1 = 32bit data align
#define BP_CSIS_UPDATE_SHADOW   (16)        // 0 = default ,  1 = update the shodow register
#define BP_CSIS_WCLK_SRC        (8)         // 0 = PCLK , 1 = EXTCLK
#define BP_CSIS_SWRST           (4)         // 0 = No Reset, 1 = Reset
#define BP_CSIS_ENABLE          (0)         // 0 = Off, 1 = On

#define BS_CSIS_DPDNSWAP_CLK    (1<<BP_CSIS_DPDNSWAP_CLK)
#define BS_CSIS_DPDNSWAP_DAT    (1<<BP_CSIS_DPDNSWAP_DAT)
#define BS_CSIS_PARALLEL        (1<<BP_CSIS_PARALLEL)
#define BS_CSIS_UPDATE_SHADOW   (1<<BP_CSIS_UPDATE_SHADOW)
#define BS_CSIS_WCLK_SRC        (1<<BP_CSIS_WCLK_SRC)
#define BS_CSIS_SWRST       (1<<BP_CSIS_SWRST)
#define BS_CSIS_ENABLE      (1<<BP_CSIS_ENABLE)

#define BC_CSIS_DPDNSWAP_CLK    (1)
#define BC_CSIS_DPDNSWAP_DAT    (1)        
#define BC_CSIS_PARALLEL        (1)        
#define BC_CSIS_UPDATE_SHADOW   (1)        
#define BC_CSIS_WCLK_SRC        (1)         
#define BC_CSIS_SWRST           (1)
#define BC_CSIS_ENABLE          (1)

#define BW_CSIS_DPDNSWAP_CLK    (0x1)
#define BW_CSIS_DPDNSWAP_DAT    (0x1)        
#define BW_CSIS_PARALLEL        (0x1)        
#define BW_CSIS_UPDATE_SHADOW   (0x1)        
#define BW_CSIS_WCLK_SRC        (0x1)         
#define BW_CSIS_SWRST           (0x1)
#define BW_CSIS_ENABLE          (0x1)

#define BM_CSIS_DPDNSWAP_CLK    (BW_CSIS_DPDNSWAP_CLK<<BP_CSIS_DPDNSWAP_CLK)
#define BM_CSIS_DPDNSWAP_DAT    (BW_CSIS_DPDNSWAP_DAT<<BP_CSIS_DPDNSWAP_DAT)
#define BM_CSIS_PARALLEL        (BW_CSIS_PARALLEL   <<BP_CSIS_PARALLEL)
#define BM_CSIS_UPDATE_SHADOW   (BW_CSIS_UPDATE_SHADOW<<BP_CSIS_UPDATE_SHADOW)
#define BM_CSIS_WCLK_SRC        (BW_CSIS_WCLK_SRC   <<BP_CSIS_WCLK_SRC)
#define BM_CSIS_SWRST           (BW_CSIS_SWRST      <<BP_CSIS_SWRST)
#define BM_CSIS_ENABLE          (BW_CSIS_ENABLE     <<BP_CSIS_ENABLE)


// CSIS_DPHYCTRL, R/W

#define BP_CSIS_DPHYON      (0)         // 0 = Disable, 1 = Enable
#define BS_CSIS_DPHYON      (1<<BP_CSIS_DPHYON)
#define BC_CSIS_DPHYON      (1)
#define BW_CSIS_DPHYON      (0x1)
#define BM_CSIS_DPHYON      (BW_CSIS_DPHYON<<BP_CSIS_DPHYON)


// CSIS_CONFIG, R/W
//DEF_REG_BITINFO(CSIS_NUMOFDATLANE, 0, 2, 0x3);


#define BP_CSIS_HSYNC_LINTV     (26)
#define BP_CSIS_VSYNC_SINTV     (20)
#define BP_CSIS_VSYNC_EINTV     (8)
#define BP_CSIS_DATA_FORMAT     (2)
#define BP_CSIS_NUMOFDATLANE    (0)     // 00 = 1 Data Lane, 01 = 2 Data Lane, 10~11 = Reserved


#define BS_CSIS_HSYNC_LINTV     (1<<BP_CSIS_HSYNC_LINTV)
#define BS_CSIS_VSYNC_SINTV     (1<<BP_CSIS_VSYNC_SINTV)
#define BS_CSIS_VSYNC_EINTV     (1<<BP_CSIS_VSYNC_EINTV)
#define BS_CSIS_DATA_FORMAT     (1<<BP_CSIS_DATA_FORMAT)
#define BS_CSIS_NUMOFDATLANE    (1<<BP_CSIS_NUMOFDATLANE)


#define BC_CSIS_HSYNC_LINTV     (6)
#define BC_CSIS_VSYNC_SINTV     (6)
#define BC_CSIS_VSYNC_EINTV     (12)
#define BC_CSIS_DATA_FORMAT     (6)
#define BC_CSIS_NUMOFDATLANE    (2)

#define BW_CSIS_HSYNC_LINTV     (0x3f)
#define BW_CSIS_VSYNC_SINTV     (0x3f)
#define BW_CSIS_VSYNC_EINTV     (0xfff)
#define BW_CSIS_DATA_FORMAT     (0x3f)
#define BW_CSIS_NUMOFDATLANE    (0x3)

#define BM_CSIS_HSYNC_LINTV     (BW_CSIS_HSYNC_LINTV<<BP_CSIS_HSYNC_LINTV)
#define BM_CSIS_VSYNC_SINTV     (BW_CSIS_VSYNC_SINTV<<BP_CSIS_VSYNC_SINTV)
#define BM_CSIS_VSYNC_EINTV     (BW_CSIS_VSYNC_EINTV<<BP_CSIS_VSYNC_EINTV)
#define BM_CSIS_DATA_FORMAT     (BW_CSIS_DATA_FORMAT<<BP_CSIS_DATA_FORMAT)
#define BM_CSIS_NUMOFDATLANE    (BW_CSIS_NUMOFDATLANE<<BP_CSIS_NUMOFDATLANE)


// CSIS_DPHYSTS, R
//DEF_REG_BITINFO(CSIS_STOPSTATEDAT, 4, 2, 0x3);
//DEF_REG_BITINFO(CSIS_STOPSTATECLK, 0, 1, 0x1);


#define BP_CSIS_ULPSDAT         (8)
#define BP_CSIS_STOPSTATEDAT    (4)
#define BP_CSIS_ULPSCLK         (1)
#define BP_CSIS_STOPSTATECLK    (0)

#define BS_CSIS_ULPSDAT         (1<<BP_CSIS_ULPSDAT)
#define BS_CSIS_STOPSTATEDAT    (1<<BP_CSIS_STOPSTATEDAT)
#define BS_CSIS_ULPSCLK         (1<<BP_CSIS_ULPSCLK)
#define BS_CSIS_STOPSTATECLK    (1<<BP_CSIS_STOPSTATECLK)

#define BC_CSIS_ULPSDAT         (4)
#define BC_CSIS_STOPSTATEDAT    (4)
#define BC_CSIS_ULPSCLK         (1)
#define BC_CSIS_STOPSTATECLK    (1)

#define BW_CSIS_ULPSDAT         (0xf)
#define BW_CSIS_STOPSTATEDAT    (0xf)
#define BW_CSIS_ULPSCLK         (0x1)
#define BW_CSIS_STOPSTATECLK    (0x1)

#define BM_CSIS_ULPSDAT         (BW_CSIS_ULPSDAT<<BP_CSIS_ULPSDAT)
#define BM_CSIS_STOPSTATEDAT    (BW_CSIS_STOPSTATEDAT<<BP_CSIS_STOPSTATEDAT)
#define BM_CSIS_ULPSCLK         (BW_CSIS_ULPSCLK<<BP_CSIS_ULPSCLK)
#define BM_CSIS_STOPSTATECLK    (BW_CSIS_STOPSTATECLK<<BP_CSIS_STOPSTATECLK)


// CSIS_INTMSK
//DEF_REG_BITINFO(CSIS_MSK_EVENBEFORE, 31, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_EVENAFTER, 30, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ODDBEFORE, 29, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ODDAFTER, 28, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ERR_SOT_HS, 12, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ERR_ESC, 8, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ERR_CTRL, 4, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ERR_ECC, 2, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ERR_CRC, 1, 1, 0x1);
//DEF_REG_BITINFO(CSIS_MSK_ERR_ID, 0, 1, 0x1);

#define BP_CSIS_MSK_EVENBEFORE  (31)    // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_EVENAFTER   (30)    // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_ODDBEFORE   (29)    // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_ODDAFTER    (28)    // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_ERR_SOT_HS  (12)    // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_ERR_CTRL    (3)     // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_ERR_ECC     (2)     // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_ERR_CRC     (1)     // 0 = Disable Interrupt, 1 = Enable Interrupt
#define BP_CSIS_MSK_ERR_ID      (0)     // 0 = Disable Interrupt, 1 = Enable Interrupt

#define BS_CSIS_MSK_EVENBEFORE  (1<<BP_CSIS_MSK_EVENBEFORE)
#define BS_CSIS_MSK_EVENAFTER   (1<<BP_CSIS_MSK_EVENAFTER)
#define BS_CSIS_MSK_ODDBEFORE   (1<<BP_CSIS_MSK_ODDBEFORE)
#define BS_CSIS_MSK_ODDAFTER    (1<<BP_CSIS_MSK_ODDAFTER)
#define BS_CSIS_MSK_ERR_SOT_HS  (1<<BP_CSIS_MSK_ERR_SOT_HS)
#define BS_CSIS_MSK_ERR_CTRL    (1<<BP_CSIS_MSK_ERR_CTRL)
#define BS_CSIS_MSK_ERR_ECC     (1<<BP_CSIS_MSK_ERR_ECC)
#define BS_CSIS_MSK_ERR_CRC     (1<<BP_CSIS_MSK_ERR_CRC)
#define BS_CSIS_MSK_ERR_ID      (1<<BP_CSIS_MSK_ERR_ID)

#define BC_CSIS_MSK_EVENBEFORE  (1)
#define BC_CSIS_MSK_EVENAFTER   (1)
#define BC_CSIS_MSK_ODDBEFORE   (1)
#define BC_CSIS_MSK_ODDAFTER    (1)
#define BC_CSIS_MSK_ERR_SOT_HS  (1)
#define BC_CSIS_MSK_ERR_CTRL    (1)
#define BC_CSIS_MSK_ERR_ECC     (1)
#define BC_CSIS_MSK_ERR_CRC     (1)
#define BC_CSIS_MSK_ERR_ID      (1)

#define BW_CSIS_MSK_EVENBEFORE  (0x1)
#define BW_CSIS_MSK_EVENAFTER   (0x1)
#define BW_CSIS_MSK_ODDBEFORE   (0x1)
#define BW_CSIS_MSK_ODDAFTER    (0x1)
#define BW_CSIS_MSK_ERR_SOT_HS  (0x1)
#define BW_CSIS_MSK_ERR_CTRL    (0x1)
#define BW_CSIS_MSK_ERR_ECC     (0x1)
#define BW_CSIS_MSK_ERR_CRC     (0x1)
#define BW_CSIS_MSK_ERR_ID      (0x1)

#define BM_CSIS_MSK_EVENBEFORE  (BW_CSIS_MSK_EVENBEFORE<<BP_CSIS_MSK_EVENBEFORE)
#define BM_CSIS_MSK_EVENAFTER   (BW_CSIS_MSK_EVENAFTER<<BP_CSIS_MSK_EVENAFTER)
#define BM_CSIS_MSK_ODDBEFORE   (BW_CSIS_MSK_ODDBEFORE<<BP_CSIS_MSK_ODDBEFORE)
#define BM_CSIS_MSK_ODDAFTER    (BW_CSIS_MSK_ODDAFTER<<BP_CSIS_MSK_ODDAFTER)
#define BM_CSIS_MSK_ERR_SOT_HS  (BW_CSIS_MSK_ERR_SOT_HS<<BP_CSIS_MSK_ERR_SOT_HS)
#define BM_CSIS_MSK_ERR_CTRL    (BW_CSIS_MSK_ERR_CTRL<<BP_CSIS_MSK_ERR_CTRL)
#define BM_CSIS_MSK_ERR_ECC     (BW_CSIS_MSK_ERR_ECC<<BP_CSIS_MSK_ERR_ECC)
#define BM_CSIS_MSK_ERR_CRC     (BW_CSIS_MSK_ERR_CRC<<BP_CSIS_MSK_ERR_CRC)
#define BM_CSIS_MSK_ERR_ID      (BW_CSIS_MSK_ERR_ID<<BP_CSIS_MSK_ERR_ID)


// CSIS_INTSRC
//DEF_REG_BITINFO(CSIS_SRC_EVENBEFORE, 31, 1, 0x1);
//DEF_REG_BITINFO(CSIS_SRC_EVENAFTER, 30, 1, 0x1);
//DEF_REG_BITINFO(CSIS_SRC_ODDBEFORE, 29, 1, 0x1);
//DEF_REG_BITINFO(CSIS_SRC_ODDAFTER, 28, 1, 0x1);
//DEF_REG_BITINFO(CSIS_SRC_ERR_SOT_HS, 12, 2, 0x3);
//DEF_REG_BITINFO(CSIS_SRC_ERR_ESC, 8, 2, 0x3);
//DEF_REG_BITINFO(CSIS_SRC_ERR_CTRL, 4, 2, 0x3);
//DEF_REG_BITINFO(CSIS_SRC_ERR_ECC, 2, 1, 0x1);
//DEF_REG_BITINFO(CSIS_SRC_ERR_CRC, 1, 1, 0x1);
//DEF_REG_BITINFO(CSIS_SRC_ERR_ID, 0, 1, 0x1);

#define BP_CSIS_SRC_EVENBEFORE  (31)    
#define BP_CSIS_SRC_EVENAFTER   (30)    
#define BP_CSIS_SRC_ODDBEFORE   (29)    
#define BP_CSIS_SRC_ODDAFTER    (28)    
#define BP_CSIS_SRC_ERR_SOT_HS  (12)    
#define BP_CSIS_SRC_ERR_CTRL    (3)     
#define BP_CSIS_SRC_ERR_ECC     (2)     
#define BP_CSIS_SRC_ERR_CRC     (1)     
#define BP_CSIS_SRC_ERR_ID      (0)     

#define BS_CSIS_SRC_EVENBEFORE  (1<<BP_CSIS_SRC_EVENBEFORE)
#define BS_CSIS_SRC_EVENAFTER   (1<<BP_CSIS_SRC_EVENAFTER)
#define BS_CSIS_SRC_ODDBEFORE   (1<<BP_CSIS_SRC_ODDBEFORE)
#define BS_CSIS_SRC_ODDAFTER    (1<<BP_CSIS_SRC_ODDAFTER)
#define BS_CSIS_SRC_ERR_SOT_HS  (1<<BP_CSIS_SRC_ERR_SOT_HS)
#define BS_CSIS_SRC_ERR_CTRL    (1<<BP_CSIS_SRC_ERR_CTRL)
#define BS_CSIS_SRC_ERR_ECC     (1<<BP_CSIS_SRC_ERR_ECC)
#define BS_CSIS_SRC_ERR_CRC     (1<<BP_CSIS_SRC_ERR_CRC)
#define BS_CSIS_SRC_ERR_ID      (1<<BP_CSIS_SRC_ERR_ID)

#define BC_CSIS_SRC_EVENBEFORE  (1)
#define BC_CSIS_SRC_EVENAFTER   (1)
#define BC_CSIS_SRC_ODDBEFORE   (1)
#define BC_CSIS_SRC_ODDAFTER    (1)
#define BC_CSIS_SRC_ERR_SOT_HS  (2)
#define BC_CSIS_SRC_ERR_CTRL    (2)
#define BC_CSIS_SRC_ERR_ECC     (1)
#define BC_CSIS_SRC_ERR_CRC     (1)
#define BC_CSIS_SRC_ERR_ID      (1)

#define BW_CSIS_SRC_EVENBEFORE  (0x1)
#define BW_CSIS_SRC_EVENAFTER   (0x1)
#define BW_CSIS_SRC_ODDBEFORE   (0x1)
#define BW_CSIS_SRC_ODDAFTER    (0x1)
#define BW_CSIS_SRC_ERR_SOT_HS  (0x3)
#define BW_CSIS_SRC_ERR_CTRL    (0x3)
#define BW_CSIS_SRC_ERR_ECC     (0x1)
#define BW_CSIS_SRC_ERR_CRC     (0x1)
#define BW_CSIS_SRC_ERR_ID      (0x1)

#define BM_CSIS_SRC_EVENBEFORE  (BW_CSIS_SRC_EVENBEFORE<<BP_CSIS_SRC_EVENBEFORE)
#define BM_CSIS_SRC_EVENAFTER   (BW_CSIS_SRC_EVENAFTER<<BP_CSIS_SRC_EVENAFTER)
#define BM_CSIS_SRC_ODDBEFORE   (BW_CSIS_SRC_ODDBEFORE<<BP_CSIS_SRC_ODDBEFORE)
#define BM_CSIS_SRC_ODDAFTER    (BW_CSIS_SRC_ODDAFTER<<BP_CSIS_SRC_ODDAFTER)
#define BM_CSIS_SRC_ERR_SOT_HS  (BW_CSIS_SRC_ERR_SOT_HS<<BP_CSIS_SRC_ERR_SOT_HS)
#define BM_CSIS_SRC_ERR_CTRL    (BW_CSIS_SRC_ERR_CTRL<<BP_CSIS_SRC_ERR_CTRL)
#define BM_CSIS_SRC_ERR_ECC     (BW_CSIS_SRC_ERR_ECC<<BP_CSIS_SRC_ERR_ECC)
#define BM_CSIS_SRC_ERR_CRC     (BW_CSIS_SRC_ERR_CRC<<BP_CSIS_SRC_ERR_CRC)
#define BM_CSIS_SRC_ERR_ID      (BW_CSIS_SRC_ERR_ID<<BP_CSIS_SRC_ERR_ID)


//CSIS_RESOL  // 0x002C
#define BP_CSIS_HRESOL          (16)
#define BP_CSIS_VRESOL          (0)

#define BS_CSIS_HRESOL          (1<<BP_CSIS_HRESOL)
#define BS_CSIS_VRESOL          (1<<BP_CSIS_VRESOL)

#define BC_CSIS_HRESOL          (4)
#define BC_CSIS_VRESOL          (4)

#define BW_CSIS_HRESOL          (0xf)
#define BW_CSIS_VRESOL          (0xf)

#define BM_CSIS_HRESOL          (BW_CSIS_HRESOL<<BP_CSIS_HRESOL)
#define BM_CSIS_VRESOL          (BW_CSIS_VRESOL<<BP_CSIS_VRESOL)






// PKTDATA Register will be mapped to other structure as like different Reigster.


//------------------------------------------------------------------------------
//  Type: MIPICSI_REG
//
//  MIPI-CSI Interface registers. This register bank is located by the constant
//  <CPU>_BASE_REG_XX_MIPICSI in the configuration file <cpu>_base_regs.h.
//

typedef struct _reg_mipicsi_v1
{
    // General Registers
    UINT32 CSIS_CONTROL;         //  (MIPICSI_BASE+0x00) // Control Register
    UINT32 CSIS_DPHYCTRL;        //  (MIPICSI_BASE+0x04) // D-PHY Control Register
    UINT32 CSIS_CONFIG;          //  (MIPICSI_BASE+0x08) // Configuration Register
    UINT32 CSIS_DPHYSTS;         //  (MIPICSI_BASE+0x0c) // D-PHY STOP State Register
    UINT32 CSIS_INTMSK;          //  (MIPICSI_BASE+0x10) // Interrupt Mask Register
    UINT32 CSIS_INTSRC;          //  (MIPICSI_BASE+0x14) // Interrupt Status Register
    UINT32 RESERVED[5];        // 0x18~0x28
   
    UINT32 CSIS_RESOL;          //  (MIPICSI_BASE+0x2C) // Image Resolution Register

    //UINT32 SDW_CONFIG;          //  (MIPICSI_BASE+0x2C) // Image Resolution Register
    //UINT32 SDW_RESOL;          //  (MIPICSI_BASE+0x2C) // Image Resolution Register
    //UINT32 CSIS_PKTDATA;


 } MIPICSI_REG, *PMIPICSI_REG;

#ifdef __cplusplus
}
#endif


#endif /*__MIPICSI_REG_H__*/
