//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: MIE_reg.h
//
//  Defines the MIE Controller CPU register layout and definitions.
//
#ifndef __MIE_REG_H
#define __MIE_REG_H

#if __cplusplus
    extern "C"
    {
#endif

//------------------------------------------------------------------------------
//  Type: MIE_REG
//
//  Defines the MIE Interface register layout. This register bank is located by the
//  constant BASE_REG_PA_MIE in the configuration file Base_regs.h.
//

typedef struct
{
    UINT32 MIE_CTRL1;               //0x00
    UINT32 MIE_CTRL2;               //0x04
    UINT32 MIE_CTRL3;               //0x08
    UINT32 PAD1;                    //0x0C
    UINT32 MIE_WINHADDR;            //0x10
    UINT32 MIE_WINVADDR;            //0x14
    UINT32 PAD2[6];                 //0x18-0x2F
    UINT32 MIE_PWMCTRL1;            //0x30
    UINT32 MIE_PWMCTRL2;            //0x34
    UINT32 MIE_PWMVIDTCON1;         //0x38
    UINT32 MIE_PWMVIDTCON2;         //0x3C
} MIE_REG, *PMIE_REG;

#if __cplusplus
}
#endif

#endif    // __MIE_REG_H
