;
; Module Name: gpio_reg.inc
;
; Abstract: S5PV210 GPIO offset address
;
; Revision History: 07.31.2009
;
;-------------------------------------------------------------------------------

DAT_OFFSET		    EQU		0x04
PUD_OFFSET		    EQU		0x08
DRV_OFFSET		    EQU		0x0C
CONPDN_OFFSET		EQU		0x10
PUDPDN_OFFSET		EQU		0x14

;GPA0[8pin]
GPA0CON_ADDR		EQU 	0x0000
GPA0DAT_ADDR		EQU     (GPA0CON_ADDR + DAT_OFFSET)
GPA0PUD_ADDR		EQU 	(GPA0CON_ADDR + PUD_OFFSET)
GPA0DRV_ADDR		EQU 	(GPA0CON_ADDR + DRV_OFFSET)
GPA0CONPDN_ADDR	    EQU 	(GPA0CON_ADDR + CONPDN_OFFSET)
GPA0PUDPDN_ADDR	    EQU 	(GPA0CON_ADDR + PUDPDN_OFFSET)

;GPA1[4pin]
GPA1CON_ADDR		EQU 		0x0020
GPA1DAT_ADDR		EQU 		(GPA1CON_ADDR + DAT_OFFSET)
GPA1PUD_ADDR		EQU 		(GPA1CON_ADDR + PUD_OFFSET)
GPA1DRV_ADDR		EQU 		(GPA1CON_ADDR + DRV_OFFSET)
GPA1CONPDN_ADDR	    EQU 		(GPA1CON_ADDR + CONPDN_OFFSET)
GPA1PUDPDN_ADDR	    EQU 		(GPA1CON_ADDR + PUDPDN_OFFSET)

;GPB[8pin]
GPB0CON_ADDR		EQU 		0x0040
GPB0DAT_ADDR		EQU 		(GPB0CON_ADDR + DAT_OFFSET)
GPB0PUD_ADDR		EQU 		(GPB0CON_ADDR + PUD_OFFSET)
GPB0DRV_ADDR		EQU 		(GPB0CON_ADDR + DRV_OFFSET)
GPB0CONPDN_ADDR	    EQU 		(GPB0CON_ADDR + CONPDN_OFFSET)
GPB0PUDPDN_ADDR	    EQU 		(GPB0CON_ADDR + PUDPDN_OFFSET)

;GPC0[5pin]
GPC0CON_ADDR		EQU 		0x0060
GPC0DAT_ADDR		EQU 		(GPC0CON_ADDR + DAT_OFFSET)
GPC0PUD_ADDR		EQU 		(GPC0CON_ADDR + PUD_OFFSET)
GPC0DRV_ADDR		EQU 		(GPC0CON_ADDR + DRV_OFFSET)
GPC0CONPDN_ADDR	    EQU 		(GPC0CON_ADDR + CONPDN_OFFSET)
GPC0PUDPDN_ADDR	    EQU 		(GPC0CON_ADDR + PUDPDN_OFFSET)

;GPD0[4pin]
GPD0CON_ADDR		EQU 		0x00A0
GPD0DAT_ADDR		EQU 		(GPD0CON_ADDR + DAT_OFFSET)
GPD0PUD_ADDR		EQU 		(GPD0CON_ADDR + PUD_OFFSET)
GPD0DRV_ADDR		EQU 		(GPD0CON_ADDR + DRV_OFFSET)
GPD0CONPDN_ADDR	    EQU 		(GPD0CON_ADDR + CONPDN_OFFSET)
GPD0PUDPDN_ADDR	    EQU 		(GPD0CON_ADDR + PUDPDN_OFFSET)

;GPD1[6pin]
GPD1CON_ADDR		EQU 		0x00C0
GPD1DAT_ADDR		EQU 		(GPD1CON_ADDR + DAT_OFFSET)
GPD1PUD_ADDR		EQU 		(GPD1CON_ADDR + PUD_OFFSET)
GPD1DRV_ADDR		EQU 		(GPD1CON_ADDR + DRV_OFFSET)
GPD1CONPDN_ADDR	    EQU 		(GPD1CON_ADDR + CONPDN_OFFSET)
GPD1PUDPDN_ADDR	    EQU 		(GPD1CON_ADDR + PUDPDN_OFFSET)

;GPE0[8pin]
GPE0CON_ADDR		EQU 		0x00E0
GPE0DAT_ADDR		EQU 		(GPE0CON_ADDR + DAT_OFFSET)
GPE0PUD_ADDR		EQU 		(GPE0CON_ADDR + PUD_OFFSET)
GPE0DRV_ADDR		EQU 		(GPE0CON_ADDR + DRV_OFFSET)
GPE0CONPDN_ADDR	    EQU 		(GPE0CON_ADDR + CONPDN_OFFSET)
GPE0PUDPDN_ADDR	    EQU 		(GPE0CON_ADDR + PUDPDN_OFFSET)

;GPE1[5pin]
GPE1CON_ADDR		EQU 		0x0100
GPE1DAT_ADDR		EQU 		(GPE1CON_ADDR + DAT_OFFSET)
GPE1PUD_ADDR		EQU 		(GPE1CON_ADDR + PUD_OFFSET)
GPE1DRV_ADDR		EQU 		(GPE1CON_ADDR + DRV_OFFSET)
GPE1CONPDN_ADDR	    EQU 		(GPE1CON_ADDR + CONPDN_OFFSET)
GPE1PUDPDN_ADDR	    EQU 		(GPE1CON_ADDR + PUDPDN_OFFSET)

;GPF0[8pin]
GPF0CON_ADDR		EQU 		0x0120
GPF0DAT_ADDR		EQU 		(GPF0CON_ADDR + DAT_OFFSET)
GPF0PUD_ADDR		EQU 		(GPF0CON_ADDR + PUD_OFFSET)
GPF0DRV_ADDR		EQU 		(GPF0CON_ADDR + DRV_OFFSET)
GPF0CONPDN_ADDR	    EQU 		(GPF0CON_ADDR + CONPDN_OFFSET)
GPF0PUDPDN_ADDR	    EQU 		(GPF0CON_ADDR + PUDPDN_OFFSET)

;GPF1[8pin]
GPF1CON_ADDR		EQU 		0x0140
GPF1DAT_ADDR		EQU 		(GPF1CON_ADDR + DAT_OFFSET)
GPF1PUD_ADDR		EQU 		(GPF1CON_ADDR + PUD_OFFSET)
GPF1DRV_ADDR		EQU 		(GPF1CON_ADDR + DRV_OFFSET)
GPF1CONPDN_ADDR	    EQU 		(GPF1CON_ADDR + CONPDN_OFFSET)
GPF1PUDPDN_ADDR	    EQU 		(GPF1CON_ADDR + PUDPDN_OFFSET)

;GPF2[8pin]
GPF2CON_ADDR		EQU 		0x0160
GPF2DAT_ADDR		EQU 		(GPF2CON_ADDR + DAT_OFFSET)
GPF2PUD_ADDR		EQU 		(GPF2CON_ADDR + PUD_OFFSET)
GPF2DRV_ADDR		EQU 		(GPF2CON_ADDR + DRV_OFFSET)
GPF2CONPDN_ADDR	    EQU 		(GPF2CON_ADDR + CONPDN_OFFSET)
GPF2PUDPDN_ADDR	    EQU 		(GPF2CON_ADDR + PUDPDN_OFFSET)

;GPF3[6pin]
GPF3CON_ADDR		EQU 		0x0180
GPF3DAT_ADDR		EQU 		(GPF3CON_ADDR + DAT_OFFSET)
GPF3PUD_ADDR		EQU 		(GPF3CON_ADDR + PUD_OFFSET)
GPF3DRV_ADDR		EQU 		(GPF3CON_ADDR + DRV_OFFSET)
GPF3CONPDN_ADDR	    EQU 		(GPF3CON_ADDR + CONPDN_OFFSET)
GPF3PUDPDN_ADDR	    EQU 		(GPF3CON_ADDR + PUDPDN_OFFSET)

;GPG0[7pin]
GPG0CON_ADDR		EQU 		0x01A0
GPG0DAT_ADDR		EQU 		(GPG0CON_ADDR + DAT_OFFSET)
GPG0PUD_ADDR		EQU 		(GPG0CON_ADDR + PUD_OFFSET)
GPG0DRV_ADDR		EQU 		(GPG0CON_ADDR + DRV_OFFSET)
GPG0CONPDN_ADDR	    EQU 		(GPG0CON_ADDR + CONPDN_OFFSET)
GPG0PUDPDN_ADDR	    EQU 		(GPG0CON_ADDR + PUDPDN_OFFSET)

;GPG1[7pin]
GPG1CON_ADDR		EQU 		0x01C0
GPG1DAT_ADDR		EQU 		(GPG1CON_ADDR + DAT_OFFSET)
GPG1PUD_ADDR		EQU 		(GPG1CON_ADDR + PUD_OFFSET)
GPG1DRV_ADDR		EQU 		(GPG1CON_ADDR + DRV_OFFSET)
GPG1CONPDN_ADDR	    EQU 		(GPG1CON_ADDR + CONPDN_OFFSET)
GPG1PUDPDN_ADDR	    EQU 		(GPG1CON_ADDR + PUDPDN_OFFSET)

;GPG2[7pin]
GPG2CON_ADDR		EQU 		0x01E0
GPG2DAT_ADDR		EQU 		(GPG2CON_ADDR + DAT_OFFSET)
GPG2PUD_ADDR		EQU 		(GPG2CON_ADDR + PUD_OFFSET)
GPG2DRV_ADDR		EQU 		(GPG2CON_ADDR + DRV_OFFSET)
GPG2CONPDN_ADDR	    EQU 		(GPG2CON_ADDR + CONPDN_OFFSET)
GPG2PUDPDN_ADDR	    EQU 		(GPG2CON_ADDR + PUDPDN_OFFSET)

;GPG3[7pin]
GPG3CON_ADDR		EQU 		0x0200
GPG3DAT_ADDR		EQU 		(GPG3CON_ADDR + DAT_OFFSET)
GPG3PUD_ADDR		EQU 		(GPG3CON_ADDR + PUD_OFFSET)
GPG3DRV_ADDR		EQU 		(GPG3CON_ADDR + DRV_OFFSET)
GPG3CONPDN_ADDR	    EQU 		(GPG3CON_ADDR + CONPDN_OFFSET)
GPG3PUDPDN_ADDR	    EQU 		(GPG3CON_ADDR + PUDPDN_OFFSET)

;GPH0[8pin]
GPH0CON_ADDR		EQU 		0x0C00
GPH0DAT_ADDR		EQU 		(GPH0CON_ADDR + DAT_OFFSET)
GPH0PUD_ADDR		EQU 		(GPH0CON_ADDR + PUD_OFFSET)
GPH0DRV_ADDR		EQU 		(GPH0CON_ADDR + DRV_OFFSET)

;GPH1[8pin]
GPH1CON_ADDR		EQU 		0x0C20
GPH1DAT_ADDR		EQU 		(GPH1CON_ADDR + DAT_OFFSET)
GPH1PUD_ADDR		EQU 		(GPH1CON_ADDR + PUD_OFFSET)
GPH1DRV_ADDR		EQU 		(GPH1CON_ADDR + DRV_OFFSET)

;GPH2[8pin]
GPH2CON_ADDR		EQU 		0x0C40
GPH2DAT_ADDR		EQU 		(GPH2CON_ADDR + DAT_OFFSET)
GPH2PUD_ADDR		EQU 		(GPH2CON_ADDR + PUD_OFFSET)
GPH2DRV_ADDR		EQU 		(GPH2CON_ADDR + DRV_OFFSET)

;GPH3[8pin]
GPH3CON_ADDR		EQU 		0x0C60
GPH3DAT_ADDR		EQU 		(GPH3CON_ADDR + DAT_OFFSET)
GPH3PUD_ADDR		EQU 		(GPH3CON_ADDR + PUD_OFFSET)
GPH3DRV_ADDR		EQU 		(GPH3CON_ADDR + DRV_OFFSET)

;GPI[7pin]
GPICON_ADDR		    EQU 		0x0220
GPIDAT_ADDR		    EQU 		(GPICON_ADDR + DAT_OFFSET)
GPIPUD_ADDR		    EQU 		(GPICON_ADDR + PUD_OFFSET)
GPIDRV_ADDR		    EQU 		(GPICON_ADDR + DRV_OFFSET)
GPICONPDN_ADDR	    EQU 		(GPICON_ADDR + CONPDN_OFFSET)
GPIPUDPDN_ADDR	    EQU 		(GPICON_ADDR + PUDPDN_OFFSET)

;GPJ0[8pin]
GPJ0CON_ADDR		EQU 		0x0240
GPJ0DAT_ADDR		EQU 		(GPJ0CON_ADDR + DAT_OFFSET)
GPJ0PUD_ADDR		EQU 		(GPJ0CON_ADDR + PUD_OFFSET)
GPJ0DRV_ADDR		EQU 		(GPJ0CON_ADDR + DRV_OFFSET)
GPJ0CONPDN_ADDR	    EQU 		(GPJ0CON_ADDR + CONPDN_OFFSET)
GPJ0PUDPDN_ADDR	    EQU 		(GPJ0CON_ADDR + PUDPDN_OFFSET)

;GPJ1[6pin]
GPJ1CON_ADDR		EQU 		0x0260
GPJ1DAT_ADDR		EQU 		(GPJ1CON_ADDR + DAT_OFFSET)
GPJ1PUD_ADDR		EQU 		(GPJ1CON_ADDR + PUD_OFFSET)
GPJ1DRV_ADDR		EQU 		(GPJ1CON_ADDR + DRV_OFFSET)
GPJ1CONPDN_ADDR	    EQU 		(GPJ1CON_ADDR + CONPDN_OFFSET)
GPJ1PUDPDN_ADDR	    EQU 		(GPJ1CON_ADDR + PUDPDN_OFFSET)

;GPJ2[8pin]
GPJ2CON_ADDR		EQU 		0x0280
GPJ2DAT_ADDR		EQU 		(GPJ2CON_ADDR + DAT_OFFSET)
GPJ2PUD_ADDR		EQU 		(GPJ2CON_ADDR + PUD_OFFSET)
GPJ2DRV_ADDR		EQU 		(GPJ2CON_ADDR + DRV_OFFSET)
GPJ2CONPDN_ADDR	    EQU 		(GPJ2CON_ADDR + CONPDN_OFFSET)
GPJ2PUDPDN_ADDR	    EQU 		(GPJ2CON_ADDR + PUDPDN_OFFSET)

;GPJ3[8pin]
GPJ3CON_ADDR		EQU 		0x02A0
GPJ3DAT_ADDR		EQU 		(GPJ3CON_ADDR + DAT_OFFSET)
GPJ3PUD_ADDR		EQU 		(GPJ3CON_ADDR + PUD_OFFSET)
GPJ3DRV_ADDR		EQU 		(GPJ3CON_ADDR + DRV_OFFSET)
GPJ3CONPDN_ADDR	    EQU 		(GPJ3CON_ADDR + CONPDN_OFFSET)
GPJ3PUDPDN_ADDR	    EQU 		(GPJ3CON_ADDR + PUDPDN_OFFSET)

;GPJ4[5pin]
GPJ4CON_ADDR		EQU 		0x02C0
GPJ4DAT_ADDR		EQU 		(GPJ4CON_ADDR + DAT_OFFSET)
GPJ4PUD_ADDR		EQU 		(GPJ4CON_ADDR + PUD_OFFSET)
GPJ4DRV_ADDR		EQU 		(GPJ4CON_ADDR + DRV_OFFSET)
GPJ4CONPDN_ADDR	    EQU 		(GPJ4CON_ADDR + CONPDN_OFFSET)
GPJ4PUDPDN_ADDR	    EQU 		(GPJ4CON_ADDR + PUDPDN_OFFSET)

;MP01[8pin]
MP01CON_ADDR		EQU 		0x02E0
MP01DAT_ADDR		EQU 		(MP01CON_ADDR + DAT_OFFSET)
MP01PUD_ADDR		EQU 		(MP01CON_ADDR + PUD_OFFSET)
MP01DRV_ADDR		EQU 		(MP01CON_ADDR + DRV_OFFSET)
MP01CONPDN_ADDR	    EQU 		(MP01CON_ADDR + CONPDN_OFFSET)
MP01PUDPDN_ADDR	    EQU 		(MP01CON_ADDR + PUDPDN_OFFSET)

;MP02[4pin]
MP02CON_ADDR		EQU 		0x0300
MP02DAT_ADDR		EQU 		(MP02CON_ADDR + DAT_OFFSET)
MP02PUD_ADDR		EQU 		(MP02CON_ADDR + PUD_OFFSET)
MP02DRV_ADDR		EQU 		(MP02CON_ADDR + DRV_OFFSET)
MP02CONPDN_ADDR	    EQU 		(MP02CON_ADDR + CONPDN_OFFSET)
MP02PUDPDN_ADDR	    EQU 		(MP02CON_ADDR + PUDPDN_OFFSET)

;MP03[8pin]
MP03CON_ADDR		EQU 		0x0320
MP03DAT_ADDR		EQU 		(MP03CON_ADDR + DAT_OFFSET)
MP03PUD_ADDR		EQU 		(MP03CON_ADDR + PUD_OFFSET)
MP03DRV_ADDR		EQU 		(MP03CON_ADDR + DRV_OFFSET)
MP03CONPDN_ADDR	    EQU 		(MP03CON_ADDR + CONPDN_OFFSET)
MP03PUDPDN_ADDR	    EQU 		(MP03CON_ADDR + PUDPDN_OFFSET)

;MP04[8pin]
MP04CON_ADDR		EQU 		0x0340
MP04DAT_ADDR		EQU 		(MP04CON_ADDR + DAT_OFFSET)
MP04PUD_ADDR		EQU 		(MP04CON_ADDR + PUD_OFFSET)
MP04DRV_ADDR		EQU 		(MP04CON_ADDR + DRV_OFFSET)
MP04CONPDN_ADDR	    EQU 		(MP04CON_ADDR + CONPDN_OFFSET)
MP04PUDPDN_ADDR	    EQU 		(MP04CON_ADDR + PUDPDN_OFFSET)

;MP05[8pin]
MP05CON_ADDR		EQU 		0x0360
MP05DAT_ADDR		EQU 		(MP05CON_ADDR + DAT_OFFSET)
MP05PUD_ADDR		EQU 		(MP05CON_ADDR + PUD_OFFSET)
MP05DRV_ADDR		EQU 		(MP05CON_ADDR + DRV_OFFSET)
MP05CONPDN_ADDR	    EQU 		(MP05CON_ADDR + CONPDN_OFFSET)
MP05PUDPDN_ADDR	    EQU 		(MP05CON_ADDR + PUDPDN_OFFSET)

	END
