//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header:  gpio_reg.h
//
//  Defines the Input/Output Ports (GPIO) control registers and associated
//  types and constants.
//
#ifndef __S5PV210_GPIO_H
#define __S5PV210_GPIO_H

#if __cplusplus
extern "C" {
#endif

#include "GpioEntry_reg.h"

#define GPIO_TOTALNUM                   23  // Total Number of GPA0~GPJ4
#define GPIO_GROUPNUM                   6
#define MP_TOTALNUM                     25  // Total Number of MP0_1~MP0_7, MP1_0~MP1_8, MP2_0~MP2_8
#define MP_GROUPNUM                     6
#define ETC_TOTALNUM                    4
#define ETC_GROUPNUM                    2
#define GPIO_EINT_NUM                   22  // Total Number of GPIO Ext Interrupt

typedef struct                              // 0xE0200000
{
    _GPIO_PORT_REG      GPA0;           // 0x0
    _GPIO_PORT_REG      GPA1;
    _GPIO_PORT_REG      GPB;
    _GPIO_PORT_REG      GPC0;
    _GPIO_PORT_REG      GPC1;
    _GPIO_PORT_REG      GPD0;
    _GPIO_PORT_REG      GPD1;
    _GPIO_PORT_REG      GPE0;
    _GPIO_PORT_REG      GPE1;
    _GPIO_PORT_REG      GPF0;
    _GPIO_PORT_REG      GPF1;
    _GPIO_PORT_REG      GPF2;
    _GPIO_PORT_REG      GPF3;
    _GPIO_PORT_REG      GPG0;
    _GPIO_PORT_REG      GPG1;
    _GPIO_PORT_REG      GPG2;
    _GPIO_PORT_REG      GPG3;
    _LP_PORT_REG        GPI;              // 0x220
    _GPIO_PORT_REG      GPJ0;
    _GPIO_PORT_REG      GPJ1;
    _GPIO_PORT_REG      GPJ2;
    _GPIO_PORT_REG      GPJ3;
    _GPIO_PORT_REG      GPJ4;           // 0x2C0 ~ 0x2DC

    _MP_PORT_REG        MP0_1;       // 0x2E0
    _MP_PORT_REG        MP0_2;
    _MP_PORT_REG        MP0_3;
    _MP_PORT_REG        MP0_4;
    _MP_PORT_REG        MP0_5;
    _MP_PORT_REG        MP0_6;
    _MP_PORT_REG        MP0_7;

    _MP_PORT_REG        MP1_0;
    _MP_PORT_REG        MP1_1;
    _MP_PORT_REG        MP1_2;
    _MP_PORT_REG        MP1_3;
    _MP_PORT_REG        MP1_4;
    _MP_PORT_REG        MP1_5;
    _MP_PORT_REG        MP1_6;
    _MP_PORT_REG        MP1_7;
    _MP_PORT_REG        MP1_8;

    _MP_PORT_REG        MP2_0;
    _MP_PORT_REG        MP2_1;
    _MP_PORT_REG        MP2_2;
    _MP_PORT_REG        MP2_3;
    _MP_PORT_REG        MP2_4;
    _MP_PORT_REG        MP2_5;
    _MP_PORT_REG        MP2_6;
    _MP_PORT_REG        MP2_7;
    _MP_PORT_REG        MP2_8;    // 0x5E0 ~ 0x5FC

    _ETC_PORT_REG       ETC0;      // 0x600 ~ 0x61C
    _ETC_PORT_REG       ETC1;
    _ETC_PORT_REG       ETC2;
    _ETC_PORT_REG       ETC4;      // 0x660 ~ 0x67C

    UINT32              ETC_PAD[32]; //0x680 ~ 0x6FC

    _GPIOINTCON_REG     GPIOINTCON;  // 0x700 ~ 0x754
    UINT32              GPIOCON_PAD[42]; //0x758 ~ 0x7FC

    _GPIOINTFLT_REG     GPIOINTFLT;    // 0x800 ~ 0x8AC
    UINT32              GPIOFLT_PAD[20]; // 0x8B0 ~ 0x8FC

    _GPIOINTMSK_REG     GPIOINTMSK; //0x900 ~ 0x954
    UINT32              GPIOMSK_PAD[42]; // 0x958 ~ 0x9FC

    _GPIOINTPND_REG     GPIOINTPND; // 0xA00 ~ 0xA54
    UINT32              GPIOPND_PAD[42]; // 0xA58~0xAFC

    UINT32              GPIOINT_GRPPRI;
    UINT32              GPIOINT_PRIORITY;
    UINT32              GPIOINT_SERVICE;
    UINT32              GPIOINT_SERVICE_PEND;
    UINT32              GPIOINT_GRPFIXPRI;

     _GPIOINTFIXPRI_REG GPIOINTFIXPRI;  // 0xB14 ~ 0xB68
    UINT32              GPIOPRI_PAD[37]; //0xB6C ~ 0xBFC

    _ALIVE_PORT_REG     GPH0;               // 0xC00 ~ 0xC1C
    _ALIVE_PORT_REG     GPH1;
    _ALIVE_PORT_REG     GPH2;
    _ALIVE_PORT_REG     GPH3;               // 0xC60 ~ 0xC7C

    UINT32              GPH_PAD[96];  // 0xC80 ~ 0xDFC

    _EINTCON_REG       EINTCON;  // 0xE00 ~ 0xE0C
    UINT32             EINTCON_PAD[28]; // 0xE10 ~ 0xE7C

    _EINTFLT_REG       EINTFLT;    // 0xE80~ 0xE9C
    UINT32             EINTFLT_PAD[24]; // 0xEA0 ~ 0xEFC

    _EINTMSK_REG       EINTMSK; //0xF00 ~ 0xF0C
    UINT32             EINTMSK_PAD[12]; // 0xF10 ~ 0xF3C

    _EINTPND_REG       EINTPND; // 0xF40 ~ 0xF4C
    UINT32             EINTPND_PAD[12]; // 0xF50~0xF7C

    UINT32             PDNEN;          // 0xF80
} GPIO_REG, *PGPIO_REG;


#if __cplusplus
}
#endif

#endif // __S5PV210_GPIO_H
