//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
--*/
/**
*    @file      g2d_reg.h
*    @brief     Defines the FIMG-2D Graphics Accerlerator's register layout and definitions.

*    
*    @note      This version is made for S5PV210
*    @note      IP version is v3.0
*/

#ifndef __G2D_REG_H__
#define __G2D_REG_H__

#ifdef __cplusplus
extern "C"
{
#endif


//------------------------------------------------------------------------------
//
//  Type:  G2D_REG
//
//  Defines the FIMG-2D register layout. This register bank is
//  located by the constant BASE_REG_XX_G2D in the configuration file
//  base_reg_cfg.h.
//

typedef struct
{
//**   General Register   ******************
    UINT32 SOFT_RESET_REG;          // 0x0000
    UINT32 INTEN_REG;               // 0x0004
    UINT32 PAD0[1];                 
    UINT32 INTC_PEND_REG;           // 0x000C
    UINT32 FIFO_STAT_REG;           // 0x0010
    UINT32 AXI_ID_MODE_REG;         // 0x0014
    UINT32 CACHECTL_REG;            // 0x0018
    UINT32 PAD1[57];
    
//**   G2D Command   ***********************
    UINT32 BITBLT_START_REG;        // 0x0100
    UINT32 BITBLT_COMMAND_REG;      // 0x0104
    UINT32 PAD2[62];

//**   Rotation & Direction   **************
    UINT32 ROTATE_REG;              // 0x0200
    UINT32 SRC_MSK_DIRECT_REG;      // 0x0204
    UINT32 DST_PAT_DIRECT_REG;      // 0x0208
    UINT32 PAD3[61];

//**   Source    ***************************
    UINT32 SRC_SELECT_REG;          // 0x0300
    UINT32 SRC_BASE_ADDR_REG;       // 0x0304
    UINT32 SRC_STRIDE_REG;          // 0x0308
    UINT32 SRC_COLOR_MODE_REG;      // 0x030C
    UINT32 SRC_LEFT_TOP_REG;        // 0x0310
    UINT32 SRC_RIGHT_BOTTOM_REG;    // 0x0314
    UINT32 PAD4[58];

//**   Destination  ************************
    UINT32 DST_SELECT_REG;          // 0x0400
    UINT32 DST_BASE_ADDR_REG;       // 0x0404
    UINT32 DST_STRIDE_REG;          // 0x0408
    UINT32 DST_COLOR_MODE_REG;      // 0x040C
    UINT32 DST_LEFT_TOP_REG;        // 0x0410
    UINT32 DST_RIGHT_BOTTOM_REG;    // 0x0414
    UINT32 PAD5[58];

//**   Pattern   ***************************
    UINT32 PAT_BASE_ADDR_REG;       // 0x0500
    UINT32 PAT_SIZE_REG;            // 0x0504
    UINT32 PAT_COLOR_MODE_REG;      // 0x0508
    UINT32 PAT_OFFSET_REG;          // 0x050C
    UINT32 PAT_STRIDE_REG;          // 0x0510
    UINT32 PAD6[3];

//**   Mask   *****************************8
    UINT32 MASK_BASE_ADDR_REG;      // 0x0520
    UINT32 MASK_STRIDE_REG;         // 0x0524
    UINT32 PAD7[55];

//**   Clipping Window  ********************
    UINT32 CW_LT_REG;               // 0x0600
    UINT32 CW_RB_REG;               // 0x0604
    UINT32 PAD8[2];

//**   ROP & Alpha Setting  ****************
    UINT32 THIRD_OPERAND_REG;       // 0x0610
    UINT32 ROP4_REG;                // 0x0614
    UINT32 ALPHA_REG;               // 0x0618
    UINT32 PAD9[57];

//**   Color   *****************************
    UINT32 FG_COLOR_REG;            // 0x0700
    UINT32 BG_COLOR_REG;            // 0x0704
    UINT32 BS_COLOR_REG;            // 0x0708
    UINT32 PAD10[61];

//**   Color Key   *************************
    UINT32 SRC_COLORKEY_CTRL_REG;   // 0x0710
    UINT32 SRC_COLORKEY_DR_MIN_REG; // 0x0714
    UINT32 SRC_COLORKEY_DR_MAX_REG; // 0x0718
    UINT32 DST_COLORKEY_CTRL_REG;   // 0x071C
    UINT32 DST_COLORKEY_DR_MIN_REG; // 0x0720
    UINT32 DST_COLORKEY_DR_MAX_REG; // 0x0724

} G2D_REG, *PG2D_REG;

 
#ifdef __cplusplus
}
#endif


#endif /*__G2D_REG_H__*/
