//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: dramcon_reg.h
//
//  Defines the DRAM controller CPU register layout and definitions.
//
#ifndef __S5PV210_DRAMCON_H
#define __S5PV210_DRAMCON_H

#if __cplusplus
    extern "C"
    {
#endif


//------------------------------------------------------------------------------
//  Type: DRAMCON_REG
//
//  DRAM controller register layout. This register bank is located
//  by the constant CPU_BASE_REG_XX_DMCX in the configuration file
//  cpu_base_reg_cfg.h.
//

//------------------------------------------------------------------------------
// Currently, following structure is not used.. 
typedef struct
{
    UINT32 CON_CONTROL;                  // 0x00
    UINT32 MEM_CONTROL;                  // 0x04
    UINT32 MEM_CONFIG0;                  // 0x08
    UINT32 MEM_CONFIG1;                  // 0x0c
    UINT32 DIRECT_CMD;                   // 0x10
    UINT32 PRECH_CONFIG;                 // 0x14
    UINT32 PHY_CONTROL0;                 // 0x18
    UINT32 PHY_CONTROL1;                 // 0x1c
    UINT32 PAD0[2];                      // 0x20-24
    UINT32 PWRDN_CONFIG;                 // 0x28
    UINT32 PAD1;                         // 0x2C
    UINT32 TIMING_AREF;                  // 0x30
    UINT32 TIMING_ROW;                   // 0x34
    UINT32 TIMING_DATA;                   // 0x38
    UINT32 TIMING_POWER;                 // 0x3c
    UINT32 PHY_STATUS;                   // 0x40-44
    UINT32 CHIP0_STATUS;                 // 0x48
    UINT32 CHIP1_STATUS;                 // 0x4c
    UINT32 AREF_STATUS;                  // 0x50
    UINT32 MR_STATUS;                    // 0x54
    UINT32 PHY_TEST0;                    // 0x58
    UINT32 PHY_TEST1;                    // 0x5c
    UINT32 QOS_CONTROL0;                 // 0x60
    UINT32 QOS_CONFIG0;                  // 0x64
    UINT32 QOS_CONTROL1;                 // 0x68
    UINT32 QOS_CONFIG1;                  // 0x6c
    UINT32 QOS_CONTROL2;                 // 0x70
    UINT32 QOS_CONFIG2;                  // 0x74
    UINT32 QOS_CONTROL3;                 // 0x78
    UINT32 QOS_CONFIG3;                  // 0x7c
    UINT32 QOS_CONTROL4;                 // 0x80
    UINT32 QOS_CONFIG4;                  // 0x84
    UINT32 QOS_CONTROL5;                 // 0x88
    UINT32 QOS_CONFIG5;                  // 0x8c
    UINT32 QOS_CONTROL6;                 // 0x90
    UINT32 QOS_CONFIG6;                  // 0x94
    UINT32 QOS_CONTROL7;                 // 0x98
    UINT32 QOS_CONFIG7;                  // 0x9c
    UINT32 QOS_CONTROL8;                 // 0xA0
    UINT32 QOS_CONFIG8;                  // 0xA4
    UINT32 QOS_CONTROL9;                 // 0xA8
    UINT32 QOS_CONFIG9;                  // 0xAc
    UINT32 QOS_CONTROL10;                // 0xB0
    UINT32 QOS_CONFIG10;                 // 0xB4
    UINT32 QOS_CONTRPL11;                // 0xB8
    UINT32 QOS_CONFIG11;                 // 0xBc
    UINT32 QOS_CONTROL12;                // 0xC0
    UINT32 QOS_CONFIG12;                 // 0xC4
    UINT32 QOS_CONTROL13;                // 0xC8
    UINT32 QOS_CONFIG13;                 // 0xCc
    UINT32 QOS_CONTROL14;                // 0xD0
    UINT32 QOS_CONFIG14;                 // 0xD4
    UINT32 QOS_CONTROL15;                // 0xD8
    UINT32 QOS_CONFIG15;                 // 0xDc    

} DRAMCON_REG, *PDRAMCON_REG;


#if __cplusplus
    }
#endif

#endif    // __S5PV210_DRAMCON_H
