//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: dma_reg.h
//
//  Defines the DMA Controller CPU register layout and
//  definitions.
//
#ifndef __S5PV210_DMA_H
#define __S5PV210_DMA_H

#if __cplusplus
    extern "C"
    {
#endif


//------------------------------------------------------------------------------
//  Type: DMAC_REG
//
//  Defines the DMA register layout. This register bank is located by the
//  constant CPU_REG_BASE_XX_DMAX in the configuration file reg_base_cfg.h.
//

typedef struct
{
    UINT32 SrcAddr; //4 
    UINT32 DstAddr; 
    UINT32 CHCtrl; 
    UINT32 LoopCnt0; 
    UINT32 LoopCnt1; 
    UINT32 PAD[3];
}DMA_STATUS_REG;

typedef struct
{
    UINT32 Dmastaus;            // 0x000
    UINT32 Dmapc;            // 0x004
    UINT32 PAD0[6];

    UINT32 IntEnable;                // 0x020
    UINT32 EveStatus;            // 0x024
    UINT32 IntStatus;            // 0x028
    UINT32 IntClear;            // 0x02c

    UINT32 FaultStatusManager; // 0x030
    UINT32 FaultStatusChannel;        // 0x034
    UINT32 FaultTypeManager;        // 0x038
    UINT32 PAD1[1];                 // 0x03c


    UINT32 FaultType[8];        // 0x040
    UINT32 PAD2[40];

    UINT32 CHStatusCH0; // 0x100
    UINT32 CHPCCH0; // 0x104
    UINT32 CHStatusCH1;        // 0x108
    UINT32 CHPCCH1;        // 0x10c
    UINT32 CHStatusCH2; // 0x110
    UINT32 CHPCCH2;        // 0x114
    UINT32 CHStatusCH3;        // 0x118
    UINT32 CHPCCH3;        // 0x11c
    UINT32 CHStatusCH4;        // 0x120
    UINT32 CHPCCH4;        // 0x124
    UINT32 CHStatusCH5; // 0x128
    UINT32 CHPCCH5;        // 0x12c
    UINT32 CHStatusCH6;        // 0x130
    UINT32 CHPCCH6;        // 0x134
    UINT32 CHStatusCH7;        // 0x138
    UINT32 CHPCCH7;        // 0x13c    
    UINT32 PAD3[176];

    DMA_STATUS_REG CHStatus[8]; // 0x400

    UINT32 PAD4[512];

    UINT32 DbgStatus; // 0xD00
    UINT32 DbgCMD;        // 0xD04
    UINT32 DbgINST0; // 0xD08
    UINT32 DbgINST1;        // 0xD0c

    UINT32 PAD5[60];


    UINT32 ConfigReg[6];        // 0xE00
    UINT32 PAD6[114];

    UINT32 PeriID[4];        // 0xFE0
    UINT32 PrimeCellID[4];        // 0xFF0        

    
} DMAC_REG, *PDMAC_REG;


//------------------------------------------------------------------------------

#if __cplusplus
    }
#endif

#endif    // __S5PV210_DMA_H
