//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: displaycon_reg.h
//
//  Defines the Display Controller CPU register layout and definitions.
//
#ifndef __DISPLAYCON_REG_H
#define __DISPLAYCON_REG_H

#define DISPCON_IP_VER    (600)       // FIMD_VER 6.0

#if __cplusplus
    extern "C"
    {
#endif

//------------------------------------------------------------------------------
//  Type: DISPLAY_REG
//
//  Display Controller registers. This register bank is located by the constant
//  CPU_BASE_REG_XX_DISPLAY in the configuration file cpu_base_reg_cfg.h.
//

#if (DISPCON_IP_VER>=600)
typedef struct
{
    UINT32 VIDCON0;         // 0x00
    UINT32 VIDCON1;         // 0x04
    UINT32 VIDCON2;         // 0x08
    UINT32 VIDCON3;         // 0x0c

    UINT32 VIDTCON0;        // 0x10
    UINT32 VIDTCON1;        // 0x14
    UINT32 VIDTCON2;        // 0x18
    UINT32 VIDTCON3;        // 0x1c

    UINT32 WINCON0;         // 0x20
    UINT32 WINCON1;         // 0x24
    UINT32 WINCON2;         // 0x28
    UINT32 WINCON3;         // 0x2c
    UINT32 WINCON4;         // 0x30
    UINT32 SHADOWCON;       // 0x34
    UINT32 PAD1[2];         // 0x38~0x3f

    UINT32 VIDOSD0A;        // 0x40
    UINT32 VIDOSD0B;        // 0x44
    UINT32 VIDOSD0C;        // 0x48
    UINT32 PAD2[1];         // 0x4c

    union{
        struct {
            UINT32  Reserved        :10;    //< RESERVED
            UINT32  OSD_LeftTopX_F  :11;    //< Horizontal Screen Coordinate for LeftTop Pixel of OSD Image
            UINT32  OSD_LeftTopY_F  :11;    //< Vertical Screen Coordinate for LeftTop Pixel of OSD Image
        } VIDOSD1ABITFIELD;
        UINT32 VIDOSD1A;        // 0x50
    };
    union{
        struct {
            UINT32  Reserved        :10;    //< RESERVED
            UINT32  OSD_RightBotX_F :11;    //< Horizontal Screen Coordinate for RightBottom Pixel of OSD Image
            UINT32  OSD_RightBotY_F :11;    //< Vertical Screen Coordinate for RightBottom Pixel of OSD Image
        } VIDOSD1BBITFIELD;
        UINT32 VIDOSD1B;        // 0x54
    };
    union{
        struct {
            UINT32  Reserved1       : 7;
            UINT32  Reserved2       : 1;
            UINT32  ALPHA0_R_H      : 4;
            UINT32  ALPHA0_G_H      : 4;
            UINT32  ALPHA0_B_H      : 4;
            UINT32  ALPHA1_R_H      : 4;
            UINT32  ALPHA1_G_H      : 4;
            UINT32  ALPHA1_B_H      : 4;
        } VIDOSD1CBITFIELD;
        UINT32 VIDOSD1C;        // 0x58
    };
    union{
        struct {
            UINT32  Reserved1       : 6;    //< RESERVED
            UINT32  Reserved2       : 2;    //< RESERVED (Should Be Zero)
            UINT32  OSDSIZE         :24;    //< Window Size (Height*Width, in Number of Word)
        } VIDOSD1DBITFIELD;
        UINT32 VIDOSD1D;        // 0x5c
    };
    UINT32 VIDOSD2A;        // 0x60
    UINT32 VIDOSD2B;        // 0x64
    UINT32 VIDOSD2C;        // 0x68
    UINT32 VIDOSD2D;        // 0x6c

    UINT32 VIDOSD3A;        // 0x70
    UINT32 VIDOSD3B;        // 0x74
    UINT32 VIDOSD3C;        // 0x78
    UINT32 PAD3[1];         // 0x7c

    UINT32 VIDOSD4A;        // 0x80
    UINT32 VIDOSD4B;        // 0x84
    UINT32 VIDOSD4C;        // 0x88
    UINT32 PAD4[5];         // 0x8c~0x9f

    UINT32 VIDW00ADD0B0;    // 0xa0
    UINT32 VIDW00ADD0B1;    // 0xa4
    UINT32 VIDW01ADD0B0;    // 0xa8
    UINT32 VIDW01ADD0B1;    // 0xac

    UINT32 VIDW02ADD0B0;    // 0xb0
    UINT32 VIDW02ADD0B1;    // 0xb4
    UINT32 VIDW03ADD0B0;    // 0xb8
    UINT32 VIDW03ADD0B1;    // 0xbc

    UINT32 VIDW04ADD0B0;    // 0xc0
    UINT32 VIDW04ADD0B1;    // 0xc4
    UINT32 PAD5[2];         // 0xc8~0xcf

    UINT32 VIDW00ADD1B0;    // 0xd0
    UINT32 VIDW00ADD1B1;    // 0xd4
    UINT32 VIDW01ADD1B0;    // 0xd8
    UINT32 VIDW01ADD1B1;    // 0xdc

    UINT32 VIDW02ADD1B0;    // 0xe0
    UINT32 VIDW02ADD1B1;    // 0xe4
    UINT32 VIDW03ADD1B0;    // 0xe8
    UINT32 VIDW03ADD1B1;    // 0xec

    UINT32 VIDW04ADD1B0;    // 0xf0
    UINT32 VIDW04ADD1B1;    // 0xf4
    UINT32 PAD6[2];         // 0xf8~0xff


    UINT32 VIDW00ADD2;      // 0x100
    UINT32 VIDW01ADD2;      // 0x104
    UINT32 VIDW02ADD2;      // 0x108
    UINT32 VIDW03ADD2;      // 0x10c
    UINT32 VIDW04ADD2;      // 0x110
    UINT32 PAD7[1];         // 0x114
    UINT32 VP1TCON0;        // 0x118
    UINT32 VP1TCON1;        // 0x11c

    UINT32 PAD8[4];         // 0x120~0x12f

    UINT32 VIDINTCON0;      // 0x130
    UINT32 VIDINTCON1;      // 0x134
    UINT32 PAD9[2];         // 0x138~0x13f

    UINT32 W1KEYCON0;       // 0x140
    UINT32 W1KEYCON1;       // 0x144
    UINT32 W2KEYCON0;       // 0x148
    UINT32 W2KEYCON1;       // 0x14c
    UINT32 W3KEYCON0;       // 0x150
    UINT32 W3KEYCON1;       // 0x154
    UINT32 W4KEYCON0;       // 0x158
    UINT32 W4KEYCON1;       // 0x15c

    UINT32 W1KEYALPHA;      // 0x160
    UINT32 W2KEYALPHA;      // 0x164
    UINT32 W3KEYALPHA;      // 0x168
    UINT32 W4KEYALPHA;      // 0x16C

    UINT32 DITHMODE;        // 0x170
    UINT32 PAD10[3];        // 0x174~0x17f

    UINT32 WIN0MAP;         // 0x180
    UINT32 WIN1MAP;         // 0x184
    UINT32 WIN2MAP;         // 0x188
    UINT32 WIN3MAP;         // 0x18c
    UINT32 WIN4MAP;         // 0x190
    UINT32 PAD11[2];        // 0x194~0x19b
    UINT32 WPALCON_H;       // 0x19c
    UINT32 WPALCON_L;       // 0x1a0

    union
    {
        struct
        {
            UINT32  RESERVED1       :5;
            UINT32  SWTRGCMD_W4BUF  :1;
            UINT32  TRGMODE_W4BUF   :1;
            UINT32  RESERVED2       :2;
            UINT32  SWTRGCMD_W3BUF  :1;
            UINT32  TRGMODE_W3BUF   :1;
            UINT32  RESERVED3       :2;
            UINT32  SWTRGCMD_W2BUF  :1;
            UINT32  TRGMODE_W2BUF   :1;
            UINT32  RESERVED4       :2;
            UINT32  SWTRGCMD_W1BUF  :1;
            UINT32  TRGMODE_W1BUF   :1;
            UINT32  RESERVED5       :2;
            UINT32  SWTRGCMD_W0BUF  :1;
            UINT32  TRGMODE_W0BUF   :1;
            UINT32  RESERVED6       :2;
            UINT32  SWFRSTATUS_I80  :1;
            UINT32  SWTRGCMD_I80    :1;
            UINT32  TRGMODE_I80     :1;
        } TRIGCONFIELD;
        UINT32 TRIGCON;         // 0x1a4
    };
    union
    {
        struct
        {
            UINT32 RESERVED1    :7;
            UINT32 SELVSYNC     :1;
            UINT32 DLYVSYNC     :8;
            UINT32 RESERVED2    :6;
            UINT32 I656FIELD    :1;
            UINT32 I656CLK      :1;
            UINT32 RESERVED3    :1;
            UINT32 I601HREF     :1;
            UINT32 I601VSYNC    :1;
            UINT32 I601HSYNC    :1;
            UINT32 I601FIELD    :1;
            UINT32 I601CLK      :1;
            UINT32 RESERVED4    :2;
        }ITUIFCONFIELD;
        UINT32 ITUIFCON;        // 0x1a8
    };
    UINT32 PAD12[1];        // 0x1ac

    union
    {
        struct
        {
            UINT32 RESERVED1    :12;
            UINT32 LCD_CS_SETUP :4;
            UINT32 LCD_WR_SETUP :4;
            UINT32 LCD_WR_ACT   :4;
            UINT32 LCD_WR_HOLD  :4;
            UINT32 RESERVED2    :1;
            UINT32 RSPOL        :1;
            UINT32 RESERVED3    :1;
            UINT32 I80IFEN      :1;
        }I80IFCONA0FIELD;
        UINT32 I80IFCONA0;      // 0x1b0
    };
    union
    {
        struct
        {
            UINT32 RESERVED1    :12;
            UINT32 LCD_CS_SETUP :4;
            UINT32 LCD_WR_SETUP :4;
            UINT32 LCD_WR_ACT   :4;
            UINT32 LCD_WR_HOLD  :4;
            UINT32 RESERVED2    :1;
            UINT32 RSPOL        :1;
            UINT32 RESERVED3    :1;
            UINT32 I80IFEN      :1;
        }I80IFCONA1FIELD;
        UINT32 I80IFCONA1;      // 0x1b4
    };
    union
    {
        struct
        {
            UINT32 RESERVED1        :22;
            UINT32 NORMAL_CMD_ST    :1;
            UINT32 RESERVED2        :2;
            UINT32 FRAME_SKIP       :2;
            UINT32 RESERVED3        :1;
            UINT32 AUTO_CMD_RATE    :4;
        }I80IFCONB0FIELD;
       UINT32 I80IFCONB0;      // 0x1b8
    };
    union
    {
        struct
        {
            UINT32 RESERVED1        :22;
            UINT32 NORMAL_CMD_ST    :1;
            UINT32 RESERVED2        :2;
            UINT32 FRAME_SKIP       :2;
            UINT32 RESERVED3        :1;
            UINT32 AUTO_CMD_RATE    :4;
        }I80IFCONB1FIELD;
       UINT32 I80IFCONB1;      // 0x1bc
    };

    UINT32 COLORGAINCON;    // 0x1c0
    UINT32 VESFRCON0;       // 0x1c4
    union
    {
        struct
        {
            UINT32  VE_VSIZE_F      :11;
            UINT32  VE_HSIZE_F      :11;
            UINT32  VE_MUXSEL_F     :2;
            UINT32  VE_OVCHECK_F    :1;
            UINT32  RESERVED        :7;
        } VESFRCON1FIELD;
        UINT32 VESFRCON1;       // 0x1c8
    };
    UINT32 VESFRCON2;       // 0x1cc

    UINT32 LDI_CMDCON0;     // 0x1d0
    UINT32 LDI_CMDCON1;     // 0x1d4
    UINT32 PAD13[2];        // 0x1d8~0x1df

    UINT32 SIFCCON0;        // 0x1e0
    UINT32 SIFCCON1;        // 0x1e4
    UINT32 SIFCCON2;        // 0x1e8

    UINT32 HUECOEF00;       // 0x1ec
    UINT32 HUECOEF01;       // 0x1f0
    UINT32 HUECOEF10;       // 0x1f4
    UINT32 HUECOEF11;       // 0x1f8
    UINT32 HUEOFFSET;       // 0x1fc

    UINT32 VIDW0ALPHA0;     // 0x200
    UINT32 VIDW0ALPHA1;     // 0x204
    UINT32 VIDW1ALPHA0;     // 0x208
    UINT32 VIDW1ALPHA1;     // 0x20c

    UINT32 VIDW2ALPHA0;     // 0x210
    UINT32 VIDW2ALPHA1;     // 0x214
    UINT32 VIDW3ALPHA0;     // 0x218
    UINT32 VIDW3ALPHA1;     // 0x21c

    UINT32 VIDW4ALPHA0;     // 0x220
    UINT32 VIDW4ALPHA1;     // 0x224

    UINT32 PAD14[7];        // 0x228~0x243

    UINT32 BLENDEQ1;        // 0x244
    UINT32 BLENDEQ2;        // 0x248
    UINT32 BLENDEQ3;        // 0x24c
    UINT32 BLENDEQ4;        // 0x250
    UINT32 PAD15[3];        // 0x254~0x25f
    UINT32 BLENDCON;        // 0x260

    UINT32 W0RTQOSCON;      // 0x264
    UINT32 W1RTQOSCON;      // 0x268
    UINT32 W2RTQOSCON;      // 0x26c
    UINT32 W3RTQOSCON;      // 0x270
    UINT32 W4RTQOSCON;      // 0x274
    UINT32 GPOUTCON0;       // 0x278
    UINT32 DUALCON;         // 0x27c

    UINT32 LDI_CMD0;        // 0x280
    UINT32 LDI_CMD1;        // 0x284
    UINT32 LDI_CMD2;        // 0x288
    UINT32 LDI_CMD3;        // 0x28c

    UINT32 LDI_CMD4;        // 0x290
    UINT32 LDI_CMD5;        // 0x294
    UINT32 LDI_CMD6;        // 0x298
    UINT32 LDI_CMD7;        // 0x29c

    UINT32 LDI_CMD8;        // 0x2a0
    UINT32 LDI_CMD9;        // 0x2a4
    UINT32 LDI_CMD10;       // 0x2a8
    UINT32 LDI_CMD11;       // 0x2ac

    UINT32 PAD17[51];       // 0x2b0~0x37b

    UINT32 GAMMALUT_01_00;  // 0x37c
    UINT32 GAMMALUT_03_02;  // 0x380
    UINT32 GAMMALUT_05_04;  // 0x384
    UINT32 GAMMALUT_07_06;  // 0x388
    UINT32 GAMMALUT_09_08;  // 0x38c
    UINT32 GAMMALUT_11_10;  // 0x390
    UINT32 GAMMALUT_13_12;  // 0x394
    UINT32 GAMMALUT_15_14;  // 0x398
    UINT32 GAMMALUT_17_16;  // 0x39c
    UINT32 GAMMALUT_19_18;  // 0x3a0
    UINT32 GAMMALUT_21_20;  // 0x3a4
    UINT32 GAMMALUT_23_22;  // 0x3a8
    UINT32 GAMMALUT_25_24;  // 0x3ac
    UINT32 GAMMALUT_27_26;  // 0x3b0
    UINT32 GAMMALUT_29_28;  // 0x3b4
    UINT32 GAMMALUT_31_30;  // 0x3b8
    UINT32 GAMMALUT_33_32;  // 0x3bc
    UINT32 GAMMALUT_35_34;  // 0x3c0
    UINT32 GAMMALUT_37_36;  // 0x3c4
    UINT32 GAMMALUT_39_38;  // 0x3c8
    UINT32 GAMMALUT_41_40;  // 0x3cc
    UINT32 GAMMALUT_43_42;  // 0x3d0
    UINT32 GAMMALUT_45_44;  // 0x3d4
    UINT32 GAMMALUT_47_46;  // 0x3d8
    UINT32 GAMMALUT_49_48;  // 0x3dc
    UINT32 GAMMALUT_51_50;  // 0x3e0
    UINT32 GAMMALUT_53_52;  // 0x3e4
    UINT32 GAMMALUT_55_54;  // 0x3e8
    UINT32 GAMMALUT_57_56;  // 0x3ec
    UINT32 GAMMALUT_59_58;  // 0x3f0
    UINT32 GAMMALUT_61_60;  // 0x3f4
    UINT32 GAMMALUT_63_62;  // 0x3f8
    UINT32 GAMMALUT_xx_64;  // 0x3fc

    UINT32 PAD18[1832];     // 0x400 ~ 0x209f

    UINT32 VIDW00ADD0B2;    // 0x20a0
    UINT32 PAD19[1];        // 0x20a4
    UINT32 VIDW01ADD0B2;    // 0x20a8
    UINT32 PAD20[1];        // 0x20ac
    UINT32 VIDW02ADD0B2;    // 0x20b0
    UINT32 PAD21[1];        // 0x20b4
    UINT32 VIDW03ADD0B2;    // 0x20b8
    UINT32 PAD22[1];        // 0x20bc
    UINT32 VIDW04ADD0B2;    // 0x20c0

    UINT32 PAD23[3];        // 0x20c4~0x20cf

    UINT32 VIDW00ADD1B2;    // 0x20d0
    UINT32 PAD24[1];        // 0x20d4
    UINT32 VIDW01ADD1B2;    // 0x20d8
    UINT32 PAD25[1];        // 0x20dc
    UINT32 VIDW02ADD1B2;    // 0x20e0
    UINT32 PAD26[1];        // 0x20e4
    UINT32 VIDW03ADD1B2;    // 0x20e8
    UINT32 PAD27[1];        // 0x20ec
    UINT32 VIDW04ADD1B2;    // 0x20f0

    UINT32 PAD28[2027];     // 0x20f4~0x409f

    UINT32 SHD_VIDW00ADD0;  // 0x40a0
    UINT32 PAD29[1];        // 0x40a4
    UINT32 SHD_VIDW01ADD0;  // 0x40a8
    UINT32 PAD30[1];        // 0x40ac
    UINT32 SHD_VIDW02ADD0;  // 0x40b0
    UINT32 PAD31[1];        // 0x40b4
    UINT32 SHD_VIDW03ADD0;  // 0x40b8
    UINT32 PAD32[1];        // 0x40bc
    UINT32 SHD_VIDW04ADD0;  // 0x40c0

    UINT32 PAD33[3];        // 0x40c4~0x40cf

    UINT32 SHD_VIDW00ADD1;  // 0x40d0
    UINT32 PAD34[1];        // 0x40d4
    UINT32 SHD_VIDW01ADD1;  // 0x40d8
    UINT32 PAD35[1];        // 0x40dc
    UINT32 SHD_VIDW02ADD1;  // 0x40e0
    UINT32 PAD36[1];        // 0x40e4
    UINT32 SHD_VIDW03ADD1;  // 0x40e8
    UINT32 PAD37[1];        // 0x40ec
    UINT32 SHD_VIDW04ADD1;  // 0x40f0

    UINT32 PAD38[3];        // 0x40f4~0x40ff

    UINT32 SHD_VIDW00ADD2;  // 0x4100
    UINT32 SHD_VIDW01ADD2;  // 0x4104
    UINT32 SHD_VIDW02ADD2;  // 0x4108
    UINT32 SHD_VIDW03ADD2;  // 0x410c
    UINT32 SHD_VIDW04ADD2;  // 0x4110

    UINT32 PAD39[(0x4800-0x4114)/4];    //0x4114~0x47ff

    UINT32 VELUT1_00[(0x400)/4];  // 0x4800~0x4Bff

    UINT32 PAD40[(0x5000-0x4C00)/4];    //0x4C00~0x4fff

    UINT32 VELUT2_000[(0x800)/4];  // 0x5000~0x57fc
} DISPLAY_REG, *PDISPLAY_REG;

#elif (DISPCON_IP_VER>=500)
typedef struct
{
    UINT32 VIDCON0;         // 0x00
    UINT32 VIDCON1;         // 0x04
    UINT32 VIDCON2;         // 0x08
    UINT32 PAD0;            // 0x0c

    UINT32 VIDTCON0;        // 0x10
    UINT32 VIDTCON1;        // 0x14
    UINT32 VIDTCON2;        // 0x18
    UINT32 VIDTCON3;        // 0x1c

    UINT32 WINCON0;         // 0x20
    UINT32 WINCON1;         // 0x24
    UINT32 WINCON2;         // 0x28
    UINT32 WINCON3;         // 0x2c

    UINT32 WINCON4;         // 0x30
    UINT32 PAD2[3];         // 0x34~3f

    UINT32 VIDOSD0A;        // 0x40
    UINT32 VIDOSD0B;        // 0x44
    UINT32 VIDOSD0C;        // 0x48
    UINT32 PAD3[1];         // 0x4c

    union{
        struct {
            UINT32  Reserved        :10;    //< RESERVED
            UINT32  OSD_LeftTopX_F  :11;    //< Horizontal Screen Coordinate for LeftTop Pixel of OSD Image
            UINT32  OSD_LeftTopY_F  :11;    //< Vertical Screen Coordinate for LeftTop Pixel of OSD Image
        } VIDOSD1ABITFIELD;
        UINT32 VIDOSD1A;        // 0x50
    };
    union{
        struct {
            UINT32  Reserved        :10;    //< RESERVED
            UINT32  OSD_RightBotX_F :11;    //< Horizontal Screen Coordinate for RightBottom Pixel of OSD Image
            UINT32  OSD_RightBotY_F :11;    //< Vertical Screen Coordinate for RightBottom Pixel of OSD Image
        } VIDOSD1BBITFIELD;
        UINT32 VIDOSD1B;        // 0x54
    };
    union{
        struct {
            UINT32  Reserved1       : 7;
            UINT32  Reserved2       : 1;
            UINT32  ALPHA0_R_H      : 4;
            UINT32  ALPHA0_G_H      : 4;
            UINT32  ALPHA0_B_H      : 4;
            UINT32  ALPHA1_R_H      : 4;
            UINT32  ALPHA1_G_H      : 4;
            UINT32  ALPHA1_B_H      : 4;
        } VIDOSD1CBITFIELD;
        UINT32 VIDOSD1C;        // 0x58
    };
    union{
        struct {
            UINT32  Reserved1       : 6;    //< RESERVED
            UINT32  Reserved2       : 2;    //< RESERVED (Should Be Zero)
            UINT32  OSDSIZE         :24;    //< Window Size (Height*Width, in Number of Word)
        } VIDOSD1DBITFIELD;
        UINT32 VIDOSD1D;        // 0x5c
    };
    UINT32 VIDOSD2A;        // 0x60
    UINT32 VIDOSD2B;        // 0x64
    UINT32 VIDOSD2C;        // 0x68
    UINT32 VIDOSD2D;        // 0x6c

    UINT32 VIDOSD3A;        // 0x70
    UINT32 VIDOSD3B;        // 0x74
    UINT32 VIDOSD3C;        // 0x78
    UINT32 PAD4[1];         // 0x7c

    UINT32 VIDOSD4A;        // 0x80
    UINT32 VIDOSD4B;        // 0x84
    UINT32 VIDOSD4C;        // 0x88
    UINT32 PAD5[1];         // 0x8c

    UINT32 PAD6[4];         // 0x90~9f

    UINT32 VIDW00ADD0B0;    // 0xa0
    UINT32 VIDW00ADD0B1;    // 0xa4
    UINT32 VIDW01ADD0B0;    // 0xa8
    UINT32 VIDW01ADD0B1;    // 0xac

    UINT32 VIDW02ADD0;      // 0xb0
    UINT32 PAD7[1];         // 0xb4
    UINT32 VIDW03ADD0;      // 0xb8
    UINT32 PAD8[1];         // 0x8c

    UINT32 VIDW04ADD0;      // 0xc0
    UINT32 PAD9[3];         // 0xc4 ~ 0xcf

    UINT32 VIDW00ADD1B0;    // 0xd0
    UINT32 VIDW00ADD1B1;    // 0xd4
    UINT32 VIDW01ADD1B0;    // 0xd8
    UINT32 VIDW01ADD1B1;    // 0xdc

    UINT32 VIDW02ADD1;      // 0xe0
    UINT32 PAD10[1];        // 0xe4
    UINT32 VIDW03ADD1;      // 0xe8
    UINT32 PAD11[1];        // 0xec

    UINT32 VIDW04ADD1;      // 0xf0
    UINT32 PAD12[3];        // 0xf4 ~ 0xff


    UINT32 VIDW00ADD2;      // 0x100
    UINT32 VIDW01ADD2;      // 0x104
    UINT32 VIDW02ADD2;      // 0x108
    UINT32 VIDW03ADD2;      // 0x10c

    UINT32 VIDW04ADD2;      // 0x110
    UINT32 PAD13_1[1];      // 0x114
    UINT32 VP1TCON0;        // 0x118
    UINT32 VP1TCON1;        // 0x11c

    UINT32 PAD14[4];        // 0x120 ~ 0x12f

    UINT32 VIDINTCON0;      // 0x130
    UINT32 VIDINTCON1;      // 0x134
    UINT32 PAD15[2];        // 0x138 ~ 0x13f

    UINT32 W1KEYCON0;       // 0x140
    UINT32 W1KEYCON1;       // 0x144
    UINT32 W2KEYCON0;       // 0x148
    UINT32 W2KEYCON1;       // 0x14c

    UINT32 W3KEYCON0;       // 0x150
    UINT32 W3KEYCON1;       // 0x154
    UINT32 W4KEYCON0;       // 0x158
    UINT32 W4KEYCON1;       // 0x15c

    UINT32 PAD16[4];        // 0x160 ~ 0x16f

    UINT32 DITHMODE;        // 0x170
    UINT32 PAD17[3];        // 0x174~17f

    UINT32 WIN0MAP;         // 0x180
    UINT32 WIN1MAP;         // 0x184
    UINT32 WIN2MAP;         // 0x188
    UINT32 WIN3MAP;         // 0x18c

    UINT32 WIN4MAP;         // 0x190
    UINT32 PAD18[2];        // 0x194 ~ 0x19b
    UINT32 WPALCON_H;       // 0x19c
    UINT32 WPALCON_L;       // 0x1a0

    UINT32 TRIGCON;         // 0x1a4
    UINT32 ITUIFCON;        // 0x1a8
    UINT32 PAD19[1];        // 0x1ac~1af

    UINT32 I80IFCONA0;      // 0x1b0
    UINT32 I80IFCONA1;      // 0x1b4
    UINT32 I80IFCONB0;      // 0x1b8
    UINT32 I80IFCONB1;      // 0x1bc

    UINT32 PAD21[4];        // 0x1c0 ~ 0x1cf

    UINT32 LDI_CMDCON0;     // 0x1d0
    UINT32 LDI_CMDCON1;     // 0x1d4
    UINT32 PAD22[2];        // 0x1d8~1df

    UINT32 SIFCCON0;        // 0x1e0
    UINT32 SIFCCON1;        // 0x1e4
    UINT32 SIFCCON2;        // 0x1e8
    UINT32 PAD23[1];        // 0x1ec

    UINT32 PAD24[4];        // 0x1f0 ~ 0x1ff

    UINT32 VIDW0ALPHA0;     // 0x200
    UINT32 VIDW0ALPHA1;     // 0x204
    UINT32 VIDW1ALPHA0;     // 0x208
    UINT32 VIDW1ALPHA1;     // 0x20c

    UINT32 VIDW2ALPHA0;     // 0x210
    UINT32 VIDW2ALPHA1;     // 0x214
    UINT32 VIDW3ALPHA0;     // 0x218
    UINT32 VIDW3ALPHA1;     // 0x21c

    UINT32 VIDW4ALPHA0;     // 0x220
    UINT32 VIDW4ALPHA1;     // 0x224

    UINT32 PAD24_1[7];      // 0x228 ~ 0x243

    UINT32 BLENDEQ1;        // 0x244
    UINT32 BLENDEQ2;        // 0x248
    UINT32 BLENDEQ3;        // 0x24c

    UINT32 BLENDEQ4;        // 0x250
    UINT32 PAD24_2[3];      // 0x254 ~ 0x25f

    UINT32 BLENDCON;        // 0x260
    UINT32 PAD24_3[7];      // 0x264 ~ 0x27f

    UINT32 LDI_CMD0;        // 0x280
    UINT32 LDI_CMD1;        // 0x284
    UINT32 LDI_CMD2;        // 0x288
    UINT32 LDI_CMD3;        // 0x28c

    UINT32 LDI_CMD4;        // 0x290
    UINT32 LDI_CMD5;        // 0x294
    UINT32 LDI_CMD6;        // 0x298
    UINT32 LDI_CMD7;        // 0x29c

    UINT32 LDI_CMD8;        // 0x2a0
    UINT32 LDI_CMD9;        // 0x2a4
    UINT32 LDI_CMD10;       // 0x2a8
    UINT32 LDI_CMD11;       // 0x2ac
} DISPLAY_REG, *PDISPLAY_REG;
/*
PALETTE MEMEMORY
{
    UINT32 PAD25[20];       // 0x2b0 ~ 0x2ff

    UINT32 PAD26[64];       // 0x300 ~ 0x3ff

    UINT32 W0PRAMSTART;     // 0x400
    UINT32 PAD28[3];        // 0x404~0x40f

    UINT32 PAD29[252];      // 0x410~0x7ff

    UINT32 W1PRAMSTART;     // 0x800
    UINT32 PAD30[3];        // 0x804~0x80f

    UINT32 PAD31[1788];      // 0x410~0x7ff

    UINT32 W0PRAMSTART_A;   // 0x2400
    UINT32 PAD32[3];        // 0x2404~0x240f

    UINT32 PAD33[252];      // 0x2410~0x27ff

    UINT32 W1PRAMSTART_A;   // 0x2800
    UINT32 PAD34[3];        // 0x2804~0x280f

    UINT32 PAD35[252];      // 0x2810~0x28ff

    UINT32 W2PRAMSTART;     // 0x2c00
    UINT32 PAD36[3];        // 0x2c04~0x2c0f

    UINT32 PAD37[252];      // 0x2c10~0x2cff

    UINT32 W3PRAMSTART;     // 0x3000
    UINT32 PAD38[3];        // 0x3004~0x300f

    UINT32 PAD39[252];      // 0x3010~0x30ff

    UINT32 W4PRAMSTART;     // 0x3400
    UINT32 PAD40[3];        // 0x3404~0x340f

    UINT32 PAD41[252];      // 0x3410~0x34ff
}
*/
#elif (DISPCON_IP_VER < 500)
typedef struct
{
    UINT32 VIDCON0;         // 0x00
    UINT32 VIDCON1;         // 0x04
    UINT32 VIDCON2;         // 0x08
    UINT32 PAD0;            // 0x0c

    UINT32 VIDTCON0;        // 0x10
    UINT32 VIDTCON1;        // 0x14
    UINT32 VIDTCON2;        // 0x18
    UINT32 VIDTCON3;        // 0x1c

    UINT32 WINCON0;         // 0x20
    UINT32 WINCON1;         // 0x24
    UINT32 WINCON2;         // 0x28
    UINT32 WINCON3;         // 0x2c

    UINT32 WINCON4;         // 0x30
    UINT32 PAD2[3];         // 0x34~3f

    UINT32 VIDOSD0A;        // 0x40
    UINT32 VIDOSD0B;        // 0x44
    UINT32 VIDOSD0C;        // 0x48
    UINT32 PAD3[1];         // 0x4c

    UINT32 VIDOSD1A;        // 0x50
    UINT32 VIDOSD1B;        // 0x54
    UINT32 VIDOSD1C;        // 0x58
    UINT32 VIDOSD1D;        // 0x5c

    UINT32 VIDOSD2A;        // 0x60
    UINT32 VIDOSD2B;        // 0x64
    UINT32 VIDOSD2C;        // 0x68
    UINT32 VIDOSD2D;        // 0x6c

    UINT32 VIDOSD3A;        // 0x70
    UINT32 VIDOSD3B;        // 0x74
    UINT32 VIDOSD3C;        // 0x78
    UINT32 PAD4[1];         // 0x7c

    UINT32 VIDOSD4A;        // 0x80
    UINT32 VIDOSD4B;        // 0x84
    UINT32 VIDOSD4C;        // 0x88
    UINT32 PAD5[1];         // 0x8c

    UINT32 PAD6[4];         // 0x90~9f

    UINT32 VIDW00ADD0B0;    // 0xa0
    UINT32 VIDW00ADD0B1;    // 0xa4
    UINT32 VIDW01ADD0B0;    // 0xa8
    UINT32 VIDW01ADD0B1;    // 0xac

    UINT32 VIDW02ADD0;      // 0xb0
    UINT32 PAD7[1];         // 0xb4
    UINT32 VIDW03ADD0;      // 0xb8
    UINT32 PAD8[1];         // 0x8c

    UINT32 VIDW04ADD0;      // 0xc0
    UINT32 PAD9[3];         // 0xc4 ~ 0xcf

    UINT32 VIDW00ADD1B0;    // 0xd0
    UINT32 VIDW00ADD1B1;    // 0xd4
    UINT32 VIDW01ADD1B0;    // 0xd8
    UINT32 VIDW01ADD1B1;    // 0xdc

    UINT32 VIDW02ADD1;      // 0xe0
    UINT32 PAD10[1];        // 0xe4
    UINT32 VIDW03ADD1;      // 0xe8
    UINT32 PAD11[1];        // 0xec

    UINT32 VIDW04ADD1;      // 0xf0
    UINT32 PAD12[3];        // 0xf4 ~ 0xff


    UINT32 VIDW00ADD2;      // 0x100
    UINT32 VIDW01ADD2;      // 0x104
    UINT32 VIDW02ADD2;      // 0x108
    UINT32 VIDW03ADD2;      // 0x10c

    UINT32 VIDW04ADD2;      // 0x110
    UINT32 PAD13_1[1];      // 0x114
    UINT32 PAD13_2[2];      // 0x118 ~ 0x11c

    UINT32 PAD14[4];        // 0x120 ~ 0x12f

    UINT32 VIDINTCON0;      // 0x130
    UINT32 VIDINTCON1;      // 0x134
    UINT32 PAD15[2];        // 0x138 ~ 0x13f

    UINT32 W1KEYCON0;       // 0x140
    UINT32 W1KEYCON1;       // 0x144
    UINT32 W2KEYCON0;       // 0x148
    UINT32 W2KEYCON1;       // 0x14c

    UINT32 W3KEYCON0;       // 0x150
    UINT32 W3KEYCON1;       // 0x154
    UINT32 W4KEYCON0;       // 0x158
    UINT32 W4KEYCON1;       // 0x15c

    UINT32 PAD16[4];        // 0x160 ~ 0x16f

    UINT32 DITHMODE;        // 0x170
    UINT32 PAD17[3];        // 0x174~17f

    UINT32 WIN0MAP;         // 0x180
    UINT32 WIN1MAP;         // 0x184
    UINT32 WIN2MAP;         // 0x188
    UINT32 WIN3MAP;         // 0x18c

    UINT32 WIN4MAP;         // 0x190
    UINT32 PAD18[2];        // 0x194 ~ 0x19b
    UINT32 PAD18_1[1];      // 0x19c
    UINT32 WPALCON;         // 0x1a0

    UINT32 TRIGCON;         // 0x1a4
    UINT32 PAD19_1[1];      // 0x1a8
    UINT32 PAD19[1];        // 0x1ac~1af

    UINT32 I80IFCONA0;      // 0x1b0
    UINT32 I80IFCONA1;      // 0x1b4
    UINT32 I80IFCONB0;      // 0x1b8
    UINT32 I80IFCONB1;      // 0x1bc

    UINT32 PAD21[4];        // 0x1c0 ~ 0x1cf

    UINT32 LDI_CMDCON0;     // 0x1d0
    UINT32 LDI_CMDCON1;     // 0x1d4
    UINT32 PAD22[2];        // 0x1d8~1df

    UINT32 SIFCCON0;        // 0x1e0
    UINT32 SIFCCON1;        // 0x1e4
    UINT32 SIFCCON2;        // 0x1e8
    UINT32 PAD23[1];        // 0x1ec

    UINT32 PAD24[35];     // 0x1f0 ~ 0x27f

    UINT32 LDI_CMD0;        // 0x280
    UINT32 LDI_CMD1;        // 0x284
    UINT32 LDI_CMD2;        // 0x288
    UINT32 LDI_CMD3;        // 0x28c

    UINT32 LDI_CMD4;        // 0x290
    UINT32 LDI_CMD5;        // 0x294
    UINT32 LDI_CMD6;        // 0x298
    UINT32 LDI_CMD7;        // 0x29c

    UINT32 LDI_CMD8;        // 0x2a0
    UINT32 LDI_CMD9;        // 0x2a4
    UINT32 LDI_CMD10;       // 0x2a8
    UINT32 LDI_CMD11;       // 0x2ac

    UINT32 PAD25[20];       // 0x2b0 ~ 0x2ff

    UINT32 W2PDATA01;       // 0x300
    UINT32 W2PDATA23;       // 0x304
    UINT32 W2PDATA45;       // 0x308
    UINT32 W2PDATA67;       // 0x30c

    UINT32 W2PDATA89;       // 0x310
    UINT32 W2PDATAAB;       // 0x314
    UINT32 W2PDATACD;       // 0x318
    UINT32 W2PDATAEF;       // 0x31c

    UINT32 W3PDATA01;       // 0x320
    UINT32 W3PDATA23;       // 0x324
    UINT32 W3PDATA45;       // 0x328
    UINT32 W3PDATA67;       // 0x32c

    UINT32 W3PDATA89;       // 0x330
    UINT32 W3PDATAAB;       // 0x334
    UINT32 W3PDATACD;       // 0x338
    UINT32 W3PDATAEF;       // 0x33c

    UINT32 W4PDATA01;       // 0x340
    UINT32 W4PDATA23;       // 0x344
    UINT32 PAD26[2];        // 0x348~0x34f

    UINT32 PAD27[44];       // 0x350~0x3ff

    UINT32 W0PRAMSTART;     // 0x400
    UINT32 PAD28[3];        // 0x404~0x40f

    UINT32 PAD29[252];      // 0x410~0x7ff

    UINT32 W1PRAMSTART;     // 0x800
} DISPLAY_REG, *PDISPLAY_REG;
#endif  // DISPCON_IP_VER


#if __cplusplus
}
#endif

#endif    // __DISPLAYCON_REG_H
