#ifndef __DBGSERIAL_H
#define __DBGSERIAL_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//
//  Defines: 
//

// Flags to denote the serial port status
#define UART_INITIALIZED	(0)
#define UART_NOT_READY		(1 << 0)
#define UART_SUPPRESSED		(1 << 1)


#define DEFAULT_DEBUG_BAUDRATE		115200
#define DEBUG_UART_ULCON            ((0<<6)|(0<<3)|(0<<2)|(3<<0))              // 8 bits, 1 stop, no parity
#define DEBUG_UART_UCON             ((0<<10)|(1<<9)|(1<<8)|(0<<7)|(0<<6)|(0<<5)|(0<<4)|(1<<2)|(1<<0))              // PCLKPSYS divide, Polling
#define DEBUG_UART_UFCON         	((0<<6)|(0<<4)|(0<<2)|(0<<1)|(0<<0))		// disable FIFO
#define DEBUG_UART_UMCON         	((0<<5)|(0<<4)|(0<<0))                       // Disable Auto Flow Control


//------------------------------------------------------------------------------
//
//  Function Prototypes
//
void OEMInitDebugSerial(void);

void OEMWriteDebugString(unsigned short *str);
VOID OEMWriteDebugByte(UINT8 ch);
int OEMReadDebugByte();

void OEMWriteDebugLED(UINT16 Index, DWORD Pattern);

//  Disables this library to send data through the serial port
void OEMSupressDebug(BOOL supress);


#if __cplusplus
}
#endif

#endif

