//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header:  chipid_reg.h
//
//  Defines the CHIP ID register layout and associated types
//  and constants.
//

#ifndef __S5PV210_CHIPID_H
#define __S5PV210_CHIPID_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//
//  Type:  CHIPID_REG
//
//  System Clock Controller registers. This register bank is located by the
//  constant BASE_REG_CMU_XX in the configuration file
//  reg_base_cfg.h.
//


typedef struct  // Base Addr : 0xE000_0000
{
    UINT32      PRO_ID;
    UINT32      OMR;
}   CHIPID_REG, *PCHIPID_REG;

#if __cplusplus
    }
#endif

#endif    // __S5PV210_CHIPID_H

