#ifndef __ARGS_H
#define __ARGS_H

//------------------------------------------------------------------------------
//
// File:        args.h
//
// Description: This header file defines device structures and constant related
//              to boot configuration. BOOT_CFG structure defines layout of
//              persistent device information. It is used to control boot
//              process. BSP_ARGS structure defines information passed from
//              boot loader to kernel HAL/OAL. Each structure has version
//              field which should be updated each time when structure layout
//              change.
//
//------------------------------------------------------------------------------

#include "oal_args.h"
#include "oal_kitl.h"
#include "drvmsg.h"
#include "clkinfo.h"

#define BSP_ARGS_VERSION    1

#define NUMOFINTRDAISYCHAIN         4
#ifdef BSP_USEDVFS
#define NUMOFDVFSLEVEL              4
#endif
//------------------------------------------------------------------------------
//
//  Define:  OAL_ARG_QUERY_xxx
//
#define OAL_ARGS_QUERY_KITLBOOT     	6
#define OAL_ARGS_QUERY_USER_HIVE_CLEAN	7
#define OAL_ARGS_QUERY_SYS_HIVE_CLEAN	8
#define OAL_ARGS_QUERY_CLEANBOOT		9
#define OAL_ARGS_QUERY_FORMATPART		10
#define OAL_ARGS_QUERY_DRVMASK			11	// Query DBGMSG mask state.
#define OAL_ARGS_QUERY_DRVMASKENABLE	12	// Query DBGMSG Enable flag.
#define OAL_ARGS_QUERY_LOGMASK			13	// Query OAL Logmask state.
#define OAL_ARGS_QUERY_LOGMASKENABLE	14	// Query OALLog Enable flag.
#define OAL_ARGS_QUERY_SYSTEMCLOCKS     15  // Query SYSTEM CLOCK definition

typedef struct {
    //---------------------------
    // BSP_ARGS Header
    OAL_ARGS_HEADER header;

    //---------------------------
    // Reset/Booting Type
    DWORD   Reset_reason;
    BOOL    fUpdateMode;                // Is the device in update mode?
    BOOL    fUpdateComplete;               
    BOOL	bKITLBoot;
    BOOL 	bCleanBoot;    
    BOOL	bCleanHive;
    BOOL    bUSBDLMode;
    BOOL 	bClearSystemHiveReg;
    BOOL	bClearUserHiveReg;
    BOOL    bFormatStorage;
    
    //---------------------------
    // KITL   
    OAL_KITL_ARGS   kitl;
    OAL_KITL_TYPE 	KITLType;
    
    //---------------------------
    // NAND UUID    
    UINT8   uuid[16];                   // NAND UUID

    //---------------------------
    // Device ID/ UUID
    UINT8   deviceID[16];			    // Device identification
    UINT8   deviceUUID[16];			    // Device unique identification

    //---------------------------
    // ADC   
    BOOL    bDCDetected;                // 1:Inserted. 0:extracted.
    BOOL    bPowerStatus;               // 1:AC status 0:DC status 

    //---------------------------
    // USB MSF
    HANDLE  SDCardDetectEvent;        //For USB MSF , check SD Card insert & remove.
    DWORD   SDCardState;              //For USB MSF , check SD Card insert & remove.

    //---------------------------
    // LPAudio
    BOOL    bLPAudioEn;   
    BOOL    bLPDisplayOff;
    BOOL    bLPUSBPlug;    
    BOOL    bLPWaveDown;

    BOOL    bAugStateLPMode;    // Augmented Power state is in NORMAL,LP_READY (FALSE), CREEP, ABYSS(TRUE).
    BOOL    bAugStateCreepMode;    // LP Driver working mode : LB(TRUE), SB(FALSE), which is in LP_CREEP, CP_ABYSS of augmented Power state
    DWORD   dwCreepModeInfo;         // LP Driver working information : dwMinPlayTime, if 0, do not check the dwLPmode
    DWORD	LPWakeUpSrc[NUMOFINTRDAISYCHAIN]; // VIC	source mask for each LP wakeup
    //---------------------------
    // Messages    
    BOOL    bNoSerialMSG;
    BOOL    bUseOALLOG;
    BOOL    bUseDRVMSG;
   	DWORD   dwOALLogMask;
 	DWORD	dwDrvMsgMask[DRVLOG_PART_NUM];	// Should match the size with g_DrvMsgMask[DRVLOG_PART_NUM] in drvmsg.h	

    //---------------------------
    // System Clock
    SYSTEM_CLOCK   SystemClocks;
    
    //---------------------------
    // Test
    DWORD   dwSystemTest;
    
    //---------------------------
    // PMIC
	BYTE 	PMICSetting_Init[3];
	BYTE 	PMICSetting_Sleep[2]; 
	
    // Initializing to comparation count for error compensation by RTC Tick 
    BOOL   bTickCountInit;

#ifdef BSP_USEDVFS
    BOOL    DVFSTransitionDone;
	SHORT	PowerLevelReMapTable[NUMOFDVFSLEVEL];	  // Remap the Power level:	this	is for changing	power level range, Emergency	Level up.,	etc
    int     CurrentPowerLevel;                        // Current DVFS Power level
	DWORD	EmergencyLevelUpMsk[NUMOFINTRDAISYCHAIN]; // VIC	source mask for each Emergency Level up
    DWORD   CPU_RunTime;                              // Total running time by msec
    DWORD   CPU_IdleTime;                             // Idle  running time by msec
    DWORD   LevelUpMargin;                            // Level up percent(128based) for current power level
    DWORD   LevelDnMargin;                            // Level down percent(128based) for current power level
    DWORD   MonitoringTime;
    SHORT   DVFSTransitLock;                          // Application Remap table Semaphore

    // This is used for the future.
//    DWORD        BUS_RunTime;
//    DWORD        BUS_IdleTime;
#endif

	BOOL    bDVFSDisable;
	
#ifdef SDMMC_BOOT
	DWORD dwIssueStartTick;
	DWORD dwB4Memcpy;
	DWORD dwAfterMemcpy;
	DWORD dwGetinDoneTransfer;
	DWORD dwCount;
	DWORD dwStartTick;
	DWORD dwEndTick;
	DWORD dwCallBackFunction;	
	DWORD dwISRTick;
	DWORD dwISTTick;
	DWORD dwCountISR;
	DWORD dwNewISRTick[12];
	DWORD dwIssueEndTick;

	DWORD dwOneSectorRead;
	DWORD dwOneSectorWrite;
	DWORD dw2_4SectorRead;
	DWORD dw2_4SectorWrite;
	DWORD dw5_8SectorRead;	
	DWORD dw5_8SectorWrite;
	DWORD dw9_16SectorRead;
	DWORD dw9_16SectorWrite;
	DWORD dw17_32SectorRead;
	DWORD dw17_32SectorWrite;	
	DWORD dw33_64SectorRead;
	DWORD dw33_64SectorWrite;		
	DWORD dw65_128SectorRead;
	DWORD dw65_128SectorWrite;			
	DWORD dw128_256SectorRead;
	DWORD dw128_256SectorWrite;	
	DWORD dw257SectorRead;
	DWORD dw257SectorWrite;	

	DWORD dwOneFATSectorRead;
	DWORD dwOneFATSectorWrite;
	DWORD dw2_4FATSectorRead;
	DWORD dw2_4FATSectorWrite;
	DWORD dw5_8FATSectorRead;	
	DWORD dw5_8FATSectorWrite;
	DWORD dw9_16FATSectorRead;
	DWORD dw9_16FATSectorWrite;
	DWORD dw17_32FATSectorRead;
	DWORD dw17_32FATSectorWrite;	
	DWORD dw33_64FATSectorRead;
	DWORD dw33_64FATSectorWrite;		
	DWORD dw65_128FATSectorRead;
	DWORD dw65_128FATSectorWrite;			
	DWORD dw128_256FATSectorRead;
	DWORD dw128_256FATSectorWrite;	
	DWORD dw257FATSectorRead;
	DWORD dw257FATSectorWrite;	

	DWORD dwOneSDSectorRead;
	DWORD dwOneSDSectorWrite;
	DWORD dw2_4SDSectorRead;
	DWORD dw2_4SDSectorWrite;
	DWORD dw5_8SDSectorRead;	
	DWORD dw5_8SDSectorWrite;
	DWORD dw9_16SDSectorRead;
	DWORD dw9_16SDSectorWrite;
	DWORD dw17_32SDSectorRead;
	DWORD dw17_32SDSectorWrite;	
	DWORD dw33_64SDSectorRead;
	DWORD dw33_64SDSectorWrite;		
	DWORD dw65_128SDSectorRead;
	DWORD dw65_128SDSectorWrite;			
	DWORD dw128_256SDSectorRead;
	DWORD dw128_256SDSectorWrite;	
	DWORD dw257SDSectorRead;
	DWORD dw257SDSectorWrite;	
	

	DWORD dwStartTime;	
#endif
} BSP_ARGS;

// external variables
extern BSP_ARGS *g_pBSPArgs;

//------------------------------------------------------------------------------
//
//  Function:  OALArgsInit
//
//  This function is called by other OAL modules to intialize value of argument
//  structure.
//
VOID OALArgsInit(BSP_ARGS *pBSPArgs);
VOID OALArgsChange(void* pData, UINT32 size);

//------------------------------------------------------------------------------

typedef struct
{
    BOOL               bLPModeSupport;
    DWORD              dwDeviceID;
    DWORD              dwMsg;
    DWORD              dwLParam;
    DWORD              dwRParam;
} MSG_DEV_STATE;

#define OEMPM_MSGQ_NAME    (TEXT("PWC_MSGQUE"))

// Struct for IOCTRL : IOCTL_DVFS_GET_STATUS
typedef struct
{
	DWORD	dwCurrentPowerLevel;	// Current DVFS level
	DWORD	dwRunningTime;			// Snapshot of accumulated running time
	DWORD	dwIdleTime;			// Snapshot of accumulated idle time
	DWORD	dwDurationTime;			// Snapshot of current Duration time
	DWORD	dwSupremumRatio;		// Supremum ratio of stability region, based on 128
	DWORD	dwInfimumRatio;			// Infimum ratio of stability region, , based on 128
	DWORD	dwMaxLevel;				// Maximum DVFS level
	DWORD	dwMinLevel;				// Minimum DVFS level
	BOOL	bDVFSDisabled;			// Flag for DVFS working
} INFO_DVFS_STATUS, *PINFO_DVFS_STATUS;

 //* MSG_DEV_STATE.dwMsg Flag ********************************************************/
// Driver -> Power Control
#define DTOP_BASE_INDEX       100
#define DTOP_POWER_SET        (DTOP_BASE_INDEX+0)   // Set Device Power Level,                  | dwLParam = Dx, dwRParam = Don't care
#define DTOP_LP_ACTIVE          (DTOP_BASE_INDEX+1)   // Activate LP Mode
#define DTOP_LP_DEACTIVE      (DTOP_BASE_INDEX+2)   // Deactivate LP Mode
#define DTOP_LP_INFO             (DTOP_BASE_INDEX+3)    // DeepIdle Time ex) MinLPPlayTime
#define DTOP_LP_WKUP            (DTOP_BASE_INDEX+4)     // DeepIdle Wakeup Interrupt registrization  | dwLParam = Physical IRQ ID, dwRParam = 1 (ADD), 0 (DEL)
#define DTOP_DVFS_EMGR        (DTOP_BASE_INDEX+5)     // DVFS Emergency Level up interrupt registration | dwLParam = Physical IRQ ID, dwRParam = 1 (ADD), 0 (DEL)

// Power Control -> Driver
#define PTOD_BASE_INDEX       200
#define PTOD_LP_MODE     (PTOD_BASE_INDEX+0)    // Working mode in Deep Idle ex)DPIDLE_SB/LB
//***********************************************************************************/
  // dwLParam
#define PWRMSG_WAV_INDEX 300
#define WAV_NORMAL_SB (PWRMSG_WAV_INDEX + 0)
#define WAV_NORMAL_LB (PWRMSG_WAV_INDEX + 1)
#define WAV_DPIDLE_SB (PWRMSG_WAV_INDEX + 2)
#define WAV_DPIDLE_LB (PWRMSG_WAV_INDEX + 3)
#endif
