//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: adc_reg.h
//
//  Defines the analog to digital (ADC) controller CPU register layout and
//  definitions.
//
#ifndef __S5PV210_ADC_H
#define __S5PV210_ADC_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//
//  Type: ADC_REG
//
//  Defines the A/D converter's control register block. This register bank is
//  located by the constant BASE_REG_ADC in configuration file
//  base_reg_cfg.h.
//
//------------------------------------------------------------------------------

typedef struct
{
	UINT32 TSADCCON;			// 0x00 : ADC control
	UINT32 TSCON; 				// 0x04 : Touch screen control
	UINT32 TSDLY;				// 0x08 : ADC start/Interval delay
	UINT32 TSDATX;				// 0x0C : ADC conversion data X
	UINT32 TSDATY;				// 0x10 : ADC conversion data Y
	UINT32 TSPENSTAT;			// 0x14 : Pen up/down status
	UINT32 CLRINTADC;			// 0x18 : Clear ADC interrupt
	UINT32 ADCMUX;				// 0x1C : Analog input channel selection  (TSADC0 only)
	UINT32 CLRINTPEN;			// 0x20 : Clear pen down/up interrupt
} TSADC_REG, *PTSADC_REG;

/*
typedef struct
{
	UINT32 TSADCCON0;			// 0x00 : ADC control
	UINT32 TSCON0; 				// 0x04 : Touch screen control
	UINT32 TSDLY0;				// 0x08 : ADC start/Interval delay
	UINT32 TSDATX0;				// 0x0C : ADC conversion data X
	UINT32 TSDATY0;				// 0x10 : ADC conversion data Y
	UINT32 TSPENSTAT0;			// 0x14 : Pen up/down status
	UINT32 CLRINTADC0;			// 0x18 : Clear ADC interrupt
	UINT32 ADCMUX;				// 0x1C : Analog input channel selection
	UINT32 CLRINTPEN0;			// 0x20 : Clear pen down/up interrupt
} TSADC0_REG, *PTSADC0_REG;

typedef struct
{
	UINT32 TSADCCON1;			// 0x00 : ADC control
	UINT32 TSCON1; 				// 0x04 : Touch screen control
	UINT32 TSDLY1;				// 0x08 : ADC start/Interval delay
	UINT32 TSDATX1;				// 0x0C : ADC conversion data X
	UINT32 TSDATY1;				// 0x10 : ADC conversion data Y
	UINT32 TSPENSTAT1;			// 0x14 : Pen up/down status
	UINT32 CLRINTADC1;			// 0x18 : Clear ADC interrupt
	UINT32 Reserved0;			// 0x1C : Reserved
	UINT32 CLRINTPEN1;			// 0x20 : Clear pen down/up interrupt
} TSADC1_REG, *PTSADC1_REG;	
*/

#if __cplusplus
    }
#endif

#endif
