//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: USBHost.h
//
//  Defines the USBOTG controller CPU register layout and definitions.
//
#ifndef __S5PV210_USBHOST_H
#define __S5PV210_USBHOST_H

#if __cplusplus
extern "C" {
#endif


//------------------------------------------------------------------------------
//
//  Type: USBHost
//
//  Defines the USB device control register block. This register bank is
//  located by the constant BASE_REG_PA_USBHOST in configuration file
//  base_reg_cfg.h.
//

typedef struct
{
    UINT32      HCCPBASE;
    UINT32         HCSPARAMS;
    UINT32      HCCPARAMS;
    UINT32        PAD1;

    UINT32        USBCMD;
    UINT32        USBSTS;
    UINT32        USBINTR;
    UINT32        FRINDEX;
    UINT32        CTRLDSSEGMENT;
    UINT32        PERIODICLISTBASE;
    UINT32        ASYSNCLISTADDR;
    
    UINT32        PAD2[9];
    
    UINT32        CONFIGFLAG;
    UINT32        PORTSTASCTRL;
    
    UINT32        PAD3[14];
    
    UINT32        INSNREG00;
    UINT32        INSNREG01;
    UINT32        INSNREG02;
    UINT32        INSNREG03;
    UINT32        INSNREG04;    
    UINT32        INSNREG05;    
}USBEHCIHOST_REG, *PUSBEHCIHOST_REG;

typedef struct
{
    UINT32      HcRevision;
    UINT32      HcControl;
    UINT32      HcCommonStatus;
    UINT32      HcInterruptStatus;

    UINT32        HcInterruptEnable;
    UINT32        HcInterruptDisable;
    UINT32        HcHCCA;
    UINT32        HcPeriodCuttentED;
    
    UINT32        HcControlHeadED;
    UINT32        HcControlCurrentED;
    UINT32        HcBulkHeadED;
    UINT32        HcBulkCurrentED;
    
    UINT32        HcDoneHead;
    UINT32        HcRmInterval;
    UINT32        HcFmRemaining;
    UINT32        HcFmNumber;

    
    UINT32        HcPeriodicStart;
    UINT32        HcLSThreshold;
    UINT32        HcRhDescriptorA;
    UINT32        HcRhDescriptorB;
    
    UINT32        HcRhStatus;
    UINT32        HcRhPortStatus;
}USBOHCIHOST_REG, *PUSBOHCIHOST_REG;

#if __cplusplus
}
#endif

#endif

