//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: SPDIF_reg.h
//
//  Defines the SPDIF bus control register layout and associated constants 
//  and types.
//
//------------------------------------------------------------------------------

#ifndef __S5PV210_SPDIF_H
#define __S5PV210_SPDIF_H

#if __cplusplus
    extern "C" 
    {
#endif


//------------------------------------------------------------------------------
//  Type: name    
//
//  Defines SPDIF bus control register layout. This register bank is located by
//  the constant CPU_BASE_REG_XX_SPDIF in the configuration file 
//  cpu_base_reg_cfg.h.
//

typedef struct 
{
    UINT32 SPDCLKCON;       //=SPDIF_BASE + 0x00,		// Clock control register
	UINT32 SPDCON;          //=SPDIF_BASE + 0x04,		// Control register
	UINT32 SPDBSTAS;        //=SPDIF_BASE + 0x08,		// Burst status register
	UINT32 SPDCSTAS;        //=SPDIF_BASE + 0x0C,		// Channel status register
	UINT32 SPDDAT;          //=SPDIF_BASE + 0x10,		// SPDIFOUT data register
	UINT32 SPDCNT;          //=SPDIF_BASE + 0x14,		// Repetition count register
	UINT32 SPDBSTAS_SHD;    //=SPDIF_BASE + 0x18,		// Shadowed Burst Status Register 
	UINT32 SPDCNT_SHD;	    //=SPDIF_BASE + 0x1C,		// Shadowed Repetition count register
	UINT32 USERBIT1;        //=SPDIF_BASE + 0x20,		// Subcode Q1 ~ Q32
	UINT32 USERBIT2;        //=SPDIF_BASE + 0x24,		// Subcode Q33 ~ Q64
	UINT32 USERBIT3;        //=SPDIF_BASE + 0x28,		// Subcode Q65 ~ Q96
	UINT32 USERBIT1_SHD;    //=SPDIF_BASE + 0x2C,		// Shadowed Register Userbit1
	UINT32 USERBIT2_SHD;    //=SPDIF_BASE + 0x30,		// Shadowed Register Userbit2
	UINT32 USERBIT3_SHD;    //=SPDIF_BASE + 0x34,		// Shadowed Register Userbit3
	UINT32 VERSION_INFO;    //=SPDIF_BASE + 0x38,		// RTL version information	

} SPDIF_REG, *PSPDIF_REG;


#if __cplusplus
    }
#endif

#endif 
