/*
**************************************************************************
*
*                                            SAMSUNG ELECTRONICS
*                                                 Copyright(C) 2006
*                                              ALL RIGHTS RESERVED
*
* This program is proprietary to Samsung Electronics,and is protected under International
* Copyright Act as an unpublished work.Its use and disclosure is limited by the terms and
* conditions of a license agreement.  It may not  be copied  or  otherwise   reproduced or
* disclosed  to persons  outside  the  licensee's   organization  except  in  accordance with
* the  terms and conditions  of such  an agreement. All copies and  reproductions shall be
* the property of  Samsung  Electronics  and  must bear this  notice in its entirety.
*
**************************************************************************
*/
/*
*
*    File name : sgip_GPIO_register_map.h
*
*    Descriptions : this file contains the Samsung General purpose IO port Primitives (SGIP).
*                              GPIO Memory map information for S5PV210 and
*                Each pin description
*
*     History         :
*            Oct 19 2008 : First generated.
*            Jul 17 2009 : Modified For S5PV210 by JOHNLAY
*            Apr 12 2010 : Modified for S5PV210 by jungchul2.park
*/

#ifndef __SGIP_GPIO_REGITEST_MAP_H__
#define __SGIP_GPIO_REGITEST_MAP_H__

#include "sgip_GPIO.h"

//EINT Information ___________________________________________________//
#define	EXT_INT_0		spEINTEncoder(	0x0,	 0x0,	0x0,	0)
#define	EXT_INT_1		spEINTEncoder(	0x0,	 0x0,	0x0,	1)
#define	EXT_INT_2		spEINTEncoder(	0x0,	 0x0,	0x0,	2)
#define	EXT_INT_3		spEINTEncoder(	0x0,	 0x0,	0x0,	3)
#define	EXT_INT_4		spEINTEncoder(	0x0,	 0x4,	0x0,	4)
#define	EXT_INT_5		spEINTEncoder(	0x0,	 0x4,	0x0,	5)
#define	EXT_INT_6		spEINTEncoder(	0x0,	 0x4,	0x0,	6)
#define	EXT_INT_7		spEINTEncoder(	0x0,	 0x4,	0x0,	7)
#define	EXT_INT_8		spEINTEncoder(	0x4,	 0x8,	0x4,	0)
#define	EXT_INT_9		spEINTEncoder(	0x4,	 0x8,	0x4,	1)
#define	EXT_INT_10		spEINTEncoder(	0x4,	 0x8,	0x4,	2)
#define	EXT_INT_11		spEINTEncoder(	0x4,	 0x8,	0x4,	3)
#define	EXT_INT_12		spEINTEncoder(	0x4,	 0xC,	0x4,	4)
#define	EXT_INT_13		spEINTEncoder(	0x4,	 0xC,	0x4,	5)
#define	EXT_INT_14		spEINTEncoder(	0x4,	 0xC,	0x4,	6)
#define	EXT_INT_15		spEINTEncoder(	0x4,	 0xC,	0x4,	7)
#define	EXT_INT_16		spEINTEncoder(	0x8,	0x10,	0x8,	0)
#define	EXT_INT_17		spEINTEncoder(	0x8,	0x10,	0x8,	1)
#define	EXT_INT_18		spEINTEncoder(	0x8,	0x10,	0x8,	2)
#define	EXT_INT_19		spEINTEncoder(	0x8,	0x10,	0x8,	3)
#define	EXT_INT_20		spEINTEncoder(	0x8,	0x14,	0x8,	4)
#define	EXT_INT_21		spEINTEncoder(	0x8,	0x14,	0x8,	5)
#define	EXT_INT_22		spEINTEncoder(	0x8,	0x14,	0x8,	6)
#define	EXT_INT_23		spEINTEncoder(	0x8,	0x14,	0x8,	7)
#define	EXT_INT_24		spEINTEncoder(	0xC,	0x18,	0xC,	0)
#define	EXT_INT_25		spEINTEncoder(	0xC,	0x18,	0xC,	1)
#define	EXT_INT_26		spEINTEncoder(	0xC,	0x18,	0xC,	2)
#define	EXT_INT_27		spEINTEncoder(	0xC,	0x18,	0xC,	3)
#define	EXT_INT_28		spEINTEncoder(	0xC,	0x1C,	0xC,	4)
#define	EXT_INT_29		spEINTEncoder(	0xC,	0x1C,	0xC,	5)
#define	EXT_INT_30		spEINTEncoder(	0xC,	0x1C,	0xC,	6)
#define	EXT_INT_31		spEINTEncoder(	0xC,	0x1C,	0xC,	7)

//Group Information ___________________________________________________//
//	Group Name
#define	GPA0_Group		(sp_GroupEncoder(4,	1,	 0x0)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPA1_Group		(sp_GroupEncoder(4,	1,	 0x2)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPB_Group		(sp_GroupEncoder(4,	1,	 0x4)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPC0_Group		(sp_GroupEncoder(4,	1,	 0x6)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPC1_Group		(sp_GroupEncoder(4,	1,	 0x8)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPD0_Group		(sp_GroupEncoder(4,	1,	 0xa)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPD1_Group		(sp_GroupEncoder(4,	1,	 0xc)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPE0_Group		(sp_GroupEncoder(4,	1,	 0xe)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPE1_Group		(sp_GroupEncoder(4,	1,	0x10)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPF0_Group		(sp_GroupEncoder(4,	1,	0x12)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPF1_Group		(sp_GroupEncoder(4,	1,	0x14)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPF2_Group		(sp_GroupEncoder(4,	1,	0x16)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPF3_Group		(sp_GroupEncoder(4,	1,	0x18)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPG0_Group		(sp_GroupEncoder(4,	1,	0x1a)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPG1_Group		(sp_GroupEncoder(4,	1,	0x1c)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPG2_Group		(sp_GroupEncoder(4,	1,	0x1e)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPG3_Group		(sp_GroupEncoder(4,	1,	0x20)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPI_Group		(sp_GroupEncoder(4,	1,	0x22)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPJ0_Group		(sp_GroupEncoder(4,	1,	0x24)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPJ1_Group		(sp_GroupEncoder(4,	1,	0x26)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPJ2_Group		(sp_GroupEncoder(4,	1,	0x28)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPJ3_Group		(sp_GroupEncoder(4,	1,	0x2a)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPJ4_Group		(sp_GroupEncoder(4,	1,	0x2c)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP01_Group		(sp_GroupEncoder(4,	1,	0x2e)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP02_Group		(sp_GroupEncoder(4,	1,	0x30)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP03_Group		(sp_GroupEncoder(4,	1,	0x32)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP04_Group		(sp_GroupEncoder(4,	1,	0x34)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP05_Group		(sp_GroupEncoder(4,	1,	0x36)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP06_Group		(sp_GroupEncoder(4,	1,	0x38)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP07_Group		(sp_GroupEncoder(4,	1,	0x3a)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP10_Group		(sp_GroupEncoder(4,	1,	0x3c)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP11_Group		(sp_GroupEncoder(4,	1,	0x3e)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP12_Group		(sp_GroupEncoder(4,	1,	0x40)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP13_Group		(sp_GroupEncoder(4,	1,	0x42)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP14_Group		(sp_GroupEncoder(4,	1,	0x44)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP15_Group		(sp_GroupEncoder(4,	1,	0x46)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP16_Group		(sp_GroupEncoder(4,	1,	0x48)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP17_Group		(sp_GroupEncoder(4,	1,	0x4a)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP18_Group		(sp_GroupEncoder(4,	1,	0x4c)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP20_Group		(sp_GroupEncoder(4,	1,	0x4e)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP21_Group		(sp_GroupEncoder(4,	1,	0x50)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP22_Group		(sp_GroupEncoder(4,	1,	0x52)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP23_Group		(sp_GroupEncoder(4,	1,	0x54)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP24_Group		(sp_GroupEncoder(4,	1,	0x56)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP25_Group		(sp_GroupEncoder(4,	1,	0x58)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP26_Group		(sp_GroupEncoder(4,	1,	0x5a)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP27_Group		(sp_GroupEncoder(4,	1,	0x5c)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	MP28_Group		(sp_GroupEncoder(4,	1,	0x5e)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPH0_Group		(sp_GroupEncoder(4,	1,	0xc0)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPH1_Group		(sp_GroupEncoder(4,	1,	0xc2)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPH2_Group		(sp_GroupEncoder(4,	1,	0xc4)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))
#define	GPH3_Group		(sp_GroupEncoder(4,	1,	0xc6)	|spEnc_MuxNum4(1)|spEnc_ConNum2(0))

//Pin Informations __________________________sp_PinEncoder(GroupInfo, fIdx8, DatIdx, ConVal)//
//    Main Group    Sub Group    Pin Index        Function        Function    Group    Bit idx > 8    Pin Index    Con Val
//					Group Name	# of Con	Idx of Pin	Muxing
//						Group Name	# of Con	Idx of Pin	Muxing
//						Group Name	# of Con	Idx of Pin	Muxing
#define	GPA00_Input		sp_PinEncoder(GPA0_Group,	0,	0,	0x0)
#define	GPA00_Output		sp_PinEncoder(GPA0_Group,	0,	0,	0x1)
#define	GPA00_UART_0_RXD		sp_PinEncoder(GPA0_Group,	0,	0,	0x2)
#define	GPA00_INT0		sp_PinEncoder(GPA0_Group,	0,	0,	0xF)

#define	GPA01_Input		sp_PinEncoder(GPA0_Group,	0,	1,	0x0)
#define	GPA01_Output		sp_PinEncoder(GPA0_Group,	0,	1,	0x1)
#define	GPA01_UART_0_TXD		sp_PinEncoder(GPA0_Group,	0,	1,	0x2)
#define	GPA01_INT1		sp_PinEncoder(GPA0_Group,	0,	1,	0xF)

#define	GPA02_Input		sp_PinEncoder(GPA0_Group,	0,	2,	0x0)
#define	GPA02_Output		sp_PinEncoder(GPA0_Group,	0,	2,	0x1)
#define	GPA02_UART_0_CTSn		sp_PinEncoder(GPA0_Group,	0,	2,	0x2)
#define	GPA02_INT2		sp_PinEncoder(GPA0_Group,	0,	2,	0xF)

#define	GPA03_Input		sp_PinEncoder(GPA0_Group,	0,	3,	0x0)
#define	GPA03_Output		sp_PinEncoder(GPA0_Group,	0,	3,	0x1)
#define	GPA03_UART_0_RTSn		sp_PinEncoder(GPA0_Group,	0,	3,	0x2)
#define	GPA03_INT3		sp_PinEncoder(GPA0_Group,	0,	3,	0xF)

#define	GPA04_Input		sp_PinEncoder(GPA0_Group,	0,	4,	0x0)
#define	GPA04_Output		sp_PinEncoder(GPA0_Group,	0,	4,	0x1)
#define	GPA04_UART_1_RXD		sp_PinEncoder(GPA0_Group,	0,	4,	0x2)
#define	GPA04_INT4		sp_PinEncoder(GPA0_Group,	0,	4,	0xF)

#define	GPA05_Input		sp_PinEncoder(GPA0_Group,	0,	5,	0x0)
#define	GPA05_Output		sp_PinEncoder(GPA0_Group,	0,	5,	0x1)
#define	GPA05_UART_1_TXD		sp_PinEncoder(GPA0_Group,	0,	5,	0x2)
#define	GPA05_INT5		sp_PinEncoder(GPA0_Group,	0,	5,	0xF)

#define	GPA06_Input		sp_PinEncoder(GPA0_Group,	0,	6,	0x0)
#define	GPA06_Output		sp_PinEncoder(GPA0_Group,	0,	6,	0x1)
#define	GPA06_UART_1_CTSn		sp_PinEncoder(GPA0_Group,	0,	6,	0x2)
#define	GPA06_INT6		sp_PinEncoder(GPA0_Group,	0,	6,	0xF)

#define	GPA07_Input		sp_PinEncoder(GPA0_Group,	0,	7,	0x0)
#define	GPA07_Output		sp_PinEncoder(GPA0_Group,	0,	7,	0x1)
#define	GPA07_UART_1_RTSn		sp_PinEncoder(GPA0_Group,	0,	7,	0x2)
#define	GPA07_INT7		sp_PinEncoder(GPA0_Group,	0,	7,	0xF)

#define	GPA10_Input		sp_PinEncoder(GPA1_Group,	0,	0,	0x0)
#define	GPA10_Output		sp_PinEncoder(GPA1_Group,	0,	0,	0x1)
#define	GPA10_UART_2_RXD		sp_PinEncoder(GPA1_Group,	0,	0,	0x2)
#define	GPA10_UART_AUDIO_RXD		sp_PinEncoder(GPA1_Group,	0,	0,	0x4)
#define	GPA10_INT0		sp_PinEncoder(GPA1_Group,	0,	0,	0xF)

#define	GPA11_Input		sp_PinEncoder(GPA1_Group,	0,	1,	0x0)
#define	GPA11_Output		sp_PinEncoder(GPA1_Group,	0,	1,	0x1)
#define	GPA11_UART_2_TXD		sp_PinEncoder(GPA1_Group,	0,	1,	0x2)
#define	GPA11_UART_AUDIO_TXD		sp_PinEncoder(GPA1_Group,	0,	1,	0x4)
#define	GPA11_INT1		sp_PinEncoder(GPA1_Group,	0,	1,	0xF)

#define	GPA12_Input		sp_PinEncoder(GPA1_Group,	0,	2,	0x0)
#define	GPA12_Output		sp_PinEncoder(GPA1_Group,	0,	2,	0x1)
#define	GPA12_UART_3_RXD		sp_PinEncoder(GPA1_Group,	0,	2,	0x2)
#define	GPA12_UART_2_CTSn		sp_PinEncoder(GPA1_Group,	0,	2,	0x3)
#define	GPA12_INT2		sp_PinEncoder(GPA1_Group,	0,	2,	0xF)

#define	GPA13_Input		sp_PinEncoder(GPA1_Group,	0,	3,	0x0)
#define	GPA13_Output		sp_PinEncoder(GPA1_Group,	0,	3,	0x1)
#define	GPA13_UART_3_TXD		sp_PinEncoder(GPA1_Group,	0,	3,	0x2)
#define	GPA13_UART_2_RTSn		sp_PinEncoder(GPA1_Group,	0,	3,	0x3)
#define	GPA13_INT3		sp_PinEncoder(GPA1_Group,	0,	3,	0xF)

#define	GPB0_Input		sp_PinEncoder(GPB_Group,	0,	0,	0x0)
#define	GPB0_Output		sp_PinEncoder(GPB_Group,	0,	0,	0x1)
#define	GPB0_SPI_0_CLK		sp_PinEncoder(GPB_Group,	0,	0,	0x2)
#define	GPB0_INT0		sp_PinEncoder(GPB_Group,	0,	0,	0xF)

#define	GPB1_Input		sp_PinEncoder(GPB_Group,	0,	1,	0x0)
#define	GPB1_Output		sp_PinEncoder(GPB_Group,	0,	1,	0x1)
#define	GPB1_SPI_0_nSS		sp_PinEncoder(GPB_Group,	0,	1,	0x2)
#define	GPB1_INT1		sp_PinEncoder(GPB_Group,	0,	1,	0xF)

#define	GPB2_Input		sp_PinEncoder(GPB_Group,	0,	2,	0x0)
#define	GPB2_Output		sp_PinEncoder(GPB_Group,	0,	2,	0x1)
#define	GPB2_SPI_0_MISO		sp_PinEncoder(GPB_Group,	0,	2,	0x2)
#define	GPB2_INT2		sp_PinEncoder(GPB_Group,	0,	2,	0xF)

#define	GPB3_Input		sp_PinEncoder(GPB_Group,	0,	3,	0x0)
#define	GPB3_Output		sp_PinEncoder(GPB_Group,	0,	3,	0x1)
#define	GPB3_SPI_0_MOSI		sp_PinEncoder(GPB_Group,	0,	3,	0x2)
#define	GPB3_INT3		sp_PinEncoder(GPB_Group,	0,	3,	0xF)

#define	GPB4_Input		sp_PinEncoder(GPB_Group,	0,	4,	0x0)
#define	GPB4_Output		sp_PinEncoder(GPB_Group,	0,	4,	0x1)
#define	GPB4_SPI_1_CLK		sp_PinEncoder(GPB_Group,	0,	4,	0x2)
#define	GPB4_INT4		sp_PinEncoder(GPB_Group,	0,	4,	0xF)

#define	GPB5_Input		sp_PinEncoder(GPB_Group,	0,	5,	0x0)
#define	GPB5_Output		sp_PinEncoder(GPB_Group,	0,	5,	0x1)
#define	GPB5_SPI_1_nSS		sp_PinEncoder(GPB_Group,	0,	5,	0x2)
#define	GPB5_INT5		sp_PinEncoder(GPB_Group,	0,	5,	0xF)

#define	GPB6_Input		sp_PinEncoder(GPB_Group,	0,	6,	0x0)
#define	GPB6_Output		sp_PinEncoder(GPB_Group,	0,	6,	0x1)
#define	GPB6_SPI_1_MISO		sp_PinEncoder(GPB_Group,	0,	6,	0x2)
#define	GPB6_INT6		sp_PinEncoder(GPB_Group,	0,	6,	0xF)

#define	GPB7_Input		sp_PinEncoder(GPB_Group,	0,	7,	0x0)
#define	GPB7_Output		sp_PinEncoder(GPB_Group,	0,	7,	0x1)
#define	GPB7_SPI_1_MOSI		sp_PinEncoder(GPB_Group,	0,	7,	0x2)
#define	GPB7_INT7		sp_PinEncoder(GPB_Group,	0,	7,	0xF)

#define	GPC00_Input		sp_PinEncoder(GPC0_Group,	0,	0,	0x0)
#define	GPC00_Output		sp_PinEncoder(GPC0_Group,	0,	0,	0x1)
#define	GPC00_I2S_1_SCLK		sp_PinEncoder(GPC0_Group,	0,	0,	0x2)
#define	GPC00_PCM_1_SCLK		sp_PinEncoder(GPC0_Group,	0,	0,	0x3)
#define	GPC00_AC97BITCLK		sp_PinEncoder(GPC0_Group,	0,	0,	0x4)
#define	GPC00_INT0		sp_PinEncoder(GPC0_Group,	0,	0,	0xF)

#define	GPC01_Input		sp_PinEncoder(GPC0_Group,	0,	1,	0x0)
#define	GPC01_Output		sp_PinEncoder(GPC0_Group,	0,	1,	0x1)
#define	GPC01_I2S_1_CDCLK		sp_PinEncoder(GPC0_Group,	0,	1,	0x2)
#define	GPC01_PCM_1_EXTCLK		sp_PinEncoder(GPC0_Group,	0,	1,	0x3)
#define	GPC01_AC97RESETn		sp_PinEncoder(GPC0_Group,	0,	1,	0x4)
#define	GPC01_INT1		sp_PinEncoder(GPC0_Group,	0,	1,	0xF)

#define	GPC02_Input		sp_PinEncoder(GPC0_Group,	0,	2,	0x0)
#define	GPC02_Output		sp_PinEncoder(GPC0_Group,	0,	2,	0x1)
#define	GPC02_I2S_1_LRCK		sp_PinEncoder(GPC0_Group,	0,	2,	0x2)
#define	GPC02_PCM_1_FSYNC		sp_PinEncoder(GPC0_Group,	0,	2,	0x3)
#define	GPC02_AC97SYNC		sp_PinEncoder(GPC0_Group,	0,	2,	0x4)
#define	GPC02_INT2		sp_PinEncoder(GPC0_Group,	0,	2,	0xF)

#define	GPC03_Input		sp_PinEncoder(GPC0_Group,	0,	3,	0x0)
#define	GPC03_Output		sp_PinEncoder(GPC0_Group,	0,	3,	0x1)
#define	GPC03_I2S_1_SDI		sp_PinEncoder(GPC0_Group,	0,	3,	0x2)
#define	GPC03_PCM_1_SIN		sp_PinEncoder(GPC0_Group,	0,	3,	0x3)
#define	GPC03_AC97SDI		sp_PinEncoder(GPC0_Group,	0,	3,	0x4)
#define	GPC03_INT3		sp_PinEncoder(GPC0_Group,	0,	3,	0xF)

#define	GPC04_Input		sp_PinEncoder(GPC0_Group,	0,	4,	0x0)
#define	GPC04_Output		sp_PinEncoder(GPC0_Group,	0,	4,	0x1)
#define	GPC04_I2S_1_SDO		sp_PinEncoder(GPC0_Group,	0,	4,	0x2)
#define	GPC04_PCM_1_SOUT		sp_PinEncoder(GPC0_Group,	0,	4,	0x3)
#define	GPC04_AC97SDO		sp_PinEncoder(GPC0_Group,	0,	4,	0x4)
#define	GPC04_INT4		sp_PinEncoder(GPC0_Group,	0,	4,	0xF)

#define	GPC10_Input		sp_PinEncoder(GPC1_Group,	0,	0,	0x0)
#define	GPC10_Output		sp_PinEncoder(GPC1_Group,	0,	0,	0x1)
#if (S5PV210_EVT==0)
#define	GPC10_PCM_0_SCLK		sp_PinEncoder(GPC1_Group,	0,	0,	0x2)
#else
#define	GPC10_PCM_2_SCLK		sp_PinEncoder(GPC1_Group,	0,	0,	0x2)
#endif
#define	GPC10_SPDIF_0_OUT		sp_PinEncoder(GPC1_Group,	0,	0,	0x3)
#define	GPC10_I2S_2_SCLK		sp_PinEncoder(GPC1_Group,	0,	0,	0x4)
#define	GPC10_INT0		sp_PinEncoder(GPC1_Group,	0,	0,	0xF)

#define	GPC11_Input		sp_PinEncoder(GPC1_Group,	0,	1,	0x0)
#define	GPC11_Output		sp_PinEncoder(GPC1_Group,	0,	1,	0x1)
#if (S5PV210_EVT==0)
#define	GPC11_PCM_0_EXTCLK		sp_PinEncoder(GPC1_Group,	0,	1,	0x2)
#else
#define	GPC11_PCM_2_EXTCLK		sp_PinEncoder(GPC1_Group,	0,	1,	0x2)
#endif
#define	GPC11_SPDIF_EXTCLK		sp_PinEncoder(GPC1_Group,	0,	1,	0x3)
#define	GPC11_I2S_2_CDCLK		sp_PinEncoder(GPC1_Group,	0,	1,	0x4)
#define	GPC11_INT1		sp_PinEncoder(GPC1_Group,	0,	1,	0xF)

#define	GPC12_Input		sp_PinEncoder(GPC1_Group,	0,	2,	0x0)
#define	GPC12_Output		sp_PinEncoder(GPC1_Group,	0,	2,	0x1)
#if (S5PV210_EVT==0)
#define	GPC12_PCM_0_FSYNC		sp_PinEncoder(GPC1_Group,	0,	2,	0x2)
#else
#define	GPC12_PCM_2_FSYNC		sp_PinEncoder(GPC1_Group,	0,	2,	0x2)
#endif
#define	GPC12_LCD_FRM		sp_PinEncoder(GPC1_Group,	0,	2,	0x3)
#define	GPC12_I2S_2_LRCK		sp_PinEncoder(GPC1_Group,	0,	2,	0x4)
#define	GPC12_INT2		sp_PinEncoder(GPC1_Group,	0,	2,	0xF)

#define	GPC13_Input		sp_PinEncoder(GPC1_Group,	0,	3,	0x0)
#define	GPC13_Output		sp_PinEncoder(GPC1_Group,	0,	3,	0x1)
#if (S5PV210_EVT==0)
#define	GPC13_PCM_0_SIN		sp_PinEncoder(GPC1_Group,	0,	3,	0x2)
#else
#define	GPC13_PCM_2_SIN		sp_PinEncoder(GPC1_Group,	0,	3,	0x2)
#endif
#define	GPC13_I2S_2_SDI		sp_PinEncoder(GPC1_Group,	0,	3,	0x4)
#define	GPC13_INT3		sp_PinEncoder(GPC1_Group,	0,	3,	0xF)

#define	GPC14_Input		sp_PinEncoder(GPC1_Group,	0,	4,	0x0)
#define	GPC14_Output		sp_PinEncoder(GPC1_Group,	0,	4,	0x1)
#if (S5PV210_EVT==0)
#define	GPC14_PCM_0_SOUT		sp_PinEncoder(GPC1_Group,	0,	4,	0x2)
#else
#define	GPC14_PCM_2_SOUT		sp_PinEncoder(GPC1_Group,	0,	4,	0x2)
#endif
#define	GPC14_I2S_2_SDO		sp_PinEncoder(GPC1_Group,	0,	4,	0x4)
#define	GPC14_INT4		sp_PinEncoder(GPC1_Group,	0,	4,	0xF)

#define	GPD00_Input		sp_PinEncoder(GPD0_Group,	0,	0,	0x0)
#define	GPD00_Output		sp_PinEncoder(GPD0_Group,	0,	0,	0x1)
#define	GPD00_TOUT_0		sp_PinEncoder(GPD0_Group,	0,	0,	0x2)
#define	GPD00_INT0		sp_PinEncoder(GPD0_Group,	0,	0,	0xF)

#define	GPD01_Input		sp_PinEncoder(GPD0_Group,	0,	1,	0x0)
#define	GPD01_Output		sp_PinEncoder(GPD0_Group,	0,	1,	0x1)
#define	GPD01_TOUT_1		sp_PinEncoder(GPD0_Group,	0,	1,	0x2)
#define	GPD01_INT1		sp_PinEncoder(GPD0_Group,	0,	1,	0xF)

#define	GPD02_Input		sp_PinEncoder(GPD0_Group,	0,	2,	0x0)
#define	GPD02_Output		sp_PinEncoder(GPD0_Group,	0,	2,	0x1)
#define	GPD02_TOUT_2		sp_PinEncoder(GPD0_Group,	0,	2,	0x2)
#define	GPD02_INT2		sp_PinEncoder(GPD0_Group,	0,	2,	0xF)

#define	GPD03_Input		sp_PinEncoder(GPD0_Group,	0,	3,	0x0)
#define	GPD03_Output		sp_PinEncoder(GPD0_Group,	0,	3,	0x1)
#define	GPD03_TOUT_3		sp_PinEncoder(GPD0_Group,	0,	3,	0x2)
#define	GPD03_PWM_M		sp_PinEncoder(GPD0_Group,	0,	3,	0x3)
#define	GPD03_INT3		sp_PinEncoder(GPD0_Group,	0,	3,	0xF)

#define	GPD10_Input		sp_PinEncoder(GPD1_Group,	0,	0,	0x0)
#define	GPD10_Output		sp_PinEncoder(GPD1_Group,	0,	0,	0x1)
#define	GPD10_I2C0_SDA		sp_PinEncoder(GPD1_Group,	0,	0,	0x2)
#define	GPD10_INT0		sp_PinEncoder(GPD1_Group,	0,	0,	0xF)

#define	GPD11_Input		sp_PinEncoder(GPD1_Group,	0,	1,	0x0)
#define	GPD11_Output		sp_PinEncoder(GPD1_Group,	0,	1,	0x1)
#define	GPD11_I2C0_SCL		sp_PinEncoder(GPD1_Group,	0,	1,	0x2)
#define	GPD11_INT1		sp_PinEncoder(GPD1_Group,	0,	1,	0xF)

#define	GPD12_Input		sp_PinEncoder(GPD1_Group,	0,	2,	0x0)
#define	GPD12_Output		sp_PinEncoder(GPD1_Group,	0,	2,	0x1)
#define	GPD12_I2C1_SDA		sp_PinEncoder(GPD1_Group,	0,	2,	0x2)
#define	GPD12_INT2		sp_PinEncoder(GPD1_Group,	0,	2,	0xF)

#define	GPD13_Input		sp_PinEncoder(GPD1_Group,	0,	3,	0x0)
#define	GPD13_Output		sp_PinEncoder(GPD1_Group,	0,	3,	0x1)
#define	GPD13_I2C1_SCL		sp_PinEncoder(GPD1_Group,	0,	3,	0x2)
#define	GPD13_INT3		sp_PinEncoder(GPD1_Group,	0,	3,	0xF)

#define	GPD14_Input		sp_PinEncoder(GPD1_Group,	0,	4,	0x0)
#define	GPD14_Output		sp_PinEncoder(GPD1_Group,	0,	4,	0x1)
#define	GPD14_I2C2_SDA		sp_PinEncoder(GPD1_Group,	0,	4,	0x2)
#define	GPD14_IEM_SCLK		sp_PinEncoder(GPD1_Group,	0,	4,	0x3)
#define	GPD14_INT4		sp_PinEncoder(GPD1_Group,	0,	4,	0xF)

#define	GPD15_Input		sp_PinEncoder(GPD1_Group,	0,	5,	0x0)
#define	GPD15_Output		sp_PinEncoder(GPD1_Group,	0,	5,	0x1)
#define	GPD15_I2C2_SCL		sp_PinEncoder(GPD1_Group,	0,	5,	0x2)
#define	GPD15_IEM_SPWI		sp_PinEncoder(GPD1_Group,	0,	5,	0x3)
#define	GPD15_INT5		sp_PinEncoder(GPD1_Group,	0,	5,	0xF)

#define	GPE00_Input		sp_PinEncoder(GPE0_Group,	0,	0,	0x0)
#define	GPE00_Output		sp_PinEncoder(GPE0_Group,	0,	0,	0x1)
#define	GPE00_CAM_A_PCLK		sp_PinEncoder(GPE0_Group,	0,	0,	0x2)
#define	GPE00_INT0		sp_PinEncoder(GPE0_Group,	0,	0,	0xF)

#define	GPE01_Input		sp_PinEncoder(GPE0_Group,	0,	1,	0x0)
#define	GPE01_Output		sp_PinEncoder(GPE0_Group,	0,	1,	0x1)
#define	GPE01_CAM_A_VSYNC		sp_PinEncoder(GPE0_Group,	0,	1,	0x2)
#define	GPE01_INT1		sp_PinEncoder(GPE0_Group,	0,	1,	0xF)

#define	GPE02_Input		sp_PinEncoder(GPE0_Group,	0,	2,	0x0)
#define	GPE02_Output		sp_PinEncoder(GPE0_Group,	0,	2,	0x1)
#define	GPE02_CAM_A_HREF		sp_PinEncoder(GPE0_Group,	0,	2,	0x2)
#define	GPE02_INT2		sp_PinEncoder(GPE0_Group,	0,	2,	0xF)

#define	GPE03_Input		sp_PinEncoder(GPE0_Group,	0,	3,	0x0)
#define	GPE03_Output		sp_PinEncoder(GPE0_Group,	0,	3,	0x1)
#define	GPE03_CAM_A_DATA0		sp_PinEncoder(GPE0_Group,	0,	3,	0x2)
#define	GPE03_INT3		sp_PinEncoder(GPE0_Group,	0,	3,	0xF)

#define	GPE04_Input		sp_PinEncoder(GPE0_Group,	0,	4,	0x0)
#define	GPE04_Output		sp_PinEncoder(GPE0_Group,	0,	4,	0x1)
#define	GPE04_CAM_A_DATA1		sp_PinEncoder(GPE0_Group,	0,	4,	0x2)
#define	GPE04_INT4		sp_PinEncoder(GPE0_Group,	0,	4,	0xF)

#define	GPE05_Input		sp_PinEncoder(GPE0_Group,	0,	5,	0x0)
#define	GPE05_Output		sp_PinEncoder(GPE0_Group,	0,	5,	0x1)
#define	GPE05_CAM_A_DATA2		sp_PinEncoder(GPE0_Group,	0,	5,	0x2)
#define	GPE05_INT5		sp_PinEncoder(GPE0_Group,	0,	5,	0xF)

#define	GPE06_Input		sp_PinEncoder(GPE0_Group,	0,	6,	0x0)
#define	GPE06_Output		sp_PinEncoder(GPE0_Group,	0,	6,	0x1)
#define	GPE06_CAM_A_DATA3		sp_PinEncoder(GPE0_Group,	0,	6,	0x2)
#define	GPE06_INT6		sp_PinEncoder(GPE0_Group,	0,	6,	0xF)

#define	GPE07_Input		sp_PinEncoder(GPE0_Group,	0,	7,	0x0)
#define	GPE07_Output		sp_PinEncoder(GPE0_Group,	0,	7,	0x1)
#define	GPE07_CAM_A_DATA4		sp_PinEncoder(GPE0_Group,	0,	7,	0x2)
#define	GPE07_INT7		sp_PinEncoder(GPE0_Group,	0,	7,	0xF)

#define	GPE10_Input		sp_PinEncoder(GPE1_Group,	0,	0,	0x0)
#define	GPE10_Output		sp_PinEncoder(GPE1_Group,	0,	0,	0x1)
#define	GPE10_CAM_A_DATA5		sp_PinEncoder(GPE1_Group,	0,	0,	0x2)
#define	GPE10_INT0		sp_PinEncoder(GPE1_Group,	0,	0,	0xF)

#define	GPE11_Input		sp_PinEncoder(GPE1_Group,	0,	1,	0x0)
#define	GPE11_Output		sp_PinEncoder(GPE1_Group,	0,	1,	0x1)
#define	GPE11_CAM_A_DATA6		sp_PinEncoder(GPE1_Group,	0,	1,	0x2)
#define	GPE11_INT1		sp_PinEncoder(GPE1_Group,	0,	1,	0xF)

#define	GPE12_Input		sp_PinEncoder(GPE1_Group,	0,	2,	0x0)
#define	GPE12_Output		sp_PinEncoder(GPE1_Group,	0,	2,	0x1)
#define	GPE12_CAM_A_DATA7		sp_PinEncoder(GPE1_Group,	0,	2,	0x2)
#define	GPE12_INT2		sp_PinEncoder(GPE1_Group,	0,	2,	0xF)

#define	GPE13_Input		sp_PinEncoder(GPE1_Group,	0,	3,	0x0)
#define	GPE13_Output		sp_PinEncoder(GPE1_Group,	0,	3,	0x1)
#define	GPE13_CAM_A_CLKOUT		sp_PinEncoder(GPE1_Group,	0,	3,	0x2)
#define	GPE13_INT3		sp_PinEncoder(GPE1_Group,	0,	3,	0xF)

#define	GPE14_Input		sp_PinEncoder(GPE1_Group,	0,	4,	0x0)
#define	GPE14_Output		sp_PinEncoder(GPE1_Group,	0,	4,	0x1)
#define	GPE14_CAM_A_FIELD		sp_PinEncoder(GPE1_Group,	0,	4,	0x2)
#define	GPE14_INT4		sp_PinEncoder(GPE1_Group,	0,	4,	0xF)

#define	GPF00_Input		sp_PinEncoder(GPF0_Group,	0,	0,	0x0)
#define	GPF00_Output		sp_PinEncoder(GPF0_Group,	0,	0,	0x1)
#define	GPF00_LCD_HSYNC		sp_PinEncoder(GPF0_Group,	0,	0,	0x2)
#define	GPF00_SYS_CS0		sp_PinEncoder(GPF0_Group,	0,	0,	0x3)
#define	GPF00_VEN_HSYNC		sp_PinEncoder(GPF0_Group,	0,	0,	0x4)
#define	GPF00_INT0		sp_PinEncoder(GPF0_Group,	0,	0,	0xF)

#define	GPF01_Input		sp_PinEncoder(GPF0_Group,	0,	1,	0x0)
#define	GPF01_Output		sp_PinEncoder(GPF0_Group,	0,	1,	0x1)
#define	GPF01_LCD_VSYNC		sp_PinEncoder(GPF0_Group,	0,	1,	0x2)
#define	GPF01_SYS_CS1		sp_PinEncoder(GPF0_Group,	0,	1,	0x3)
#define	GPF01_VEN_VSYNC		sp_PinEncoder(GPF0_Group,	0,	1,	0x4)
#define	GPF01_INT1		sp_PinEncoder(GPF0_Group,	0,	1,	0xF)

#define	GPF02_Input		sp_PinEncoder(GPF0_Group,	0,	2,	0x0)
#define	GPF02_Output		sp_PinEncoder(GPF0_Group,	0,	2,	0x1)
#define	GPF02_LCD_VDEN		sp_PinEncoder(GPF0_Group,	0,	2,	0x2)
#define	GPF02_SYS_RS		sp_PinEncoder(GPF0_Group,	0,	2,	0x3)
#define	GPF02_VEN_HREF		sp_PinEncoder(GPF0_Group,	0,	2,	0x4)
#define	GPF02_INT2		sp_PinEncoder(GPF0_Group,	0,	2,	0xF)

#define	GPF03_Input		sp_PinEncoder(GPF0_Group,	0,	3,	0x0)
#define	GPF03_Output		sp_PinEncoder(GPF0_Group,	0,	3,	0x1)
#define	GPF03_LCD_VCLK		sp_PinEncoder(GPF0_Group,	0,	3,	0x2)
#define	GPF03_SYS_WE		sp_PinEncoder(GPF0_Group,	0,	3,	0x3)
#define	GPF03_V601_CLK		sp_PinEncoder(GPF0_Group,	0,	3,	0x4)
#define	GPF03_INT3		sp_PinEncoder(GPF0_Group,	0,	3,	0xF)

#define	GPF04_Input		sp_PinEncoder(GPF0_Group,	0,	4,	0x0)
#define	GPF04_Output		sp_PinEncoder(GPF0_Group,	0,	4,	0x1)
#define	GPF04_LCD_VD_0		sp_PinEncoder(GPF0_Group,	0,	4,	0x2)
#define	GPF04_SYS_VD_0		sp_PinEncoder(GPF0_Group,	0,	4,	0x3)
#define	GPF04_VEN_DATA_0		sp_PinEncoder(GPF0_Group,	0,	4,	0x4)
#define	GPF04_INT4		sp_PinEncoder(GPF0_Group,	0,	4,	0xF)

#define	GPF05_Input		sp_PinEncoder(GPF0_Group,	0,	5,	0x0)
#define	GPF05_Output		sp_PinEncoder(GPF0_Group,	0,	5,	0x1)
#define	GPF05_LCD_VD_1		sp_PinEncoder(GPF0_Group,	0,	5,	0x2)
#define	GPF05_SYS_VD_1		sp_PinEncoder(GPF0_Group,	0,	5,	0x3)
#define	GPF05_VEN_DATA_1		sp_PinEncoder(GPF0_Group,	0,	5,	0x4)
#define	GPF05_INT5		sp_PinEncoder(GPF0_Group,	0,	5,	0xF)

#define	GPF06_Input		sp_PinEncoder(GPF0_Group,	0,	6,	0x0)
#define	GPF06_Output		sp_PinEncoder(GPF0_Group,	0,	6,	0x1)
#define	GPF06_LCD_VD_2		sp_PinEncoder(GPF0_Group,	0,	6,	0x2)
#define	GPF06_SYS_VD_2		sp_PinEncoder(GPF0_Group,	0,	6,	0x3)
#define	GPF06_VEN_DATA_2		sp_PinEncoder(GPF0_Group,	0,	6,	0x4)
#define	GPF06_INT6		sp_PinEncoder(GPF0_Group,	0,	6,	0xF)

#define	GPF07_Input		sp_PinEncoder(GPF0_Group,	0,	7,	0x0)
#define	GPF07_Output		sp_PinEncoder(GPF0_Group,	0,	7,	0x1)
#define	GPF07_LCD_VD_3		sp_PinEncoder(GPF0_Group,	0,	7,	0x2)
#define	GPF07_SYS_VD_3		sp_PinEncoder(GPF0_Group,	0,	7,	0x3)
#define	GPF07_VEN_DATA_3		sp_PinEncoder(GPF0_Group,	0,	7,	0x4)
#define	GPF07_INT7		sp_PinEncoder(GPF0_Group,	0,	7,	0xF)

#define	GPF10_Input    		sp_PinEncoder(GPF1_Group,	0,	0,	0x0)
#define	GPF10_Output		sp_PinEncoder(GPF1_Group,	0,	0,	0x1)
#define	GPF10_LCD_VD_4		sp_PinEncoder(GPF1_Group,	0,	0,	0x2)
#define	GPF10_SYS_VD_4		sp_PinEncoder(GPF1_Group,	0,	0,	0x3)
#define	GPF10_VEN_DATA_4		sp_PinEncoder(GPF1_Group,	0,	0,	0x4)
#define	GPF10_INT0		sp_PinEncoder(GPF1_Group,	0,	0,	0xF)

#define	GPF11_Input    		sp_PinEncoder(GPF1_Group,	0,	1,	0x0)
#define	GPF11_Output		sp_PinEncoder(GPF1_Group,	0,	1,	0x1)
#define	GPF11_LCD_VD_5		sp_PinEncoder(GPF1_Group,	0,	1,	0x2)
#define	GPF11_SYS_VD_5		sp_PinEncoder(GPF1_Group,	0,	1,	0x3)
#define	GPF11_VEN_DATA_5		sp_PinEncoder(GPF1_Group,	0,	1,	0x4)
#define	GPF11_INT1		sp_PinEncoder(GPF1_Group,	0,	1,	0xF)

#define	GPF12_Input    		sp_PinEncoder(GPF1_Group,	0,	2,	0x0)
#define	GPF12_Output		sp_PinEncoder(GPF1_Group,	0,	2,	0x1)
#define	GPF12_LCD_VD_6		sp_PinEncoder(GPF1_Group,	0,	2,	0x2)
#define	GPF12_SYS_VD_6		sp_PinEncoder(GPF1_Group,	0,	2,	0x3)
#define	GPF12_VEN_DATA_6		sp_PinEncoder(GPF1_Group,	0,	2,	0x4)
#define	GPF12_INT2		sp_PinEncoder(GPF1_Group,	0,	2,	0xF)

#define	GPF13_Input    		sp_PinEncoder(GPF1_Group,	0,	3,	0x0)
#define	GPF13_Output		sp_PinEncoder(GPF1_Group,	0,	3,	0x1)
#define	GPF13_LCD_VD_7		sp_PinEncoder(GPF1_Group,	0,	3,	0x2)
#define	GPF13_SYS_VD_7		sp_PinEncoder(GPF1_Group,	0,	3,	0x3)
#define	GPF13_VEN_DATA_7		sp_PinEncoder(GPF1_Group,	0,	3,	0x4)
#define	GPF13_INT3		sp_PinEncoder(GPF1_Group,	0,	3,	0xF)

#define	GPF14_Input    		sp_PinEncoder(GPF1_Group,	0,	4,	0x0)
#define	GPF14_Output		sp_PinEncoder(GPF1_Group,	0,	4,	0x1)
#define	GPF14_LCD_VD_8		sp_PinEncoder(GPF1_Group,	0,	4,	0x2)
#define	GPF14_SYS_VD_8		sp_PinEncoder(GPF1_Group,	0,	4,	0x3)
#define	GPF14_V656_DATA_0		sp_PinEncoder(GPF1_Group,	0,	4,	0x4)
#define	GPF14_INT4		sp_PinEncoder(GPF1_Group,	0,	4,	0xF)

#define	GPF15_Input    		sp_PinEncoder(GPF1_Group,	0,	5,	0x0)
#define	GPF15_Output		sp_PinEncoder(GPF1_Group,	0,	5,	0x1)
#define	GPF15_LCD_VD_9		sp_PinEncoder(GPF1_Group,	0,	5,	0x2)
#define	GPF15_SYS_VD_9		sp_PinEncoder(GPF1_Group,	0,	5,	0x3)
#define	GPF15_V656_DATA_1		sp_PinEncoder(GPF1_Group,	0,	5,	0x4)
#define	GPF15_INT5		sp_PinEncoder(GPF1_Group,	0,	5,	0xF)

#define	GPF16_Input    		sp_PinEncoder(GPF1_Group,	0,	6,	0x0)
#define	GPF16_Output		sp_PinEncoder(GPF1_Group,	0,	6,	0x1)
#define	GPF16_LCD_VD_10		sp_PinEncoder(GPF1_Group,	0,	6,	0x2)
#define	GPF16_SYS_VD_10		sp_PinEncoder(GPF1_Group,	0,	6,	0x3)
#define	GPF16_V656_DATA_2		sp_PinEncoder(GPF1_Group,	0,	6,	0x4)
#define	GPF16_INT6		sp_PinEncoder(GPF1_Group,	0,	6,	0xF)

#define	GPF17_Input    		sp_PinEncoder(GPF1_Group,	0,	7,	0x0)
#define	GPF17_Output		sp_PinEncoder(GPF1_Group,	0,	7,	0x1)
#define	GPF17_LCD_VD_11		sp_PinEncoder(GPF1_Group,	0,	7,	0x2)
#define	GPF17_SYS_VD_11		sp_PinEncoder(GPF1_Group,	0,	7,	0x3)
#define	GPF17_V656_DATA_3		sp_PinEncoder(GPF1_Group,	0,	7,	0x4)
#define	GPF17_INT7		sp_PinEncoder(GPF1_Group,	0,	7,	0xF)

#define	GPF20_Input    		sp_PinEncoder(GPF2_Group,	0,	0,	0x0)
#define	GPF20_Output		sp_PinEncoder(GPF2_Group,	0,	0,	0x1)
#define	GPF20_LCD_VD_12		sp_PinEncoder(GPF2_Group,	0,	0,	0x2)
#define	GPF20_SYS_VD_12		sp_PinEncoder(GPF2_Group,	0,	0,	0x3)
#define	GPF20_V656_DATA_4		sp_PinEncoder(GPF2_Group,	0,	0,	0x4)
#define	GPF20_INT0		sp_PinEncoder(GPF2_Group,	0,	0,	0xF)

#define	GPF21_Input    		sp_PinEncoder(GPF2_Group,	0,	1,	0x0)
#define	GPF21_Output		sp_PinEncoder(GPF2_Group,	0,	1,	0x1)
#define	GPF21_LCD_VD_13		sp_PinEncoder(GPF2_Group,	0,	1,	0x2)
#define	GPF21_SYS_VD_13		sp_PinEncoder(GPF2_Group,	0,	1,	0x3)
#define	GPF21_V656_DATA_5		sp_PinEncoder(GPF2_Group,	0,	1,	0x4)
#define	GPF21_INT1		sp_PinEncoder(GPF2_Group,	0,	1,	0xF)

#define	GPF22_Input    		sp_PinEncoder(GPF2_Group,	0,	2,	0x0)
#define	GPF22_Output		sp_PinEncoder(GPF2_Group,	0,	2,	0x1)
#define	GPF22_LCD_VD_14		sp_PinEncoder(GPF2_Group,	0,	2,	0x2)
#define	GPF22_SYS_VD_14		sp_PinEncoder(GPF2_Group,	0,	2,	0x3)
#define	GPF22_V656_DATA_6		sp_PinEncoder(GPF2_Group,	0,	2,	0x4)
#define	GPF22_INT2		sp_PinEncoder(GPF2_Group,	0,	2,	0xF)

#define	GPF23_Input    		sp_PinEncoder(GPF2_Group,	0,	3,	0x0)
#define	GPF23_Output		sp_PinEncoder(GPF2_Group,	0,	3,	0x1)
#define	GPF23_LCD_VD_15		sp_PinEncoder(GPF2_Group,	0,	3,	0x2)
#define	GPF23_SYS_VD_15		sp_PinEncoder(GPF2_Group,	0,	3,	0x3)
#define	GPF23_V656_DATA_7		sp_PinEncoder(GPF2_Group,	0,	3,	0x4)
#define	GPF23_INT3		sp_PinEncoder(GPF2_Group,	0,	3,	0xF)

#define	GPF24_Input    		sp_PinEncoder(GPF2_Group,	0,	4,	0x0)
#define	GPF24_Output		sp_PinEncoder(GPF2_Group,	0,	4,	0x1)
#define	GPF24_LCD_VD_16		sp_PinEncoder(GPF2_Group,	0,	4,	0x2)
#define	GPF24_SYS_VD_16		sp_PinEncoder(GPF2_Group,	0,	4,	0x3)
#define	GPF24_INT4		sp_PinEncoder(GPF2_Group,	0,	4,	0xF)

#define	GPF25_Input    		sp_PinEncoder(GPF2_Group,	0,	5,	0x0)
#define	GPF25_Output		sp_PinEncoder(GPF2_Group,	0,	5,	0x1)
#define	GPF25_LCD_VD_17		sp_PinEncoder(GPF2_Group,	0,	5,	0x2)
#define	GPF25_SYS_VD_17		sp_PinEncoder(GPF2_Group,	0,	5,	0x3)
#define	GPF25_INT5		sp_PinEncoder(GPF2_Group,	0,	5,	0xF)

#define	GPF26_Input    		sp_PinEncoder(GPF2_Group,	0,	6,	0x0)
#define	GPF26_Output		sp_PinEncoder(GPF2_Group,	0,	6,	0x1)
#define	GPF26_LCD_VD_18		sp_PinEncoder(GPF2_Group,	0,	6,	0x2)
#define	GPF26_SYS_VD_18		sp_PinEncoder(GPF2_Group,	0,	6,	0x3)
#define	GPF26_INT6		sp_PinEncoder(GPF2_Group,	0,	6,	0xF)

#define	GPF27_Input    		sp_PinEncoder(GPF2_Group,	0,	7,	0x0)
#define	GPF27_Output		sp_PinEncoder(GPF2_Group,	0,	7,	0x1)
#define	GPF27_LCD_VD_19		sp_PinEncoder(GPF2_Group,	0,	7,	0x2)
#define	GPF27_SYS_VD_19		sp_PinEncoder(GPF2_Group,	0,	7,	0x3)
#define	GPF27_INT7		sp_PinEncoder(GPF2_Group,	0,	7,	0xF)

#define	GPF30_Input    		sp_PinEncoder(GPF3_Group,	0,	0,	0x0)
#define	GPF30_Output		sp_PinEncoder(GPF3_Group,	0,	0,	0x1)
#define	GPF30_LCD_VD_20		sp_PinEncoder(GPF3_Group,	0,	0,	0x2)
#define	GPF30_SYS_VD_20		sp_PinEncoder(GPF3_Group,	0,	0,	0x3)
#define	GPF30_INT0		sp_PinEncoder(GPF3_Group,	0,	0,	0xF)

#define	GPF31_Input    		sp_PinEncoder(GPF3_Group,	0,	1,	0x0)
#define	GPF31_Output		sp_PinEncoder(GPF3_Group,	0,	1,	0x1)
#define	GPF31_LCD_VD_21		sp_PinEncoder(GPF3_Group,	0,	1,	0x2)
#define	GPF31_SYS_VD_21		sp_PinEncoder(GPF3_Group,	0,	1,	0x3)
#define	GPF31_INT1		sp_PinEncoder(GPF3_Group,	0,	1,	0xF)

#define	GPF32_Input    		sp_PinEncoder(GPF3_Group,	0,	2,	0x0)
#define	GPF32_Output		sp_PinEncoder(GPF3_Group,	0,	2,	0x1)
#define	GPF32_LCD_VD_22		sp_PinEncoder(GPF3_Group,	0,	2,	0x2)
#define	GPF32_SYS_VD_22		sp_PinEncoder(GPF3_Group,	0,	2,	0x3)
#define	GPF32_INT2		sp_PinEncoder(GPF3_Group,	0,	2,	0xF)

#define	GPF33_Input    		sp_PinEncoder(GPF3_Group,	0,	3,	0x0)
#define	GPF33_Output		sp_PinEncoder(GPF3_Group,	0,	3,	0x1)
#define	GPF33_LCD_VD_23		sp_PinEncoder(GPF3_Group,	0,	3,	0x2)
#define	GPF33_SYS_VD_23		sp_PinEncoder(GPF3_Group,	0,	3,	0x3)
#define	GPF33_V656_CLK		sp_PinEncoder(GPF3_Group,	0,	3,	0x4)
#define	GPF33_INT3		sp_PinEncoder(GPF3_Group,	0,	3,	0xF)

#define	GPF34_Input    		sp_PinEncoder(GPF3_Group,	0,	4,	0x0)
#define	GPF34_Output		sp_PinEncoder(GPF3_Group,	0,	4,	0x1)
#define	GPF34_VSYNC_LDI		sp_PinEncoder(GPF3_Group,	0,	4,	0x3)
#define	GPF34_INT4		sp_PinEncoder(GPF3_Group,	0,	4,	0xF)

#define	GPF35_Input    		sp_PinEncoder(GPF3_Group,	0,	5,	0x0)
#define	GPF35_Output		sp_PinEncoder(GPF3_Group,	0,	5,	0x1)
#define	GPF35_SYS_OE		sp_PinEncoder(GPF3_Group,	0,	5,	0x3)
#define	GPF35_VEN_FIELD		sp_PinEncoder(GPF3_Group,	0,	5,	0x4)
#define	GPF35_INT5		sp_PinEncoder(GPF3_Group,	0,	5,	0xF)

#define	GPG00_Input    		sp_PinEncoder(GPG0_Group,	0,	0,	0x0)
#define	GPG00_Output		sp_PinEncoder(GPG0_Group,	0,	0,	0x1)
#define	GPG00_SD_0_CLK		sp_PinEncoder(GPG0_Group,	0,	0,	0x2)
#define	GPG00_INT0		sp_PinEncoder(GPG0_Group,	0,	0,	0xF)

#define	GPG01_Input    		sp_PinEncoder(GPG0_Group,	0,	1,	0x0)
#define	GPG01_Output		sp_PinEncoder(GPG0_Group,	0,	1,	0x1)
#define	GPG01_SD_0_CMD		sp_PinEncoder(GPG0_Group,	0,	1,	0x2)
#define	GPG01_INT1		sp_PinEncoder(GPG0_Group,	0,	1,	0xF)

#define	GPG02_Input    		sp_PinEncoder(GPG0_Group,	0,	2,	0x0)
#define	GPG02_Output		sp_PinEncoder(GPG0_Group,	0,	2,	0x1)
#define	GPG02_SD_0_CDn		sp_PinEncoder(GPG0_Group,	0,	2,	0x2)
#define	GPG02_INT2		sp_PinEncoder(GPG0_Group,	0,	2,	0xF)

#define	GPG03_Input    		sp_PinEncoder(GPG0_Group,	0,	3,	0x0)
#define	GPG03_Output		sp_PinEncoder(GPG0_Group,	0,	3,	0x1)
#define	GPG03_SD_0_DATA_0		sp_PinEncoder(GPG0_Group,	0,	3,	0x2)
#define	GPG03_INT3		sp_PinEncoder(GPG0_Group,	0,	3,	0xF)

#define	GPG04_Input    		sp_PinEncoder(GPG0_Group,	0,	4,	0x0)
#define	GPG04_Output		sp_PinEncoder(GPG0_Group,	0,	4,	0x1)
#define	GPG04_SD_0_DATA_1		sp_PinEncoder(GPG0_Group,	0,	4,	0x2)
#define	GPG04_INT4		sp_PinEncoder(GPG0_Group,	0,	4,	0xF)

#define	GPG05_Input    		sp_PinEncoder(GPG0_Group,	0,	5,	0x0)
#define	GPG05_Output		sp_PinEncoder(GPG0_Group,	0,	5,	0x1)
#define	GPG05_SD_0_DATA_2		sp_PinEncoder(GPG0_Group,	0,	5,	0x2)
#define	GPG05_INT5		sp_PinEncoder(GPG0_Group,	0,	5,	0xF)

#define	GPG06_Input    		sp_PinEncoder(GPG0_Group,	0,	6,	0x0)
#define	GPG06_Output		sp_PinEncoder(GPG0_Group,	0,	6,	0x1)
#define	GPG06_SD_0_DATA_3		sp_PinEncoder(GPG0_Group,	0,	6,	0x2)
#define	GPG06_INT6		sp_PinEncoder(GPG0_Group,	0,	6,	0xF)

#define	GPG10_Input    		sp_PinEncoder(GPG1_Group,	0,	0,	0x0)
#define	GPG10_Output		sp_PinEncoder(GPG1_Group,	0,	0,	0x1)
#define	GPG10_SD_1_CLK		sp_PinEncoder(GPG1_Group,	0,	0,	0x2)
#define	GPG10_INT0		sp_PinEncoder(GPG1_Group,	0,	0,	0xF)

#define	GPG11_Input    		sp_PinEncoder(GPG1_Group,	0,	1,	0x0)
#define	GPG11_Output		sp_PinEncoder(GPG1_Group,	0,	1,	0x1)
#define	GPG11_SD_1_CMD		sp_PinEncoder(GPG1_Group,	0,	1,	0x2)
#define	GPG11_INT1		sp_PinEncoder(GPG1_Group,	0,	1,	0xF)

#define	GPG12_Input    		sp_PinEncoder(GPG1_Group,	0,	2,	0x0)
#define	GPG12_Output		sp_PinEncoder(GPG1_Group,	0,	2,	0x1)
#define	GPG12_SD_1_CDn		sp_PinEncoder(GPG1_Group,	0,	2,	0x2)
#define	GPG12_INT2		sp_PinEncoder(GPG1_Group,	0,	2,	0xF)

#define	GPG13_Input    		sp_PinEncoder(GPG1_Group,	0,	3,	0x0)
#define	GPG13_Output		sp_PinEncoder(GPG1_Group,	0,	3,	0x1)
#define	GPG13_SD_1_DATA_0		sp_PinEncoder(GPG1_Group,	0,	3,	0x2)
#define	GPG13_SD_0_DATA_4		sp_PinEncoder(GPG1_Group,	0,	3,	0x3)
#define	GPG13_INT3		sp_PinEncoder(GPG1_Group,	0,	3,	0xF)

#define	GPG14_Input    		sp_PinEncoder(GPG1_Group,	0,	4,	0x0)
#define	GPG14_Output		sp_PinEncoder(GPG1_Group,	0,	4,	0x1)
#define	GPG14_SD_1_DATA_1		sp_PinEncoder(GPG1_Group,	0,	4,	0x2)
#define	GPG14_SD_0_DATA_5		sp_PinEncoder(GPG1_Group,	0,	4,	0x3)
#define	GPG14_INT4		sp_PinEncoder(GPG1_Group,	0,	4,	0xF)

#define	GPG15_Input    		sp_PinEncoder(GPG1_Group,	0,	5,	0x0)
#define	GPG15_Output		sp_PinEncoder(GPG1_Group,	0,	5,	0x1)
#define	GPG15_SD_1_DATA_2		sp_PinEncoder(GPG1_Group,	0,	5,	0x2)
#define	GPG15_SD_0_DATA_6		sp_PinEncoder(GPG1_Group,	0,	5,	0x3)
#define	GPG15_INT5		sp_PinEncoder(GPG1_Group,	0,	5,	0xF)

#define	GPG16_Input    		sp_PinEncoder(GPG1_Group,	0,	6,	0x0)
#define	GPG16_Output		sp_PinEncoder(GPG1_Group,	0,	6,	0x1)
#define	GPG16_SD_1_DATA_3		sp_PinEncoder(GPG1_Group,	0,	6,	0x2)
#define	GPG16_SD_0_DATA_7		sp_PinEncoder(GPG1_Group,	0,	6,	0x3)
#define	GPG16_INT6		sp_PinEncoder(GPG1_Group,	0,	6,	0xF)

#define	GPG20_Input    		sp_PinEncoder(GPG2_Group,	0,	0,	0x0)
#define	GPG20_Output		sp_PinEncoder(GPG2_Group,	0,	0,	0x1)
#define	GPG20_SD_2_CLK		sp_PinEncoder(GPG2_Group,	0,	0,	0x2)
#define	GPG20_SPI_2_CLK		sp_PinEncoder(GPG2_Group,	0,	0,	0x3)
#define	GPG20_INT0		sp_PinEncoder(GPG2_Group,	0,	0,	0xF)

#define	GPG21_Input    		sp_PinEncoder(GPG2_Group,	0,	1,	0x0)
#define	GPG21_Output		sp_PinEncoder(GPG2_Group,	0,	1,	0x1)
#define	GPG21_SD_2_CMD		sp_PinEncoder(GPG2_Group,	0,	1,	0x2)
#define	GPG21_SPI_2_nSS		sp_PinEncoder(GPG2_Group,	0,	1,	0x3)
#define	GPG21_INT1		sp_PinEncoder(GPG2_Group,	0,	1,	0xF)

#define	GPG22_Input    		sp_PinEncoder(GPG2_Group,	0,	2,	0x0)
#define	GPG22_Output		sp_PinEncoder(GPG2_Group,	0,	2,	0x1)
#define	GPG22_SD_2_CDn		sp_PinEncoder(GPG2_Group,	0,	2,	0x2)
#define	GPG22_SPI_2_MISO		sp_PinEncoder(GPG2_Group,	0,	2,	0x3)
#define	GPG22_INT2		sp_PinEncoder(GPG2_Group,	0,	2,	0xF)

#define	GPG23_Input    		sp_PinEncoder(GPG2_Group,	0,	3,	0x0)
#define	GPG23_Output		sp_PinEncoder(GPG2_Group,	0,	3,	0x1)
#define	GPG23_SD_2_DATA_0		sp_PinEncoder(GPG2_Group,	0,	3,	0x2)
#define	GPG23_SPI_2_MOSI		sp_PinEncoder(GPG2_Group,	0,	3,	0x3)
#define	GPG23_INT3		sp_PinEncoder(GPG2_Group,	0,	3,	0xF)

#define	GPG24_Input    		sp_PinEncoder(GPG2_Group,	0,	4,	0x0)
#define	GPG24_Output		sp_PinEncoder(GPG2_Group,	0,	4,	0x1)
#define	GPG24_SD_2_DATA_1		sp_PinEncoder(GPG2_Group,	0,	4,	0x2)
#define	GPG24_INT4		sp_PinEncoder(GPG2_Group,	0,	4,	0xF)

#define	GPG25_Input    		sp_PinEncoder(GPG2_Group,	0,	5,	0x0)
#define	GPG25_Output		sp_PinEncoder(GPG2_Group,	0,	5,	0x1)
#define	GPG25_SD_2_DATA_2		sp_PinEncoder(GPG2_Group,	0,	5,	0x2)
#define	GPG25_INT5		sp_PinEncoder(GPG2_Group,	0,	5,	0xF)

#define	GPG26_Input    		sp_PinEncoder(GPG2_Group,	0,	6,	0x0)
#define	GPG26_Output		sp_PinEncoder(GPG2_Group,	0,	6,	0x1)
#define	GPG26_SD_2_DATA_3		sp_PinEncoder(GPG2_Group,	0,	6,	0x2)
#define	GPG26_INT6		sp_PinEncoder(GPG2_Group,	0,	6,	0xF)

#define	GPG30_Input    		sp_PinEncoder(GPG3_Group,	0,	0,	0x0)
#define	GPG30_Output		sp_PinEncoder(GPG3_Group,	0,	0,	0x1)
#define	GPG30_SD_3_CLK		sp_PinEncoder(GPG3_Group,	0,	0,	0x2)
#define	GPG30_INT0		sp_PinEncoder(GPG3_Group,	0,	0,	0xF)

#define	GPG31_Input    		sp_PinEncoder(GPG3_Group,	0,	1,	0x0)
#define	GPG31_Output		sp_PinEncoder(GPG3_Group,	0,	1,	0x1)
#define	GPG31_SD_3_CMD		sp_PinEncoder(GPG3_Group,	0,	1,	0x2)
#define	GPG31_INT1		sp_PinEncoder(GPG3_Group,	0,	1,	0xF)

#define	GPG32_Input    		sp_PinEncoder(GPG3_Group,	0,	2,	0x0)
#define	GPG32_Output		sp_PinEncoder(GPG3_Group,	0,	2,	0x1)
#define	GPG32_SD_3_CDn		sp_PinEncoder(GPG3_Group,	0,	2,	0x2)
#define	GPG32_INT2		sp_PinEncoder(GPG3_Group,	0,	2,	0xF)

#define	GPG33_Input    		sp_PinEncoder(GPG3_Group,	0,	3,	0x0)
#define	GPG33_Output		sp_PinEncoder(GPG3_Group,	0,	3,	0x1)
#define	GPG33_SD_3_DATA_0		sp_PinEncoder(GPG3_Group,	0,	3,	0x2)
#define	GPG33_SD_2_DATA_4		sp_PinEncoder(GPG3_Group,	0,	3,	0x3)
#define	GPG33_INT3		sp_PinEncoder(GPG3_Group,	0,	3,	0xF)

#define	GPG34_Input    		sp_PinEncoder(GPG3_Group,	0,	4,	0x0)
#define	GPG34_Output		sp_PinEncoder(GPG3_Group,	0,	4,	0x1)
#define	GPG34_SD_3_DATA_1		sp_PinEncoder(GPG3_Group,	0,	4,	0x2)
#define	GPG34_SD_2_DATA_5		sp_PinEncoder(GPG3_Group,	0,	4,	0x3)
#define	GPG34_INT4		sp_PinEncoder(GPG3_Group,	0,	4,	0xF)

#define	GPG35_Input    		sp_PinEncoder(GPG3_Group,	0,	5,	0x0)
#define	GPG35_Output		sp_PinEncoder(GPG3_Group,	0,	5,	0x1)
#define	GPG35_SD_3_DATA_2		sp_PinEncoder(GPG3_Group,	0,	5,	0x2)
#define	GPG35_SD_2_DATA_6		sp_PinEncoder(GPG3_Group,	0,	5,	0x3)
#define	GPG35_INT5		sp_PinEncoder(GPG3_Group,	0,	5,	0xF)

#define	GPG36_Input    		sp_PinEncoder(GPG3_Group,	0,	6,	0x0)
#define	GPG36_Output		sp_PinEncoder(GPG3_Group,	0,	6,	0x1)
#define	GPG36_SD_3_DATA_3		sp_PinEncoder(GPG3_Group,	0,	6,	0x2)
#define	GPG36_SD_2_DATA_7		sp_PinEncoder(GPG3_Group,	0,	6,	0x3)
#define	GPG36_INT6		sp_PinEncoder(GPG3_Group,	0,	6,	0xF)

#define	GPI00_I2S_0_SCLK		sp_PinEncoder(GPI_Group,	0,	0,	0x2)
#if (S5PV210_EVT==0)
#define	GPI00_PCM_2_SCLK		sp_PinEncoder(GPI_Group,	0,	0,	0x3)
#else
#define	GPI00_PCM_0_SCLK		sp_PinEncoder(GPI_Group,	0,	0,	0x3)
#endif

#define	GPI01_I2S_0_CDCLK		sp_PinEncoder(GPI_Group,	0,	1,	0x2)
#if (S5PV210_EVT==0)
#define	GPI01_PCM_2_EXTCLK		sp_PinEncoder(GPI_Group,	0,	1,	0x3)
#else
#define	GPI01_PCM_0_EXTCLK		sp_PinEncoder(GPI_Group,	0,	1,	0x3)
#endif

#define	GPI02_I2S_0_LRCK		sp_PinEncoder(GPI_Group,	0,	2,	0x2)
#if (S5PV210_EVT==0)
#define	GPI02_PCM_2_FSYNC		sp_PinEncoder(GPI_Group,	0,	2,	0x3)
#else
#define	GPI02_PCM_0_FSYNC		sp_PinEncoder(GPI_Group,	0,	2,	0x3)
#endif

#define	GPI03_I2S_0_SDI		sp_PinEncoder(GPI_Group,	0,	3,	0x2)
#if (S5PV210_EVT==0)
#define	GPI03_PCM_2_SIN		sp_PinEncoder(GPI_Group,	0,	3,	0x3)
#else
#define	GPI03_PCM_0_SIN		sp_PinEncoder(GPI_Group,	0,	3,	0x3)
#endif

#define	GPI04_I2S_0_SDO_0		sp_PinEncoder(GPI_Group,	0,	4,	0x2)
#if (S5PV210_EVT==0)
#define	GPI04_PCM_2_SOUT		sp_PinEncoder(GPI_Group,	0,	4,	0x3)
#else
#define	GPI04_PCM_0_SOUT		sp_PinEncoder(GPI_Group,	0,	4,	0x3)
#endif

#define	GPI05_I2S_0_SDO_1		sp_PinEncoder(GPI_Group,	0,	5,	0x2)

#define	GPI06_I2S_0_SDO_2		sp_PinEncoder(GPI_Group,	0,	6,	0x2)

#define	GPJ00_Input    		sp_PinEncoder(GPJ0_Group,	0,	0,	0x0)
#define	GPJ00_Output		sp_PinEncoder(GPJ0_Group,	0,	0,	0x1)
#define	GPJ00_MSM_ADDR_0		sp_PinEncoder(GPJ0_Group,	0,	0,	0x2)
#define	GPJ00_CAM_B_DATA_0		sp_PinEncoder(GPJ0_Group,	0,	0,	0x3)
#define	GPJ00_CF_ADDR_0		sp_PinEncoder(GPJ0_Group,	0,	0,	0x4)
#define	GPJ00_MIPI_BYTE_CLK		sp_PinEncoder(GPJ0_Group,	0,	0,	0x5)
#define	GPJ00_INT0		sp_PinEncoder(GPJ0_Group,	0,	0,	0xF)

#define	GPJ01_Input    		sp_PinEncoder(GPJ0_Group,	0,	1,	0x0)
#define	GPJ01_Output		sp_PinEncoder(GPJ0_Group,	0,	1,	0x1)
#define	GPJ01_MSM_ADDR_1		sp_PinEncoder(GPJ0_Group,	0,	1,	0x2)
#define	GPJ01_CAM_B_DATA_1		sp_PinEncoder(GPJ0_Group,	0,	1,	0x3)
#define	GPJ01_CF_ADDR_1		sp_PinEncoder(GPJ0_Group,	0,	1,	0x4)
#define	GPJ01_MIPI_ESC_CLK		sp_PinEncoder(GPJ0_Group,	0,	1,	0x5)
#define	GPJ01_INT1		sp_PinEncoder(GPJ0_Group,	0,	1,	0xF)

#define	GPJ02_Input    		sp_PinEncoder(GPJ0_Group,	0,	2,	0x0)
#define	GPJ02_Output		sp_PinEncoder(GPJ0_Group,	0,	2,	0x1)
#define	GPJ02_MSM_ADDR_2		sp_PinEncoder(GPJ0_Group,	0,	2,	0x2)
#define	GPJ02_CAM_B_DATA_2		sp_PinEncoder(GPJ0_Group,	0,	2,	0x3)
#define	GPJ02_CF_ADDR_2		sp_PinEncoder(GPJ0_Group,	0,	2,	0x4)
#define	GPJ02_TS_CLK		sp_PinEncoder(GPJ0_Group,	0,	2,	0x5)
#define	GPJ02_INT2		sp_PinEncoder(GPJ0_Group,	0,	2,	0xF)

#define	GPJ03_Input    		sp_PinEncoder(GPJ0_Group,	0,	3,	0x0)
#define	GPJ03_Output		sp_PinEncoder(GPJ0_Group,	0,	3,	0x1)
#define	GPJ03_MSM_ADDR_3		sp_PinEncoder(GPJ0_Group,	0,	3,	0x2)
#define	GPJ03_CAM_B_DATA_3		sp_PinEncoder(GPJ0_Group,	0,	3,	0x3)
#define	GPJ03_CF_IORDY		sp_PinEncoder(GPJ0_Group,	0,	3,	0x4)
#define	GPJ03_TS_SYNC		sp_PinEncoder(GPJ0_Group,	0,	3,	0x5)
#define	GPJ03_INT3		sp_PinEncoder(GPJ0_Group,	0,	3,	0xF)

#define	GPJ04_Input    		sp_PinEncoder(GPJ0_Group,	0,	4,	0x0)
#define	GPJ04_Output		sp_PinEncoder(GPJ0_Group,	0,	4,	0x1)
#define	GPJ04_MSM_ADDR_4		sp_PinEncoder(GPJ0_Group,	0,	4,	0x2)
#define	GPJ04_CAM_B_DATA_4		sp_PinEncoder(GPJ0_Group,	0,	4,	0x3)
#define	GPJ04_CF_INTRQ		sp_PinEncoder(GPJ0_Group,	0,	4,	0x4)
#define	GPJ04_TS_VAL		sp_PinEncoder(GPJ0_Group,	0,	4,	0x5)
#define	GPJ04_INT4		sp_PinEncoder(GPJ0_Group,	0,	4,	0xF)

#define	GPJ05_Input    		sp_PinEncoder(GPJ0_Group,	0,	5,	0x0)
#define	GPJ05_Output		sp_PinEncoder(GPJ0_Group,	0,	5,	0x1)
#define	GPJ05_MSM_ADDR_5		sp_PinEncoder(GPJ0_Group,	0,	5,	0x2)
#define	GPJ05_CAM_B_DATA_5		sp_PinEncoder(GPJ0_Group,	0,	5,	0x3)
#define	GPJ05_CF_DMARQ		sp_PinEncoder(GPJ0_Group,	0,	5,	0x4)
#define	GPJ05_TS_DATA		sp_PinEncoder(GPJ0_Group,	0,	5,	0x5)
#define	GPJ05_INT5		sp_PinEncoder(GPJ0_Group,	0,	5,	0xF)

#define	GPJ06_Input    		sp_PinEncoder(GPJ0_Group,	0,	6,	0x0)
#define	GPJ06_Output		sp_PinEncoder(GPJ0_Group,	0,	6,	0x1)
#define	GPJ06_MSM_ADDR_6		sp_PinEncoder(GPJ0_Group,	0,	6,	0x2)
#define	GPJ06_CAM_B_DATA_6		sp_PinEncoder(GPJ0_Group,	0,	6,	0x3)
#define	GPJ06_CF_DRESETN		sp_PinEncoder(GPJ0_Group,	0,	6,	0x4)
#define	GPJ06_TS_ERROR		sp_PinEncoder(GPJ0_Group,	0,	6,	0x5)
#define	GPJ06_INT6		sp_PinEncoder(GPJ0_Group,	0,	6,	0xF)

#define	GPJ07_Input    		sp_PinEncoder(GPJ0_Group,	0,	7,	0x0)
#define	GPJ07_Output		sp_PinEncoder(GPJ0_Group,	0,	7,	0x1)
#define	GPJ07_MSM_ADDR_7		sp_PinEncoder(GPJ0_Group,	0,	7,	0x2)
#define	GPJ07_CAM_B_DATA_7		sp_PinEncoder(GPJ0_Group,	0,	7,	0x3)
#define	GPJ07_CF_DMACKN		sp_PinEncoder(GPJ0_Group,	0,	7,	0x4)
#define	GPJ07_MHL_D0		sp_PinEncoder(GPJ0_Group,	0,	7,	0x5)
#define	GPJ07_INT7		sp_PinEncoder(GPJ0_Group,	0,	7,	0xF)

#define	GPJ10_Input    		sp_PinEncoder(GPJ1_Group,	0,	0,	0x0)
#define	GPJ10_Output		sp_PinEncoder(GPJ1_Group,	0,	0,	0x1)
#define	GPJ10_MSM_ADDR_8		sp_PinEncoder(GPJ1_Group,	0,	0,	0x2)
#define	GPJ10_CAM_B_PCLK		sp_PinEncoder(GPJ1_Group,	0,	0,	0x3)
#define	GPJ10_SROM_ADDR_16to22_0		sp_PinEncoder(GPJ1_Group,	0,	0,	0x4)
#define	GPJ10_MHL_D1		sp_PinEncoder(GPJ1_Group,	0,	0,	0x5)
#define	GPJ10_INT0		sp_PinEncoder(GPJ1_Group,	0,	0,	0xF)

#define	GPJ11_Input    		sp_PinEncoder(GPJ1_Group,	0,	1,	0x0)
#define	GPJ11_Output		sp_PinEncoder(GPJ1_Group,	0,	1,	0x1)
#define	GPJ11_MSM_ADDR_9		sp_PinEncoder(GPJ1_Group,	0,	1,	0x2)
#define	GPJ11_CAM_B_VSYNC		sp_PinEncoder(GPJ1_Group,	0,	1,	0x3)
#define	GPJ11_SROM_ADDR_16to22_1		sp_PinEncoder(GPJ1_Group,	0,	1,	0x4)
#define	GPJ11_MHL_D2		sp_PinEncoder(GPJ1_Group,	0,	1,	0x5)
#define	GPJ11_INT1		sp_PinEncoder(GPJ1_Group,	0,	1,	0xF)

#define	GPJ12_Input    		sp_PinEncoder(GPJ1_Group,	0,	2,	0x0)
#define	GPJ12_Output		sp_PinEncoder(GPJ1_Group,	0,	2,	0x1)
#define	GPJ12_MSM_ADDR_10		sp_PinEncoder(GPJ1_Group,	0,	2,	0x2)
#define	GPJ12_CAM_B_HREF		sp_PinEncoder(GPJ1_Group,	0,	2,	0x3)
#define	GPJ12_SROM_ADDR_16to22_2		sp_PinEncoder(GPJ1_Group,	0,	2,	0x4)
#define	GPJ12_MHL_D3		sp_PinEncoder(GPJ1_Group,	0,	2,	0x5)
#define	GPJ12_INT2		sp_PinEncoder(GPJ1_Group,	0,	2,	0xF)

#define	GPJ13_Input    		sp_PinEncoder(GPJ1_Group,	0,	3,	0x0)
#define	GPJ13_Output		sp_PinEncoder(GPJ1_Group,	0,	3,	0x1)
#define	GPJ13_MSM_ADDR_11		sp_PinEncoder(GPJ1_Group,	0,	3,	0x2)
#define	GPJ13_CAM_B_FIELD		sp_PinEncoder(GPJ1_Group,	0,	3,	0x3)
#define	GPJ13_SROM_ADDR_16to22_3		sp_PinEncoder(GPJ1_Group,	0,	3,	0x4)
#define	GPJ13_MHL_D4		sp_PinEncoder(GPJ1_Group,	0,	3,	0x5)
#define	GPJ13_INT3		sp_PinEncoder(GPJ1_Group,	0,	3,	0xF)

#define	GPJ14_Input    		sp_PinEncoder(GPJ1_Group,	0,	4,	0x0)
#define	GPJ14_Output		sp_PinEncoder(GPJ1_Group,	0,	4,	0x1)
#define	GPJ14_MSM_ADDR_12		sp_PinEncoder(GPJ1_Group,	0,	4,	0x2)
#define	GPJ14_CAM_B_CLKOUT		sp_PinEncoder(GPJ1_Group,	0,	4,	0x3)
#define	GPJ14_SROM_ADDR_16to22_4		sp_PinEncoder(GPJ1_Group,	0,	4,	0x4)
#define	GPJ14_MHL_D5		sp_PinEncoder(GPJ1_Group,	0,	4,	0x5)
#define	GPJ14_INT4		sp_PinEncoder(GPJ1_Group,	0,	4,	0xF)

#define	GPJ15_Input    		sp_PinEncoder(GPJ1_Group,	0,	5,	0x0)
#define	GPJ15_Output		sp_PinEncoder(GPJ1_Group,	0,	5,	0x1)
#define	GPJ15_MSM_ADDR_13		sp_PinEncoder(GPJ1_Group,	0,	5,	0x2)
#define	GPJ15_KP_COL_0		sp_PinEncoder(GPJ1_Group,	0,	5,	0x3)
#define	GPJ15_SROM_ADDR_16to22_5		sp_PinEncoder(GPJ1_Group,	0,	5,	0x4)
#define	GPJ15_MHL_D6		sp_PinEncoder(GPJ1_Group,	0,	5,	0x5)
#define	GPJ15_INT5		sp_PinEncoder(GPJ1_Group,	0,	5,	0xF)

#define	GPJ20_Input    		sp_PinEncoder(GPJ2_Group,	0,	0,	0x0)
#define	GPJ20_Output		sp_PinEncoder(GPJ2_Group,	0,	0,	0x1)
#define	GPJ20_MSM_DATA_0		sp_PinEncoder(GPJ2_Group,	0,	0,	0x2)
#define	GPJ20_KP_COL_1		sp_PinEncoder(GPJ2_Group,	0,	0,	0x3)
#define	GPJ20_CF_DATA_0		sp_PinEncoder(GPJ2_Group,	0,	0,	0x4)
#define	GPJ20_MHL_D7		sp_PinEncoder(GPJ2_Group,	0,	0,	0x5)
#define	GPJ20_INT0		sp_PinEncoder(GPJ2_Group,	0,	0,	0xF)

#define	GPJ21_Input    		sp_PinEncoder(GPJ2_Group,	0,	1,	0x0)
#define	GPJ21_Output		sp_PinEncoder(GPJ2_Group,	0,	1,	0x1)
#define	GPJ21_MSM_DATA_1		sp_PinEncoder(GPJ2_Group,	0,	1,	0x2)
#define	GPJ21_KP_COL_2		sp_PinEncoder(GPJ2_Group,	0,	1,	0x3)
#define	GPJ21_CF_DATA_1		sp_PinEncoder(GPJ2_Group,	0,	1,	0x4)
#define	GPJ21_MHL_D8		sp_PinEncoder(GPJ2_Group,	0,	1,	0x5)
#define	GPJ21_INT1		sp_PinEncoder(GPJ2_Group,	0,	1,	0xF)

#define	GPJ22_Input    		sp_PinEncoder(GPJ2_Group,	0,	2,	0x0)
#define	GPJ22_Output		sp_PinEncoder(GPJ2_Group,	0,	2,	0x1)
#define	GPJ22_MSM_DATA_2		sp_PinEncoder(GPJ2_Group,	0,	2,	0x2)
#define	GPJ22_KP_COL_3		sp_PinEncoder(GPJ2_Group,	0,	2,	0x3)
#define	GPJ22_CF_DATA_2		sp_PinEncoder(GPJ2_Group,	0,	2,	0x4)
#define	GPJ22_MHL_D9		sp_PinEncoder(GPJ2_Group,	0,	2,	0x5)
#define	GPJ22_INT2		sp_PinEncoder(GPJ2_Group,	0,	2,	0xF)

#define	GPJ23_Input    		sp_PinEncoder(GPJ2_Group,	0,	3,	0x0)
#define	GPJ23_Output		sp_PinEncoder(GPJ2_Group,	0,	3,	0x1)
#define	GPJ23_MSM_DATA_3		sp_PinEncoder(GPJ2_Group,	0,	3,	0x2)
#define	GPJ23_KP_COL_4		sp_PinEncoder(GPJ2_Group,	0,	3,	0x3)
#define	GPJ23_CF_DATA_3		sp_PinEncoder(GPJ2_Group,	0,	3,	0x4)
#define	GPJ23_MHL_D10		sp_PinEncoder(GPJ2_Group,	0,	3,	0x5)
#define	GPJ23_INT3		sp_PinEncoder(GPJ2_Group,	0,	3,	0xF)

#define	GPJ24_Input    		sp_PinEncoder(GPJ2_Group,	0,	4,	0x0)
#define	GPJ24_Output		sp_PinEncoder(GPJ2_Group,	0,	4,	0x1)
#define	GPJ24_MSM_DATA_4		sp_PinEncoder(GPJ2_Group,	0,	4,	0x2)
#define	GPJ24_KP_COL_5		sp_PinEncoder(GPJ2_Group,	0,	4,	0x3)
#define	GPJ24_CF_DATA_4		sp_PinEncoder(GPJ2_Group,	0,	4,	0x4)
#define	GPJ24_MHL_D11		sp_PinEncoder(GPJ2_Group,	0,	4,	0x5)
#define	GPJ24_INT4		sp_PinEncoder(GPJ2_Group,	0,	4,	0xF)

#define	GPJ25_Input    		sp_PinEncoder(GPJ2_Group,	0,	5,	0x0)
#define	GPJ25_Output		sp_PinEncoder(GPJ2_Group,	0,	5,	0x1)
#define	GPJ25_MSM_DATA_5		sp_PinEncoder(GPJ2_Group,	0,	5,	0x2)
#define	GPJ25_KP_COL_6		sp_PinEncoder(GPJ2_Group,	0,	5,	0x3)
#define	GPJ25_CF_DATA_5		sp_PinEncoder(GPJ2_Group,	0,	5,	0x4)
#define	GPJ25_MHL_D12		sp_PinEncoder(GPJ2_Group,	0,	5,	0x5)
#define	GPJ25_INT5		sp_PinEncoder(GPJ2_Group,	0,	5,	0xF)

#define	GPJ26_Input    		sp_PinEncoder(GPJ2_Group,	0,	6,	0x0)
#define	GPJ26_Output		sp_PinEncoder(GPJ2_Group,	0,	6,	0x1)
#define	GPJ26_MSM_DATA_6		sp_PinEncoder(GPJ2_Group,	0,	6,	0x2)
#define	GPJ26_KP_COL_7		sp_PinEncoder(GPJ2_Group,	0,	6,	0x3)
#define	GPJ26_CF_DATA_6		sp_PinEncoder(GPJ2_Group,	0,	6,	0x4)
#define	GPJ26_MHL_D13		sp_PinEncoder(GPJ2_Group,	0,	6,	0x5)
#define	GPJ26_INT6		sp_PinEncoder(GPJ2_Group,	0,	6,	0xF)

#define	GPJ27_Input    		sp_PinEncoder(GPJ2_Group,	0,	7,	0x0)
#define	GPJ27_Output		sp_PinEncoder(GPJ2_Group,	0,	7,	0x1)
#define	GPJ27_MSM_DATA_7		sp_PinEncoder(GPJ2_Group,	0,	7,	0x2)
#define	GPJ27_KP_ROW_0		sp_PinEncoder(GPJ2_Group,	0,	7,	0x3)
#define	GPJ27_CF_DATA_7		sp_PinEncoder(GPJ2_Group,	0,	7,	0x4)
#define	GPJ27_MHL_D14		sp_PinEncoder(GPJ2_Group,	0,	7,	0x5)
#define	GPJ27_INT7		sp_PinEncoder(GPJ2_Group,	0,	7,	0xF)

#define	GPJ30_Input    		sp_PinEncoder(GPJ3_Group,	0,	0,	0x0)
#define	GPJ30_Output		sp_PinEncoder(GPJ3_Group,	0,	0,	0x1)
#define	GPJ30_MSM_DATA_8		sp_PinEncoder(GPJ3_Group,	0,	0,	0x2)
#define	GPJ30_KP_ROW_1		sp_PinEncoder(GPJ3_Group,	0,	0,	0x3)
#define	GPJ30_CF_DATA_8		sp_PinEncoder(GPJ3_Group,	0,	0,	0x4)
#define	GPJ30_MHL_D15		sp_PinEncoder(GPJ3_Group,	0,	0,	0x5)
#define	GPJ30_INT0		sp_PinEncoder(GPJ3_Group,	0,	0,	0xF)

#define	GPJ31_Input    		sp_PinEncoder(GPJ3_Group,	0,	1,	0x0)
#define	GPJ31_Output		sp_PinEncoder(GPJ3_Group,	0,	1,	0x1)
#define	GPJ31_MSM_DATA_9		sp_PinEncoder(GPJ3_Group,	0,	1,	0x2)
#define	GPJ31_KP_ROW_2		sp_PinEncoder(GPJ3_Group,	0,	1,	0x3)
#define	GPJ31_CF_DATA_9		sp_PinEncoder(GPJ3_Group,	0,	1,	0x4)
#define	GPJ31_MHL_D16		sp_PinEncoder(GPJ3_Group,	0,	1,	0x5)
#define	GPJ31_INT1		sp_PinEncoder(GPJ3_Group,	0,	1,	0xF)

#define	GPJ32_Input    		sp_PinEncoder(GPJ3_Group,	0,	2,	0x0)
#define	GPJ32_Output		sp_PinEncoder(GPJ3_Group,	0,	2,	0x1)
#define	GPJ32_MSM_DATA_10		sp_PinEncoder(GPJ3_Group,	0,	2,	0x2)
#define	GPJ32_KP_ROW_3		sp_PinEncoder(GPJ3_Group,	0,	2,	0x3)
#define	GPJ32_CF_DATA_10		sp_PinEncoder(GPJ3_Group,	0,	2,	0x4)
#define	GPJ32_MHL_D17		sp_PinEncoder(GPJ3_Group,	0,	2,	0x5)
#define	GPJ32_INT2		sp_PinEncoder(GPJ3_Group,	0,	2,	0xF)

#define	GPJ33_Input    		sp_PinEncoder(GPJ3_Group,	0,	3,	0x0)
#define	GPJ33_Output		sp_PinEncoder(GPJ3_Group,	0,	3,	0x1)
#define	GPJ33_MSM_DATA_11		sp_PinEncoder(GPJ3_Group,	0,	3,	0x2)
#define	GPJ33_KP_ROW_4		sp_PinEncoder(GPJ3_Group,	0,	3,	0x3)
#define	GPJ33_CF_DATA_11		sp_PinEncoder(GPJ3_Group,	0,	3,	0x4)
#define	GPJ33_MHL_D18		sp_PinEncoder(GPJ3_Group,	0,	3,	0x5)
#define	GPJ33_INT3		sp_PinEncoder(GPJ3_Group,	0,	3,	0xF)

#define	GPJ34_Input    		sp_PinEncoder(GPJ3_Group,	0,	4,	0x0)
#define	GPJ34_Output		sp_PinEncoder(GPJ3_Group,	0,	4,	0x1)
#define	GPJ34_MSM_DATA_12		sp_PinEncoder(GPJ3_Group,	0,	4,	0x2)
#define	GPJ34_KP_ROW_5		sp_PinEncoder(GPJ3_Group,	0,	4,	0x3)
#define	GPJ34_CF_DATA_12		sp_PinEncoder(GPJ3_Group,	0,	4,	0x4)
#define	GPJ34_MHL_D19		sp_PinEncoder(GPJ3_Group,	0,	4,	0x5)
#define	GPJ34_INT4		sp_PinEncoder(GPJ3_Group,	0,	4,	0xF)

#define	GPJ35_Input    		sp_PinEncoder(GPJ3_Group,	0,	5,	0x0)
#define	GPJ35_Output		sp_PinEncoder(GPJ3_Group,	0,	5,	0x1)
#define	GPJ35_MSM_DATA_13		sp_PinEncoder(GPJ3_Group,	0,	5,	0x2)
#define	GPJ35_KP_ROW_6		sp_PinEncoder(GPJ3_Group,	0,	5,	0x3)
#define	GPJ35_CF_DATA_13		sp_PinEncoder(GPJ3_Group,	0,	5,	0x4)
#define	GPJ35_MHL_D20		sp_PinEncoder(GPJ3_Group,	0,	5,	0x5)
#define	GPJ35_INT5		sp_PinEncoder(GPJ3_Group,	0,	5,	0xF)

#define	GPJ36_Input    		sp_PinEncoder(GPJ3_Group,	0,	6,	0x0)
#define	GPJ36_Output		sp_PinEncoder(GPJ3_Group,	0,	6,	0x1)
#define	GPJ36_MSM_DATA_14		sp_PinEncoder(GPJ3_Group,	0,	6,	0x2)
#define	GPJ36_KP_ROW_7		sp_PinEncoder(GPJ3_Group,	0,	6,	0x3)
#define	GPJ36_CF_DATA_14		sp_PinEncoder(GPJ3_Group,	0,	6,	0x4)
#define	GPJ36_MHL_D21		sp_PinEncoder(GPJ3_Group,	0,	6,	0x5)
#define	GPJ36_INT6		sp_PinEncoder(GPJ3_Group,	0,	6,	0xF)

#define	GPJ37_Input    		sp_PinEncoder(GPJ3_Group,	0,	7,	0x0)
#define	GPJ37_Output		sp_PinEncoder(GPJ3_Group,	0,	7,	0x1)
#define	GPJ37_MSM_DATA_15		sp_PinEncoder(GPJ3_Group,	0,	7,	0x2)
#define	GPJ37_KP_ROW_8		sp_PinEncoder(GPJ3_Group,	0,	7,	0x3)
#define	GPJ37_CF_DATA_15		sp_PinEncoder(GPJ3_Group,	0,	7,	0x4)
#define	GPJ37_MHL_D22		sp_PinEncoder(GPJ3_Group,	0,	7,	0x5)
#define	GPJ37_INT7		sp_PinEncoder(GPJ3_Group,	0,	7,	0xF)

#define	GPJ40_Input    		sp_PinEncoder(GPJ4_Group,	0,	0,	0x0)
#define	GPJ40_Output		sp_PinEncoder(GPJ4_Group,	0,	0,	0x1)
#define	GPJ40_MSM_CSn		sp_PinEncoder(GPJ4_Group,	0,	0,	0x2)
#define	GPJ40_KP_ROW_9		sp_PinEncoder(GPJ4_Group,	0,	0,	0x3)
#define	GPJ40_CF_CSn_0		sp_PinEncoder(GPJ4_Group,	0,	0,	0x4)
#define	GPJ40_MHL_D23		sp_PinEncoder(GPJ4_Group,	0,	0,	0x5)
#define	GPJ40_INT0		sp_PinEncoder(GPJ4_Group,	0,	0,	0xF)

#define	GPJ41_Input    		sp_PinEncoder(GPJ4_Group,	0,	1,	0x0)
#define	GPJ41_Output		sp_PinEncoder(GPJ4_Group,	0,	1,	0x1)
#define	GPJ41_MSM_WEn		sp_PinEncoder(GPJ4_Group,	0,	1,	0x2)
#define	GPJ41_KP_ROW_10		sp_PinEncoder(GPJ4_Group,	0,	1,	0x3)
#define	GPJ41_CF_CSn_1		sp_PinEncoder(GPJ4_Group,	0,	1,	0x4)
#define	GPJ41_MHL_HSYNC		sp_PinEncoder(GPJ4_Group,	0,	1,	0x5)
#define	GPJ41_INT1		sp_PinEncoder(GPJ4_Group,	0,	1,	0xF)

#define	GPJ42_Input    		sp_PinEncoder(GPJ4_Group,	0,	2,	0x0)
#define	GPJ42_Output		sp_PinEncoder(GPJ4_Group,	0,	2,	0x1)
#define	GPJ42_MSM_Rn		sp_PinEncoder(GPJ4_Group,	0,	2,	0x2)
#define	GPJ42_KP_ROW_11		sp_PinEncoder(GPJ4_Group,	0,	2,	0x3)
#define	GPJ42_CF_IORN		sp_PinEncoder(GPJ4_Group,	0,	2,	0x4)
#define	GPJ42_MHL_IDCK		sp_PinEncoder(GPJ4_Group,	0,	2,	0x5)
#define	GPJ42_INT2		sp_PinEncoder(GPJ4_Group,	0,	2,	0xF)

#define	GPJ43_Input    		sp_PinEncoder(GPJ4_Group,	0,	3,	0x0)
#define	GPJ43_Output		sp_PinEncoder(GPJ4_Group,	0,	3,	0x1)
#define	GPJ43_MSM_IRQn		sp_PinEncoder(GPJ4_Group,	0,	3,	0x2)
#define	GPJ43_KP_ROW_12		sp_PinEncoder(GPJ4_Group,	0,	3,	0x3)
#define	GPJ43_CF_IOWN		sp_PinEncoder(GPJ4_Group,	0,	3,	0x4)
#define	GPJ43_MHL_VSYNC		sp_PinEncoder(GPJ4_Group,	0,	3,	0x5)
#define	GPJ43_INT3		sp_PinEncoder(GPJ4_Group,	0,	3,	0xF)

#define	GPJ44_Input    		sp_PinEncoder(GPJ4_Group,	0,	4,	0x0)
#define	GPJ44_Output		sp_PinEncoder(GPJ4_Group,	0,	4,	0x1)
#define	GPJ44_MSM_ADVN		sp_PinEncoder(GPJ4_Group,	0,	4,	0x2)
#define	GPJ44_KP_ROW_13		sp_PinEncoder(GPJ4_Group,	0,	4,	0x3)
#define	GPJ44_SROM_ADDR_16to22_6		sp_PinEncoder(GPJ4_Group,	0,	4,	0x4)
#define	GPJ44_MHL_DE		sp_PinEncoder(GPJ4_Group,	0,	4,	0x5)
#define	GPJ44_INT4		sp_PinEncoder(GPJ4_Group,	0,	4,	0xF)

#define	MP01_0_Input    		sp_PinEncoder(MP01_Group,	0,	0,	0x0)
#define	MP01_0_Output		sp_PinEncoder(MP01_Group,	0,	0,	0x1)
#define	MP01_0_SROM_CSn_0		sp_PinEncoder(MP01_Group,	0,	0,	0x2)

#define	MP01_1_Input    		sp_PinEncoder(MP01_Group,	0,	1,	0x0)
#define	MP01_1_Output		sp_PinEncoder(MP01_Group,	0,	1,	0x1)
#define	MP01_1_SROM_CSn_1		sp_PinEncoder(MP01_Group,	0,	1,	0x2)

#define	MP01_2_Input    		sp_PinEncoder(MP01_Group,	0,	2,	0x0)
#define	MP01_2_Output		sp_PinEncoder(MP01_Group,	0,	2,	0x1)
#define	MP01_2_SROM_CSn_2		sp_PinEncoder(MP01_Group,	0,	2,	0x2)
#define	MP01_2_NFCSn_0		sp_PinEncoder(MP01_Group,	0,	2,	0x3)

#define	MP01_3_Input    		sp_PinEncoder(MP01_Group,	0,	3,	0x0)
#define	MP01_3_Output		sp_PinEncoder(MP01_Group,	0,	3,	0x1)
#define	MP01_3_SROM_CSn_3		sp_PinEncoder(MP01_Group,	0,	3,	0x2)
#define	MP01_3_NFCSn_1		sp_PinEncoder(MP01_Group,	0,	3,	0x3)

#define	MP01_4_Input    		sp_PinEncoder(MP01_Group,	0,	4,	0x0)
#define	MP01_4_Output		sp_PinEncoder(MP01_Group,	0,	4,	0x1)
#define	MP01_4_SROM_CSn_4		sp_PinEncoder(MP01_Group,	0,	4,	0x2)
#define	MP01_4_NFCSn_2		sp_PinEncoder(MP01_Group,	0,	4,	0x3)
#define	MP01_4_ONANDXL_CSn_0		sp_PinEncoder(MP01_Group,	0,	4,	0x5)

#define	MP01_5_Input    		sp_PinEncoder(MP01_Group,	0,	5,	0x0)
#define	MP01_5_Output		sp_PinEncoder(MP01_Group,	0,	5,	0x1)
#define	MP01_5_SROM_CSn_5		sp_PinEncoder(MP01_Group,	0,	5,	0x2)
#define	MP01_5_NFCSn_3		sp_PinEncoder(MP01_Group,	0,	5,	0x3)
#define	MP01_5_ONANDXL_CSn_1		sp_PinEncoder(MP01_Group,	0,	5,	0x5)

#define	MP01_6_Input    		sp_PinEncoder(MP01_Group,	0,	6,	0x0)
#define	MP01_6_Output		sp_PinEncoder(MP01_Group,	0,	6,	0x1)
#define	MP01_6_EBI_OEn		sp_PinEncoder(MP01_Group,	0,	6,	0x2)

#define	MP01_7_Input    		sp_PinEncoder(MP01_Group,	0,	7,	0x0)
#define	MP01_7_Output		sp_PinEncoder(MP01_Group,	0,	7,	0x1)
#define	MP01_7_EBI_WEn		sp_PinEncoder(MP01_Group,	0,	7,	0x2)

#define	MP02_0_Input    		sp_PinEncoder(MP02_Group,	0,	0,	0x0)
#define	MP02_0_Output		sp_PinEncoder(MP02_Group,	0,	0,	0x1)
#define	MP02_0_EBI_BEn_0		sp_PinEncoder(MP02_Group,	0,	0,	0x2)

#define	MP02_1_Input    		sp_PinEncoder(MP02_Group,	0,	1,	0x0)
#define	MP02_1_Output		sp_PinEncoder(MP02_Group,	0,	1,	0x1)
#define	MP02_1_EBI_BEn_1		sp_PinEncoder(MP02_Group,	0,	1,	0x2)

#define	MP02_2_Input    		sp_PinEncoder(MP02_Group,	0,	2,	0x0)
#define	MP02_2_Output		sp_PinEncoder(MP02_Group,	0,	2,	0x1)
#define	MP02_2_SROM_WAITn		sp_PinEncoder(MP02_Group,	0,	2,	0x2)

#define	MP02_3_Input    		sp_PinEncoder(MP02_Group,	0,	3,	0x0)
#define	MP02_3_Output		sp_PinEncoder(MP02_Group,	0,	3,	0x1)
#define	MP02_3_EBI_DATA_RDn		sp_PinEncoder(MP02_Group,	0,	3,	0x2)

#define	MP03_0_Input    		sp_PinEncoder(MP03_Group,	0,	0,	0x0)
#define	MP03_0_Output		sp_PinEncoder(MP03_Group,	0,	0,	0x1)
#define	MP03_0_NF_CLE		sp_PinEncoder(MP03_Group,	0,	0,	0x2)
#define	MP03_0_ONANDXL_ADDRVALID		sp_PinEncoder(MP03_Group,	0,	0,	0x5)

#define	MP03_1_Input    		sp_PinEncoder(MP03_Group,	0,	1,	0x0)
#define	MP03_1_Output		sp_PinEncoder(MP03_Group,	0,	1,	0x1)
#define	MP03_1_NF_ALE		sp_PinEncoder(MP03_Group,	0,	1,	0x2)
#define	MP03_1_ONANDXL_SMCLK		sp_PinEncoder(MP03_Group,	0,	1,	0x5)

#define	MP03_2_Input    		sp_PinEncoder(MP03_Group,	0,	2,	0x0)
#define	MP03_2_Output		sp_PinEncoder(MP03_Group,	0,	2,	0x1)
#define	MP03_2_NF_FWEn		sp_PinEncoder(MP03_Group,	0,	2,	0x2)
#define	MP03_2_ONANDXL_RPn		sp_PinEncoder(MP03_Group,	0,	2,	0x5)

#define	MP03_3_Input    		sp_PinEncoder(MP03_Group,	0,	3,	0x0)
#define	MP03_3_Output		sp_PinEncoder(MP03_Group,	0,	3,	0x1)
#define	MP03_3_NF_FREn		sp_PinEncoder(MP03_Group,	0,	3,	0x2)

#define	MP03_4_Input    		sp_PinEncoder(MP03_Group,	0,	4,	0x0)
#define	MP03_4_Output		sp_PinEncoder(MP03_Group,	0,	4,	0x1)
#define	MP03_4_NF_RnB_0		sp_PinEncoder(MP03_Group,	0,	4,	0x2)
#define	MP03_4_ONANDXL_INT_0		sp_PinEncoder(MP03_Group,	0,	4,	0x5)

#define	MP03_5_Input    		sp_PinEncoder(MP03_Group,	0,	5,	0x0)
#define	MP03_5_Output		sp_PinEncoder(MP03_Group,	0,	5,	0x1)
#define	MP03_5_NF_RnB_1		sp_PinEncoder(MP03_Group,	0,	5,	0x2)
#define	MP03_5_ONANDXL_INT_1		sp_PinEncoder(MP03_Group,	0,	5,	0x5)

#define	MP03_6_Input    		sp_PinEncoder(MP03_Group,	0,	6,	0x0)
#define	MP03_6_Output		sp_PinEncoder(MP03_Group,	0,	6,	0x1)
#define	MP03_6_NF_RnB_2		sp_PinEncoder(MP03_Group,	0,	6,	0x2)

#define	MP03_7_Input    		sp_PinEncoder(MP03_Group,	0,	7,	0x0)
#define	MP03_7_Output		sp_PinEncoder(MP03_Group,	0,	7,	0x1)
#define	MP03_7_NF_RnB_3		sp_PinEncoder(MP03_Group,	0,	7,	0x2)

#define	MP04_0_Input    		sp_PinEncoder(MP04_Group,	0,	0,	0x0)
#define	MP04_0_Output		sp_PinEncoder(MP04_Group,	0,	0,	0x1)
#define	MP04_0_EBI_ADDR_0		sp_PinEncoder(MP04_Group,	0,	0,	0x2)

#define	MP04_1_Input    		sp_PinEncoder(MP04_Group,	0,	1,	0x0)
#define	MP04_1_Output		sp_PinEncoder(MP04_Group,	0,	1,	0x1)
#define	MP04_1_EBI_ADDR_1		sp_PinEncoder(MP04_Group,	0,	1,	0x2)

#define	MP04_2_Input    		sp_PinEncoder(MP04_Group,	0,	2,	0x0)
#define	MP04_2_Output		sp_PinEncoder(MP04_Group,	0,	2,	0x1)
#define	MP04_2_EBI_ADDR_2		sp_PinEncoder(MP04_Group,	0,	2,	0x2)

#define	MP04_3_Input    		sp_PinEncoder(MP04_Group,	0,	3,	0x0)
#define	MP04_3_Output		sp_PinEncoder(MP04_Group,	0,	3,	0x1)
#define	MP04_3_EBI_ADDR_3		sp_PinEncoder(MP04_Group,	0,	3,	0x2)

#define	MP04_4_Input    		sp_PinEncoder(MP04_Group,	0,	4,	0x0)
#define	MP04_4_Output		sp_PinEncoder(MP04_Group,	0,	4,	0x1)
#define	MP04_4_EBI_ADDR_4		sp_PinEncoder(MP04_Group,	0,	4,	0x2)

#define	MP04_5_Input    		sp_PinEncoder(MP04_Group,	0,	5,	0x0)
#define	MP04_5_Output		sp_PinEncoder(MP04_Group,	0,	5,	0x1)
#define	MP04_5_EBI_ADDR_5		sp_PinEncoder(MP04_Group,	0,	5,	0x2)

#define	MP04_6_Input    		sp_PinEncoder(MP04_Group,	0,	6,	0x0)
#define	MP04_6_Output		sp_PinEncoder(MP04_Group,	0,	6,	0x1)
#define	MP04_6_EBI_ADDR_6		sp_PinEncoder(MP04_Group,	0,	6,	0x2)

#define	MP04_7_Input    		sp_PinEncoder(MP04_Group,	0,	7,	0x0)
#define	MP04_7_Output		sp_PinEncoder(MP04_Group,	0,	7,	0x1)
#define	MP04_7_EBI_ADDR_7		sp_PinEncoder(MP04_Group,	0,	7,	0x2)

#define	MP05_0_Input    		sp_PinEncoder(MP05_Group,	0,	0,	0x0)
#define	MP05_0_Output		sp_PinEncoder(MP05_Group,	0,	0,	0x1)
#define	MP05_0_EBI_ADDR_8		sp_PinEncoder(MP05_Group,	0,	0,	0x2)

#define	MP05_1_Input    		sp_PinEncoder(MP05_Group,	0,	1,	0x0)
#define	MP05_1_Output		sp_PinEncoder(MP05_Group,	0,	1,	0x1)
#define	MP05_1_EBI_ADDR_9		sp_PinEncoder(MP05_Group,	0,	1,	0x2)

#define	MP05_2_Input    		sp_PinEncoder(MP05_Group,	0,	2,	0x0)
#define	MP05_2_Output		sp_PinEncoder(MP05_Group,	0,	2,	0x1)
#define	MP05_2_EBI_ADDR_10		sp_PinEncoder(MP05_Group,	0,	2,	0x2)

#define	MP05_3_Input    		sp_PinEncoder(MP05_Group,	0,	3,	0x0)
#define	MP05_3_Output		sp_PinEncoder(MP05_Group,	0,	3,	0x1)
#define	MP05_3_EBI_ADDR_11		sp_PinEncoder(MP05_Group,	0,	3,	0x2)

#define	MP05_4_Input    		sp_PinEncoder(MP05_Group,	0,	4,	0x0)
#define	MP05_4_Output		sp_PinEncoder(MP05_Group,	0,	4,	0x1)
#define	MP05_4_EBI_ADDR_12		sp_PinEncoder(MP05_Group,	0,	4,	0x2)

#define	MP05_5_Input    		sp_PinEncoder(MP05_Group,	0,	5,	0x0)
#define	MP05_5_Output		sp_PinEncoder(MP05_Group,	0,	5,	0x1)
#define	MP05_5_EBI_ADDR_13		sp_PinEncoder(MP05_Group,	0,	5,	0x2)

#define	MP05_6_Input    		sp_PinEncoder(MP05_Group,	0,	6,	0x0)
#define	MP05_6_Output		sp_PinEncoder(MP05_Group,	0,	6,	0x1)
#define	MP05_6_EBI_ADDR_14		sp_PinEncoder(MP05_Group,	0,	6,	0x2)

#define	MP05_7_Input    		sp_PinEncoder(MP05_Group,	0,	7,	0x0)
#define	MP05_7_Output		sp_PinEncoder(MP05_Group,	0,	7,	0x1)
#define	MP05_7_EBI_ADDR_15		sp_PinEncoder(MP05_Group,	0,	7,	0x2)

#define	MP06_0_Input    		sp_PinEncoder(MP06_Group,	0,	0,	0x0)
#define	MP06_0_Output		sp_PinEncoder(MP06_Group,	0,	0,	0x1)
#define	MP06_0_EBI_DATA_0		sp_PinEncoder(MP06_Group,	0,	0,	0x2)

#define	MP06_1_Input    		sp_PinEncoder(MP06_Group,	0,	1,	0x0)
#define	MP06_1_Output		sp_PinEncoder(MP06_Group,	0,	1,	0x1)
#define	MP06_1_EBI_DATA_1		sp_PinEncoder(MP06_Group,	0,	1,	0x2)

#define	MP06_2_Input    		sp_PinEncoder(MP06_Group,	0,	2,	0x0)
#define	MP06_2_Output		sp_PinEncoder(MP06_Group,	0,	2,	0x1)
#define	MP06_2_EBI_DATA_2		sp_PinEncoder(MP06_Group,	0,	2,	0x2)

#define	MP06_3_Input    		sp_PinEncoder(MP06_Group,	0,	3,	0x0)
#define	MP06_3_Output		sp_PinEncoder(MP06_Group,	0,	3,	0x1)
#define	MP06_3_EBI_DATA_3		sp_PinEncoder(MP06_Group,	0,	3,	0x2)

#define	MP06_4_Input    		sp_PinEncoder(MP06_Group,	0,	4,	0x0)
#define	MP06_4_Output		sp_PinEncoder(MP06_Group,	0,	4,	0x1)
#define	MP06_4_EBI_DATA_4		sp_PinEncoder(MP06_Group,	0,	4,	0x2)

#define	MP06_5_Input    		sp_PinEncoder(MP06_Group,	0,	5,	0x0)
#define	MP06_5_Output		sp_PinEncoder(MP06_Group,	0,	5,	0x1)
#define	MP06_5_EBI_DATA_5		sp_PinEncoder(MP06_Group,	0,	5,	0x2)

#define	MP06_6_Input    		sp_PinEncoder(MP06_Group,	0,	6,	0x0)
#define	MP06_6_Output		sp_PinEncoder(MP06_Group,	0,	6,	0x1)
#define	MP06_6_EBI_DATA_6		sp_PinEncoder(MP06_Group,	0,	6,	0x2)

#define	MP06_7_Input    		sp_PinEncoder(MP06_Group,	0,	7,	0x0)
#define	MP06_7_Output		sp_PinEncoder(MP06_Group,	0,	7,	0x1)
#define	MP06_7_EBI_DATA_7		sp_PinEncoder(MP06_Group,	0,	7,	0x2)

#define	MP07_0_Input    		sp_PinEncoder(MP07_Group,	0,	0,	0x0)
#define	MP07_0_Output		sp_PinEncoder(MP07_Group,	0,	0,	0x1)
#define	MP07_0_EBI_DATA_8		sp_PinEncoder(MP07_Group,	0,	0,	0x2)

#define	MP07_1_Input    		sp_PinEncoder(MP07_Group,	0,	1,	0x0)
#define	MP07_1_Output		sp_PinEncoder(MP07_Group,	0,	1,	0x1)
#define	MP07_1_EBI_DATA_9		sp_PinEncoder(MP07_Group,	0,	1,	0x2)

#define	MP07_2_Input    		sp_PinEncoder(MP07_Group,	0,	2,	0x0)
#define	MP07_2_Output		sp_PinEncoder(MP07_Group,	0,	2,	0x1)
#define	MP07_2_EBI_DATA_10		sp_PinEncoder(MP07_Group,	0,	2,	0x2)

#define	MP07_3_Input    		sp_PinEncoder(MP07_Group,	0,	3,	0x0)
#define	MP07_3_Output		sp_PinEncoder(MP07_Group,	0,	3,	0x1)
#define	MP07_3_EBI_DATA_11		sp_PinEncoder(MP07_Group,	0,	3,	0x2)

#define	MP07_4_Input    		sp_PinEncoder(MP07_Group,	0,	4,	0x0)
#define	MP07_4_Output		sp_PinEncoder(MP07_Group,	0,	4,	0x1)
#define	MP07_4_EBI_DATA_12		sp_PinEncoder(MP07_Group,	0,	4,	0x2)

#define	MP07_5_Input    		sp_PinEncoder(MP07_Group,	0,	5,	0x0)
#define	MP07_5_Output		sp_PinEncoder(MP07_Group,	0,	5,	0x1)
#define	MP07_5_EBI_DATA_13		sp_PinEncoder(MP07_Group,	0,	5,	0x2)

#define	MP07_6_Input    		sp_PinEncoder(MP07_Group,	0,	6,	0x0)
#define	MP07_6_Output		sp_PinEncoder(MP07_Group,	0,	6,	0x1)
#define	MP07_6_EBI_DATA_14		sp_PinEncoder(MP07_Group,	0,	6,	0x2)

#define	MP07_7_Input    		sp_PinEncoder(MP07_Group,	0,	7,	0x0)
#define	MP07_7_Output		sp_PinEncoder(MP07_Group,	0,	7,	0x1)
#define	MP07_7_EBI_DATA_15		sp_PinEncoder(MP07_Group,	0,	7,	0x2)

#define	GPH00_Input    		sp_PinEncoder(	GPH0_Group,	0,	0,	0x0	)
#define	GPH00_Output		sp_PinEncoder(	GPH0_Group,	0,	0,	0x1	)
#define	GPH00_EXT_INT_0		sp_PinEncoder(	GPH0_Group,	0,	0,	0XF	)

#define	GPH01_Input    		sp_PinEncoder(	GPH0_Group,	0,	1,	0x0	)
#define	GPH01_Output		sp_PinEncoder(	GPH0_Group,	0,	1,	0x1	)
#define	GPH01_EXT_INT_1		sp_PinEncoder(	GPH0_Group,	0,	1,	0XF	)

#define	GPH02_Input    		sp_PinEncoder(	GPH0_Group,	0,	2,	0x0	)
#define	GPH02_Output		sp_PinEncoder(	GPH0_Group,	0,	2,	0x1	)
#define	GPH02_EXT_INT_2		sp_PinEncoder(	GPH0_Group,	0,	2,	0XF	)

#define	GPH03_Input    		sp_PinEncoder(	GPH0_Group,	0,	3,	0x0	)
#define	GPH03_Output		sp_PinEncoder(	GPH0_Group,	0,	3,	0x1	)
#define	GPH03_EXT_INT_3		sp_PinEncoder(	GPH0_Group,	0,	3,	0XF	)

#define	GPH04_Input    		sp_PinEncoder(	GPH0_Group,	0,	4,	0x0	)
#define	GPH04_Output		sp_PinEncoder(	GPH0_Group,	0,	4,	0x1	)
#define	GPH04_EXT_INT_4		sp_PinEncoder(	GPH0_Group,	0,	4,	0XF	)

#define	GPH05_Input    		sp_PinEncoder(	GPH0_Group,	0,	5,	0x0	)
#define	GPH05_Output		sp_PinEncoder(	GPH0_Group,	0,	5,	0x1	)
#define	GPH05_EXT_INT_5		sp_PinEncoder(	GPH0_Group,	0,	5,	0XF	)

#define	GPH06_Input    		sp_PinEncoder(	GPH0_Group,	0,	6,	0x0	)
#define	GPH06_Output		sp_PinEncoder(	GPH0_Group,	0,	6,	0x1	)
#define	GPH06_EXT_INT_6		sp_PinEncoder(	GPH0_Group,	0,	6,	0XF	)

#define	GPH07_Input    		sp_PinEncoder(	GPH0_Group,	0,	7,	0x0	)
#define	GPH07_Output		sp_PinEncoder(	GPH0_Group,	0,	7,	0x1	)
#define	GPH07_EXT_INT_7		sp_PinEncoder(	GPH0_Group,	0,	7,	0XF	)

#define	GPH10_Input    		sp_PinEncoder(	GPH1_Group,	0,	0,	0x0	)
#define	GPH10_Output		sp_PinEncoder(	GPH1_Group,	0,	0,	0x1	)
#define	GPH10_EXT_INT_8		sp_PinEncoder(	GPH1_Group,	0,	0,	0XF	)

#define	GPH11_Input    		sp_PinEncoder(	GPH1_Group,	0,	1,	0x0	)
#define	GPH11_Output		sp_PinEncoder(	GPH1_Group,	0,	1,	0x1	)
#define	GPH11_EXT_INT_9		sp_PinEncoder(	GPH1_Group,	0,	1,	0XF	)

#define	GPH12_Input    		sp_PinEncoder(	GPH1_Group,	0,	2,	0x0	)
#define	GPH12_Output		sp_PinEncoder(	GPH1_Group,	0,	2,	0x1	)
#define	GPH12_EXT_INT_10		sp_PinEncoder(	GPH1_Group,	0,	2,	0XF	)

#define	GPH13_Input    		sp_PinEncoder(	GPH1_Group,	0,	3,	0x0	)
#define	GPH13_Output		sp_PinEncoder(	GPH1_Group,	0,	3,	0x1	)
#define	GPH13_EXT_INT_11		sp_PinEncoder(	GPH1_Group,	0,	3,	0XF	)

#define	GPH14_Input    		sp_PinEncoder(	GPH1_Group,	0,	4,	0x0	)
#define	GPH14_Output		sp_PinEncoder(	GPH1_Group,	0,	4,	0x1	)
#define	GPH14_HDMI_CEC		sp_PinEncoder(	GPH1_Group,	0,	4,	0x4	)
#define	GPH14_EXT_INT_12		sp_PinEncoder(	GPH1_Group,	0,	4,	0XF	)

#define	GPH15_Input    		sp_PinEncoder(	GPH1_Group,	0,	5,	0x0	)
#define	GPH15_Output		sp_PinEncoder(	GPH1_Group,	0,	5,	0x1	)
#define	GPH15_HDMI_HPD		sp_PinEncoder(	GPH1_Group,	0,	5,	0x4	)
#define	GPH15_EXT_INT_13		sp_PinEncoder(	GPH1_Group,	0,	5,	0XF	)

#define	GPH16_Input    		sp_PinEncoder(	GPH1_Group,	0,	6,	0x0	)
#define	GPH16_Output		sp_PinEncoder(	GPH1_Group,	0,	6,	0x1	)
#define	GPH16_EXT_INT_14		sp_PinEncoder(	GPH1_Group,	0,	6,	0XF	)

#define	GPH17_Input    		sp_PinEncoder(	GPH1_Group,	0,	7,	0x0	)
#define	GPH17_Output		sp_PinEncoder(	GPH1_Group,	0,	7,	0x1	)
#define	GPH17_EXT_INT_15		sp_PinEncoder(	GPH1_Group,	0,	7,	0XF	)

#define	GPH20_Input    		sp_PinEncoder(	GPH2_Group,	0,	0,	0x0	)
#define	GPH20_Output		sp_PinEncoder(	GPH2_Group,	0,	0,	0x1	)
#define	GPH20_KP_COL_0		sp_PinEncoder(	GPH2_Group,	0,	0,	0x3	)
#define	GPH20_EXT_INT_16		sp_PinEncoder(	GPH2_Group,	0,	0,	0xF	)

#define	GPH21_Input    		sp_PinEncoder(	GPH2_Group,	0,	1,	0x0	)
#define	GPH21_Output		sp_PinEncoder(	GPH2_Group,	0,	1,	0x1	)
#define	GPH21_KP_COL_1		sp_PinEncoder(	GPH2_Group,	0,	1,	0x3	)
#define	GPH21_EXT_INT_17		sp_PinEncoder(	GPH2_Group,	0,	1,	0xF	)

#define	GPH22_Input    		sp_PinEncoder(	GPH2_Group,	0,	2,	0x0	)
#define	GPH22_Output		sp_PinEncoder(	GPH2_Group,	0,	2,	0x1	)
#define	GPH22_KP_COL_2		sp_PinEncoder(	GPH2_Group,	0,	2,	0x3	)
#define	GPH22_EXT_INT_18		sp_PinEncoder(	GPH2_Group,	0,	2,	0xF	)

#define	GPH23_Input    		sp_PinEncoder(	GPH2_Group,	0,	3,	0x0	)
#define	GPH23_Output		sp_PinEncoder(	GPH2_Group,	0,	3,	0x1	)
#define	GPH23_KP_COL_3		sp_PinEncoder(	GPH2_Group,	0,	3,	0x3	)
#define	GPH23_EXT_INT_19		sp_PinEncoder(	GPH2_Group,	0,	3,	0xF	)

#define	GPH24_Input    		sp_PinEncoder(	GPH2_Group,	0,	4,	0x0	)
#define	GPH24_Output		sp_PinEncoder(	GPH2_Group,	0,	4,	0x1	)
#define	GPH24_KP_COL_4		sp_PinEncoder(	GPH2_Group,	0,	4,	0x3	)
#define	GPH24_EXT_INT_20		sp_PinEncoder(	GPH2_Group,	0,	4,	0xF	)

#define	GPH25_Input    		sp_PinEncoder(	GPH2_Group,	0,	5,	0x0	)
#define	GPH25_Output		sp_PinEncoder(	GPH2_Group,	0,	5,	0x1	)
#define	GPH25_KP_COL_5		sp_PinEncoder(	GPH2_Group,	0,	5,	0x3	)
#define	GPH25_EXT_INT_21		sp_PinEncoder(	GPH2_Group,	0,	5,	0xF	)

#define	GPH26_Input    		sp_PinEncoder(	GPH2_Group,	0,	6,	0x0	)
#define	GPH26_Output		sp_PinEncoder(	GPH2_Group,	0,	6,	0x1	)
#define	GPH26_KP_COL_6		sp_PinEncoder(	GPH2_Group,	0,	6,	0x3	)
#define	GPH26_EXT_INT_22		sp_PinEncoder(	GPH2_Group,	0,	6,	0xF	)

#define	GPH27_Input    		sp_PinEncoder(	GPH2_Group,	0,	7,	0x0	)
#define	GPH27_Output		sp_PinEncoder(	GPH2_Group,	0,	7,	0x1	)
#define	GPH27_KP_COL_7		sp_PinEncoder(	GPH2_Group,	0,	7,	0x3	)
#define	GPH27_EXT_INT_23		sp_PinEncoder(	GPH2_Group,	0,	7,	0xF	)

#define	GPH30_Input    		sp_PinEncoder(	GPH3_Group,	0,	0,	0x0	)
#define	GPH30_Output		sp_PinEncoder(	GPH3_Group,	0,	0,	0x1	)
#define	GPH30_KP_ROW_0		sp_PinEncoder(	GPH3_Group,	0,	0,	0x3	)
#define	GPH30_EXT_INT_24		sp_PinEncoder(	GPH3_Group,	0,	0,	0xF	)

#define	GPH31_Input    		sp_PinEncoder(	GPH3_Group,	0,	1,	0x0	)
#define	GPH31_Output		sp_PinEncoder(	GPH3_Group,	0,	1,	0x1	)
#define	GPH31_KP_ROW_1		sp_PinEncoder(	GPH3_Group,	0,	1,	0x3	)
#define	GPH31_EXT_INT_25		sp_PinEncoder(	GPH3_Group,	0,	1,	0xF	)

#define	GPH32_Input    		sp_PinEncoder(	GPH3_Group,	0,	2,	0x0	)
#define	GPH32_Output		sp_PinEncoder(	GPH3_Group,	0,	2,	0x1	)
#define	GPH32_KP_ROW_2		sp_PinEncoder(	GPH3_Group,	0,	2,	0x3	)
#define	GPH32_EXT_INT_26		sp_PinEncoder(	GPH3_Group,	0,	2,	0xF	)

#define	GPH33_Input    		sp_PinEncoder(	GPH3_Group,	0,	3,	0x0	)
#define	GPH33_Output		sp_PinEncoder(	GPH3_Group,	0,	3,	0x1	)
#define	GPH33_KP_ROW_3		sp_PinEncoder(	GPH3_Group,	0,	3,	0x3	)
#define	GPH33_EXT_INT_27		sp_PinEncoder(	GPH3_Group,	0,	3,	0xF	)

#define	GPH34_Input    		sp_PinEncoder(	GPH3_Group,	0,	4,	0x0	)
#define	GPH34_Output		sp_PinEncoder(	GPH3_Group,	0,	4,	0x1	)
#define	GPH34_KP_ROW_4		sp_PinEncoder(	GPH3_Group,	0,	4,	0x3	)
#define	GPH34_EXT_INT_28		sp_PinEncoder(	GPH3_Group,	0,	4,	0xF	)

#define	GPH35_Input    		sp_PinEncoder(	GPH3_Group,	0,	5,	0x0	)
#define	GPH35_Output		sp_PinEncoder(	GPH3_Group,	0,	5,	0x1	)
#define	GPH35_KP_ROW_5		sp_PinEncoder(	GPH3_Group,	0,	5,	0x3	)
#define	GPH35_EXT_INT_29		sp_PinEncoder(	GPH3_Group,	0,	5,	0xF	)

#define	GPH36_Input    		sp_PinEncoder(	GPH3_Group,	0,	6,	0x0	)
#define	GPH36_Output		sp_PinEncoder(	GPH3_Group,	0,	6,	0x1	)
#define	GPH36_KP_ROW_6		sp_PinEncoder(	GPH3_Group,	0,	6,	0x3	)
#define	GPH36_EXT_INT_30		sp_PinEncoder(	GPH3_Group,	0,	6,	0xF	)

#define	GPH37_Input    		sp_PinEncoder(	GPH3_Group,	0,	7,	0x0	)
#define	GPH37_Output		sp_PinEncoder(	GPH3_Group,	0,	7,	0x1	)
#define	GPH37_KP_ROW_7		sp_PinEncoder(	GPH3_Group,	0,	7,	0x3	)
#define	GPH37_EXT_INT_31		sp_PinEncoder(	GPH3_Group,	0,	7,	0xF	)



#endif // __SGIP_GPIO_REGITEST_MAP_H__
