
/**************************************************************************

Module Name:  MAX8698.h

Abstract:


**************************************************************************/

#ifndef __MAX8998__
#define __MAX8998__

#define PMIC_SLAVE_ADDR 0x66        // (when SRAD=0)

//I2C Control Register
#define IRQ1            0x0
#define IRQ2            0x1
#define IRQ3            0x2
#define IRQ4            0x3
#define IRQM1           0x4
#define IRQM2           0x5
#define IRQM3           0x6
#define IRQM4           0x7
#define STATUS1         0x8
#define STATUS2         0x9
#define STATUSM1        0xA
#define STATUSM2        0xB
#define CHGR1           0xC
#define CHGR2           0xD
#define LDO2_9ADIS      0xE
#define LDO10_17ADIS    0xF
#define SD1_4ADIS       0x10
#define ONOFF1			0x11
#define ONOFF2			0x12
#define ONOFF3          0x13
#define ONOFF4          0x14
#define BUCK1_DVSARM1   0x15
#define BUCK1_DVSARM2   0x16
#define BUCK1_DVSARM3   0x17
#define BUCK1_DVSARM4   0x18
#define BUCK2_DVSINT1   0x19
#define BUCK2_DVSINT2   0x1A
#define BUCK3           0x1B
#define BUCK4           0x1C
#define LDO2_3          0x1D
#define LDO4            0x1E
#define LDO5            0x1F
#define LDO6            0x20
#define LDO7            0x21
#define LDO8_9          0x22
#define LDO10_11        0x23
#define LDO12           0x24
#define LDO13           0x25
#define LDO14           0x26
#define LDO15           0x27
#define LDO16           0x28
#define LDO17           0x29
#define BKCHR           0x2A
#define LBCNFG1         0x2B
#define LBCNFG2         0x2C

//ONOFF1 Reg bits
#define EN1				(0x01 << 7)
#define EN2				(0x01 << 6)
#define EN3				(0x01 << 5)
#define EN4     		(0x01 << 4)
#define ELDO2			(0x01 << 3)
#define ELDO3			(0x01 << 2)
#define ELDO4			(0x01 << 1)
#define ELDO5			(0x01 << 0)

//ONOFF2 Reg bits
#define ELDO6			(0x01 << 7)
#define ELDO7			(0x01 << 6)
#define ELDO8			(0x01 << 5)
#define ELDO9			(0x01 << 4)
#define ELDO10			(0x01 << 3)
#define ELDO11			(0x01 << 2)
#define ELDO12			(0x01 << 1)
#define ELDO13			(0x01 << 0)

//ONOFF3 Reg bits
#define ELDO14			(0x01 << 7)
#define ELDO15			(0x01 << 6)
#define ELDO16			(0x01 << 5)
#define ELDO17			(0x01 << 4)
#define EPWRHOLD	    (0x01 << 3)
#define EBATTMON		(0x01 << 2)
#define ELBCNFG2		(0x01 << 1)
#define ELBCNFG1		(0x01 << 0)

//ONOFF4 Reg bits
#define EN32KHZAP		(0x01 << 7)
#define EN32KHZCP		(0x01 << 6)
#define ENVICHG 		(0x01 << 5)
#define RAMP			(0x0F << 0)

//LDO2_9ADIS Reg bits
#define LDO2_ADEN		(0x01 << 7)
#define LDO3_ADEN		(0x01 << 6)
#define LDO4_ADEN		(0x01 << 5)
#define LDO5_ADEN		(0x01 << 4)
#define LDO6_ADEN		(0x01 << 3)
#define LDO7_ADEN		(0x01 << 2)
#define LDO8_ADEN		(0x01 << 1)
#define LDO9_ADEN		(0x01 << 0)

//LDO10_17ADIS Reg bits
#define LDO10_ADEN		(0x01 << 7)
#define LDO11_ADEN		(0x01 << 6)
#define LDO12_ADEN		(0x01 << 5)
#define LDO13_ADEN		(0x01 << 4)
#define LDO14_ADEN		(0x01 << 3)
#define LDO15_ADEN		(0x01 << 2)
#define LDO16_ADEN		(0x01 << 1)
#define LDO17_ADEN		(0x01 << 0)

//SD1_4ADIS Reg bits
#define SAFEOUT2DIS     (0x01<<5)
#define SAFEOUT1DIS     (0x01<<4)
#define SD1ADIS         (0x01<<3)
#define SD2ADIS         (0x01<<2)
#define SD3ADIS         (0x01<<1)
#define SD4ADIS         (0x01<<0)

//ADISCHG_EN2 Reg bits
#define LDO7_ADEN		(0x01 << 7)
#define LDO8_ADEN		(0x01 << 6)
#define LDO9_ADEN		(0x01 << 5)
#define RAMP_MASK		(0x0F << 0)
#define RAMP_1MV_US		(0x0)
#define RAMP_2MV_US		(0x1)
#define RAMP_3MV_US		(0x2)
#define RAMP_4MV_US		(0x3)
#define RAMP_5MV_US		(0x4)
#define RAMP_6MV_US		(0x5)
#define RAMP_7MV_US		(0x6)
#define RAMP_8MV_US		(0x7)
#define RAMP_9MV_US		(0x8)
#define RAMP_10MV_US	(0x9)
#define RAMP_11MV_US	(0xA)
#define RAMP_12MV_US	(0xB)

//DVSARM 1~4
#define DVSARM_0_750    (0x0)
#define DVSARM_0_775    (0x1)
#define DVSARM_0_800    (0x2)
#define DVSARM_0_825    (0x3)
#define DVSARM_0_850	(0x4)
#define DVSARM_0_875    (0x5)    
#define DVSARM_0_900	(0x6)
#define DVSARM_0_925    (0x7)
#define DVSARM_0_950	(0x8)
#define DVSARM_0_975    (0x9)
#define DVSARM_1_000	(0xA)
#define DVSARM_1_025    (0xB)
#define DVSARM_1_050	(0xC)
#define DVSARM_1_075    (0xD)
#define DVSARM_1_100	(0xE)
#define DVSARM_1_125    (0xF)
#define DVSARM_1_150	(0x10)
#define DVSARM_1_175    (0x11)
#define DVSARM_1_200	(0x12)      // default
#define DVSARM_1_225    (0x13)
#define DVSARM_1_250	(0x14)
#define DVSARM_1_275    (0x15)
#define DVSARM_1_300	(0x16)
#define DVSARM_1_325	(0x17)
#define DVSARM_1_350	(0x18)
#define DVSARM_1_375	(0x19)
#define DVSARM_1_400    (0x1A)
#define DVSARM_1_425	(0x1B)
#define DVSARM_1_450	(0x1C)
#define DVSARM_1_475	(0x1D)
#define DVSARM_1_500	(0x1E)
#define DVSARM_1_525	(0x1F)

//DVSINT 1~2

#define DVSINT_0_750    (0x0)
#define DVSINT_0_775    (0x1)
#define DVSINT_0_800    (0x2)
#define DVSINT_0_825    (0x3)
#define DVSINT_0_850	(0x4)
#define DVSINT_0_875    (0x5)    
#define DVSINT_0_900	(0x6)
#define DVSINT_0_925    (0x7)
#define DVSINT_0_950	(0x8)
#define DVSINT_0_975    (0x9)
#define DVSINT_1_000	(0xA)
#define DVSINT_1_025    (0xB)
#define DVSINT_1_050	(0xC)
#define DVSINT_1_075    (0xD)
#define DVSINT_1_100	(0xE)
#define DVSINT_1_125    (0xF)
#define DVSINT_1_150	(0x10)
#define DVSINT_1_175    (0x11)
#define DVSINT_1_200	(0x12)      // default
#define DVSINT_1_225    (0x13)
#define DVSINT_1_250	(0x14)
#define DVSINT_1_275    (0x15)
#define DVSINT_1_300	(0x16)
#define DVSINT_1_325	(0x17)
#define DVSINT_1_350	(0x18)
#define DVSINT_1_375	(0x19)
#define DVSINT_1_400    (0x1A)
#define DVSINT_1_425	(0x1B)
#define DVSINT_1_450	(0x1C)
#define DVSINT_1_475	(0x1D)
#define DVSINT_1_500	(0x1E)
#define DVSINT_1_525	(0x1F)

//BUCK3
#define BUCK3_1_60		(0x00)
#define BUCK3_1_70		(0x01)
#define BUCK3_1_80		(0x02)      // default
#define BUCK3_1_90		(0x03)
#define BUCK3_2_00		(0x04)
#define BUCK3_2_10		(0x05)
#define BUCK3_2_20		(0x06)
#define BUCK3_2_30		(0x07)
#define BUCK3_2_40		(0x08)
#define BUCK3_2_50		(0x09)
#define BUCK3_2_60		(0x0A)
#define BUCK3_2_70		(0x0B)
#define BUCK3_2_80		(0x0C)
#define BUCK3_2_90		(0x0D)
#define BUCK3_3_00		(0x0E)
#define BUCK3_3_10		(0x0F)
#define BUCK3_3_20		(0x10)
#define BUCK3_3_30		(0x11)
#define BUCK3_3_40		(0x12)
#define BUCK3_3_50		(0x13)
#define BUCK3_3_60		(0x14)

//BUCK4
#define BUCK4_0_80      (0x0)
#define BUCK4_0_90      (0x1)
#define BUCK4_1_00      (0x2)
#define BUCK4_1_10      (0x3)
#define BUCK4_1_20      (0x4)       // default
#define BUCK4_1_30      (0x5)
#define BUCK4_1_40      (0x6)
#define BUCK4_1_50      (0x7)
#define BUCK4_1_60      (0x8)
#define BUCK4_1_70      (0x9)
#define BUCK4_1_80      (0xA)
#define BUCK4_1_90      (0xB)
#define BUCK4_2_00      (0xC)
#define BUCK4_2_10      (0xD)
#define BUCK4_2_20      (0xE)
#define BUCK4_2_30      (0xF)


//LDO 2~3
#define LDO2_START		(4)
#define LDO3_MASK		(0x0F << 0)
#define LDO2_MASK		(0x0F << LDO2_START)
#define LDO2TO3_0_80	(0x0)
#define LDO2TO3_0_85	(0x1)
#define LDO2TO3_0_90	(0x2)
#define LDO2TO3_0_95	(0x3)
#define LDO2TO3_1_00	(0x4)
#define LDO2TO3_1_05	(0x5)
#define LDO2TO3_1_10	(0x6)
#define LDO2TO3_1_15	(0x7)
#define LDO2TO3_1_20	(0x8)       // default
#define LDO2TO3_1_25	(0x9)
#define LDO2TO3_1_30	(0xA)

//LDO 4~7
#define LDO4TO7_1_60	(0x00)
#define LDO4TO7_1_70	(0x01)
#define LDO4TO7_1_80	(0x02)      // LDO4 default
#define LDO4TO7_1_90	(0x03)
#define LDO4TO7_2_00	(0x04)
#define LDO4TO7_2_10	(0x05)
#define LDO4TO7_2_20	(0x06)
#define LDO4TO7_2_30	(0x07)
#define LDO4TO7_2_40	(0x08)
#define LDO4TO7_2_50	(0x09)
#define LDO4TO7_2_60	(0x0A)      // LDO6 default
#define LDO4TO7_2_70	(0x0B)
#define LDO4TO7_2_80	(0x0C)      // LDO5 default
#define LDO4TO7_2_90	(0x0D)
#define LDO4TO7_3_00	(0x0E)      // LDO7 default
#define LDO4TO7_3_10	(0x0F)
#define LDO4TO7_3_20	(0x10)
#define LDO4TO7_3_30	(0x11)
#define LDO4TO7_3_40	(0x12)
#define LDO4TO7_3_50	(0x13)
#define LDO4TO7_3_60	(0x14)

//LDO8, LDO9
#define LDO8_START		(4)
#define LDO8_MASK		(0x07 << LDO8_START)
#define LDO9_MASK		(0x03 << 0)
#define LDO8_3_00		(0x0)
#define LDO8_3_10		(0x1)
#define LDO8_3_20		(0x2)
#define LDO8_3_30		(0x3)       // default
#define LDO8_3_40		(0x4)
#define LDO8_3_50		(0x5)
#define LDO8_3_60		(0x6)
#define LDO9_2_80		(0x0)       // default
#define LDO9_2_90		(0x1)
#define LDO9_3_00		(0x2)
#define LDO9_3_10		(0x3)

//LDO10
#define LDO10_START		(5)
#define LDO10_MASK		(0x07 << LDO10_START)
#define LDO11_MASK		(0x1F << 0)
#define LDO10_0_95		(0x00)
#define LDO10_1_00		(0x01)
#define LDO10_1_05		(0x02)
#define LDO10_1_10		(0x03)
#define LDO10_1_15		(0x04)
#define LDO10_1_20		(0x05)      // default
#define LDO10_1_25		(0x06)
#define LDO10_1_30		(0x07)

//LDO11
#define LDO11_1_60      (0x00)
#define LDO11_1_70      (0x01)
#define LDO11_1_80      (0x02)
#define LDO11_1_90      (0x03)
#define LDO11_2_00      (0x04)
#define LDO11_2_10      (0x05)
#define LDO11_2_20      (0x06)
#define LDO11_2_30      (0x07)
#define LDO11_2_40      (0x08)
#define LDO11_2_50      (0x09)
#define LDO11_2_60      (0x0A)
#define LDO11_2_70      (0x0B)
#define LDO11_2_80      (0x0C)       // default
#define LDO11_2_90      (0x0D)
#define LDO11_3_00      (0x0E)
#define LDO11_3_10      (0x0F)
#define LDO11_3_20      (0x10)
#define LDO11_3_30      (0x11)
#define LDO11_3_40      (0x12)
#define LDO11_3_50      (0x13)
#define LDO11_3_60      (0x14)

//LDO12~13
#define LDO12TO13_0_80      (0x0)
#define LDO12TO13_0_90      (0x1)
#define LDO12TO13_1_00      (0x2)
#define LDO12TO13_1_10      (0x3)
#define LDO12TO13_1_20      (0x4)
#define LDO12TO13_1_30      (0x5)
#define LDO12TO13_1_40      (0x6)
#define LDO12TO13_1_50      (0x7)
#define LDO12TO13_1_60      (0x8)
#define LDO12TO13_1_70      (0x9)
#define LDO12TO13_1_80      (0xA)       // default
#define LDO12TO13_1_90      (0xB)
#define LDO12TO13_2_00      (0xC)
#define LDO12TO13_2_10      (0xD)
#define LDO12TO13_2_20      (0xE)
#define LDO12TO13_2_30      (0xF)
#define LDO12TO13_2_40      (0x10)
#define LDO12TO13_2_50      (0x11)
#define LDO12TO13_2_60      (0x12)
#define LDO12TO13_2_70      (0x13)
#define LDO12TO13_2_80      (0x14)
#define LDO12TO13_2_90      (0x15)
#define LDO12TO13_3_00      (0x16)
#define LDO12TO13_3_10      (0x17)
#define LDO12TO13_3_20      (0x18)
#define LDO12TO13_3_30      (0x19)

//LDO14~15
#define LDO14TO15_1_20      (0x0)
#define LDO14TO15_1_30      (0x1)
#define LDO14TO15_1_40      (0x2)
#define LDO14TO15_1_50      (0x3)
#define LDO14TO15_1_60      (0x4)
#define LDO14TO15_1_70      (0x5)
#define LDO14TO15_1_80      (0x6)       // LDO14 default
#define LDO14TO15_1_90      (0x7)
#define LDO14TO15_2_00      (0x8)
#define LDO14TO15_2_10      (0x9)
#define LDO14TO15_2_20      (0xA)
#define LDO14TO15_2_30      (0xB)
#define LDO14TO15_2_40      (0xC)
#define LDO14TO15_2_50      (0xD)
#define LDO14TO15_2_60      (0xE)
#define LDO14TO15_2_70      (0xF)
#define LDO14TO15_2_80      (0x10)      // LDO15 default
#define LDO14TO15_2_90      (0x11)
#define LDO14TO15_3_00      (0x12)
#define LDO14TO15_3_10      (0x13)
#define LDO14TO15_3_20      (0x14)
#define LDO14TO15_3_30      (0x15)

//LDO16~17
#define LDO16TO17_1_60      (0x0)
#define LDO16TO17_1_70      (0x1)
#define LDO16TO17_1_80      (0x2)
#define LDO16TO17_1_90      (0x3)
#define LDO16TO17_2_00      (0x4)
#define LDO16TO17_2_10      (0x5)
#define LDO16TO17_2_20      (0x6)
#define LDO16TO17_2_30      (0x7)
#define LDO16TO17_2_40      (0x8)
#define LDO16TO17_2_50      (0x9)
#define LDO16TO17_2_60      (0xA)
#define LDO16TO17_2_70      (0xB)
#define LDO16TO17_2_80      (0xC)
#define LDO16TO17_2_90      (0xD)
#define LDO16TO17_3_00      (0xE)
#define LDO16TO17_3_10      (0xF)
#define LDO16TO17_3_20      (0x10)
#define LDO16TO17_3_30      (0x11)      // default
#define LDO16TO17_3_40      (0x12)
#define LDO16TO17_3_50      (0x13)
#define LDO16TO17_3_60      (0x14)

//BKCHR
#define BKCHR_2_90          (0x0)
#define BKCHR_3_00          (0x1)       // default
#define BKCHR_3_10          (0x2)
#define BKCHR_3_20          (0x3)
#define BKCHR_3_30          (0x4)
#define BKCHR_3_40          (0x5)

//LBCNFG 
#define LBHYST_START 		(4)
#define LBHYST_MASK		    (0x3 << LBHYST_START)
#define LBTH_MASK		    (0x7 << 0)
#define LBHYST_100MV	    (0x0)
#define LBHYST_200MV	    (0x1)       // default
#define LBHYST_300MV	    (0x2)
#define LBHYST_400MV	    (0x3)
#define LBTH_2_90		    (0x0)
#define LBTH_3_00		    (0x1)
#define LBTH_3_10		    (0x2)
#define LBTH_3_20		    (0x3)
#define LBTH_3_30		    (0x4)       // LBTH2 default
#define LBTH_3_40		    (0x5)
#define LBTH_3_50		    (0x6)
#define LBTH_3_57           (0x7)       // LBTH1 default

//LDO on/off setting value
//setting for Init and Wakeup
#define ONOFF1_REG_VALUE_INIT	(EN3|EN4|ELDO2|ELDO3|ELDO4|ELDO5)
#define ONOFF2_REG_VALUE_INIT	(ELDO6|ELDO7|ELDO8|ELDO9|ELDO10|ELDO11|ELDO12|ELDO13)
#define ONOFF3_REG_VALUE_INIT   (ELDO14|ELDO15|ELDO16|ELDO17)

//setting for Sleep
#define ONOFF1_REG_VALUE_SLEEP	(EN3|ELDO2|ELDO3)
#define ONOFF2_REG_VALUE_SLEEP	(ELDO6|ELDO9)

#if (S5PV210_EVT==0)
#define DVS_L0_ARM          (DVSARM_1_300)
#define DVS_L1_ARM          (DVSARM_1_200)
#define DVS_L2_ARM          (DVSARM_1_100)
#define DVS_L3_ARM          (DVSARM_1_000)

#define DVS_L0_INT          (DVSINT_1_200)
#define DVS_L1_INT          (DVSINT_1_000)
#else
#define DVS_L0_ARM          (DVSARM_1_200)
#define DVS_L1_ARM          (DVSARM_1_100)
#define DVS_L2_ARM          (DVSARM_1_050)
#define DVS_L3_ARM          (DVSARM_1_000)

#define DVS_L0_INT          (DVSINT_1_100)
#define DVS_L1_INT          (DVSINT_1_000)
#endif


#endif //__SYSTEM_FUNCTION__
