//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  File:  intr.h
//
//  This file contains SMDK2440X board specific interrupt code. The board uses
//  GPG1 pin as interrupt for CS8900A ethernet chip.
//
#include <bsp.h>
#include <soc_cfg.h>
//------------------------------------------------------------------------------
//
//  Function:  BSPIntrInit
//
BOOL BSPIntrInit()
{
//    volatile GPIO_REG *pOalPortRegs;
//    BSP_ARGS    *pBspArgs;
    //ULONG value;

     //OALMSG(OAL_INTR&&OAL_FUNC, (L"[OAL] ++BSPIntrInit()\r\n"));
#if 1  // terry for test 
#ifndef ETH_EINT9
//modified by terry 
      unsigned long value;
     volatile GPIO_REG *v_pGPIOregs = (GPIO_REG *)OALPAtoVA(BASE_REG_PA_GPIO, FALSE);
       Set_PinFunction(v_pGPIOregs, GPH12_EXT_INT_10);
	v_pGPIOregs->GPH1.GP_CON &=  ~(0xf<<8); //gph12 as eint10
	v_pGPIOregs->GPH1.GP_CON |=  (0xf<<8); //gph12 as eint10
	v_pGPIOregs->GPH1.GP_PUD &=~(0x3<<4); //gph12 pull disable
	v_pGPIOregs->EINTCON.EXT_INT1_CON &=~(0xF<<8); //gph12 low level triggered
	v_pGPIOregs->EINTCON.EXT_INT1_CON |=(0x1<<8); //gph12 high level triggered

	v_pGPIOregs->EINTMSK.EXT_INT1_MASK &=~(0x1<<2); //enable eint10
	v_pGPIOregs->EINTFLT.EXT_FLT1_CON._FLT_CON0   &=~(0x3<<22); //Filter Enable for EXT_INT[10] ---DISBLE

	v_pGPIOregs->EINTPND.EXT_INT1_PEND |=(0x1<<2); //EINT10 interrupt clear

	//---------------------
	// Static SYSINTR mapping
	//---------------------

	//------------------------------------------------
	OALIntrStaticTranslate(SYSINTR_ETH, IRQ_EINT10);        // for DM9000A
	value = IRQ_EINT10;
	OALIntrEnableIrqs(1, &value);
#else
//modified by terry  for ENT9
      unsigned long value;
     volatile GPIO_REG *v_pGPIOregs = (GPIO_REG *)OALPAtoVA(BASE_REG_PA_GPIO, FALSE);
       Set_PinFunction(v_pGPIOregs, GPH11_EXT_INT_9);
	v_pGPIOregs->GPH1.GP_CON &=  ~(0xf<<4); //gph11 as eint9
	v_pGPIOregs->GPH1.GP_CON |=  (0xf<<4); //gph11 as eint9
	v_pGPIOregs->GPH1.GP_PUD &=~(0x3<<2); //gph11 pull disable
	
	v_pGPIOregs->EINTCON.EXT_INT1_CON &=~(0xF<<4); //gph11 low level triggered
	v_pGPIOregs->EINTCON.EXT_INT1_CON |=(0x1<<4); //gph11 high level triggered

	v_pGPIOregs->EINTMSK.EXT_INT1_MASK &=~(0x1<<1); //enable eint9
	v_pGPIOregs->EINTFLT.EXT_FLT1_CON._FLT_CON0   &=~(0x3<<14); //Filter Enable for EXT_INT[9] ---DISBLE

	v_pGPIOregs->EINTPND.EXT_INT1_PEND |=(0x1<<1); //EINT9 interrupt clear

	//---------------------
	// Static SYSINTR mapping
	//---------------------

	//------------------------------------------------
	OALIntrStaticTranslate(SYSINTR_ETH, IRQ_EINT9);        // for DM9000A
	value = IRQ_EINT9;
	OALIntrEnableIrqs(1, &value);

#endif
#endif
    // Then get virtual address for IO port
//    pOalPortRegs = OALPAtoVA(BASE_REG_PA_GPIO, FALSE);
//    pBspArgs = OALPAtoVA(IMAGE_SHARE_ARGS_PA_START, FALSE);

#if    0    // TODO:
//#ifdef KITL_ETHERNET
    //Set GPF2 as output and pull-up disabling for checking Hive-Based Registry cleaning flag
    // But,  In booting, GPF0 was mapped for reset button.
    value = INREG32(&pOalPortRegs->GPFCON);
    OUTREG32(&pOalPortRegs->GPFCON, (value & ~(3 << 4))|(1 << 4));
    value = INREG32(&pOalPortRegs->GPFUP);
    OUTREG32(&pOalPortRegs->GPFUP, (value | (1 << 2)));

    // Set GPG1 as EINT9
    value = INREG32(&pOalPortRegs->GPGCON);
    OUTREG32(&pOalPortRegs->GPGCON, (value & ~(3 << 2))|(2 << 2));

    // Disable pullup
    value = INREG32(&pOalPortRegs->GPGUP);
    OUTREG32(&pOalPortRegs->GPGUP, value | (1 << 1));

    // High level interrupt
    value = INREG32(&pOalPortRegs->EXTINT1);
    OUTREG32(&pOalPortRegs->EXTINT1, (value & ~(0xf << 4))|(0x1 << 4));
#endif

    //---------------------
    // Static SYSINTR mapping
    //---------------------


    // Add static mapping for RTC alarm
    OALIntrStaticTranslate(SYSINTR_RTC_ALARM, IRQ_RTC_ALARM);    
#if    0
    //For CFCON
    OALIntrStaticTranslate(SYSINTR_CFCON, IRQ_CFC);
    // OALIntrStaticTranslate(SYSINTR_USBFN, IRQ_USBFN);
#endif

    OALMSG(OAL_INTR&&OAL_FUNC, (L"[OAL] --BSPIntrInit()\r\n"));

    return TRUE;
}

//------------------------------------------------------------------------------

BOOL BSPIntrRequestIrqs(DEVICE_LOCATION *pDevLoc, UINT32 *pCount, UINT32 *pIrqs)
{
    BOOL rc = FALSE;

    OALMSG(OAL_INTR&&OAL_FUNC, (
        L"+BSPIntrRequestIrq(0x%08x->%d/%d/0x%08x/%d, 0x%08x, 0x%08x)\r\n",
        pDevLoc, pDevLoc->IfcType, pDevLoc->BusNumber, pDevLoc->LogicalLoc,
        pDevLoc->Pin, pCount, pIrqs
    ));

    if (pIrqs == NULL || pCount == NULL || *pCount < 1) goto cleanUp;

    switch (pDevLoc->IfcType) {
    case Internal:
        switch ((ULONG)pDevLoc->LogicalLoc) {
			// not implemented
            break;
        }
        break;
    }

cleanUp:
    OALMSG(OAL_INTR&&OAL_FUNC, (L"-BSPIntrRequestIrq(rc = %d)\r\n", rc));
    return rc;
}

//------------------------------------------------------------------------------
//
//  Function:  BSPIntrEnableIrq
//
//  This function is called from OALIntrEnableIrq to enable interrupt on
//  secondary interrupt controller.
//
UINT32 BSPIntrEnableIrq(UINT32 irq)
{
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"+BSPIntrEnableIrq(%d)\r\n", irq));
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"-BSPIntrEnableIrq(irq = %d)\r\n", irq));
    return irq;
}

//------------------------------------------------------------------------------
//
//  Function:  BSPIntrDisableIrq
//
//  This function is called from OALIntrDisableIrq to disable interrupt on
//  secondary interrupt controller.
//
UINT32 BSPIntrDisableIrq(UINT32 irq)
{
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"+BSPIntrDisableIrq(%d)\r\n", irq));
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"-BSPIntrDisableIrq(irq = %d\r\n", irq));
    return irq;
}


//------------------------------------------------------------------------------
//
//  Function:  BSPIntrDoneIrq
//
//  This function is called from OALIntrDoneIrq to finish interrupt on
//  secondary interrupt controller.
//
UINT32 BSPIntrDoneIrq(UINT32 irq)
{
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"+BSPIntrDoneIrq(%d)\r\n", irq));
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"-BSPIntrDoneIrq(irq = %d)\r\n", irq));
    return irq;
}


//------------------------------------------------------------------------------
//
//  Function:  BSPIntrActiveIrq
//
//  This function is called from interrupt handler to give BSP chance to
//  translate IRQ in case of secondary interrupt controller.
//
UINT32 BSPIntrActiveIrq(UINT32 irq)
{
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"+BSPIntrActiveIrq(%d)\r\n", irq));
    OALMSG(OAL_INTR&&OAL_VERBOSE, (L"-BSPIntrActiveIrq(%d)\r\n", irq));
    return irq;
}

//------------------------------------------------------------------------------

