//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  File:  bsp_cfg.h
//
//  This file contains system constant specific for SMDKV210 board.
//
#ifndef __BSP_CFG_H
#define __BSP_CFG_H

#include "InitSystem.h"
#define LITTLE_ENDIAN

//extern DWORD g_oSD_CHANNEL0;
#define SD_CHANNEL0 // it could be SD_CHANNEL2 default

//added by terry 2012.07.21
	#define OV2655_1600_1200   // 200W 1600*1200            defale 800*600 // ʹ200ʱ趨OV2655_1600_1200  Ĭ800*600


//	#define TVP5150  //  added by terry  for tvp5150  2012.07.05





//------------------------------------------------------------------------------
//
//  Define:  BSP_DEVICE_PREFIX
//
//  Prefix used to generate device name for bootload/KITL
//
#define BSP_DEVICE_PREFIX       "SMDKV210"        // Device name prefix

//------------------------------------------------------------------------------
// Define: USE_JTAG 
//
// If you want to use JTAG port for debugging, then set following value to 'TRUE'
// But this case, HCLK_SECSS will be always ON state.
//------------------------------------------------------------------------------
#define USE_JTAG                (TRUE)


//------------------------------------------------------------------------------
// CLOCK settings.
// : Following values are pre-defined at "InitSystem.h"
//------------------------------------------------------------------------------
#define PCLKPSYS        PCLKPSYS_CLK_BL

//------------------------------------------------------------------------------
// System Tick Timer Definition
//------------------------------------------------------------------------------
// For Precision of System timer
// Use timer counter as large as possible. (32-bit Counter)
// Use timer divider as small as possible.
#define SYS_TIMER_PRESCALER	            1
#define SYS_TIMER_DIVIDER               1
#define OEM_CLOCK_FREQ					(FIN/(SYS_TIMER_PRESCALER+1)/SYS_TIMER_DIVIDER)	// 6,600,000

// Timer count for 1 ms
#define OEM_COUNT_1MS				    (OEM_CLOCK_FREQ / 1000)
#define RESCHED_PERIOD    				1	// Reschedule period in ms
 
#define PWM0_1_PRESCALER                ((int)(PCLKPSYS/1000000)-1)
#define PWM0_DIVIDER                    1   //PWM0 for backlight(1Count:2us)

#ifdef BSP_USEDVFS
#define SYSINTR_DVFS        0xDEADBABE
#endif

//------------------------------------------------------------------------------
// SMDKV210 Display Dimension
// : Following values are pre-defined at "InitSystem.h"
//   For more details about LCD attributes, refer the "InitSystem.h"
//------------------------------------------------------------------------------
#define LCD_MODULE     LCD_MODULE_AT070TN92			//qunchuang TN92

//#define LCD_MODULE     LCD_MODULE_VGA8060 	//VGA for 800*600    //OK
//	#define LCD_MODULE     LCD_MODULE_VGA1024	//VGA for 1024*768
//#define LCD_MODULE     LCD_MODULE_VGA1280 	//VGA for 1280*1024  
//#define LCD_MODULE  LCD_MODULE_VGA1440  // VGA for 1440*900  

//#define LCD_MODULE     LCD_MODULE_VAG8048	//VGA for 800*480  for test


//#define LCD_MODULE     LCD_MODULE_LTV350			//qimei 4.3 480*272 



// lqm added.11-11-11
#if (LCD_MODULE == LCD_MODULE_LTS222)
#define LCD_WIDTH               240
#define LCD_HEIGHT              320
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT
#elif (LCD_MODULE == LCD_MODULE_LTV350)

/* masked by terry for qimei4.3 inch 
#define LCD_WIDTH               320
#define LCD_HEIGHT              240
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_LANDSCAPE
*/

// added by terry for qimei4.3 inch
#define LCD_WIDTH            480
#define LCD_HEIGHT            272
#define LCD_BPP                16
#define LCD_TYPE                LCD_TYPE_PORTRAIT


#elif (LCD_MODULE == LCD_MODULE_AT070TN92)
#define LCD_WIDTH               800
#define LCD_HEIGHT              480
#define LCD_BPP                 16  //32
#define LCD_TYPE                LCD_TYPE_PORTRAIT //LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_HT101HD1)
#define LCD_WIDTH               1376
#define LCD_HEIGHT              768
#define LCD_BPP                 16  //32
#define LCD_TYPE                LCD_TYPE_PORTRAIT //LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_EMUL48_D1)
#define LCD_WIDTH               720
#define LCD_HEIGHT              480
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_EMUL48_QV)
#define LCD_WIDTH               320
#define LCD_HEIGHT              240
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_EMUL48_PQV)
#define LCD_WIDTH               240
#define LCD_HEIGHT              320
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT
#elif (LCD_MODULE == LCD_MODULE_EMUL48_ML)
#define LCD_WIDTH               480
#define LCD_HEIGHT              320
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_EMUL48_MP)
#define LCD_WIDTH               320
#define LCD_HEIGHT              480
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT
#elif (LCD_MODULE == LCD_MODULE_LTP700)
#define LCD_WIDTH               800
#define LCD_HEIGHT              480
#define LCD_BPP                 32    // rgb888 XRGB
#define LCD_TYPE                LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_TL2796)
#define LCD_WIDTH               480
#define LCD_HEIGHT              800
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT
#elif (LCD_MODULE == LCD_MODULE_DSI_DUMMY)
#define LCD_WIDTH               320
#define LCD_HEIGHT              480
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT
#define USE_DSI
#elif (LCD_MODULE == LCD_MODULE_VGA8060)
#define LCD_WIDTH               800
#define LCD_HEIGHT              600
#define LCD_BPP                 16 
#define LCD_TYPE              LCD_TYPE_PORTRAIT//  LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_VGA1024)
#define LCD_WIDTH               1024
#define LCD_HEIGHT              768
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT//LCD_TYPE_LANDSCAPE
#elif (LCD_MODULE == LCD_MODULE_VGA1280)
#define LCD_WIDTH               1280
#define LCD_HEIGHT              1024
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT//LCD_TYPE_LANDSCAPE
#elif(LCD_MODULE == LCD_MODULE_VGA1440)
#define LCD_WIDTH   1440
#define LCD_HEIGHT    900
#define LCD_BPP		16
#define LCD_TYPE     LCD_TYPE_PORTRAIT

#elif  (LCD_MODULE == LCD_MODULE_VAG8048)
#define LCD_WIDTH               800
#define LCD_HEIGHT              480
#define LCD_BPP                 16
#define LCD_TYPE                LCD_TYPE_PORTRAIT//LCD_TYPE_LANDSCAPE
#else
#error LCD_MODULE_UNDEFINED_ERROR
#endif
// end added.


//------------------------------------------------------------------------------
// SMDKV210 Audio Sampling Rate
//------------------------------------------------------------------------------
#define AUDIO_44_1KHz       (44100)
#define AUDIO_48KHz         (48000)
#define AUDIO_SAMPLE_RATE   (AUDIO_44_1KHz)        // Keep sync with EPLL Fout

//------------------------------------------------------------------------------
// SMDKV210 UART Debug Port Baudrate
//------------------------------------------------------------------------------
#define DEBUG_UART0         (0)
#define DEBUG_UART1         (1)
#define DEBUG_UART2         (2)
#define DEBUG_UART3         (3)
#define DEBUG_BAUDRATE      (115200)

//------------------------------------------------------------------------------
// SMDKV210 NAND Flash Timing Parameter
// Need to optimize for each HClock value.
// Default vaule is 7.7.7. this value has maximum margin. 
// so stable but performance cannot be max.
//------------------------------------------------------------------------------
#define NAND_TACLS          (7)
#define NAND_TWRPH0         (7)
#define NAND_TWRPH1         (7)

//------------------------------------------------------------------------------
// SMDKV210 Static SYSINTR Definition
//------------------------------------------------------------------------------
#define SYSINTR_OHCI        (SYSINTR_FIRMWARE+1)    // for USB Host
#define SYSINTR_EHCI        (SYSINTR_FIRMWARE+2)    // for USB Host 2.0


//------------------------------------------------------------------------------
// SMDKV210 BSP Debug Option
//------------------------------------------------------------------------------
#define REMOVE_BEFORE_RELEASE        // Define this will remove debug message or somthing...

//------------------------------------------------------------------------------
// SteppingStone Size 
//------------------------------------------------------------------------------
#define STEPLDR_LENGTH      0x4000   // 16KB

//------------------------------------------------------------------------------
// SMDKV210 Keypad Layout
//------------------------------------------------------------------------------
#define LAYOUT0            (0)        // 8*8 Keyppad board
#define LAYOUT1            (1)        // On-Board Key
#define LAYOUT2            (2)        // Qwerty Key board
#define MATRIX_LAYOUT      (BSP_KEYBD_TYPE)		// Configured by SMDKV210.bat

//------------------------------------------------------------------------------
// SMDKV210 TIMER(PWM, System Timer) GPIO-LED Display
//------------------------------------------------------------------------------
#define TIMER_LED_DISPLAY   1

#define	OND_VOL_NUM						1

//------------------------------------------------------------------------------
// SMDKV210 APM
//------------------------------------------------------------------------------
#define SUPPORT_APM

#endif
