//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: video_mixer_internal.h
//
//  Defines macros, structures, pre-defined functions, and etc for the Video Mixer.
//
#ifndef __VIDEO_MIXER_INTERNAL_H
#define __VIDEO_MIXER_INTERNAL_H

#if __cplusplus
    extern "C"
    {
#endif

// macro

// MIXER_STATUS
#define VM_BURST16_MODE    (1<<7)
#define VM_BURST8_MODE     (0<<7)
#define VM_BIG_ENDIAN_SOURCE_FORMAT    (1<<3)
#define VM_LITTLE_ENDIAN_SOURCE_FORMAT (0<<3)
#define VM_MIXER_RESERVED  (1<<2)
#define VM_CMU_STOP_CLOCK          (1<<1)
#define VM_CMU_CANNOT_STOP_CLOCK   (0<<1)
#define VM_MIXER_START (1<<0)
#define VM_MIXER_STOP  (0<<0)

// MIXER_CFG

#define VM_RGB601_0_255  (0x0<<9)
#define VM_RGB601_16_235  (0x1<<9)
#define VM_RGB709_0_255  (0x2<<9)
#define VM_RGB709_16_235  (0x3<<9)

#define VM_YUV444  (0<<8)
#define VM_RGB888  (1<<8)
#define VM_REG_DST_SEL_HD   (1<<7)
#define VM_REG_DST_SEL_SD    (0<<7)
#define VM_HD_1080I_MODE   (1<<6)
#define VM_HD_720P_MODE    (0<<6)
#define VM_GRAPHIC1_LAYER_SHOW (1<<5)
#define VM_GRAPHIC1_LAYER_HIDE (0<<5)
#define VM_GRAPHIC0_LAYER_SHOW (1<<4)
#define VM_GRAPHIC0_LAYER_HIDE (0<<4)
#define VM_VIDEO_LAYER_SHOW    (1<<3)
#define VM_VIDEO_LAYER_HIDE    (0<<3)
#define VM_PROGRESSIVE_MODE (1<<2)
#define VM_INTERLACE_MODE  (0<<2)
#define VM_PAL  (1<<1)
#define VM_NTSC (0<<1)
#define VM_HD   (1<<0)
#define VM_SD   (0<<0)

// MIXER_INT_EN
#define VM_VSYNC_INT_ENABLE    (1<<11)
#define VM_VP_INT_ENABLE    (1<<10)
#define VM_VP_INT_DISABLE   (0<<10)
#define VM_GRP1_INT_ENABLE  (1<<9)
#define VM_GRP1_INT_DISABLE (0<<9)
#define VM_GRP0_INT_ENABLE  (1<<8)
#define VM_GRP0_INT_DISABLE (0<<8)

// MIXER_INT_STATUS
#define VM_VSYNC_INT_FIRED        (1<<11)
#define VM_VP_INT_FIRED     (1<<10)
#define VM_GRP1_INT_FIRED   (1<<9)
#define VM_GRP0_INT_FIRED   (1<<8)
#define VM_INT_FIRED        (1<<0)

//MIXER_VIDEO_LIMITER_PARA
#define VM_REG_PARA_Y_UPPER(a)	((0xff&a)<<24)
#define VM_REG_PARA_Y_LOWER(a)	((0xff&a)<<16)
#define VM_REG_PARA_C_UPPER(a)	((0xff&a)<<8)
#define VM_REG_PARA_C_LOWER(a)	((0xff&a)<<0)

// MIXER_LAYER_CFG
#define VM_GRP1_LAYER_PRIORITY(a)   ((0xf&a)<<8)
#define VM_GRP0_LAYER_PRIORITY(a)   ((0xf&a)<<4)
#define VM_VP_LAYER_PRIORITY(a)     ((0xf&a)<<0)
#define VM_GRP1_LAYER_PRIORITY_CLEAR(a) ((~(0xf<<8))&a)
#define VM_GRP0_LAYER_PRIORITY_CLEAR(a) ((~(0xf<<4))&a)
#define VM_VP_LAYER_PRIORITY_CLEAR(a)   ((~(0xf<<0))&a)
#define VM_GRP1_LAYER_PRIORITY_INFO(a)   ((0xf<<8)&a)
#define VM_GRP0_LAYER_PRIORITY_INFO(a)   ((0xf<<4)&a)
#define VM_VP_LAYER_PRIORITY_INFO(a)     ((0xf<<0)&a)

// MIXER_VIDEO_CFG
#define VM_VP_BLEND_ENABLE  (1<<16)
#define VM_VP_BLEND_DISABLE (0<<16)
#define VM_VP_ALPHA_VALUE(a)    ((0xff&a)<<0)
#define VM_VP_ALPHA_VALUE_CLEAR(a)   ((~(0xff<<0))&a)

// MIXER_GRAPHx_CFG
#define VM_BLANK_CHANGE_NEW_PIXEL       (1<<21)
#define VM_BLANK_NOT_CHANGE_NEW_PIXEL   (0<<21)
#define VM_PRE_MUL_MODE (1<<20)
#define VM_NORMAL_MODE  (0<<20)
#define VM_WIN_BLEND_ENABLE     (1<<17)
#define VM_WIN_BLEND_DISABLE    (0<<17)
#define VM_PIXEL_BLEND_ENABLE   (1<<16)
#define VM_PIXEL_BLEND_DISABLE  (0<<16)
#define VM_EG_COLOR_FORMAT(a)   ((0xf&a)<<8)
#define VM_EG_COLOR_FORMAT_CLEAR(a) ((~(0xf<<8))&a)
#define VM_GRP_ALPHA_VALUE(a)   ((0xff&a)<<0)
#define VM_GRP_ALPHA_VALUE_CLEAR(a) ((~(0xff<<0))&a)
/*
enum VMIXER_COLOR_FORMAT
{
    VM_DIRECT_RGB565  = 4,
    VM_DIRECT_RGB1555 = 5,
    VM_DIRECT_RGB4444 = 6,
    VM_DIRECT_RGB8888 = 7
}
*/

// MIXER_GRAPHx_BASE
#define VM_GPR_BASE(a)  (0xffffffff&a)
#define VM_GRP_ADDR_ILLEGAL(a)  (0x3&a)

// MIXER_GRAPH1_SPAN
#define VM_GRP_SPAN(a)  (0x7fff&a)

// MIXER_GRAPH1_WH
#define VM_GRP_WIDTH(a) ((0x7ff&a)<<16)
#define VM_GRP_HEIGHT(a)((0x7ff&a)<<0)

//MIXER_H_SCALEn
#define VM_GRP_H_SCALE_EN(a) ((0x3&a)<<28)

//MIXER_V_SCALEn
#define VM_GRP_V_SCALE_EN(a) ((0x3&a)<<12)


// MIXER_GRAPH1_SXY
#define VM_GRP_STARTX(a)    ((0x7ff&a)<<16)
#define VM_GRP_STARTY(a)    ((0x7ff&a)<<0)

// MIXER_GRAPH1_DXY
#define VM_GRP_DESTX(a) ((0x7ff&a)<<16)
#define VM_GRP_DESTY(a) ((0x7ff&a)<<0)

// MIXER_GRAPH1_BLANK
#define VM_GPR_BLANK_COLOR(a)   (0xffffffff&a)

// MIXER_BG_CFG
#define VM_BG_CR_DIHER_EN   (1<<19)
#define VM_BG_CB_DIHER_EN   (1<<18)
#define VM_BG_Y_DIHER_EN    (1<<17)

// MIXER_BG_COLORx
#define VM_BG_COLOR_Y(a)    ((0xff&a)<<16)
#define VM_BG_COLOR_CB(a)   ((0xff&a)<<8)
#define VM_BG_COLOR_CR(a)   ((0xff&a)<<0)

// MIXER_CM_COEFF_x
#define VM_BG_COLOR_WIDE    (1<<30)
#define VM_BG_COLOR_NARROW  (0<<30)
#define VM_BG_COEFF_0(a)    ((0x3f&a)<<20)
#define VM_BG_COEFF_1(a)    ((0x3f&a)<<10)
#define VM_BG_COEFF_2(a)    ((0x3f&a)<<0)


// global variables
static volatile PVMIXER_REG g_pVMixerConfig = NULL; // VMixer Register

#if __cplusplus
    }
#endif

#endif    // __VIDEO_MIXER_INTERNAL_H
