//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    stda_resource.c

Abstract:       Implementation of tvout resource Library
                This module implements Middle Level Driver control

Functions:


Notes:


--*/

#include "tvout_global.h"
#include <windows.h>
#include <bsp_cfg.h>    // for reference HCLK, ECLK
#include <register_map.h>
#include "stda_common.h"
#include "stda_context.h"
#include "stda_resource.h"

/*============================================================================*/
// functions
/*============================================================================*/

BOOL
STDA_Resource_API_Proc
(DWORD hOpenContext,
DWORD dwCode,
PBYTE pBufIn,
DWORD dwLenIn,
PBYTE pBufOut,
DWORD dwLenOut,
PDWORD pdwActualOut)
{
	BOOL bRet = TRUE;

	RETAILMSG(TV_PLAY,(_T("[TVRES] ++STDA_Resource_API_Proc()\n\r")));

	switch(dwCode)
	{
		case STDA_RSC_REQUEST_TVOUT_INTERFACE:
			bRet = STDA_resource_request_TVout_interface(hOpenContext);
			break;
		case STDA_RSC_RELEASE_TVOUT_INTERFACE:
			bRet = STDA_resource_release_TVout_interface(hOpenContext);
			break;
		case STDA_RSC_REQUEST_VIDEO_PROCESSOR:
			bRet = STDA_resource_request_VP(hOpenContext);
			break;
		case STDA_RSC_RELEASE_VIDEO_PROCESSOR:
			bRet = STDA_resource_release_VP(hOpenContext);
			break;
		case STDA_RSC_REQUEST_GRAPHIC_0:
			bRet = STDA_resource_request_GRP0(hOpenContext);
			break;
		case STDA_RSC_RELEASE_GRAPHIC_0:
			bRet = STDA_resource_release_GRP0(hOpenContext);
			break;
		case STDA_RSC_REQUEST_GRAPHIC_1:
			bRet = STDA_resource_request_GRP1(hOpenContext);
			break;
		case STDA_RSC_RELEASE_GRAPHIC_1:
			bRet = STDA_resource_release_GRP1(hOpenContext);
			break;
		default:
			DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_Resource_API_Proc() : invalid hOpenContext parameter(%d)\n\r"),hOpenContext));
			return STDA_ERROR_INVALID_PARAM;
			break;
	}

	if (bRet == FALSE)
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_Resource_API_Proc() : dwCode[0x%08x] Failed\n\r")));
	}

	return bRet;
}

BOOL
STDA_resource_request_TVout_interface
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if (pCtxt->dwOccupantTVout == 0)
	{
		pCtxt->dwOccupantTVout = dwOpenContext;
		pPMCtxt->bTvOutputParam = FALSE;
		pPMCtxt->bTVoutOutputEnable = FALSE;
		pPMCtxt->bVPLayerEnable = FALSE;
		pPMCtxt->bVLMode = FALSE;
		pPMCtxt->bGRPLayerEnable[0] = FALSE;
		pPMCtxt->bGRPMode[0] = FALSE;
		pPMCtxt->bGRPLayerEnable[1] = FALSE;
		pPMCtxt->bGRPMode[1] = FALSE;
		pCtxt->bVPEnable = FALSE;
		pCtxt->bGRPEnable[0] = FALSE;
		pCtxt->bGRPEnable[1] = FALSE;
		pCtxt->bSDoutEnable = FALSE;
		pCtxt->bHDMIEnable = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_request_TVout_interface() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else if (pCtxt->dwOccupantTVout == dwOpenContext)
	{
		DBGMSG(TV_FUNC, (_T("[TVRES] STDA_resource_request_TVout_interface() : OpenContext[0x%08x] already have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_request_TVout_interface() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_release_TVout_interface
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(pCtxt->dwOccupantVP || pCtxt->dwOccupantGRP0 || pCtxt->dwOccupantGRP1)
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_TVout_interface() : Some layers still are occupied, have to all layers off\r\n")));
		return FALSE;
	}
	else if(pCtxt->dwOccupantTVout == dwOpenContext)
	{
		pCtxt->dwOccupantTVout = 0;
		pPMCtxt->bTvOutputParam = FALSE;
		pPMCtxt->bTVoutOutputEnable = FALSE;
		pPMCtxt->bVPLayerEnable = FALSE;
		pPMCtxt->bVLMode = FALSE;
		pPMCtxt->bGRPLayerEnable[0] = FALSE;
		pPMCtxt->bGRPMode[0] = FALSE;
		pPMCtxt->bGRPLayerEnable[1] = FALSE;
		pPMCtxt->bGRPMode[1] = FALSE;
		pCtxt->bVPEnable = FALSE;
		pCtxt->bGRPEnable[0] = FALSE;
		pCtxt->bGRPEnable[1] = FALSE;
		pCtxt->bSDoutEnable = FALSE;
		pCtxt->bHDMIEnable = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_release_TVout_interface() : OpenContext[0x%08x] release resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_TVout_interface() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_compare_TVout_interface
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();

	if (pCtxt->dwOccupantTVout == dwOpenContext)
	{
		DBGMSG(TV_USR4,(_T("[TVRES] STDA_resource_compare_TVout_interface() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR4,(_T("[TVRES:INF] STDA_resource_compare_TVout_interface() : Resource was occupied by OpenContext: 0x%x\r\n"), pCtxt->dwOccupantTVout));
		return FALSE;
	}
}

BOOL
STDA_resource_request_VP
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_request_VP() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantVP == 0)
	{
		pCtxt->dwOccupantVP = dwOpenContext;
		pPMCtxt->bVPLayerEnable = FALSE;
		pPMCtxt->bVLMode = FALSE;
		pCtxt->bVPEnable = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_request_VP() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else if (pCtxt->dwOccupantVP == dwOpenContext)
	{
		DBGMSG(TV_FUNC, (_T("[TVRES] STDA_resource_request_VP() : OpenContext[0x%08x] already have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_request_VP() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_release_VP
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_VP() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if(pPMCtxt->bVPLayerEnable)
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_VP() : Video layers is still on, have to video layer off\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantVP == dwOpenContext)
	{
		pCtxt->dwOccupantVP = 0;
		pPMCtxt->bVPLayerEnable = FALSE;
		pPMCtxt->bVLMode = FALSE;
		pCtxt->bVPEnable = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_release_VP() : OpenContext[0x%08x] release resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_VP() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_compare_VP
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES:ERR] STDA_resource_compare_VP() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantVP == dwOpenContext)
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES] STDA_resource_compare_VP() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES:INF] STDA_resource_compare_VP() : Resource was occupied by OpenContext: 0x%x\r\n"), pCtxt->dwOccupantVP));
		return FALSE;
	}
}

BOOL
STDA_resource_request_GRP0
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_request_GRP0() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantGRP0 == 0)
	{
		pCtxt->dwOccupantGRP0 = dwOpenContext;
		pPMCtxt->bGRPLayerEnable[0] = FALSE;
		pPMCtxt->bGRPMode[0] = FALSE;
		pCtxt->bGRPEnable[0] = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_request_GRP0() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else if (pCtxt->dwOccupantGRP0 == dwOpenContext)
	{
		DBGMSG(TV_FUNC, (_T("[TVRES] STDA_resource_request_GRP0() : OpenContext[0x%08x] already have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_request_GRP0() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_release_GRP0
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_GRP0() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if(pPMCtxt->bGRPLayerEnable[0])
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_GRP0() : GRP0 layers is still on, have to GRP0 layer off\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantGRP0 == dwOpenContext)
	{
		pCtxt->dwOccupantGRP0 = 0;
		pPMCtxt->bGRPLayerEnable[0] = FALSE;
		pPMCtxt->bGRPMode[0] = FALSE;
		pCtxt->bGRPEnable[0] = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_release_GRP0() : OpenContext[0x%08x] release resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_GRP0() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_compare_GRP0
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES:ERR] STDA_resource_compare_GRP0() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantGRP0 == dwOpenContext)
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES] STDA_resource_compare_GRP0() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES:INF] STDA_resource_compare_GRP0() : Resource was occupied by OpenContext: 0x%x\r\n"), pCtxt->dwOccupantGRP0));
		return FALSE;
	}
}

BOOL
STDA_resource_request_GRP1
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_request_GRP1() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantGRP1 == 0)
	{
		pCtxt->dwOccupantGRP1 = dwOpenContext;
		pPMCtxt->bGRPLayerEnable[1] = FALSE;
		pPMCtxt->bGRPMode[1] = FALSE;
		pCtxt->bGRPEnable[1] = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_request_GRP1() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else if (pCtxt->dwOccupantGRP1 == dwOpenContext)
	{
		DBGMSG(TV_FUNC, (_T("[TVRES] STDA_resource_request_GRP1() : OpenContext[0x%08x] already have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_request_GRP1() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_release_GRP1
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_GRP1() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if(pPMCtxt->bGRPLayerEnable[1])
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_GRP1() : GRP1 layers is still on, have to GRP1 layer off\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantGRP1 == dwOpenContext)
	{
		pCtxt->dwOccupantGRP1 = 0;
		pPMCtxt->bGRPLayerEnable[1] = FALSE;
		pPMCtxt->bGRPMode[1] = FALSE;
		pCtxt->bGRPEnable[1] = FALSE;
		DBGMSG(TV_FUNC,(_T("[TVRES] STDA_resource_release_GRP1() : OpenContext[0x%08x] release resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		DBGMSG(TV_USR1,(_T("[TVRES:ERR] STDA_resource_release_GRP1() : Resource was occupied by other OpenContext\r\n")));
		return FALSE;
	}
}

BOOL
STDA_resource_compare_GRP1
(DWORD dwOpenContext)
{
	STDAContext *pCtxt = STDA_get_context();
	STDAPowerContext *pPMCtxt = STDA_get_power_context();

	if(!(pPMCtxt->bTVoutOutputEnable))
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES:ERR] STDA_resource_compare_GRP1() : TVout I/F is not Power On\r\n")));
		return FALSE;
	}
	else if (pCtxt->dwOccupantGRP1 == dwOpenContext)
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES] STDA_resource_compare_GRP1() : OpenContext[0x%08x] have resource\r\n"), dwOpenContext));
		return TRUE;
	}
	else
	{
		RETAILMSG(TV_PLAY,(_T("[TVRES:INF] STDA_resource_compare_GRP1() : Resource was occupied by OpenContext: 0x%x\r\n"), pCtxt->dwOccupantGRP1));
		return FALSE;
	}
}

