//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: stda_common.h
//
//  Defines macros, structures, pre-defined functions, and etc for the STDA.
//
#ifndef __STDA_COMMON_H
#define __STDA_COMMON_H

#if __cplusplus
	extern "C"
	{
#endif

#include "tvout_message.h"
#include "tvout_internal.h"
#include "tvout_power.h"
#include "tvout_clock.h"
#include "video_processor.h"
#include "video_mixer.h"
#include "sdout.h"
#include "hdmi.h"
#include "hdmi_video.h"
#include "hdmi_audio.h"
#include "hdcp.h"
#include "libedid.h"
#include "libhdmi.h"

#define TVOUT_DRIVER_SIGNITURE			(0xC110)
#define TVOUT_ERROR_BASE					(0x20000000)        // Non system error code

#define TVOUT_IST_PRIORITY					(100)

#define TVOUT_VM_CMD_TIMEOUT				(100)
#define TVOUT_SDOUT_CMD_TIMEOUT			(100)
#define TVOUT_HDMI_CMD_TIMEOUT			(100)
#define TVOUT_HPD_CMD_TIMEOUT			(1000)
#define TVOUT_HDMI_I2C_CMD_TIMEOUT		(100)

#define __MODULE__  "S5PV210 TVout Driver"


	/*============================================================================*/
	// TVout API Data

#include "vp_reg.h"
#include "vmixer_reg.h"
#include "sdo_reg.h"
#include <hdmireg.h>

typedef struct _GRPCommandContext
{
	CRITICAL_SECTION	csCmd;
	BOOL				bCmdSetSrcBuffer;
	BOOL				bCmdSetOffset;
	DWORD				dwBuffer;
	DWORD				dwOffsetX;
	DWORD				dwOffsetY;
} GRPCommandContext;

typedef struct _STDAContext
{
	// Driver Signature
	DWORD					dwSignature;

	// TV-related Hardware SFR
	volatile PVP_REG			pVPReg;         // Video Processor SFR
	volatile PVMIXER_REG		pVMReg;         // Video Mixer SFR
	volatile PSDOUT_REG		pSDoutReg;      // TV Encoder SFR

	volatile PHDMI_SS_REG		pHDMISSReg;
	volatile PHDMI_CORE_REG	pHDMICoreReg;
	volatile PHDMI_TG_REG		pHDMITGReg;
	volatile PHDMI_HDCP_REG	pHDCPReg;    // HDCP SFR

	volatile PHDMI_EFUSE_REG	pHDMIEfuseReg;

	volatile PHDMI_I2S_REG	pIISReg;
	volatile PHDMI_SPDIF_REG	pSPDIFReg;

	volatile PIIC_REG			pHDMIIICReg;
	
	volatile PCMU_CLK_REG		pCmuClkCon;
	volatile PCMU_MISC_REG	pCmuMiscCon;
	volatile PPMU_PM_REG		pPmuPmCon;
	volatile PPMU_MISC_REG	pPmuMiscCon;

	volatile PGPIO_REG		pGpioReg;       // GPIO SFR


	// Interrupt
	DWORD dwSysIntrVM;        // Video Mixer SysIntr
	DWORD dwSysIntrSDout;     // SD VSYNC SysIntr
	DWORD dwSysIntrHDMI;      // HDMI SysIntr
	DWORD dwSysIntrHPD;      // HDMI HPD SysIntr
	DWORD dwSysIntrHDMII2C;   // HDMI I2C SysIntr
	HANDLE hInterruptVM;       // Video Mixer Handle
	HANDLE hInterruptSDout;    // SD VSYNC Handle
	HANDLE hInterruptHDMI;    // HDMI Handle
	HANDLE hInterruptHPD;    // HDMI HPD Handle
	HANDLE hInterruptHDMII2C;  // HDMI I2C Handle

	// Interrupt Thread
	HANDLE hVMIST;
	HANDLE hSDoutIST;
	HANDLE hHDMIIST;
	HANDLE hHPDIST;
	HANDLE hHDMII2CIST;

	// Handle for Power Control Driver
	//HANDLE    hPowerControl;

	// Critical Section for IOCTL Proc
	CRITICAL_SECTION csProc;
	CRITICAL_SECTION csProcWaitHPD;
	CRITICAL_SECTION csProcWaitHPDVP;
	CRITICAL_SECTION csProcWaitHPDGRP0;
	CRITICAL_SECTION csProcWaitHPDGRP1;
	CRITICAL_SECTION csProcHPDInfo;
	CRITICAL_SECTION csProcIntr;

	// HW status Flags
	BOOL bVPEnable;
	BOOL bGRPEnable[2];
	BOOL bSDoutEnable;
	BOOL bHDMIEnable;

	// Command Event
	GRPCommandContext GRP0pCmdCtxt;
	GRPCommandContext GRP1pCmdCtxt;
	HANDLE hSDoutCmdDone;   // SDout Cmd Event (VSync)
	HANDLE hVMCmdDone;      // Video Mixer Cmd Event
	HANDLE hHDMICmdDone;    // HDMI Cmd Event
	HANDLE hHPDCmdDone;    // HDMI HPD Cmd Event
	HANDLE hHPDCmdDoneForVP;    // HDMI HPD Cmd Event for VP
	HANDLE hHPDCmdDoneForGRP0;    // HDMI HPD Cmd Event for GRP0
	HANDLE hHPDCmdDoneForGRP1;    // HDMI HPD Cmd Event for GRP1
	HANDLE hHDMII2CCmdDone; // HDMI I2C Cmd Event

	// Thread Loop Termination Trigger
	BOOL bVMThrdExit;
	BOOL bSDoutThrdExit;
	BOOL bHDMIThrdExit;
	BOOL bHPDThrdExit;
	BOOL bHDMII2CThrdExit;


	// Open Context of Resource Occupant
	DWORD dwOccupantTVout;
	DWORD dwOccupantVP;
	DWORD dwOccupantGRP0;
	DWORD dwOccupantGRP1;

	DWORD dwOpenCount;
	DWORD dwLastOpenContext;
} STDAContext, *pSTDAContext;

typedef struct _STDAPowerContext
{
	// TVOUT_SET_INTERFACE_PARAM
	BOOL bTvOutputParam;
	TVOUT_OUTPUT_IF tTvOutputParam;

	// TVOUT_SET_OUTPUT_ENABLE/DISABLE
	BOOL bTVoutOutputEnable;

	// TVOUT_SET_LAYER_MODE/POSITION
	BOOL bVLMode;
	BOOL bGRPMode[2];

	// Video Layer Parameters
	STDA_ARG_VIDEO_BASIC_PARAM tVLBasicParam;
	VPROC_SRC_COLOR_FORMAT srcColor;
	VPROC_SRC_CODEC_FORMAT srcCodec;
	unsigned int uiVLTopYAddress;
	unsigned int uiVLTopCAddress;
	unsigned int uiVLBottomYAddress;
	unsigned int uiVLBottomCAddress;
	unsigned int uiVLSrcOffsetX;
	unsigned int uiVLSrcXFractStep;
	unsigned int uiVLSrcOffsetY;
	unsigned int uiVLSrcWidth;
	unsigned int uiVLSrcHeight;
	unsigned int uiVLDestOffsetX;
	unsigned int uiVLDestOffsetY;
	unsigned int uiVLDestWidth;
	unsigned int uiVLDestHeight;
	BOOL bVL2dIpc;
	VPROC_FIELD_ID vlFiledId;
	STDA_ARG_VIDEO_OP_MODE tVlOpMode;

	BOOL bVLPolyFilterDefault;
	BOOL bVLByPassPostProcess;
	unsigned int uiVLSaturation;
	STDA_ARG_VIDEO_SHARPNESS tVLSharpness;
	
	STDA_ARG_VIDEO_BRIGHTNESS_CONTRAST_CONTROL tVLBCControl[8];
	unsigned int uiVLBrightOffset;
	
	STDA_ARG_VIDEO_CSC_CONTROL tVLCscControl;
	VPROC_CSC_TYPE vlCscType;
	BOOL bVLCscCoefDefault;
	

	unsigned int uiVLBCControl;

	// GRPx Layer Parameters
	STDA_ARG_GRP_BASIC_PARAM tGrpParam[2];

	// GRP Layer Common Parameters
	VMIXER_BURST_MODE grpBurst;
	TVOUT_ENDIAN_FORMAT_TYPE grpEndian;

	//Mixer Limiter Parameters
	unsigned int uiVMLimitYUpper;
	unsigned int uiVMLimitYLower;
	unsigned int uiVMLimitCUpper;
	unsigned int uiVMLimitCUppe;


	// BackGroung Layer Parameters
	STDA_ARG_BG_COLOR tBGColor[3];

	// Video Mixer Parameters
	BOOL bVMCscCoefDefault;

	// SDout Parameters
	STDA_ARG_SDOUT_VIDEO_SCALE_CFG tSDoutVideoScaleCfg;
	//SDOUT_OUTPUT_ORDER sdoutOrder;
	SDOUT_SYNC_SIG_PIN sdoutSyncPin;
	STDA_ARG_SDOUT_VBI tSDoutVbi;
	STDA_ARG_SDOUT_OFFSET_GAIN tSDoutOffsetGain[3];
	STDA_ARG_SDOUT_DELAY tSDoutDelay;
	BOOL bSDoutColorSubCarrierPhaseAdjustment;
	BOOL bSDoutDacOn[3];

	STDA_ARG_SDOUT_BRIGHTNESS_HUE_SATURATION tSDoutBriHueSat;
	BOOL bSDoutYPbPrComp;
	STDA_ARG_SDOUT_RGB_COLOR_COMPENSATON tSDoutRGBCompen;
	STDA_ARG_SDOUT_CVBS_COLOR_COMPENSATON tSDoutCVBSCompen;
	STDA_ARG_SDOUT_SVIDEO_COLOR_COMPENSATON tSDoutSvideoCompen;
	STDA_ARG_SDOUT_COMPONENT_PORCH tSDoutCompPorch;
	STDA_ARG_SDOUT_VESA_RGB_SYNC tSDoutRGBSync;
	STDA_ARG_SDOUT_CHANNEL_XTALK_CANCELLATION_COEFF tSDoutXtalkCC[3];
	STDA_ARG_SDOUT_CLOSED_CAPTION tSDoutClosedCapt;
	STDA_ARG_SDOUT_525_DATA tSDoutWSS525;
	STDA_ARG_SDOUT_625_DATA tSDoutWSS625;
	STDA_ARG_SDOUT_525_DATA tSDoutCGMS525;
	STDA_ARG_SDOUT_625_DATA tSDoutCGMS625;

	// HDMI video parameters
	STDA_ARG_HDMI_VIDEO_BLUESCREEN tHdmiVideoBlueScreen;
	STDA_ARG_HDMI_COLOR_RANGE tHdmiColorRange;
	STDA_ARG_HDMI_VIDEO_INFOFRAME tHdmiAviInfoFrame;
	STDA_ARG_HDMI_VIDEO_INFOFRAME tHdmiMpgInfoFrame;
	STDA_ARG_HDMI_TG_CMD tHdmiTgCmd;
	unsigned char ucAviByte[13];
	unsigned char ucMpgByte[5];

	// HDMI parameters
	STDA_ARG_HDMI_SPD_INFOFRAME tHdmiSpdInfoFrame;
	unsigned char ucSpdHeader[3];
	unsigned char ucSpdData[28];
	BOOL bHDCPEn;
	HDMI_AUDIO_TYPE hdmiAudioType;
	BOOL bAudioEn;
	BOOL bHPDStatus;
	STDA_ARG_HDMI_AVAILABLE_MODE tHdmiAvailableMode;

	// TVOUT_SET_LAYER_ENABLE/DISABLE
	BOOL bVPLayerEnable;
	BOOL bGRPLayerEnable[2];

	// POWER STATE
	CEDEVICE_POWER_STATE powerState;
	CEDEVICE_POWER_STATE powerStateChange;
	BOOL bChangePowerState;

	//V210 Added Parameters
	HDMIVideoParameter tHdmiVideoParameter;
	HDMIAudioParameter tHdmiAudioParameter;
	unsigned int uiHdmiPhyCon;
	HDMI_PIN_STATUS pinStatus;

} STDAPowerContext, *pSTDAPowerContext;


#if __cplusplus
	}
#endif

#endif    // __STDA_COMMON_H

