//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: sdout_internal.h
//
//  Defines macros, structures, pre-defined functions, and etc for the SDOUT.
//
#ifndef __SDOUT_INTERNAL_H
#define __SDOUT_INTERNAL_H

#if __cplusplus
	extern "C"
	{
#endif

// SDO_CLKCON
#define SDO_TVOUT_SW_RESET      (1<<4)
#define SDO_TVOUT_CLOCK_ON      (1)
#define SDO_TVOUT_CLOCK_OFF     (0)

// SDO_CONFIG
#define SDO_DAC2_Y_G  (0<<20)
#define SDO_DAC2_PB_B (1<<20)
#define SDO_DAC2_PR_R (2<<20)
#define SDO_DAC1_Y_G  (0<<18)
#define SDO_DAC1_PB_B (1<<18)
#define SDO_DAC1_PR_R (2<<18)
#define SDO_DAC0_Y_G  (0<<16)
#define SDO_DAC0_PB_B (1<<16)
#define SDO_DAC0_PR_R (2<<16)
#define SDO_DAC2_CVBS   (0<<12)
#define SDO_DAC2_Y      (1<<12)
#define SDO_DAC2_C      (2<<12)
#define SDO_DAC1_CVBS   (0<<10)
#define SDO_DAC1_Y      (1<<10)
#define SDO_DAC1_C      (2<<10)
#define SDO_DAC0_CVBS   (0<<8)
#define SDO_DAC0_Y      (1<<8)
#define SDO_DAC0_C      (2<<8)
#define SDO_COMPOSITE   (0<<6)
#define SDO_COMPONENT   (1<<6)
#define SDO_RGB     (0<<5)
#define SDO_YPBPR   (1<<5)
#define SDO_INTERLACED  (0<<4)
#define SDO_PROGRESSIVE (1<<4)
#define SDO_NTSC_M      (0)
#define SDO_PAL_M       (1)
#define SDO_PAL_BGHID   (2)
#define SDO_PAL_N       (3)
#define SDO_PAL_NC      (4)
#define SDO_NTSC_443    (8)
#define SDO_PAL_60      (9)

// SDO_SCALE
#define SDO_COMPONENT_LEVEL_SEL_0IRE    (0<<3)
#define SDO_COMPONENT_LEVEL_SEL_75IRE   (1<<3)
#define SDO_COMPONENT_VTOS_RATIO_10_4   (0<<2)
#define SDO_COMPONENT_VTOS_RATIO_7_3    (1<<2)
#define SDO_COMPOSITE_LEVEL_SEL_0IRE    (0<<1)
#define SDO_COMPOSITE_LEVEL_SEL_75IRE   (1<<1)
#define SDO_COMPOSITE_VTOS_RATIO_10_4   (0<<0)
#define SDO_COMPOSITE_VTOS_RATIO_7_3    (1<<0)

// SDO_SYNC
#define SDO_COMPONENT_SYNC_ABSENT   (0)
#define SDO_COMPONENT_SYNC_YG       (1)
#define SDO_COMPONENT_SYNC_ALL      (3)

// SDO_VBI
#define SDO_CVBS_NO_WSS     (0<<14)
#define SDO_CVBS_WSS_INS    (1<<14)
#define SDO_CVBS_NO_CLOSED_CAPTION          (0<<12)
#define SDO_CVBS_21H_CLOSED_CAPTION         (1<<12)
#define SDO_CVBS_21H_284H_CLOSED_CAPTION    (2<<12)
#define SDO_CVBS_USE_OTHERS                 (3<<12)
#define SDO_SVIDEO_NO_WSS   (0<<10)
#define SDO_SVIDEO_WSS_INS  (1<<10)
#define SDO_SVIDEO_NO_CLOSED_CAPTION        (0<<8)
#define SDO_SVIDEO_21H_CLOSED_CAPTION       (1<<8)
#define SDO_SVIDEO_21H_284H_CLOSED_CAPTION  (2<<8)
#define SDO_SVIDEO_USE_OTHERS               (3<<8)
#define SDO_RGB_NO_CGMSA    (0<<7)
#define SDO_RGB_CGMSA_INS   (1<<7)
#define SDO_RGB_NO_WSS      (0<<6)
#define SDO_RGB_WSS_INS     (1<<6)
#define SDO_RGB_NO_CLOSED_CAPTION           (0<<4)
#define SDO_RGB_21H_CLOSED_CAPTION          (1<<4)
#define SDO_RGB_21H_284H_CLOSED_CAPTION     (2<<4)
#define SDO_RGB_USE_OTHERS                 (3<<4)
#define SDO_YPBPR_NO_CGMSA  (0<<3)
#define SDO_YPBPR_CGMSA_INS (1<<3)
#define SDO_YPBPR_NO_WSS    (0<<2)
#define SDO_YPBPR_WSS_INS   (1<<2)
#define SDO_YPBPR_NO_CLOSED_CAPTION         (0)
#define SDO_YPBPR_21H_CLOSED_CAPTION        (1)
#define SDO_YPBPR_21H_284H_CLOSED_CAPTION   (2)
#define SDO_YPBPR_USE_OTHERS               (3)

// SDO_SCALE_CHx
#define SDO_SCALE_CONV_OFFSET(a)    ((0x3ff&a)<<16)
#define SDO_SCALE_CONV_GAIN(a)      (0xfff&a)

// SDO_YCDELAY
#define SDO_DELAY_YTOC(a)           ((0xf&a)<<16)
#define SDO_ACTIVE_START_OFFSET(a)  ((0xff&a)<<8)
#define SDO_ACTIVE_END_OFFSET(a)    (0xff&a)

// SDO_SCHLOCK
#define SDO_COLOR_SC_PHASE_ADJ      (1)
#define SDO_COLOR_SC_PHASE_NOADJ    (0)

// SDO_DAC
#define SDO_POWER_ON_DAC2   (1<<2)
#define SDO_POWER_DOWN_DAC2 (0<<2)
#define SDO_POWER_ON_DAC1   (1<<1)
#define SDO_POWER_DOWN_DAC1 (0<<1)
#define SDO_POWER_ON_DAC0   (1<<0)
#define SDO_POWER_DOWN_DAC0 (0<<0)

// SDO_FINFO
#define SDO_FIELD_MOD_1001(a)               (((0x3ff<<16)&a)>>16)
#define SDO_FIELD_ID_BOTTOM(a)              ((1<<1)&a)
#define SDO_FIELD_ID_BOTTOM_PI_INCATION(a)  (1)
/*
// SDO_Y0
#define SDO_AA_75_73_CB     (0x251)
#define SDO_AA_75_104_CB    (0x25d)
#define SDO_AA_75_73_CB     (0x281)
#define SDO_AA_0_73_CB      (0x28f)
#define SDO_AA_75_73_CR     (0x1f3)
#define SDO_AA_75_104_CR    (0x200)
#define SDO_AA_75_73_CR     (0x21e)
#define SDO_AA_0_73_CR      (0x228)
#define SDO_AA_75_73        (0x2c0)
#define SDO_AA_75_104       (0x2d1)
#define SDO_AA_75_73        (0x2c0)
#define SDO_AA_0_73         (0x30d)
*/
// SDO_MV_480P_PROTECTION_ON
#define SDO_MV_AGC_103_ON   (1)

// SDO_CCCON
#define SDO_COMPONENT_BHS_ADJ_ON        (0<<4)
#define SDO_COMPONENT_BHS_ADJ_OFF       (1<<4)
#define SDO_COMPONENT_YPBPR_COMP_ON     (0<<3)
#define SDO_COMPONENT_YPBPR_COMP_OFF    (1<<3)
#define SDO_COMPONENT_RGB_COMP_ON       (0<<2)
#define SDO_COMPONENT_RGB_COMP_OFF      (1<<2)
#define SDO_COMPONENT_YC_COMP_ON        (0<<1)
#define SDO_COMPONENT_YC_COMP_OFF       (1<<1)
#define SDO_COMPONENT_CVBS_COMP_ON      (0)
#define SDO_COMPONENT_CVBS_COMP_OFF     (1)

// SDO_YSCALE
#define SDO_BRIGHTNESS_GAIN(a)      ((0xff&a)<<16)
#define SDO_BRIGHTNESS_OFFSET(a)    (0xff&a)

// SDO_CBSCALE
#define SDO_HS_CB_GAIN0(a)  ((0x1ff&a)<<16)
#define SDO_HS_CB_GAIN1(a)  (0x1ff&a)

// SDO_CRSCALE
#define SDO_HS_CR_GAIN0(a)  ((0x1ff&a)<<16)
#define SDO_HS_CR_GAIN1(a)  (0x1ff&a)

// SDO_CB_CR_OFFSET
#define SDO_HS_CR_OFFSET(a) ((0x3ff&a)<<16)
#define SDO_HS_CB_OFFSET(a) (0x3ff&a)

// SDO_RGB_CC
#define SDO_MAX_RGB_CUBE(a) ((0xff&a)<<8)
#define SDO_MIN_RGB_CUBE(a) (0xff&a)

// SDO_CVBS_CC_Y1
#define SDO_Y_LOWER_MID_CVBS_CORN(a)    ((0x3ff&a)<<16)
#define SDO_Y_BOTTOM_CVBS_CORN(a)       (0x3ff&a)

// SDO_CVBS_CC_Y2
#define SDO_Y_TOP_CVBS_CORN(a)          ((0x3ff&a)<<16)
#define SDO_Y_UPPER_MID_CVBS_CORN(a)    (0x3ff&a)

// SDO_CVBS_CC_C
#define SDO_RADIUS_CVBS_CORN(a) (0x1ff&a)

// SDO_YC_CC_Y
#define SDO_Y_TOP_YC_CYLINDER(a)    ((0x3ff&a)<<16)
#define SDO_Y_BOTOM_YC_CYLINDER(a)  (0x3ff&a)

// SDO_CVBS_CC_C
#define SDO_RADIUS_YC_CYLINDER(a)   (0x1ff&a)

// SDO_CSC_525_PORCH
#define SDO_COMPONENT_525_BP(a) ((0x3ff&a)<<16)
#define SDO_COMPONENT_525_FP(a) (0x3ff&a)

// SDO_CSC_525_PORCH
#define SDO_COMPONENT_625_BP(a) ((0x3ff&a)<<16)
#define SDO_COMPONENT_625_FP(a) (0x3ff&a)

// SDO_RGBSYNC
#define SDO_RGB_SYNC_COMPOSITE  (0<<8)
#define SDO_RGB_SYNC_SEPERATE   (1<<8)
#define SDO_RGB_VSYNC_LOW_ACT   (0<<4)
#define SDO_RGB_VSYNC_HIGH_ACT  (1<<4)
#define SDO_RGB_HSYNC_LOW_ACT   0
#define SDO_RGB_HSYNC_HIGH_ACT  1

// SDO_OSFCxx_x
#define SDO_OSF_COEF_ODD(a)     ((0xfff&a)<<16)
#define SDO_OSF_COEF_EVEN(a)    (0xfff&a)

// SDO_XTALKx
#define SDO_XTALK_COEF02(a) ((0xff&a)<<16)
#define SDO_XTALK_COEF01(a) (0xff&a)

// SDO_BB_CTRL
#define SDO_REF_BB_LEVEL_NTSC   (0x11a<<8)
#define SDO_REF_BB_LEVEL_PAL    (0xfb<<8)
#define SDO_SEL_BB_CJAN_CVBS0_BB1_BB2   (0<<4)
#define SDO_SEL_BB_CJAN_BB0_CVBS1_BB2   (1<<4)
#define SDO_SEL_BB_CJAN_BB0_BB1_CVBS2   (2<<4)
#define SDO_BB_MODE_ENABLE  (1)
#define SDO_BB_MODE_DISABLE (0)

// SDO_IRQ
#define SDO_VSYNC_IRQ_PEND  (1)
#define SDO_VSYNC_NO_IRQ    (0)

// SDO_IRQMASK
#define SDO_VSYNC_IRQ_ENABLE    (0)
#define SDO_VSYNC_IRQ_DISABLE   (1)

// SDO_ARMCC
#define SDO_DISPLAY_CC_CAPTION(a)       ((0xff&a)<<16)
#define SDO_NON_DISPLAY_CC_CAPTION(a)   (0xff&a)

// SDO_WSS525
#define SDO_CRC_WSS525(a)   ((0x3f&a)<<14)
#define SDO_WORD2_WSS525_COPY_PERMIT    (0<<6)
#define SDO_WORD2_WSS525_ONECOPY_PERMIT (1<<6)
#define SDO_WORD2_WSS525_NOCOPY_PERMIT  (3<<6)
#define SDO_WORD2_WSS525_MV_PSP_OFF             (0<<8)
#define SDO_WORD2_WSS525_MV_PSP_ON_2LINE_BURST  (1<<8)
#define SDO_WORD2_WSS525_MV_PSP_ON_BURST_OFF    (2<<8)
#define SDO_WORD2_WSS525_MV_PSP_ON_4LINE_BURST  (3<<8)
#define SDO_WORD2_WSS525_ANALOG_OFF             (0<<10)
#define SDO_WORD2_WSS525_ANALOG_ON              (1<<10)
#define SDO_WORD1_WSS525_COPY_INFO      (0<<2)
#define SDO_WORD1_WSS525_DEFAULT        (0xf<<2)
#define SDO_WORD0_WSS525_4_3_NORMAL     (0)
#define SDO_WORD0_WSS525_16_9_ANAMORPIC (1)
#define SDO_WORD0_WSS525_4_3_LETTERBOX  (2)

// SDO_WSS625
#define SDO_WSS625_SURROUND_SOUND_DISABLE   (0<<11)
#define SDO_WSS625_SURROUND_SOUND_ENABLE    (1<<11)
#define SDO_WSS625_NO_COPYRIGHT (0<<12)
#define SDO_WSS625_COPYRIGHT    (1<<12)
#define SDO_WSS625_COPY_NOT_RESTRICTED  (0<<13)
#define SDO_WSS625_COPY_RESTRICTED      (1<<13)
#define SDO_WSS625_TELETEXT_NO_SUBTITLES    (0<<8)
#define SDO_WSS625_TELETEXT_SUBTITLES       (1<<8)
#define SDO_WSS625_NO_OPEN_SUBTITLES        (0<<9)
#define SDO_WSS625_INACT_OPEN_SUBTITLES     (1<<9)
#define SDO_WSS625_OUTACT_OPEN_SUBTITLES    (2<<9)
#define SDO_WSS625_CAMERA   (0<<4)
#define SDO_WSS625_FILM     (1<<4)
#define SDO_WSS625_NORMAL_PAL                   (0<<5)
#define SDO_WSS625_MOTION_ADAPTIVE_COLORPLUS    (1<<5)
#define SDO_WSS625_HELPER_NO_SIG    (0<<6)
#define SDO_WSS625_HELPER_SIG       (1<<6)
#define SDO_WSS625_4_3_FULL_576                 (0x8)
#define SDO_WSS625_14_9_LETTERBOX_CENTER_504    (0x1)
#define SDO_WSS625_14_9_LETTERBOX_TOP_504       (0x2)
#define SDO_WSS625_16_9_LETTERBOX_CENTER_430    (0xb)
#define SDO_WSS625_16_9_LETTERBOX_TOP_430       (0x4)
#define SDO_WSS625_16_9_LETTERBOX_CENTER        (0xd)
#define SDO_WSS625_14_9_FULL_CENTER_576         (0xe)
#define SDO_WSS625_16_9_ANAMORPIC_576           (0x7)

// SDO_CGMS525
#define SDO_CRC_CGMS525(a)  ((0x3f&a)<<14)
#define SDO_WORD2_CGMS525_COPY_PERMIT       (0<<6)
#define SDO_WORD2_CGMS525_ONECOPY_PERMIT    (1<<6)
#define SDO_WORD2_CGMS525_NOCOPY_PERMIT     (3<<6)
#define SDO_WORD2_CGMS525_MV_PSP_OFF            (0<<8)
#define SDO_WORD2_CGMS525_MV_PSP_ON_2LINE_BURST (1<<8)
#define SDO_WORD2_CGMS525_MV_PSP_ON_BURST_OFF   (2<<8)
#define SDO_WORD2_CGMS525_MV_PSP_ON_4LINE_BURST (3<<8)
#define SDO_WORD2_CGMS525_ANALOG_OFF            (0<<10)
#define SDO_WORD2_CGMS525_ANALOG_ON             (1<<10)
#define SDO_WORD1_CGMS525_COPY_INFO         (0<<2)
#define SDO_WORD1_CGMS525_DEFAULT           (0xf<<2)
#define SDO_WORD0_CGMS525_4_3_NORMAL        (0)
#define SDO_WORD0_CGMS525_16_9_ANAMORPIC    (1)
#define SDO_WORD0_CGMS525_4_3_LETTERBOX     (2)

// SDO_CGMS625
#define SDO_CGMS625_SURROUND_SOUND_DISABLE  (0<<11)
#define SDO_CGMS625_SURROUND_SOUND_ENABLE   (1<<11)
#define SDO_CGMS625_NO_COPYRIGHT    (0<<12)
#define SDO_CGMS625_COPYRIGHT       (1<<12)
#define SDO_CGMS625_COPY_NOT_RESTRICTED (0<<13)
#define SDO_CGMS625_COPY_RESTRICTED     (1<<13)
#define SDO_CGMS625_TELETEXT_NO_SUBTITLES   (0<<8)
#define SDO_CGMS625_TELETEXT_SUBTITLES      (1<<8)
#define SDO_CGMS625_NO_OPEN_SUBTITLES       (0<<9)
#define SDO_CGMS625_INACT_OPEN_SUBTITLES    (1<<9)
#define SDO_CGMS625_OUTACT_OPEN_SUBTITLES   (2<<9)
#define SDO_CGMS625_CAMERA  (0<<4)
#define SDO_CGMS625_FILM    (1<<4)
#define SDO_CGMS625_NORMAL_PAL                  (0<<5)
#define SDO_CGMS625_MOTION_ADAPTIVE_COLORPLUS   (1<<5)
#define SDO_CGMS625_HELPER_NO_SIG   (0<<6)
#define SDO_CGMS625_HELPER_SIG      (1<<6)
#define SDO_CGMS625_4_3_FULL_576                (0x8)
#define SDO_CGMS625_14_9_LETTERBOX_CENTER_504   (0x1)
#define SDO_CGMS625_14_9_LETTERBOX_TOP_504      (0x2)
#define SDO_CGMS625_16_9_LETTERBOX_CENTER_430   (0xb)
#define SDO_CGMS625_16_9_LETTERBOX_TOP_430      (0x4)
#define SDO_CGMS625_16_9_LETTERBOX_CENTER       (0xd)
#define SDO_CGMS625_14_9_FULL_CENTER_576        (0xe)
#define SDO_CGMS625_16_9_ANAMORPIC_576          (0x7)

// global variables
static volatile PSDOUT_REG g_pSdoutConfig = NULL; // SDOUT Register

// static functions
static unsigned int Sdout_initialize_wss_cgms_crc(unsigned int uiValue);
static SDOUT_ERROR Sdout_initialize_antialias_filter_coeff_default
							(SDOUT_LEVEL compositeLevel,
							SDOUT_VIDEO_SYNC_RATIO compositeRatio,
							TVOUT_OUTPUT_MODE outMode);
static SDOUT_ERROR
Sdout_initialize_oversampling_filter_coeff_default(TVOUT_OUTPUT_MODE outMode);

#if __cplusplus
	}
#endif

#endif    // __SDOUT_INTERNAL_H
