//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: video_mixer.h
//
//  Defines macros, structures, pre-defined functions, and etc for the Video Mixer.
//
#ifndef __VIDEO_PROCESSOR_H
#define __VIDEO_PROCESSOR_H

#if __cplusplus
	extern "C"
	{
#endif

#include "tvout_internal.h"

/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping video processor
VPROC_ERROR VProc_initialize_register_address(void *pVPReg);
void VProc_initialize_field_id(VPROC_FIELD_ID mode);
void VProc_initialize_op_mode(BOOL bLineSkip,
							BOOL b2D_IPC,
							VPROC_MEM_MODE memMode,
							VPROC_CHROMA_EXPANSION chromaExp,
							VPROC_FILED_ID_TOGGLE toggleID);
VPROC_ERROR VProc_initialize_layer(unsigned int uiTopYAddress,
							unsigned int uiTopCAddress,
							unsigned int uiBottomYAddress,
							unsigned int uiBottomCAddress,
							TVOUT_ENDIAN_FORMAT_TYPE srcImgEndian,
							unsigned int uiImgWidth,
							unsigned int uiImgHeight,
							unsigned int uiSrcOffsetX,
							unsigned int uiSrcXFractStep,
							unsigned int uiSrcOffsetY,
							unsigned int uiSrcWidth,
							unsigned int uiSrcHeight,
							unsigned int uiDestOffsetX,
							unsigned int uiDestOffsetY,
							unsigned int uiDestWidth,
							unsigned int uiDestHeight,
							BOOL b2dIpc);
VPROC_ERROR VProc_initialize_layer_with_default_poly_filter_coef
							(unsigned int uiTopYAddress,
							unsigned int uiTopCAddress,
							unsigned int uiBottomYAddress,
							unsigned int uiBottomCAddress,
							TVOUT_ENDIAN_FORMAT_TYPE srcImgEndian,
							unsigned int uiImgWidth,
							unsigned int uiImgHeight,
							unsigned int uiSrcOffsetX,
							unsigned int uiSrcXFractStep,
							unsigned int uiSrcOffsetY,
							unsigned int uiSrcWidth,
							unsigned int uiSrcHeight,
							unsigned int uiDestOffsetX,
							unsigned int uiDestOffsetY,
							unsigned int uiDestWidth,
							unsigned int uiDestHeight,
							BOOL b2dIpc);
VPROC_ERROR VProc_initialize_poly_filter_coef(VPROC_POLY_COEFFICIENT polyCoeff,
							signed char ch0,
							signed char ch1,
							signed char ch2,
							signed char ch3);
void VProc_initialize_bypass_post_process(BOOL bByPass);
VPROC_ERROR VProc_initialize_csc_coef(VPROC_CSC_COEFFICIENT cscCoeff,
							unsigned int uiCoeff);
void VProc_initialize_saturation(unsigned int uiSat);
void VProc_initialize_sharpness(unsigned int uiThHNoise,
							VPROC_SHARPNESS_CONTROL sharpness);
VPROC_ERROR VProc_initialize_brightness_contrast_control(VPROC_LINE_EQ_NUM eqNum,
							unsigned int uiIntc,
							unsigned int uiSlope);
void VProc_initialize_brightness(unsigned short usBrightness);
void VProc_initialize_contrast(unsigned char ucContrast);
void VProc_initialize_brightness_offset(unsigned int uiOffset);
void VProc_initialize_csc_control(BOOL bSubYOffsetEn, BOOL bCscEn);
VPROC_ERROR VProc_initialize_csc_coef_default(VPROC_CSC_TYPE cscType);


// set
//  - set functions are only called under running video processor
//  - after running set functions, it is need to run VProc_update() function for update shadow registers
void VProc_set_field_id(VPROC_FIELD_ID mode);
VPROC_ERROR VProc_set_top_field_address(unsigned int uiTopYAddress,
							unsigned int uiTopCAddress);
VPROC_ERROR VProc_set_bottom_field_address(unsigned int uiBottomYAddress,
							unsigned int uiBottomCAddress);
VPROC_ERROR VProc_set_img_size(unsigned int uiImgWidth,
							unsigned int uiImgHeight);
void VProc_set_src_position(unsigned int uiSrcOffsetX,
							unsigned int uiSrcXFractStep,
							unsigned int uiSrcOffsetY);
void VProc_set_dest_position(unsigned int uiDestOffsetX,
							unsigned int uiDestOffsetY);
void VProc_set_src_dest_size(unsigned int uiSrcWidth,
							unsigned int uiSrcHeight,
							unsigned int uiDestWidth,
							unsigned int uiDestHeight,
							BOOL b2dIpc);
VPROC_ERROR VProc_set_poly_filter_coef(VPROC_POLY_COEFFICIENT polyCoeff,
							signed char ch0,
							signed char ch1,
							signed char ch2,
							signed char ch3);
void VProc_set_poly_filter_coef_default(unsigned int uiHRatio,
							unsigned int uiVRatio);
void VProc_set_src_dest_size_with_default_poly_filter_coef
							(unsigned int uiSrcWidth,
							unsigned int uiSrcHeight,
							unsigned int uiDestWidth,
							unsigned int uiDestHeight,
							BOOL b2dIpc);
VPROC_ERROR VProc_set_brightness_contrast_control(VPROC_LINE_EQ_NUM eqNum,
							unsigned int uiIntc,
							unsigned int uiSlope);
void VProc_set_brightness_offset(unsigned int uiOffset);
VPROC_ERROR VProc_update(void);


// get
//  - get info
VPROC_FIELD_ID VProc_get_field_id(void);
//unsigned int VProc_get_version_info(void);


// etc
//  -
BOOL VProc_get_update_status(void);


// start
//  - start functions are only called under stopping video processor
VPROC_ERROR VProc_start(void);


// stop
//  - stop functions are only called under running video processor
VPROC_ERROR VProc_stop(void);


// reset
//  - reset function
void VProc_sw_reset(void);


/*============================================================================*/


#if __cplusplus
	}
#endif

#endif    // __VIDEO_PROCESSOR_H
