//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: video_mixer.h
//
//  Defines macros, structures, pre-defined functions, and etc for the Video Mixer.
//
#ifndef __VIDEO_MIXER_H
#define __VIDEO_MIXER_H

#if __cplusplus
	extern "C"
	{
#endif

#include "tvout_internal.h"

/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping vmixer
VMIXER_ERROR VMixer_initialize_register_address(void *pVMReg);
VMIXER_ERROR VMixer_initialize_status_reg(VMIXER_BURST_MODE burst,
										TVOUT_ENDIAN_FORMAT_TYPE endian);
VMIXER_ERROR VMixer_initialize_display_mode(TVOUT_DISPLAY_MODE dispMode,
										TVOUT_OUTPUT_MODE outputMode);
VMIXER_ERROR VMixer_initialize_Limit_Para_Cfg(unsigned int uiYUpper,
										unsigned int uiYLower,
										unsigned int uiCUpper,
										unsigned int uiCLower);
VMIXER_ERROR VMixer_initialize_layer(VMIXER_LAYER layer,
										BOOL bShow,               //video,grp
										BOOL bWinBlending,        //video,grp
										unsigned int uiAlpha,     //video,grp
										unsigned int uiPriority,  //video,grp
										VMIXER_COLOR_FORMAT color,    //grp
										BOOL bBlankChange,            //grp
										BOOL bPixelBlending,           //grp
										BOOL bPreMul,                 //grp
										unsigned int uiBlankColor,    //grp
										unsigned int uiBaseAddress,   //grp
										unsigned int uiSpan,          //grp
										unsigned int uiWidth,         //grp
										unsigned int uiHeight,        //grp
										unsigned int uiSrcOffsetX,    //grp
										unsigned int uiSrcOffsetY,    //grp
										unsigned int uiDestOffsetX,   //grp
										unsigned int uiDestOffsetY,  //grp
										unsigned int uiScaleEnH,   //grp
										unsigned int uiScaleEnV);   //grp

VMIXER_ERROR VMixer_initialize_bg_color(VMIXER_BG_COLOR_NUM colorNum,
										unsigned int uiColorY,
										unsigned int uiColorCb,
										unsigned int uiColorCr);
VMIXER_ERROR VMixer_initialize_csc_coef(TVOUT_YUV_FORMAT_COMPONENT component,
										VMIXER_COEF_Y_MODE mode,
										unsigned int uiCoeff_0,
										unsigned int uiCoeff_1,
										unsigned int uiCoeff_2);
void VMixer_initialize_csc_coef_default(VMIXER_CSC_TYPE cscType);


// set
//  - set functions are only called under running vmixer
VMIXER_ERROR VMixer_set_layer_show(VMIXER_LAYER layer,
										BOOL bShow);
VMIXER_ERROR VMixer_set_layer_priority(VMIXER_LAYER layer,
										unsigned int uiPriority);
VMIXER_ERROR VMixer_set_grp_base_address(VMIXER_LAYER layer,
										unsigned int uiBaseAddress);
VMIXER_ERROR VMixer_set_grp_layer_position(VMIXER_LAYER layer,
										unsigned int uiDestOffsetX,
										unsigned int uiDestOffsetY);
VMIXER_ERROR VMixer_set_grp_layer_size(unsigned int uiLayerNum,
										unsigned int uiBaseAddress,
										unsigned int uiSpan,
										unsigned int uiWidth,
										unsigned int uiHeight,
										unsigned int uiSrcOffsetX,
										unsigned int uiSrcOffsetY,
										unsigned int uiDestOffsetX,
										unsigned int uiDestOffsetY,
										unsigned int uiScaleEnH,
										unsigned int uiScaleEnV);

VMIXER_ERROR VMixer_set_bg_color(VMIXER_BG_COLOR_NUM colorNum,
										unsigned int uiColorY,
										unsigned int uiColorCb,
										unsigned int uiColorCr);

// etc
//  -
VMIXER_ERROR VMixer_get_layer_priority(VMIXER_LAYER layer,
										BOOL* bShow,
										unsigned int* uiPriority);


// start
//  - start functions are only called under stopping vmixer
void VMixer_start(void);


// stop
//  - stop functions are only called under running vmixer
void VMixer_stop(void);


// interrupt
//  - for debug
VMIXER_ERROR VMixer_set_underflow_interrupt_enable(VMIXER_LAYER layer,
										BOOL bEn);
void VMixer_clear_underflow_interrupt(BOOL bVideo,
										BOOL bGrp0,
										BOOL bGpr1,
										BOOL bInt);
void VMixer_get_underflow_interrupt_fired(BOOL* bVideo,
										BOOL* bGrp0,
										BOOL* bGpr1,
										BOOL* bInt);
void VMixer_set_vsync_interrupt_enable(BOOL bEn);

void VMixer_clear_vsync_interrupt();

BOOL VMixer_get_vsync_interrupt_fired();



/*============================================================================*/


#if __cplusplus
	}
#endif

#endif    // __VIDEO_MIXER_H
