//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvout_power.h
//
//  Defines macros, structures, pre-defined functions, and etc for the TVout Power.
//
#ifndef __TVOUT_POWER_H
#define __TVOUT_POWER_H

#if __cplusplus
	extern "C"
	{
#endif

#include "tvout_internal.h"


/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping tvout power
TVOUT_POWER_ERROR Tvout_power_initialize_register_address(void *pPmuPmCon, void *pPmuMiscCon);
void Tvout_power_initialize_mtc_stable_counter(unsigned int uiValue);
void TVout_power_initialize_dac_onoff(BOOL bOn);


// set
//  - set functions are only called under running tvout power
void TVout_power_set_dac_onoff(BOOL bOn);

void Tvout_power_set_hdmi_div(unsigned int uiDiv);

void Tvout_power_set_hdmi_en(BOOL bEn);


// etc
//  -
BOOL Tvout_power_get_power_status(void);
BOOL Tvout_power_get_dac_power_status(void);


// start
//  - start functions are only called under stopping tvout power
void TVout_power_on(void);


// stop
//  - stop functions are only called under running tvout power
void TVout_power_off(void);

#ifdef BSP_USEDVFS
BOOL
TVout_dvfs_set_level_fix();
BOOL
TVout_dvfs_clear_level_fix();
#endif // BSP_USEDVFS

// For APM
#ifdef SUPPORT_APM_TVD
void TVout_power_set_APM(CEDEVICE_POWER_STATE APM_POWER_STATUS);
void TVout_power_init_APM();
void TVout_power_deinit_APM();
#endif

void Tvout_power_print();

#if __cplusplus
	}
#endif

#endif    // __TVOUT_POWER_H
