//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvout_message.h
//
//  Defines messages for the tvout.
//
#ifndef __TVOUT_MESSAGE_H
#define __TVOUT_MESSAGE_H

#include "Tvout_global.h"

#if __cplusplus
	extern "C"
	{
#endif

extern DBGPARAM dpCurSettings;

#ifdef DEBUG

#define TVOUT_ZONEMASK_ERROR          (1<<0)
#define TVOUT_ZONEMASK_WARNING        (1<<1)
#define TVOUT_ZONEMASK_PERF           (1<<2)
#define TVOUT_ZONEMASK_TEMP           (1<<3)

#define TVOUT_ZONEMASK_HDCP           (1<<4)
#define TVOUT_ZONEMASK_INIT           (1<<5)
#define TVOUT_ZONEMASK_VP             (1<<6)
#define TVOUT_ZONEMASK_VMIXER         (1<<7)

#define TVOUT_ZONEMASK_SDOUT          (1<<8)
#define TVOUT_ZONEMASK_HDMI           (1<<9)
#define TVOUT_ZONEMASK_TVOUT          (1<<10)

#ifndef TVOUTDRV_DEBUGZONES
#define TVOUTDRV_DEBUGZONES         (TVOUT_ZONEMASK_ERROR)// | TVOUT_ZONEMASK_WARNING)
#endif
#endif  //DEBUG

// Even on Release Mode, We don't care about GPE message
#define ZONEID_ERROR                0
#define ZONEID_WARNING              1
#define ZONEID_TEMP                 2
#define ZONEID_HDCP                 3
#define ZONEID_CXT                  4
#define ZONEID_VP                   5
#define ZONEID_VMIXER               6
#define ZONEID_SDOUT                7
#define ZONEID_HDMI                 8
#define ZONEID_TVOUT                9
#define ZONEID_POWER                10
#define ZONEID_CLOCK                11
#define ZONEID_INTERRUPT            12
#define ZONEID_TVDRV                13
#define ZONEID_RESOURCE             14
#define ZONEID_EDID                 15

#define TVOUT_ZONE_ERROR            DEBUGZONE(ZONEID_ERROR)
#define TVOUT_ZONE_WARNING          DEBUGZONE(ZONEID_WARNING)
#define TVOUT_ZONE_TEMP             DEBUGZONE(ZONEID_TEMP)
#define TVOUT_ZONE_HDCP             DEBUGZONE(ZONEID_HDCP)
#define TVOUT_ZONE_CXT              DEBUGZONE(ZONEID_CXT)
#define TVOUT_ZONE_VP               DEBUGZONE(ZONEID_VP)
#define TVOUT_ZONE_VMIXER           DEBUGZONE(ZONEID_VMIXER)
#define TVOUT_ZONE_SDOUT            DEBUGZONE(ZONEID_SDOUT)
#define TVOUT_ZONE_HDMI             DEBUGZONE(ZONEID_HDMI)
#define TVOUT_ZONE_TVOUT            DEBUGZONE(ZONEID_TVOUT)
#define TVOUT_ZONE_POWER            DEBUGZONE(ZONEID_POWER)
#define TVOUT_ZONE_CLOCK            DEBUGZONE(ZONEID_CLOCK)
#define TVOUT_ZONE_INTERRUPT        DEBUGZONE(ZONEID_INTERRUPT)
#define TVOUT_ZONE_TVDRV            DEBUGZONE(ZONEID_TVDRV)
#define TVOUT_ZONE_RESOURCE         DEBUGZONE(ZONEID_RESOURCE)
#define TVOUT_ZONE_EDID             DEBUGZONE(ZONEID_EDID)

#define ZONEMASK_ERROR              (1 << ZONEID_ERROR)
#define ZONEMASK_WARNING            (1 << ZONEID_WARNING)
#define ZONEMASK_TEMP               (1 << ZONEID_TEMP)
#define ZONEMASK_HDCP               (1 << ZONEID_HDCP)
#define ZONEMASK_CXT                (1 << ZONEID_CXT)
#define ZONEMASK_VP                 (1 << ZONEID_VP)
#define ZONEMASK_VMIXER             (1 << ZONEID_VMIXER)
#define ZONEMASK_SDOUT              (1 << ZONEID_SDOUT)
#define ZONEMASK_HDMI               (1 << ZONEID_HDMI)
#define ZONEMASK_TVOUT              (1 << ZONEID_TVOUT)
#define ZONEMASK_POWER              (1 << ZONEID_POWER)
#define ZONEMASK_CLOCK              (1 << ZONEID_CLOCK)
#define ZONEMASK_INTERRUPT          (1 << ZONEID_INTERRUPT)
#define ZONEMASK_TVDRV              (1 << ZONEID_TVDRV)
#define ZONEMASK_RESOURCE           (1 << ZONEID_RESOURCE)
#define ZONEMASK_EDID               (1 << ZONEID_EDID)



/*
#ifndef TVOUTDRV_RETAILZONES
#define TVOUTDRV_RETAILZONES        ( ZONEMASK_ERROR |\
                                                                                ZONEMASK_WARNING | \
                                                                                ZONEMASK_TEMP | \
                                                                                ZONEMASK_HDCP | \
                                                                                ZONEMASK_CXT | \
                                                                                ZONEMASK_VMIXER |\
                                                                                ZONEMASK_SDOUT | \
                                                                                ZONEMASK_HDMI | \
                                                                                ZONEMASK_TVOUT | \
                                                                                ZONEMASK_POWER | \
                                                                                ZONEMASK_CLOCK | \
                                                                                ZONEMASK_INTERRUPT | \
                                                                                ZONEMASK_EDID )

//                                                                                ZONEMASK_VP | \
//                                                                                ZONEMASK_EDID | \
//                                                                                ZONEMASK_TVDRV | \
//                                                                                ZONEMASK_RESOURCE )
*/

#ifndef TVOUTDRV_RETAILZONES                                                                                
#define TVOUTDRV_RETAILZONES        (ZONEMASK_HDMI|ZONEMASK_TVOUT|ZONEMASK_HDCP|ZONEMASK_TVDRV)


#endif //
TVOUTDRV_RETAILZONES

//#define TV_PLAY TRUE
#define TV_PLAY FALSE

//#define TV_UNDER_RUN TRUE
#define TV_UNDER_RUN TRUE

//#define TV_HDMI_DETECT TRUE
#define TV_HDMI_DETECT FALSE

#if __cplusplus
	}
#endif

#endif    // __TVOUT_MESSAGE_H

